/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.dynamic;

import com.android.tools.adtui.DocumentAccessor;
import com.android.tools.adtui.TextAccessors;
import com.android.tools.idea.ui.ApiComboBoxItem;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.base.Objects;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.TextAccessor;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class ScopedDataBinder
implements ScopedStateStore.ScopedStoreListener,
FocusListener,
ChangeListener,
ActionListener,
DocumentListener,
ItemListener {
    protected ScopedStateStore myState;
    private final Map<Document, JComponent> myDocumentsToComponent = Maps.newIdentityHashMap();
    private final Map<ScopedStateStore.Key, ValueDeriver> myValueDerivers = Maps.newHashMap();
    private final Table<JComponent, ScopedStateStore.Key<?>, ComponentBinding<?, ?>> myComponentBindings = HashBasedTable.create();
    private final Set<ScopedStateStore.Key> myGuardedKeys = new HashSet<ScopedStateStore.Key>();
    private final Set<ScopedStateStore.Key> myUserEditedKeys = new HashSet<ScopedStateStore.Key>();
    private boolean myAlreadySavingState;
    private JComponent myUpdateTrigger;

    public ScopedDataBinder() {
        this.myState = new ScopedStateStore(ScopedStateStore.Scope.STEP, null, this);
    }

    @Override
    public <T> void invokeUpdate(@Nullable ScopedStateStore.Key<T> changedKey) {
        if (changedKey == null) {
            ImmutableSet allKeys = ImmutableSet.copyOf((Collection)this.myComponentBindings.columnKeySet());
            this.myGuardedKeys.addAll((Collection<ScopedStateStore.Key>)allKeys);
            for (ScopedStateStore.Key key : allKeys) {
                if (!this.myComponentBindings.containsColumn((Object)key)) continue;
                this.internalUpdateKey(key);
            }
            this.deriveValues(null);
        } else {
            this.myGuardedKeys.add(changedKey);
            this.internalUpdateKey(changedKey);
        }
    }

    private <T> void internalUpdateKey(@NotNull ScopedStateStore.Key<T> changedKey) {
        if (changedKey == null) {
            ScopedDataBinder.$$$reportNull$$$0(0);
        }
        T value2 = this.myState.get(changedKey);
        ImmutableMap keyBindings = ImmutableMap.copyOf((Map)this.myComponentBindings.column(changedKey));
        for (Map.Entry entry : keyBindings.entrySet()) {
            JComponent component = (JComponent)entry.getKey();
            if (!this.myComponentBindings.contains((Object)component, changedKey) || Objects.equal((Object)component, (Object)this.myUpdateTrigger)) continue;
            ComponentBinding binding = (ComponentBinding)this.myComponentBindings.get((Object)component, changedKey);
            try {
                binding.setValue(value2, component);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        this.deriveValues(changedKey);
        this.myGuardedKeys.remove(changedKey);
    }

    private <T> void deriveValues(@Nullable ScopedStateStore.Key<T> changedKey) {
        for (ScopedStateStore.Key key : this.myValueDerivers.keySet()) {
            if (this.myGuardedKeys.contains(key)) continue;
            ValueDeriver deriver = this.myValueDerivers.get(key);
            if (this.myUserEditedKeys.contains(key) && deriver.respectUserEdits()) continue;
            Set<ScopedStateStore.Key<?>> triggerKeys = deriver.getTriggerKeys();
            if (changedKey != null && triggerKeys != null && !triggerKeys.contains(changedKey)) continue;
            this.deriveValue(key, deriver, changedKey);
        }
    }

    private <T> void deriveValue(@NotNull ScopedStateStore.Key<T> key, @NotNull ValueDeriver<T> deriver, @Nullable ScopedStateStore.Key<?> changedKey) {
        T currentValue;
        T newValue;
        if (key == null) {
            ScopedDataBinder.$$$reportNull$$$0(1);
        }
        if (deriver == null) {
            ScopedDataBinder.$$$reportNull$$$0(2);
        }
        if ((newValue = deriver.deriveValue(this.myState, changedKey, currentValue = this.myState.get(key))) != null && !key.expectedClass.isInstance(newValue)) {
            throw new IllegalArgumentException(String.format("Deriver %1$s returned value for key %2$s of type %3$s, should be %4$s", deriver.toString(), key.name, newValue.getClass().getName(), key.expectedClass.getName()));
        }
        this.myState.put(key, newValue);
    }

    public <T> void saveState(@NotNull JComponent component) {
        if (component == null) {
            ScopedDataBinder.$$$reportNull$$$0(3);
        }
        if (this.myAlreadySavingState) {
            return;
        }
        this.myAlreadySavingState = true;
        for (Map.Entry entry : this.myComponentBindings.row((Object)component).entrySet()) {
            if (this.myGuardedKeys.contains(entry.getKey())) continue;
            ComponentBinding binding = (ComponentBinding)entry.getValue();
            try {
                Object value2 = binding.getValue(component);
                this.storeValue((ScopedStateStore.Key)entry.getKey(), component, value2);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        this.myAlreadySavingState = false;
    }

    private <T> void storeValue(@NotNull ScopedStateStore.Key<T> key, @NotNull JComponent updateTrigger, @Nullable T value2) {
        T oldValue;
        if (key == null) {
            ScopedDataBinder.$$$reportNull$$$0(4);
        }
        if (updateTrigger == null) {
            ScopedDataBinder.$$$reportNull$$$0(5);
        }
        if ((oldValue = this.myState.get(key)) != null && !oldValue.equals(value2) && !this.myGuardedKeys.contains(key)) {
            this.myUserEditedKeys.add(key);
        }
        this.myUpdateTrigger = updateTrigger;
        this.myState.put(key, value2);
        this.myUpdateTrigger = null;
    }

    @Nullable
    private static Object getComponentValue(@NotNull JComponent component) {
        if (component == null) {
            ScopedDataBinder.$$$reportNull$$$0(6);
        }
        Object newValue = null;
        if (component instanceof JCheckBox) {
            newValue = ((JCheckBox)component).isSelected();
        } else if (component instanceof JComboBox) {
            Object selectedObject = ((JComboBox)component).getSelectedItem();
            if (selectedObject instanceof ApiComboBoxItem) {
                ApiComboBoxItem selectedItem = (ApiComboBoxItem)selectedObject;
                newValue = selectedItem.getData();
            } else {
                newValue = selectedObject;
            }
        } else if (component instanceof JSlider) {
            newValue = ((JSlider)component).getValue();
        } else if (component instanceof JSpinner) {
            newValue = ((JSpinner)component).getValue();
        } else if (component instanceof ColorPanel) {
            newValue = ((ColorPanel)component).getSelectedColor();
        } else {
            TextAccessor accessor = TextAccessors.getTextAccessor((JComponent)component);
            if (accessor != null) {
                newValue = accessor.getText();
            }
        }
        return newValue;
    }

    private static void setComponentValue(@Nullable Object value2, @NotNull JComponent component) {
        if (component == null) {
            ScopedDataBinder.$$$reportNull$$$0(7);
        }
        if (component instanceof JCheckBox) {
            ((JCheckBox)component).setSelected(Boolean.TRUE.equals(value2));
        } else if (component instanceof JComboBox) {
            ScopedDataBinder.setSelectedItem((JComboBox)component, value2);
        } else if (component instanceof JSlider) {
            assert (value2 != null);
            ((JSlider)component).setValue((Integer)value2);
        } else if (component instanceof JSpinner) {
            ((JSpinner)component).setValue(value2);
        } else if (component instanceof ColorPanel && value2 != null) {
            ((ColorPanel)component).setSelectedColor((Color)value2);
        } else {
            String newValue;
            TextAccessor accessor = TextAccessors.getTextAccessor((JComponent)component);
            if (accessor != null && !(newValue = StringUtil.notNullize((String)((String)value2))).equals(accessor.getText())) {
                accessor.setText(newValue);
            }
        }
    }

    public <T> void registerValueDeriver(@NotNull ScopedStateStore.Key<T> key, @NotNull ValueDeriver<T> deriver) {
        if (key == null) {
            ScopedDataBinder.$$$reportNull$$$0(8);
        }
        if (deriver == null) {
            ScopedDataBinder.$$$reportNull$$$0(9);
        }
        this.myValueDerivers.put(key, deriver);
    }

    public <T, C extends JComponent> void register(@NotNull ScopedStateStore.Key<T> key, @NotNull C component, @NotNull ComponentBinding<T, ? super C> binding) {
        T value2;
        if (key == null) {
            ScopedDataBinder.$$$reportNull$$$0(10);
        }
        if (component == null) {
            ScopedDataBinder.$$$reportNull$$$0(11);
        }
        if (binding == null) {
            ScopedDataBinder.$$$reportNull$$$0(12);
        }
        if ((value2 = this.bindAndGet(key, component, binding)) != null) {
            try {
                binding.setValue(value2, component);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        } else {
            try {
                this.myState.put(key, binding.getValue(component));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        component.addFocusListener(this);
        binding.addActionListener(this, component);
        binding.addChangeListener(this, component);
        binding.addItemListener(this, component);
        Document document = binding.getDocument(component);
        if (document != null) {
            this.myDocumentsToComponent.put(document, component);
            document.addDocumentListener(this);
        }
    }

    @Nullable
    private <T> T bindAndGet(@NotNull ScopedStateStore.Key<T> key, @NotNull JComponent component, @Nullable ComponentBinding<T, ?> binding) {
        if (key == null) {
            ScopedDataBinder.$$$reportNull$$$0(13);
        }
        if (component == null) {
            ScopedDataBinder.$$$reportNull$$$0(14);
        }
        DefaultBinding b = binding == null ? new DefaultBinding() : binding;
        this.myComponentBindings.put((Object)component, key, (Object)b);
        return this.myState.get(key);
    }

    public void register(@NotNull ScopedStateStore.Key<Boolean> key, @NotNull JCheckBox checkBox) {
        Boolean value2;
        if (key == null) {
            ScopedDataBinder.$$$reportNull$$$0(15);
        }
        if (checkBox == null) {
            ScopedDataBinder.$$$reportNull$$$0(16);
        }
        if ((value2 = this.bindAndGet(key, checkBox, null)) != null) {
            checkBox.setSelected(value2);
        } else {
            this.myState.put(key, false);
        }
        checkBox.addFocusListener(this);
        checkBox.addItemListener(this);
    }

    protected <T> void register(@NotNull ScopedStateStore.Key<T> key, @NotNull JComboBox comboBox) {
        T value2;
        if (key == null) {
            ScopedDataBinder.$$$reportNull$$$0(17);
        }
        if (comboBox == null) {
            ScopedDataBinder.$$$reportNull$$$0(18);
        }
        if ((value2 = this.bindAndGet(key, comboBox, null)) != null) {
            ScopedDataBinder.setSelectedItem(comboBox, value2);
        }
        comboBox.addFocusListener(this);
        comboBox.addActionListener(this);
    }

    public static <T> void setSelectedItem(JComboBox comboBox, @Nullable T value2) {
        int index2 = -1;
        for (int i2 = 0; i2 < comboBox.getItemCount(); ++i2) {
            Object item = comboBox.getItemAt(i2);
            if (item instanceof ApiComboBoxItem) {
                item = ((ApiComboBoxItem)item).getData();
            }
            if (!Objects.equal(item, value2)) continue;
            index2 = i2;
            break;
        }
        comboBox.setSelectedIndex(index2);
    }

    public void register(@NotNull ScopedStateStore.Key<String> key, @NotNull JTextField textField) {
        if (key == null) {
            ScopedDataBinder.$$$reportNull$$$0(19);
        }
        if (textField == null) {
            ScopedDataBinder.$$$reportNull$$$0(20);
        }
        this.myDocumentsToComponent.put(textField.getDocument(), textField);
        String value2 = this.bindAndGet(key, textField, null);
        if (value2 != null) {
            textField.setText(value2);
        } else {
            this.myState.put(key, textField.getText());
        }
        textField.addFocusListener(this);
        textField.getDocument().addDocumentListener(this);
    }

    public void register(@NotNull ScopedStateStore.Key<String> key, @NotNull JLabel label) {
        String value2;
        if (key == null) {
            ScopedDataBinder.$$$reportNull$$$0(21);
        }
        if (label == null) {
            ScopedDataBinder.$$$reportNull$$$0(22);
        }
        if ((value2 = this.bindAndGet(key, label, null)) != null) {
            label.setText(value2);
        } else {
            this.myState.put(key, label.getText());
        }
    }

    public void register(@NotNull ScopedStateStore.Key<Integer> key, @NotNull JSlider paddingSlider) {
        Integer value2;
        if (key == null) {
            ScopedDataBinder.$$$reportNull$$$0(23);
        }
        if (paddingSlider == null) {
            ScopedDataBinder.$$$reportNull$$$0(24);
        }
        if ((value2 = this.bindAndGet(key, paddingSlider, null)) != null) {
            paddingSlider.setValue(value2);
        } else {
            this.myState.put(key, paddingSlider.getValue());
        }
        paddingSlider.addFocusListener(this);
        paddingSlider.addChangeListener(this);
    }

    public void register(@NotNull ScopedStateStore.Key<String> key, @NotNull TextFieldWithBrowseButton field2) {
        if (key == null) {
            ScopedDataBinder.$$$reportNull$$$0(25);
        }
        if (field2 == null) {
            ScopedDataBinder.$$$reportNull$$$0(26);
        }
        this.myDocumentsToComponent.put(field2.getTextField().getDocument(), (JComponent)field2);
        String value2 = this.bindAndGet(key, (JComponent)field2, null);
        if (value2 != null) {
            field2.setText(value2);
        } else {
            this.myState.put(key, field2.getText());
        }
        field2.addFocusListener((FocusListener)this);
        field2.getTextField().getDocument().addDocumentListener(this);
        field2.getTextField().addFocusListener(this);
    }

    public void register(@NotNull ScopedStateStore.Key<String> key, @NotNull DocumentAccessor field2) {
        if (key == null) {
            ScopedDataBinder.$$$reportNull$$$0(27);
        }
        if (field2 == null) {
            ScopedDataBinder.$$$reportNull$$$0(28);
        }
        assert (field2 instanceof JComponent);
        JComponent component = (JComponent)field2;
        String value2 = this.bindAndGet(key, component, null);
        if (value2 != null) {
            field2.setText(value2);
        } else {
            this.myState.put(key, field2.getText());
        }
        component.addFocusListener(this);
        this.myDocumentsToComponent.put(field2.getDocument(), component);
        field2.getDocument().addDocumentListener(this);
    }

    public void register(@NotNull ScopedStateStore.Key<Color> key, @NotNull ColorPanel colorPanel) {
        Color value2;
        if (key == null) {
            ScopedDataBinder.$$$reportNull$$$0(29);
        }
        if (colorPanel == null) {
            ScopedDataBinder.$$$reportNull$$$0(30);
        }
        if ((value2 = this.bindAndGet(key, (JComponent)colorPanel, null)) != null) {
            colorPanel.setSelectedColor(value2);
        } else {
            this.myState.put(key, colorPanel.getSelectedColor());
        }
        colorPanel.addFocusListener((FocusListener)this);
        colorPanel.addActionListener((ActionListener)this);
    }

    protected void deregister(JComponent component) {
        if (this.myComponentBindings.rowMap().remove(component) != null) {
            component.removeFocusListener(this);
            if (component instanceof JCheckBox) {
                ((JCheckBox)component).removeItemListener(this);
            } else if (component instanceof JComboBox) {
                ((JComboBox)component).removeActionListener(this);
            } else if (component instanceof JTextField) {
                ((JTextField)component).getDocument().removeDocumentListener(this);
            } else if (component instanceof JRadioButton) {
                ((JRadioButton)component).removeActionListener(this);
            } else if (component instanceof JSlider) {
                ((JSlider)component).removeChangeListener(this);
            } else if (component instanceof JSpinner) {
                ((JSpinner)component).removeChangeListener(this);
            } else if (component instanceof TextFieldWithBrowseButton) {
                ((TextFieldWithBrowseButton)component).getTextField().getDocument().removeDocumentListener(this);
                ((TextFieldWithBrowseButton)component).getTextField().removeFocusListener(this);
            } else if (component instanceof ColorPanel) {
                ((ColorPanel)component).removeActionListener((ActionListener)this);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.saveState((JComponent)e.getSource());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.saveState((JComponent)e.getSource());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.saveState((JComponent)e.getSource());
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.saveState(this.myDocumentsToComponent.get(e.getDocument()));
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.saveState(this.myDocumentsToComponent.get(e.getDocument()));
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedKey";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deriver";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateTrigger";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binding";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkBox";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paddingSlider";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorPanel";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/wizard/dynamic/ScopedDataBinder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "internalUpdateKey";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "deriveValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "saveState";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "storeValue";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getComponentValue";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setComponentValue";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "registerValueDeriver";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "register";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "bindAndGet";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DefaultBinding
    extends ComponentBinding<Object, JComponent> {
        private DefaultBinding() {
        }

        @Override
        public void setValue(@Nullable Object newValue, @NotNull JComponent component) {
            if (component == null) {
                DefaultBinding.$$$reportNull$$$0(0);
            }
            ScopedDataBinder.setComponentValue(newValue, component);
        }

        @Override
        @Nullable
        public Object getValue(@NotNull JComponent component) {
            if (component == null) {
                DefaultBinding.$$$reportNull$$$0(1);
            }
            return ScopedDataBinder.getComponentValue(component);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "component";
            objectArray2[1] = "com/android/tools/idea/wizard/dynamic/ScopedDataBinder$DefaultBinding";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class ComponentBinding<T, C extends JComponent> {
        public void setValue(@Nullable T newValue, @NotNull C component) {
            if (component == null) {
                ComponentBinding.$$$reportNull$$$0(0);
            }
            throw new UnsupportedOperationException();
        }

        @Nullable
        public T getValue(@NotNull C component) {
            if (component == null) {
                ComponentBinding.$$$reportNull$$$0(1);
            }
            throw new UnsupportedOperationException();
        }

        public void addActionListener(@NotNull ActionListener listener2, @NotNull C component) {
            if (listener2 == null) {
                ComponentBinding.$$$reportNull$$$0(2);
            }
            if (component == null) {
                ComponentBinding.$$$reportNull$$$0(3);
            }
        }

        public void addChangeListener(@NotNull ChangeListener listener2, @NotNull C component) {
            if (listener2 == null) {
                ComponentBinding.$$$reportNull$$$0(4);
            }
            if (component == null) {
                ComponentBinding.$$$reportNull$$$0(5);
            }
        }

        public void addItemListener(@NotNull ItemListener listener2, @NotNull C component) {
            if (listener2 == null) {
                ComponentBinding.$$$reportNull$$$0(6);
            }
            if (component == null) {
                ComponentBinding.$$$reportNull$$$0(7);
            }
        }

        @Nullable
        public Document getDocument(@NotNull C component) {
            if (component == null) {
                ComponentBinding.$$$reportNull$$$0(8);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/wizard/dynamic/ScopedDataBinder$ComponentBinding";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getValue";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addActionListener";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addChangeListener";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addItemListener";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getDocument";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class ValueDeriver<T> {
        public boolean respectUserEdits() {
            return true;
        }

        @Nullable
        public Set<ScopedStateStore.Key<?>> getTriggerKeys() {
            return null;
        }

        @Nullable
        protected static Set<ScopedStateStore.Key<?>> makeSetOf(ScopedStateStore.Key<?> ... elements) {
            HashSet keys = new HashSet(elements.length);
            Collections.addAll(keys, elements);
            return keys;
        }

        @Nullable
        public abstract T deriveValue(@NotNull ScopedStateStore var1, @Nullable ScopedStateStore.Key var2, @Nullable T var3);
    }
}

