/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.widget;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.widget.AdbConnectionWidget;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import java.awt.Component;
import java.io.File;
import java.util.concurrent.ExecutionException;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StudioAdapter
implements AdbConnectionWidget.StudioAdapter {
    @Nullable
    private Project myProject;
    @Nullable
    private TimerListener myTimerListener;

    StudioAdapter(@NotNull Project project) {
        if (project == null) {
            StudioAdapter.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @Override
    public boolean isBridgeConnected() {
        ListenableFuture<AndroidDebugBridge> bridgeFuture;
        AdbService adb = AdbService.getInstance();
        File adbFile = AndroidSdkUtils.getAdb(this.myProject);
        if (adbFile != null && !(bridgeFuture = adb.getDebugBridge(adbFile)).isCancelled() && bridgeFuture.isDone()) {
            try {
                return ((AndroidDebugBridge)bridgeFuture.get()).isConnected();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Logger.getInstance(StudioAdapter.class).warn((Throwable)e);
            }
            catch (ExecutionException e) {
                Logger.getInstance(StudioAdapter.class).warn((Throwable)e);
            }
        }
        return false;
    }

    @Override
    public boolean isBridgeInUserManagedMode() {
        return AndroidDebugBridge.isUserManagedAdbMode();
    }

    @Override
    @Nullable
    public StatusBar getVisibleStatusBar() {
        IdeFrame frame = WindowManager.getInstance().getIdeFrame(this.myProject);
        if (frame == null) {
            return null;
        }
        StatusBar statusBar = frame.getStatusBar();
        if (statusBar == null) {
            return null;
        }
        if (!statusBar.getComponent().isShowing()) {
            return null;
        }
        return statusBar;
    }

    public void dispose() {
        this.removeTimerListener();
        this.myProject = null;
    }

    @Override
    public void setOnUpdate(final @NotNull Runnable update2) {
        if (update2 == null) {
            StudioAdapter.$$$reportNull$$$0(1);
        }
        if (this.myTimerListener != null) {
            this.removeTimerListener();
        }
        this.myTimerListener = new TimerListener(){

            @NotNull
            public ModalityState getModalityState() {
                ModalityState modalityState = StudioAdapter.this.getModalityState();
                if (modalityState == null) {
                    1.$$$reportNull$$$0(0);
                }
                return modalityState;
            }

            public void run() {
                update2.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/widget/StudioAdapter$1", "getModalityState"));
            }
        };
        ActionManager.getInstance().addTimerListener(0, this.myTimerListener);
    }

    @NotNull
    private ModalityState getModalityState() {
        IdeFrame ideFrame = WindowManager.getInstance().getIdeFrame(this.myProject);
        if (ideFrame == null) {
            ModalityState modalityState = ModalityState.defaultModalityState();
            if (modalityState == null) {
                StudioAdapter.$$$reportNull$$$0(2);
            }
            return modalityState;
        }
        ModalityState modalityState = ModalityState.stateForComponent((Component)ideFrame.getComponent());
        if (modalityState == null) {
            StudioAdapter.$$$reportNull$$$0(3);
        }
        return modalityState;
    }

    private void removeTimerListener() {
        if (this.myTimerListener != null) {
            ActionManager.getInstance().removeTimerListener(this.myTimerListener);
        }
        this.myTimerListener = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "update";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/widget/StudioAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/widget/StudioAdapter";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModalityState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setOnUpdate";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

