/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.widget;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.util.Consumer;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AdbConnectionWidget
implements StatusBarWidget.IconPresentation,
StatusBarWidget {
    @VisibleForTesting
    static final String ID = "AdbConnectionWidget";
    @NotNull
    private ConnectionState myLastConnectionState;
    @Nullable
    private StudioAdapter myAdapter;

    AdbConnectionWidget(@NotNull StudioAdapter adapter) {
        if (adapter == null) {
            AdbConnectionWidget.$$$reportNull$$$0(0);
        }
        this.myAdapter = adapter;
        this.myAdapter.setOnUpdate(this::updateIfNeeded);
        Disposer.register((Disposable)this, (Disposable)this.myAdapter);
        this.myLastConnectionState = this.getConnectionState();
    }

    @NotNull
    public String ID() {
        return ID;
    }

    @NotNull
    public StatusBarWidget.WidgetPresentation getPresentation() {
        AdbConnectionWidget adbConnectionWidget = this;
        if (adbConnectionWidget == null) {
            AdbConnectionWidget.$$$reportNull$$$0(1);
        }
        return adbConnectionWidget;
    }

    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            AdbConnectionWidget.$$$reportNull$$$0(2);
        }
    }

    public void dispose() {
        this.myAdapter = null;
    }

    @NotNull
    public String getTooltipText() {
        String string = this.myLastConnectionState.myTooltip;
        if (string == null) {
            AdbConnectionWidget.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public Consumer<MouseEvent> getClickConsumer() {
        return null;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon2 = this.myLastConnectionState.myIcon;
        if (icon2 == null) {
            AdbConnectionWidget.$$$reportNull$$$0(4);
        }
        return icon2;
    }

    private void updateIfNeeded() {
        if (this.myAdapter == null) {
            return;
        }
        StatusBar statusBar = this.myAdapter.getVisibleStatusBar();
        if (statusBar == null) {
            return;
        }
        ConnectionState connectionState = this.getConnectionState();
        if (connectionState == this.myLastConnectionState) {
            return;
        }
        this.myLastConnectionState = connectionState;
        statusBar.updateWidget(ID);
    }

    @NotNull
    private ConnectionState getConnectionState() {
        if (this.myAdapter == null) {
            ConnectionState connectionState = ConnectionState.STUDIO_MANAGED_DISCONNECTED;
            if (connectionState == null) {
                AdbConnectionWidget.$$$reportNull$$$0(5);
            }
            return connectionState;
        }
        if (this.myAdapter.isBridgeConnected()) {
            ConnectionState connectionState = this.myAdapter.isBridgeInUserManagedMode() ? ConnectionState.USER_MANAGED_CONNECTED : ConnectionState.STUDIO_MANAGED_CONNECTED;
            if (connectionState == null) {
                AdbConnectionWidget.$$$reportNull$$$0(6);
            }
            return connectionState;
        }
        ConnectionState connectionState = this.myAdapter.isBridgeInUserManagedMode() ? ConnectionState.USER_MANAGED_DISCONNECTED : ConnectionState.STUDIO_MANAGED_DISCONNECTED;
        if (connectionState == null) {
            AdbConnectionWidget.$$$reportNull$$$0(7);
        }
        return connectionState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adapter";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/widget/AdbConnectionWidget";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/widget/AdbConnectionWidget";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltipText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface StudioAdapter
    extends Disposable {
        public boolean isBridgeConnected();

        public boolean isBridgeInUserManagedMode();

        @Nullable
        public StatusBar getVisibleStatusBar();

        public void setOnUpdate(@NotNull Runnable var1);
    }

    static enum ConnectionState {
        STUDIO_MANAGED_DISCONNECTED(ConnectionState.getStatusIcon(StudioIcons.Shell.StatusBar.ADB_MANAGED, Color.RED), "Not initialized/connected to local adb"),
        STUDIO_MANAGED_CONNECTED(ConnectionState.getStatusIcon(StudioIcons.Shell.StatusBar.ADB_MANAGED, Color.GREEN), "Initialized/connected to local adb"),
        USER_MANAGED_DISCONNECTED(ConnectionState.getStatusIcon(StudioIcons.Shell.StatusBar.ADB_UNMANAGED, Color.RED), "Not connected to remote adb"),
        USER_MANAGED_CONNECTED(ConnectionState.getStatusIcon(StudioIcons.Shell.StatusBar.ADB_UNMANAGED, Color.GREEN), "Connected to remote adb");

        @VisibleForTesting
        @NotNull
        Icon myIcon;
        @VisibleForTesting
        @NotNull
        private String myTooltip;

        private ConnectionState(Icon icon2, String tooltip) {
            if (icon2 == null) {
                ConnectionState.$$$reportNull$$$0(0);
            }
            if (tooltip == null) {
                ConnectionState.$$$reportNull$$$0(1);
            }
            this.myIcon = icon2;
            this.myTooltip = tooltip;
        }

        @NotNull
        private static Icon getStatusIcon(@NotNull Icon base, @NotNull Color color) {
            if (base == null) {
                ConnectionState.$$$reportNull$$$0(2);
            }
            if (color == null) {
                ConnectionState.$$$reportNull$$$0(3);
            }
            Icon icon2 = ExecutionUtil.getIndicator((Icon)base, (int)base.getIconWidth(), (int)base.getIconHeight(), (Color)color);
            if (icon2 == null) {
                ConnectionState.$$$reportNull$$$0(4);
            }
            return icon2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tooltip";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "base";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "color";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/widget/AdbConnectionWidget$ConnectionState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/widget/AdbConnectionWidget$ConnectionState";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatusIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getStatusIcon";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

