/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.tools.idea.welcome.wizard.AndroidStudioWelcomeScreenProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WelcomeFrameProvider;
import com.intellij.openapi.wm.WelcomeScreenProvider;
import com.intellij.openapi.wm.impl.welcomeScreen.FlatWelcomeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Rectangle;
import org.jetbrains.annotations.Nullable;

final class FirstRunWizardFrameProvider
implements WelcomeFrameProvider {
    FirstRunWizardFrameProvider() {
    }

    @Nullable
    public IdeFrame createFrame() {
        WelcomeFrame frame = (WelcomeFrame)WelcomeScreenProvider.EP_NAME.computeSafeIfAny(provider2 -> {
            if (provider2 instanceof AndroidStudioWelcomeScreenProvider && provider2.isAvailable()) {
                return new WelcomeFrame();
            }
            return null;
        });
        return frame != null ? frame : this.customizeFlatWelcomeFrame();
    }

    @Nullable
    private IdeFrame customizeFlatWelcomeFrame() {
        return (IdeFrame)WelcomeFrame.EP.computeSafeIfAny(provider2 -> {
            if (provider2 == this) {
                return null;
            }
            IdeFrame frame = provider2.createFrame();
            if (frame == null) {
                return null;
            }
            if (frame instanceof FlatWelcomeFrame) {
                FlatWelcomeFrame welcomeFrame = (FlatWelcomeFrame)frame;
                UiNotifyConnector.doWhenFirstShown((Component)welcomeFrame, () -> {
                    Logger.getInstance(this.getClass()).info("Overriding welcome frame to be resizable");
                    welcomeFrame.setResizable(true);
                    Rectangle newBounds = welcomeFrame.getBounds();
                    ScreenUtil.fitToScreen((Rectangle)newBounds);
                    welcomeFrame.setBounds(newBounds);
                });
            }
            return frame;
        });
    }
}

