/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.util.FormatUtil;
import com.android.tools.idea.welcome.install.ComponentInstaller;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallOperation;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.install.SdkManagerProgressIndicatorIntegration;
import com.android.tools.idea.welcome.install.WizardException;
import com.intellij.execution.ui.ConsoleViewContentType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0018\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/welcome/install/InstallComponentsOperation;", "Lcom/android/tools/idea/welcome/install/InstallOperation;", "Ljava/io/File;", "context", "Lcom/android/tools/idea/welcome/install/InstallContext;", "components", "", "Lcom/android/tools/idea/welcome/install/InstallableComponent;", "componentInstaller", "Lcom/android/tools/idea/welcome/install/ComponentInstaller;", "progressRatio", "", "(Lcom/android/tools/idea/welcome/install/InstallContext;Ljava/util/Collection;Lcom/android/tools/idea/welcome/install/ComponentInstaller;D)V", "cleanup", "", "result", "perform", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "argument", "Companion", "intellij.android.core"})
public final class InstallComponentsOperation
extends InstallOperation<File, File> {
    private final Collection<InstallableComponent> components;
    private final ComponentInstaller componentInstaller;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    protected File perform(@NotNull com.intellij.openapi.progress.ProgressIndicator indicator, @NotNull File argument) throws WizardException {
        Collection<Object> collection2;
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        indicator.setText("Checking for updated SDK components");
        try {
            collection2 = this.componentInstaller.getPackagesToInstall((Iterable<? extends InstallableComponent>)this.components);
        }
        catch (SdkQuickfixUtils.PackageResolutionException e) {
            throw (Throwable)new WizardException("Failed to determine required packages", e);
        }
        List<RemotePackage> packages = collection2;
        while (true) {
            Object object;
            collection2 = packages;
            boolean bl = false;
            if (!(!collection2.isEmpty())) break;
            indicator.setFraction(0.0);
            SdkManagerProgressIndicatorIntegration logger2 = new SdkManagerProgressIndicatorIntegration(indicator, this.getContext());
            this.componentInstaller.installPackages(packages, new StudioDownloader(), (ProgressIndicator)logger2);
            try {
                object = this.componentInstaller.getPackagesToInstall((Iterable<? extends InstallableComponent>)this.components);
            }
            catch (SdkQuickfixUtils.PackageResolutionException e) {
                throw (Throwable)new WizardException("Failed to determine required packages", e);
            }
            packages = object;
            String string = InstallComponentsOperation.Companion.getRetryMessage(packages);
            if (string == null) continue;
            object = string;
            boolean bl2 = false;
            boolean bl3 = false;
            Object message2 = object;
            boolean bl4 = false;
            String string2 = logger2.getErrors();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"logger.errors");
            this.promptToRetry((String)message2, string2, null);
        }
        this.getContext().print("Android SDK is up to date.\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        indicator.setFraction(1.0);
        return argument;
    }

    @Override
    public void cleanup(@NotNull File result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
    }

    public InstallComponentsOperation(@NotNull InstallContext context, @NotNull Collection<? extends InstallableComponent> components, @NotNull ComponentInstaller componentInstaller, double progressRatio) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(components, (String)"components");
        Intrinsics.checkNotNullParameter((Object)componentInstaller, (String)"componentInstaller");
        super(context, progressRatio);
        this.components = components;
        this.componentInstaller = componentInstaller;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/welcome/install/InstallComponentsOperation$Companion;", "", "()V", "getRetryMessage", "", "packages", "", "Lcom/android/repository/api/RemotePackage;", "intellij.android.core"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        private final String getRetryMessage(Collection<? extends RemotePackage> packages) {
            void $this$mapTo$iv$iv;
            if (packages.isEmpty()) {
                return null;
            }
            Iterable $this$map$iv = packages;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RemotePackage remotePackage = (RemotePackage)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                String string = it.getDisplayName();
                collection2.add(string);
            }
            return FormatUtil.formatElementListString((List)destination$iv$iv, "The following SDK component was not installed: %s", "The following SDK components were not installed: %1$s and %2$s", "%1$s and %2$s more SDK components were not installed");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

