/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.sdklib.devices.Storage;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.util.FileExtensions;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.install.HaxmKt;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u001a\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"GVM_WINDOWS_INSTALL_URL", "", "HAXM_DOCUMENTATION_URL", "HAXM_MAC_INSTALL_URL", "HAXM_WINDOWS_INSTALL_URL", "defaultSdkLocation", "Ljava/io/File;", "getDefaultSdkLocation", "()Ljava/io/File;", "getInitialSdkLocation", "mode", "Lcom/android/tools/idea/welcome/config/FirstRunWizardMode;", "getMaxHaxmMemory", "", "memorySize", "", "getRecommendedHaxmMemory", "intellij.android.core"})
@JvmName(name="FirstRunWizardDefaults")
public final class FirstRunWizardDefaults {
    @NotNull
    public static final String HAXM_DOCUMENTATION_URL = "https://github.com/intel/haxm";
    @NotNull
    public static final String HAXM_WINDOWS_INSTALL_URL = "https://github.com/intel/haxm/wiki/Installation-Instructions-on-Windows";
    @NotNull
    public static final String HAXM_MAC_INSTALL_URL = "https://github.com/intel/haxm/wiki/Installation-Instructions-on-macOS";
    @NotNull
    public static final String GVM_WINDOWS_INSTALL_URL = "https://github.com/google/android-emulator-hypervisor-driver-for-amd-processors";

    private static final File getDefaultSdkLocation() {
        String string = System.getenv("ANDROID_HOME");
        if (string == null) {
            string = System.getenv("ANDROID_SDK_ROOT");
        }
        String path2 = string;
        CharSequence charSequence = path2;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            String string2;
            String userHome = System.getProperty("user.home");
            if (SystemInfo.isWindows) {
                string2 = FileUtil.join((String[])new String[]{userHome, "AppData", "Local", "Android", "Sdk"});
            } else if (SystemInfo.isMac) {
                string2 = FileUtil.join((String[])new String[]{userHome, "Library", "Android", "sdk"});
            } else if (SystemInfo.isLinux) {
                string2 = FileUtil.join((String[])new String[]{userHome, "Android", "Sdk"});
            } else {
                Messages.showErrorDialog((String)"Your OS is not officially supported.\nYou can continue, but it is likely you will encounter further problems.", (String)"Unsupported OS");
                string2 = "";
            }
            path2 = string2;
        }
        return new File(path2);
    }

    public static final int getRecommendedHaxmMemory(long memorySize) {
        long l;
        long gb = Storage.Unit.GiB.getNumberOfBytes();
        if (memorySize > (long)16 * gb) {
            l = (long)4 * gb;
        } else if (memorySize > (long)4 * gb) {
            l = (long)2 * gb;
        } else if (memorySize > (long)2 * gb) {
            l = gb;
        } else {
            long l2 = gb / (long)2;
            boolean bl = false;
            l = Math.min(memorySize, l2);
        }
        long defaultMemory = l;
        return RangesKt.coerceAtMost((int)((int)(defaultMemory / HaxmKt.UI_UNITS.getNumberOfBytes())), (int)FirstRunWizardDefaults.getMaxHaxmMemory(memorySize));
    }

    public static final int getMaxHaxmMemory(long memorySize) {
        long gb = Storage.Unit.GiB.getNumberOfBytes();
        long maxMemory = RangesKt.coerceAtLeast((long)(memorySize - (long)2 * gb), (long)(memorySize / (long)2));
        return (int)(maxMemory / HaxmKt.UI_UNITS.getNumberOfBytes());
    }

    @NotNull
    public static final File getInitialSdkLocation(@NotNull FirstRunWizardMode mode) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        File file3 = mode.getSdkLocation();
        if (file3 == null) {
            AndroidSdks androidSdks = AndroidSdks.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)androidSdks, (String)"AndroidSdks.getInstance()");
            List<Sdk> list = androidSdks.getAllAndroidSdks();
            Intrinsics.checkNotNullExpressionValue(list, (String)"AndroidSdks.getInstance().allAndroidSdks");
            Sdk sdk = (Sdk)CollectionsKt.firstOrNull(list);
            file3 = sdk != null && (sdk = sdk.getHomeDirectory()) != null ? FileExtensions.toIoFile((VirtualFile)sdk) : (file2 = null);
        }
        if (file3 == null) {
            file2 = FirstRunWizardDefaults.getDefaultSdkLocation();
        }
        return file2;
    }
}

