/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.util;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PropertiesFiles {
    private PropertiesFiles() {
    }

    @NotNull
    public static Properties getProperties(@NotNull File filePath) throws IOException {
        if (filePath == null) {
            PropertiesFiles.$$$reportNull$$$0(0);
        }
        Properties properties2 = (Properties)ReadAction.compute(() -> {
            VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)filePath, (boolean)false);
            if (virtualFile == null) {
                return new Properties();
            }
            if (virtualFile.isDirectory()) {
                throw new IllegalArgumentException(String.format("The path '%1$s' belongs to a directory!", filePath.getPath()));
            }
            Properties properties2 = new Properties();
            try (InputStreamReader reader = new InputStreamReader(virtualFile.getInputStream(), StandardCharsets.UTF_8);){
                properties2.load(reader);
            }
            return properties2;
        });
        if (properties2 == null) {
            PropertiesFiles.$$$reportNull$$$0(1);
        }
        return properties2;
    }

    public static void savePropertiesToFile(@NotNull Properties properties2, @NotNull File filePath, @Nullable String comments) throws IOException {
        if (properties2 == null) {
            PropertiesFiles.$$$reportNull$$$0(2);
        }
        if (filePath == null) {
            PropertiesFiles.$$$reportNull$$$0(3);
        }
        WriteAction.computeAndWait(() -> {
            VirtualFile directory = VfsUtil.createDirectoryIfMissing((String)filePath.getParent());
            if (directory == null) {
                throw new IllegalStateException("Cannot find or create a VFS file for directory: " + filePath.getParent());
            }
            VirtualFile virtualFile = directory.findOrCreateChildData(PropertiesFiles.class, filePath.getName());
            try (OutputStream out = virtualFile.getOutputStream(PropertiesFiles.class);){
                properties2.store(out, comments);
            }
            return null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/util/PropertiesFiles";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/util/PropertiesFiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "savePropertiesToFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

