/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.repository.api.RepoPackage;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.util.RepoPackageUtilKt;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.avdmanager.HardwareAccelerationCheck;
import com.android.tools.idea.updater.configure.DetailsTreeNode;
import com.android.tools.idea.updater.configure.DownloadStatusColumnInfo;
import com.android.tools.idea.updater.configure.MultiVersionTreeNode;
import com.android.tools.idea.updater.configure.PackageNodeModel;
import com.android.tools.idea.updater.configure.ParentTreeNode;
import com.android.tools.idea.updater.configure.RootNode;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigPanel;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigurable;
import com.android.tools.idea.updater.configure.StatusColumnInfo;
import com.android.tools.idea.updater.configure.UpdaterTreeNode;
import com.android.tools.idea.updater.configure.VersionColumnInfo;
import com.android.tools.idea.welcome.install.Gvm;
import com.android.tools.idea.welcome.install.Haxm;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.DynamicBundle;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreeNode;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class ToolComponentsPanel {
    private static final Set<String> MULTI_VERSION_PREFIXES = ImmutableSet.of((Object)"build-tools", (Object)"lldb", (Object)"cmake", (Object)"ndk", (Object)"cmdline-tools", (Object)String.join((CharSequence)String.valueOf(';'), "extras", "android", "gapid"), (Object[])new String[0]);
    private static final Set<String> CHROME_OS_INCOMPATIBLE_PATHS = ImmutableSet.of((Object)"emulator", (Object)Haxm.InstallerInfo.getRepoPackagePath(), (Object)Gvm.InstallerInfo.getRepoPackagePath());
    private TreeTableView myToolsSummaryTable;
    private JCheckBox myToolsDetailsCheckbox;
    private JCheckBox myHideObsoletePackagesCheckbox;
    private JPanel myToolsPanel;
    private TreeTableView myToolsDetailTable;
    private JPanel myToolsLoadingPanel;
    private AsyncProcessIcon myToolsLoadingIcon;
    private JPanel myRootPanel;
    private final Set<UpdatablePackage> myToolsPackages;
    private final Multimap<String, UpdatablePackage> myMultiVersionPackages;
    private final Multimap<String, UpdatablePackage> myMavenPackages;
    @VisibleForTesting
    UpdaterTreeNode myToolsDetailsRootNode;
    @VisibleForTesting
    UpdaterTreeNode myToolsSummaryRootNode;
    Set<PackageNodeModel> myStates;
    private boolean myModified;
    private final ChangeListener myModificationListener;
    private SdkUpdaterConfigurable myConfigurable;

    public ToolComponentsPanel() {
        Comparator comparator2 = (o1, o2) -> ComparisonChain.start().compare((Comparable)((Object)o1.getRepresentative().getDisplayName()), (Comparable)((Object)o2.getRepresentative().getDisplayName())).compare((Comparable)((Object)o1.getRepresentative().getPath()), (Comparable)((Object)o2.getRepresentative().getPath())).result();
        this.$$$setupUI$$$();
        this.myToolsPackages = Sets.newTreeSet((Comparator)comparator2);
        this.myMultiVersionPackages = HashMultimap.create();
        this.myMavenPackages = HashMultimap.create();
        this.myStates = new HashSet<PackageNodeModel>();
        this.myModified = false;
        this.myModificationListener = e -> this.refreshModified();
        this.myToolsDetailsCheckbox.addActionListener(e -> this.updateToolsTable());
        this.myHideObsoletePackagesCheckbox.addActionListener(e -> this.updateToolsItems());
    }

    private void updateToolsTable() {
        ((CardLayout)this.myToolsPanel.getLayout()).show(this.myToolsPanel, this.myToolsDetailsCheckbox.isSelected() ? "details" : "summary");
    }

    private void updateToolsItems() {
        this.myToolsDetailsRootNode.removeAllChildren();
        this.myToolsSummaryRootNode.removeAllChildren();
        this.myStates.clear();
        for (String prefix : this.myMultiVersionPackages.keySet()) {
            Collection versions = this.myMultiVersionPackages.get((Object)prefix);
            TreeSet<DetailsTreeNode> detailsNodes = new TreeSet<DetailsTreeNode>(Comparator.comparing(node2 -> node2.getPackage().getVersion()).thenComparing(node2 -> node2.getPackage().getPath().endsWith("latest")).reversed());
            for (UpdatablePackage info2 : versions) {
                PackageNodeModel model2;
                RepoPackage representative = info2.getRepresentative();
                if (representative.getTypeDetails() instanceof DetailsTypes.MavenType || (model2 = new PackageNodeModel(info2)).obsolete() && this.myHideObsoletePackagesCheckbox.isSelected()) continue;
                this.myStates.add(model2);
                detailsNodes.add(new DetailsTreeNode(model2, this.myModificationListener, this.myConfigurable));
            }
            if (detailsNodes.isEmpty()) continue;
            MultiVersionTreeNode summaryNode = new MultiVersionTreeNode(detailsNodes);
            this.myToolsSummaryRootNode.add(summaryNode);
            ParentTreeNode multiVersionParent = new ParentTreeNode(summaryNode.getDisplayName());
            detailsNodes.forEach(multiVersionParent::add);
            this.myToolsDetailsRootNode.add(multiVersionParent);
        }
        for (UpdatablePackage info3 : this.myToolsPackages) {
            PackageNodeModel holder;
            boolean isMaven = info3.getPath().endsWith(";m2repository");
            if (isMaven || (holder = new PackageNodeModel(info3)).obsolete() && this.myHideObsoletePackagesCheckbox.isSelected()) continue;
            this.myStates.add(holder);
            DetailsTreeNode node3 = new DetailsTreeNode(holder, this.myModificationListener, this.myConfigurable);
            this.myToolsDetailsRootNode.add(node3);
            DetailsTreeNode summaryNode = new DetailsTreeNode(holder, this.myModificationListener, this.myConfigurable);
            this.myToolsSummaryRootNode.add(summaryNode);
        }
        this.refreshModified();
        SdkUpdaterConfigPanel.resizeColumnsToFit((JTable)this.myToolsDetailTable);
        SdkUpdaterConfigPanel.resizeColumnsToFit((JTable)this.myToolsSummaryTable);
        this.myToolsDetailTable.updateUI();
        this.myToolsSummaryTable.updateUI();
        TreeUtil.expandAll((JTree)this.myToolsDetailTable.getTree());
        TreeUtil.expandAll((JTree)this.myToolsSummaryTable.getTree());
    }

    public void setPackages(@NotNull Set<UpdatablePackage> toolsPackages) {
        if (toolsPackages == null) {
            ToolComponentsPanel.$$$reportNull$$$0(0);
        }
        this.myMultiVersionPackages.clear();
        this.myToolsPackages.clear();
        for (UpdatablePackage p : toolsPackages) {
            String path2 = p.getRepresentative().getPath();
            if (ToolComponentsPanel.shouldAlwaysHide(path2)) continue;
            boolean found = false;
            String prefix = RepoPackageUtilKt.getRepoPackagePrefix((String)path2);
            if (MULTI_VERSION_PREFIXES.contains(prefix) || p.getRepresentative().getTypeDetails() instanceof DetailsTypes.MavenType) {
                this.myMultiVersionPackages.put((Object)prefix, (Object)p);
                found = true;
            }
            if (found) continue;
            this.myToolsPackages.add(p);
        }
        this.updateToolsItems();
    }

    private static boolean shouldAlwaysHide(@NotNull String path2) {
        String prefix;
        if (path2 == null) {
            ToolComponentsPanel.$$$reportNull$$$0(1);
        }
        if ((prefix = RepoPackageUtilKt.getRepoPackagePrefix((String)path2)).equals("patcher")) {
            return true;
        }
        return HardwareAccelerationCheck.isChromeOSAndIsNotHWAccelerated() && CHROME_OS_INCOMPATIBLE_PATHS.contains(path2);
    }

    public void startLoading() {
        this.myToolsPackages.clear();
        this.myMultiVersionPackages.clear();
        this.myMavenPackages.clear();
        this.myToolsLoadingPanel.setVisible(true);
    }

    public void finishLoading() {
        this.updateToolsItems();
        this.myToolsLoadingPanel.setVisible(false);
    }

    public void reset() {
        Enumeration<TreeNode> children = this.myToolsDetailsRootNode.breadthFirstEnumeration();
        while (children.hasMoreElements()) {
            UpdaterTreeNode node2 = (UpdaterTreeNode)children.nextElement();
            node2.resetState();
        }
        this.refreshModified();
    }

    public boolean isModified() {
        return this.myModified;
    }

    public void refreshModified() {
        Enumeration<TreeNode> items2 = this.myToolsDetailsRootNode.breadthFirstEnumeration();
        while (items2.hasMoreElements()) {
            UpdaterTreeNode node2 = (UpdaterTreeNode)items2.nextElement();
            if (node2.getInitialState() == node2.getCurrentState()) continue;
            this.myModified = true;
            return;
        }
        this.myModified = false;
    }

    private void createUIComponents() {
        this.myToolsLoadingIcon = new AsyncProcessIcon(AndroidBundle.message("text.loading", new Object[0]));
        this.myToolsSummaryRootNode = new RootNode();
        this.myToolsDetailsRootNode = new RootNode();
        UpdaterTreeNode.Renderer renderer2 = new UpdaterTreeNode.Renderer();
        ColumnInfo[] toolsSummaryColumns = new ColumnInfo[]{new DownloadStatusColumnInfo(), new TreeColumnInfo("Name"), new VersionColumnInfo(), new StatusColumnInfo()};
        this.myToolsSummaryTable = new TreeTableView(new ListTreeTableModelOnColumns((TreeNode)this.myToolsSummaryRootNode, toolsSummaryColumns));
        SdkUpdaterConfigPanel.setTreeTableProperties(this.myToolsSummaryTable, renderer2, this.myModificationListener);
        ColumnInfo[] toolsDetailColumns = new ColumnInfo[]{new DownloadStatusColumnInfo(), new TreeColumnInfo("Name"), new VersionColumnInfo(), new StatusColumnInfo()};
        this.myToolsDetailTable = new TreeTableView(new ListTreeTableModelOnColumns((TreeNode)this.myToolsDetailsRootNode, toolsDetailColumns));
        SdkUpdaterConfigPanel.setTreeTableProperties(this.myToolsDetailTable, renderer2, this.myModificationListener);
    }

    public void setConfigurable(@NotNull SdkUpdaterConfigurable configurable) {
        if (configurable == null) {
            ToolComponentsPanel.$$$reportNull$$$0(2);
        }
        this.myConfigurable = configurable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolsPackages";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/updater/configure/ToolComponentsPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setPackages";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldAlwaysHide";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setConfigurable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        JCheckBox jCheckBox2;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myRootPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/AndroidBundle", ToolComponentsPanel.class).getString("label.below.are.the.available.sdk"));
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(600, -1), new Dimension(600, -1)));
        this.myToolsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new CardLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, "summary");
        TreeTableView treeTableView = this.myToolsSummaryTable;
        jBScrollPane.setViewportView((Component)treeTableView);
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane2, "details");
        TreeTableView treeTableView2 = this.myToolsDetailTable;
        jBScrollPane2.setViewportView((Component)treeTableView2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 2, 1, 3, 3, null, null, null));
        this.myToolsDetailsCheckbox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/AndroidBundle", ToolComponentsPanel.class).getString("checkbox.show.package.details"));
        jPanel4.add((Component)jCheckBox2, new GridConstraints(0, 3, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myToolsLoadingPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/AndroidBundle", ToolComponentsPanel.class).getString("label.looking.for.updates"));
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        AsyncProcessIcon asyncProcessIcon = this.myToolsLoadingIcon;
        jPanel.add((Component)asyncProcessIcon, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myHideObsoletePackagesCheckbox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/AndroidBundle", ToolComponentsPanel.class).getString("checkbox.hide.obsolete.packages"));
        jPanel4.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 4, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

