/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.repository.api.RepoPackage;
import com.android.repository.api.UpdatablePackage;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.updater.configure.ApiLevelColumnInfo;
import com.android.tools.idea.updater.configure.DetailsTreeNode;
import com.android.tools.idea.updater.configure.DownloadStatusColumnInfo;
import com.android.tools.idea.updater.configure.PackageNodeModel;
import com.android.tools.idea.updater.configure.ParentTreeNode;
import com.android.tools.idea.updater.configure.RevisionColumnInfo;
import com.android.tools.idea.updater.configure.RootNode;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigPanel;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigurable;
import com.android.tools.idea.updater.configure.StatusColumnInfo;
import com.android.tools.idea.updater.configure.SummaryTreeNode;
import com.android.tools.idea.updater.configure.UpdaterTreeNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.intellij.CommonBundle;
import com.intellij.DynamicBundle;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class PlatformComponentsPanel {
    private TreeTableView myPlatformSummaryTable;
    private TreeTableView myPlatformDetailTable;
    private JPanel myPlatformPanel;
    private JCheckBox myPlatformDetailsCheckbox;
    private JCheckBox myHideObsoletePackagesCheckbox;
    private JPanel myPlatformLoadingPanel;
    private JBLabel myPlatformLoadingLabel;
    private AsyncProcessIcon myPlatformLoadingIcon;
    private JPanel myRootPanel;
    private boolean myModified;
    @VisibleForTesting
    UpdaterTreeNode myPlatformDetailsRootNode;
    @VisibleForTesting
    UpdaterTreeNode myPlatformSummaryRootNode;
    Set<PackageNodeModel> myStates;
    private final Multimap<AndroidVersion, UpdatablePackage> myCurrentPackages;
    private final ChangeListener myModificationListener;
    private SdkUpdaterConfigurable myConfigurable;

    public PlatformComponentsPanel() {
        this.$$$setupUI$$$();
        this.myStates = new HashSet<PackageNodeModel>();
        this.myCurrentPackages = TreeMultimap.create();
        this.myModificationListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PlatformComponentsPanel.this.refreshModified();
            }
        };
        this.myPlatformSummaryTable.setColumnSelectionAllowed(false);
        this.myPlatformLoadingLabel.setForeground((Color)JBColor.GRAY);
        this.myPlatformDetailsCheckbox.addActionListener(e -> this.updatePlatformTable());
        this.myHideObsoletePackagesCheckbox.addActionListener(e -> this.updatePlatformItems());
    }

    private void updatePlatformTable() {
        ((CardLayout)this.myPlatformPanel.getLayout()).show(this.myPlatformPanel, this.myPlatformDetailsCheckbox.isSelected() ? "details" : "summary");
    }

    private void updatePlatformItems() {
        this.myPlatformDetailsRootNode.removeAllChildren();
        this.myPlatformSummaryRootNode.removeAllChildren();
        this.myStates.clear();
        List versions = Lists.newArrayList((Iterable)this.myCurrentPackages.keySet());
        versions = Lists.reverse((List)versions);
        for (AndroidVersion version2 : versions) {
            SummaryTreeNode node2;
            HashSet<UpdaterTreeNode> versionNodes = new HashSet<UpdaterTreeNode>();
            ParentTreeNode marker = new ParentTreeNode(version2);
            for (UpdatablePackage info2 : this.myCurrentPackages.get((Object)version2)) {
                RepoPackage pkg = info2.getRepresentative();
                if (pkg.obsolete() && this.myHideObsoletePackagesCheckbox.isSelected()) continue;
                PackageNodeModel model2 = new PackageNodeModel(info2);
                this.myStates.add(model2);
                DetailsTreeNode node3 = new DetailsTreeNode(model2, this.myModificationListener, this.myConfigurable);
                marker.add(node3);
                versionNodes.add(node3);
            }
            if (marker.getChildCount() > 0) {
                this.myPlatformDetailsRootNode.add(marker);
            }
            if ((node2 = SummaryTreeNode.createNode(version2, versionNodes)) == null) continue;
            this.myPlatformSummaryRootNode.add(node2);
        }
        this.refreshModified();
        SdkUpdaterConfigPanel.resizeColumnsToFit((JTable)this.myPlatformDetailTable);
        SdkUpdaterConfigPanel.resizeColumnsToFit((JTable)this.myPlatformSummaryTable);
        this.myPlatformDetailTable.updateUI();
        this.myPlatformSummaryTable.updateUI();
        TreeUtil.expandAll((JTree)this.myPlatformDetailTable.getTree());
        TreeUtil.expandAll((JTree)this.myPlatformSummaryTable.getTree());
    }

    public void startLoading() {
        this.myCurrentPackages.clear();
        this.myPlatformLoadingPanel.setVisible(true);
    }

    public void finishLoading() {
        this.updatePlatformItems();
        this.myPlatformLoadingPanel.setVisible(false);
    }

    private void createUIComponents() {
        UpdaterTreeNode.Renderer renderer2 = new UpdaterTreeNode.Renderer();
        this.myPlatformLoadingIcon = new AsyncProcessIcon(CommonBundle.getLoadingTreeNodeText());
        this.myPlatformSummaryRootNode = new RootNode();
        this.myPlatformDetailsRootNode = new RootNode();
        ColumnInfo[] platformSummaryColumns = new ColumnInfo[]{new DownloadStatusColumnInfo(), new TreeColumnInfo("Name"), new ApiLevelColumnInfo(), new RevisionColumnInfo(), new StatusColumnInfo()};
        this.myPlatformSummaryTable = new TreeTableView(new ListTreeTableModelOnColumns((TreeNode)this.myPlatformSummaryRootNode, platformSummaryColumns));
        SdkUpdaterConfigPanel.setTreeTableProperties(this.myPlatformSummaryTable, renderer2, this.myModificationListener);
        ColumnInfo[] platformDetailColumns = new ColumnInfo[]{new DownloadStatusColumnInfo(), new TreeColumnInfo("Name"), new ApiLevelColumnInfo(), new RevisionColumnInfo(), new StatusColumnInfo()};
        this.myPlatformDetailTable = new TreeTableView(new ListTreeTableModelOnColumns((TreeNode)this.myPlatformDetailsRootNode, platformDetailColumns));
        SdkUpdaterConfigPanel.setTreeTableProperties(this.myPlatformDetailTable, renderer2, this.myModificationListener);
    }

    public void setPackages(@NotNull Multimap<AndroidVersion, UpdatablePackage> packages) {
        if (packages == null) {
            PlatformComponentsPanel.$$$reportNull$$$0(0);
        }
        this.myCurrentPackages.clear();
        this.myCurrentPackages.putAll(packages);
        this.updatePlatformItems();
    }

    public boolean isModified() {
        return this.myModified;
    }

    public void refreshModified() {
        Enumeration<TreeNode> items2 = this.myPlatformDetailsRootNode.breadthFirstEnumeration();
        while (items2.hasMoreElements()) {
            UpdaterTreeNode node2 = (UpdaterTreeNode)items2.nextElement();
            if (node2.getInitialState() == node2.getCurrentState()) continue;
            this.myModified = true;
            return;
        }
        this.myModified = false;
    }

    public void reset() {
        Enumeration<TreeNode> children = this.myPlatformDetailsRootNode.breadthFirstEnumeration();
        while (children.hasMoreElements()) {
            UpdaterTreeNode node2 = (UpdaterTreeNode)children.nextElement();
            node2.resetState();
        }
        this.refreshModified();
    }

    public void setEnabled(boolean enabled) {
        this.myPlatformDetailTable.setEnabled(enabled);
        this.myPlatformSummaryTable.setEnabled(enabled);
        this.myPlatformDetailsCheckbox.setEnabled(enabled);
    }

    public void setConfigurable(@NotNull SdkUpdaterConfigurable configurable) {
        if (configurable == null) {
            PlatformComponentsPanel.$$$reportNull$$$0(1);
        }
        this.myConfigurable = configurable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/updater/configure/PlatformComponentsPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setPackages";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setConfigurable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JBLabel jBLabel;
        JPanel jPanel2;
        JCheckBox jCheckBox2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myRootPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPlatformDetailsCheckbox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/AndroidBundle", PlatformComponentsPanel.class).getString("checkbox.show.package.details"));
        jPanel4.add((Component)jCheckBox2, new GridConstraints(0, 3, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myPlatformLoadingPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPlatformLoadingLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/AndroidBundle", PlatformComponentsPanel.class).getString("label.looking.for.updates"));
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        AsyncProcessIcon asyncProcessIcon = this.myPlatformLoadingIcon;
        jPanel2.add((Component)asyncProcessIcon, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myHideObsoletePackagesCheckbox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/AndroidBundle", PlatformComponentsPanel.class).getString("checkbox.hide.obsolete.packages"));
        jPanel4.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/AndroidBundle", PlatformComponentsPanel.class).getString("label.each.android.sdk.platform.package"));
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(600, -1), new Dimension(600, -1)));
        this.myPlatformPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, "summary");
        TreeTableView treeTableView = this.myPlatformSummaryTable;
        jBScrollPane.setViewportView((Component)treeTableView);
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel.add((Component)jBScrollPane2, "details");
        TreeTableView treeTableView2 = this.myPlatformDetailTable;
        jBScrollPane2.setViewportView((Component)treeTableView2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

