/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.ide.common.repository.GradleVersion;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.UpdatablePackage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.updater.configure.DetailsTreeNode;
import com.android.tools.idea.updater.configure.PackageNodeModel;
import com.android.tools.idea.updater.configure.UpdaterTreeNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.Function;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

class MultiVersionTreeNode
extends UpdaterTreeNode {
    private final DetailsTreeNode myMaxVersionNode;
    private final Collection<DetailsTreeNode> myVersionNodes;

    public MultiVersionTreeNode(@NotNull Collection<DetailsTreeNode> versionNodes) {
        if (versionNodes == null) {
            MultiVersionTreeNode.$$$reportNull$$$0(0);
        }
        this.myVersionNodes = versionNodes;
        DetailsTreeNode max = this.myVersionNodes.stream().filter(node2 -> node2.getPackage().getPath().endsWith("latest")).findFirst().orElse(null);
        if (max == null) {
            RepoPackage greatestPackage = AndroidSdkHandler.getLatestPackageFromPrefixCollection((Collection)ContainerUtil.map(this.myVersionNodes, DetailsTreeNode::getPackage), null, (boolean)true, GradleVersion::tryParse, Comparator.nullsFirst(Comparator.naturalOrder()));
            max = this.myVersionNodes.stream().filter(node2 -> node2.getPackage() == greatestPackage).findFirst().orElse(null);
        }
        this.myMaxVersionNode = max;
    }

    @NotNull
    private PackageNodeModel.SelectedState getState(@NotNull Function<UpdaterTreeNode, PackageNodeModel.SelectedState> childStateGetter) {
        if (childStateGetter == null) {
            MultiVersionTreeNode.$$$reportNull$$$0(1);
        }
        if (this.myMaxVersionNode == null) {
            PackageNodeModel.SelectedState selectedState = PackageNodeModel.SelectedState.NOT_INSTALLED;
            if (selectedState == null) {
                MultiVersionTreeNode.$$$reportNull$$$0(2);
            }
            return selectedState;
        }
        if (childStateGetter.apply(this.myMaxVersionNode) == PackageNodeModel.SelectedState.INSTALLED) {
            PackageNodeModel.SelectedState selectedState = PackageNodeModel.SelectedState.INSTALLED;
            if (selectedState == null) {
                MultiVersionTreeNode.$$$reportNull$$$0(3);
            }
            return selectedState;
        }
        for (UpdaterTreeNode updaterTreeNode : this.myVersionNodes) {
            if (childStateGetter.apply(updaterTreeNode) == PackageNodeModel.SelectedState.NOT_INSTALLED) continue;
            PackageNodeModel.SelectedState selectedState = PackageNodeModel.SelectedState.MIXED;
            if (selectedState == null) {
                MultiVersionTreeNode.$$$reportNull$$$0(4);
            }
            return selectedState;
        }
        PackageNodeModel.SelectedState selectedState = PackageNodeModel.SelectedState.NOT_INSTALLED;
        if (selectedState == null) {
            MultiVersionTreeNode.$$$reportNull$$$0(5);
        }
        return selectedState;
    }

    @Override
    @NotNull
    public PackageNodeModel.SelectedState getInitialState() {
        return this.getState(UpdaterTreeNode::getInitialState);
    }

    @Override
    @NotNull
    public PackageNodeModel.SelectedState getCurrentState() {
        return this.getState(UpdaterTreeNode::getCurrentState);
    }

    @Override
    protected boolean canHaveMixedState() {
        return this.getInitialState() == PackageNodeModel.SelectedState.MIXED;
    }

    @Override
    public void customizeRenderer(UpdaterTreeNode.Renderer renderer2, JTree tree, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        renderer2.getTextRenderer().append(this.getDisplayName());
    }

    @NotNull
    public String getDisplayName() {
        RepoPackage maxPackage = this.myMaxVersionNode.getPackage();
        String maxName = maxPackage.getDisplayName();
        String maxPath = maxPackage.getPath();
        String suffix = maxPath.substring(maxPath.lastIndexOf(59) + 1);
        maxName = StringUtil.trimEnd((String)maxName, (String)suffix).trim();
        String string = maxName = StringUtil.trimEnd((String)maxName, (String)":");
        if (string == null) {
            MultiVersionTreeNode.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public String getStatusString() {
        String revision;
        if (this.getInitialState() == PackageNodeModel.SelectedState.INSTALLED) {
            return "Installed";
        }
        if (this.getInitialState() == PackageNodeModel.SelectedState.NOT_INSTALLED) {
            return "Not Installed";
        }
        UpdatablePackage p = this.myMaxVersionNode.getItem();
        if (p.hasRemote()) {
            revision = p.getRemote().getVersion().toString();
        } else {
            assert (false);
            revision = p.getLocal().getVersion().toString();
        }
        String string = "Update Available: " + revision;
        if (string == null) {
            MultiVersionTreeNode.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    protected void setState(PackageNodeModel.SelectedState state) {
        if (state == PackageNodeModel.SelectedState.NOT_INSTALLED) {
            for (UpdaterTreeNode updaterTreeNode : this.myVersionNodes) {
                updaterTreeNode.setState(PackageNodeModel.SelectedState.NOT_INSTALLED);
            }
        } else {
            for (UpdaterTreeNode updaterTreeNode : this.myVersionNodes) {
                updaterTreeNode.resetState();
            }
            if (state == PackageNodeModel.SelectedState.INSTALLED) {
                this.myMaxVersionNode.setState(PackageNodeModel.SelectedState.INSTALLED);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionNodes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childStateGetter";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/updater/configure/MultiVersionTreeNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/updater/configure/MultiVersionTreeNode";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

