/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual.colorblindmode;

import com.android.tools.idea.uibuilder.visual.colorblindmode.ColorBlindMode;
import com.android.tools.idea.uibuilder.visual.colorblindmode.ColorConverter;
import com.android.tools.idea.uibuilder.visual.colorblindmode.ColorConverter$WhenMappings;
import com.android.tools.idea.uibuilder.visual.colorblindmode.ColorLut;
import com.android.tools.idea.uibuilder.visual.colorblindmode.ColorUtilKt;
import com.android.tools.idea.uibuilder.visual.colorblindmode.MathUtilKt;
import com.intellij.openapi.Disposable;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/uibuilder/visual/colorblindmode/ColorConverter;", "Lcom/intellij/openapi/Disposable;", "mode", "Lcom/android/tools/idea/uibuilder/visual/colorblindmode/ColorBlindMode;", "(Lcom/android/tools/idea/uibuilder/visual/colorblindmode/ColorBlindMode;)V", "cbmCLut", "Lcom/android/tools/idea/uibuilder/visual/colorblindmode/ColorLut;", "getMode", "()Lcom/android/tools/idea/uibuilder/visual/colorblindmode/ColorBlindMode;", "convert", "", "startImage", "Ljava/awt/image/BufferedImage;", "postImage", "dispose", "", "prepare", "", "color", "Companion", "intellij.android.designer"})
public final class ColorConverter
implements Disposable {
    private ColorLut cbmCLut;
    @NotNull
    private final ColorBlindMode mode;
    private static double[] removeGammaCLut;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public final boolean convert(@NotNull BufferedImage startImage, @NotNull BufferedImage postImage) {
        Intrinsics.checkNotNullParameter((Object)startImage, (String)"startImage");
        Intrinsics.checkNotNullParameter((Object)postImage, (String)"postImage");
        if (this.cbmCLut == null || removeGammaCLut == null) {
            removeGammaCLut = ColorUtilKt.buildGammaCLut(convert.1.INSTANCE);
            Intrinsics.checkNotNull((Object)removeGammaCLut);
            this.cbmCLut = ColorUtilKt.buildColorLut(16, this.mode, removeGammaCLut);
        }
        if (startImage.getType() != 2 || postImage.getType() != 2) {
            String string = "Error:: BufferedImage not supported for color blind mode.";
            boolean bl = false;
            System.out.println((Object)string);
            return false;
        }
        WritableRaster writableRaster = startImage.getRaster();
        Intrinsics.checkNotNullExpressionValue((Object)writableRaster, (String)"startImage.raster");
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        if (dataBuffer == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.image.DataBufferInt");
        }
        int[] inData = ((DataBufferInt)dataBuffer).getData();
        WritableRaster writableRaster2 = postImage.getRaster();
        Intrinsics.checkNotNullExpressionValue((Object)writableRaster2, (String)"postImage.raster");
        DataBuffer dataBuffer2 = writableRaster2.getDataBuffer();
        if (dataBuffer2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.image.DataBufferInt");
        }
        int[] outData = ((DataBufferInt)dataBuffer2).getData();
        int n = 0;
        Intrinsics.checkNotNullExpressionValue((Object)inData, (String)"inData");
        int n2 = inData.length;
        while (n < n2) {
            void i2;
            ColorLut colorLut = this.cbmCLut;
            Intrinsics.checkNotNull((Object)colorLut);
            outData[i2] = 0xFF000000 | colorLut.interpolate(this.prepare(inData[i2]));
            ++i2;
        }
        return true;
    }

    private final int prepare(int color) {
        int n;
        double a = (double)MathUtilKt.a(color) / 255.0;
        double r = (double)MathUtilKt.r(color) * a;
        double g = (double)MathUtilKt.g(color) * a;
        double b = (double)MathUtilKt.b(color) * a;
        switch (ColorConverter$WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 1: 
            case 2: {
                r = 0.992052 * r + 0.003974;
                g = 0.992052 * g + 0.003974;
                b = 0.992052 * b + 0.003974;
                n = MathUtilKt.combine(r, g, b);
                break;
            }
            case 3: 
            case 4: {
                r = 0.957237 * r + 0.0213814;
                g = 0.957237 * g + 0.0213814;
                b = 0.957237 * b + 0.0213814;
                n = MathUtilKt.combine(r, g, b);
                break;
            }
            default: {
                n = MathUtilKt.combine(r, g, b);
            }
        }
        return n;
    }

    public void dispose() {
        removeGammaCLut = null;
        this.cbmCLut = null;
    }

    @NotNull
    public final ColorBlindMode getMode() {
        return this.mode;
    }

    public ColorConverter(@NotNull ColorBlindMode mode) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.mode = mode;
    }

    static {
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/uibuilder/visual/colorblindmode/ColorConverter$Companion;", "", "()V", "removeGammaCLut", "", "intellij.android.designer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

