/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.uibuilder.visual.VisualizationForm;
import com.android.tools.idea.uibuilder.visual.VisualizationToolSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import icons.StudioIcons;
import java.awt.event.HierarchyListener;
import java.util.Arrays;
import javax.swing.JComponent;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisualizationManager
implements Disposable {
    private static final int DEFAULT_WINDOW_WIDTH = 500;
    @Nullable
    private final MergingUpdateQueue myToolWindowUpdateQueue;
    private final Project myProject;
    @Nullable
    private VisualizationForm myToolWindowForm;
    @Nullable
    private ToolWindow myToolWindow;
    private boolean myToolWindowReady;
    private boolean myToolWindowDisposed;
    private boolean mySeenEditor;
    private JComponent myPendingShowComponent;
    private HierarchyListener myHierarchyListener;

    public VisualizationManager(@NotNull Project project) {
        if (project == null) {
            VisualizationManager.$$$reportNull$$$0(0);
        }
        this.myToolWindowReady = false;
        this.myToolWindowDisposed = false;
        this.myProject = project;
        if (!((Boolean)StudioFlags.NELE_VISUALIZATION.get()).booleanValue()) {
            this.myToolWindowUpdateQueue = null;
            return;
        }
        this.myToolWindowUpdateQueue = new MergingUpdateQueue("android.layout.visual", 100, true, null, (Disposable)project);
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new MyFileEditorManagerListener());
    }

    private void onToolWindowReady() {
        this.myToolWindowReady = true;
        this.processFileEditorChange(FileEditorManager.getInstance((Project)this.myProject).getSelectedEditor());
    }

    public boolean isWindowVisible() {
        return this.myToolWindow != null && this.myToolWindow.isVisible();
    }

    @NotNull
    public String getToolWindowId() {
        String string = AndroidBundle.message("android.layout.visual.tool.window.title", new Object[0]);
        if (string == null) {
            VisualizationManager.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private VisualizationForm createPreviewForm() {
        return new VisualizationForm(this.myProject);
    }

    protected void initToolWindow() {
        if (!((Boolean)StudioFlags.NELE_VISUALIZATION.get()).booleanValue()) {
            return;
        }
        this.myToolWindowForm = this.createPreviewForm();
        Disposer.register((Disposable)this, (Disposable)this.myToolWindowForm);
        final String toolWindowId = this.getToolWindowId();
        this.myToolWindow = ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow(RegisterToolWindowTask.notClosable((String)toolWindowId, (ToolWindowAnchor)ToolWindowAnchor.RIGHT));
        this.myToolWindow.setIcon(StudioIcons.Shell.ToolWindows.MULTI_PREVIEW);
        this.myProject.getMessageBus().connect().subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            public void stateChanged() {
                if (VisualizationManager.this.myProject.isDisposed()) {
                    return;
                }
                ToolWindow window2 = ToolWindowManager.getInstance((Project)VisualizationManager.this.myProject).getToolWindow(toolWindowId);
                if (VisualizationToolSettings.getInstance().getGlobalState().isFirstTimeOpen() && window2 instanceof ToolWindowEx) {
                    ToolWindowEx windowEx = (ToolWindowEx)window2;
                    int width = window2.getComponent().getWidth();
                    windowEx.stretchWidth(500 - width);
                }
                VisualizationToolSettings.getInstance().getGlobalState().setFirstTimeOpen(false);
                if (window2 != null && window2.isAvailable()) {
                    boolean visible = window2.isVisible();
                    VisualizationToolSettings.getInstance().getGlobalState().setVisible(visible);
                    if (VisualizationManager.this.myToolWindowForm != null) {
                        if (visible) {
                            VisualizationManager.this.myToolWindowForm.activate();
                        } else {
                            VisualizationManager.this.myToolWindowForm.deactivate();
                        }
                    }
                }
            }
        });
        JComponent contentPanel2 = this.myToolWindowForm.getComponent();
        ContentManager contentManager = this.myToolWindow.getContentManager();
        contentManager.addDataProvider(dataId -> {
            FileEditor fileEditor = this.myToolWindowForm.getEditor();
            if (fileEditor == null) {
                return null;
            }
            if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                return fileEditor.getFile();
            }
            if (LangDataKeys.IDE_VIEW.is(dataId)) {
                return ((DataProvider)fileEditor).getData(dataId);
            }
            if (LangDataKeys.MODULE.is(dataId)) {
                VirtualFile file2 = fileEditor.getFile();
                return file2 == null ? null : ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)this.myProject);
            }
            return null;
        });
        Content content2 = contentManager.getFactory().createContent(contentPanel2, null, false);
        content2.setDisposer((Disposable)this.myToolWindowForm);
        content2.setCloseable(false);
        content2.setPreferredFocusableComponent(contentPanel2);
        contentManager.addContent(content2);
        contentManager.setSelectedContent(content2, true);
        if (this.isWindowVisible()) {
            this.myToolWindowForm.activate();
        }
    }

    private void processFileEditorChange(final @Nullable FileEditor newEditor) {
        if (this.myToolWindowUpdateQueue == null) {
            return;
        }
        if (this.myPendingShowComponent != null) {
            this.myPendingShowComponent.removeHierarchyListener(this.myHierarchyListener);
            this.myPendingShowComponent = null;
        }
        this.myToolWindowUpdateQueue.cancelAllUpdates();
        this.myToolWindowUpdateQueue.queue(new Update("update"){

            public void run() {
                if (!VisualizationManager.this.myToolWindowReady || VisualizationManager.this.myToolWindowDisposed) {
                    return;
                }
                if (VisualizationManager.this.myToolWindow == null) {
                    if (newEditor == null) {
                        return;
                    }
                    if (!newEditor.getComponent().isShowing()) {
                        if (!VisualizationManager.this.mySeenEditor) {
                            VisualizationManager.this.myPendingShowComponent = newEditor.getComponent();
                            if (VisualizationManager.this.myHierarchyListener == null) {
                                VisualizationManager.this.myHierarchyListener = hierarchyEvent -> {
                                    if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && hierarchyEvent.getComponent() == VisualizationManager.this.myPendingShowComponent && VisualizationManager.this.myPendingShowComponent.isShowing()) {
                                        VisualizationManager.this.myPendingShowComponent.removeHierarchyListener(VisualizationManager.this.myHierarchyListener);
                                        VisualizationManager.this.mySeenEditor = true;
                                        VisualizationManager.this.myPendingShowComponent = null;
                                        VisualizationManager.this.processFileEditorChange(VisualizationManager.this.getFirstActiveLayoutEditor());
                                    }
                                };
                            }
                            VisualizationManager.this.myPendingShowComponent.addHierarchyListener(VisualizationManager.this.myHierarchyListener);
                        }
                        return;
                    }
                    VisualizationManager.this.mySeenEditor = true;
                    VisualizationManager.this.initToolWindow();
                }
                if (VisualizationManager.this.myToolWindow == null || VisualizationManager.this.myToolWindowForm == null) {
                    return;
                }
                if (newEditor == null) {
                    VisualizationManager.this.myToolWindow.setAvailable(false);
                    return;
                }
                if (!VisualizationManager.this.myToolWindowForm.setNextEditor(newEditor)) {
                    VisualizationManager.this.myToolWindow.setAvailable(false);
                    return;
                }
                VisualizationManager.this.myToolWindow.setAvailable(true);
                if (VisualizationToolSettings.getInstance().getGlobalState().isVisible() && !VisualizationManager.this.myToolWindow.isVisible()) {
                    Runnable restoreFocus = null;
                    if (VisualizationManager.this.myToolWindow.getType() == ToolWindowType.WINDOWED) {
                        restoreFocus = () -> IdeFocusManager.getInstance((Project)VisualizationManager.this.myProject).doWhenFocusSettlesDown(() -> VisualizationManager.restoreFocusToEditor(newEditor));
                    }
                    VisualizationManager.this.myToolWindow.activate(restoreFocus, false, false);
                }
            }
        });
    }

    public void dispose() {
        if (this.myToolWindowForm != null) {
            Disposer.dispose((Disposable)this.myToolWindowForm);
            this.myToolWindowForm = null;
            this.myToolWindow = null;
            this.myToolWindowDisposed = true;
        }
    }

    private static void restoreFocusToEditor(@NotNull FileEditor newEditor) {
        if (newEditor == null) {
            VisualizationManager.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().invokeLater(() -> newEditor.getComponent().requestFocus());
    }

    @Nullable
    private FileEditor getActiveLayoutEditor(@Nullable PsiFile file2) {
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return (FileEditor)ApplicationManager.getApplication().runReadAction(() -> this.getActiveLayoutEditor(file2));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return Arrays.stream(FileEditorManager.getInstance((Project)this.myProject).getSelectedEditors()).filter(editor2 -> {
            VirtualFile editorFile = editor2.getFile();
            return editorFile != null && editorFile.equals(file2);
        }).findFirst().orElse(null);
    }

    @Nullable
    private FileEditor getFirstActiveLayoutEditor() {
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return (FileEditor)ApplicationManager.getApplication().runReadAction(() -> this.getFirstActiveLayoutEditor());
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return Arrays.stream(FileEditorManager.getInstance((Project)this.myProject).getSelectedEditors()).filter(editor2 -> {
            VirtualFile editorFile = editor2.getFile();
            ResourceFolderType type = IdeResourcesUtil.getFolderType(editorFile);
            return type == ResourceFolderType.LAYOUT;
        }).findFirst().orElse(null);
    }

    @Nullable
    private ToolWindow getToolWindow() {
        return this.myToolWindow;
    }

    public static VisualizationManager getInstance(Project project) {
        return (VisualizationManager)project.getService(VisualizationManager.class);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            VisualizationManager.$$$reportNull$$$0(3);
        }
        return project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/visual/VisualizationManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/visual/VisualizationManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "restoreFocusToEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyFileEditorManagerListener
    implements FileEditorManagerListener {
        private MyFileEditorManagerListener() {
        }

        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
            if (source == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(0);
            }
            if (file2 == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(1);
            }
            if (!file2.isValid()) {
                return;
            }
            PsiFile psiFile2 = PsiManager.getInstance((Project)VisualizationManager.this.myProject).findFile(file2);
            FileEditor fileEditor = VisualizationManager.this.getActiveLayoutEditor(psiFile2);
            if (fileEditor != null) {
                VisualizationManager.this.processFileEditorChange(fileEditor);
            }
        }

        public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
            if (source == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(2);
            }
            if (file2 == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(3);
            }
            if (VisualizationManager.this.myToolWindowForm != null) {
                VisualizationManager.this.myToolWindowForm.fileClosed(source, file2);
            }
            if (source.getOpenFiles().length == 0) {
                VisualizationManager.this.processFileEditorChange(null);
            }
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            PsiFile psiFile2;
            VirtualFile newVirtualFile;
            if (event == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(4);
            }
            FileEditor editorForLayout = null;
            FileEditor newEditor = event.getNewEditor();
            if (newEditor != null && (newVirtualFile = newEditor.getFile()) != null && IdeResourcesUtil.getFolderType(psiFile2 = PsiManager.getInstance((Project)VisualizationManager.this.myProject).findFile(newVirtualFile)) == ResourceFolderType.LAYOUT) {
                editorForLayout = newEditor;
            }
            VisualizationManager.this.processFileEditorChange(editorForLayout);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/visual/VisualizationManager$MyFileEditorManagerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileOpened";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileClosed";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectionChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class VisualizationManagerPostStartupActivity
    implements StartupActivity {
        public void runActivity(@NotNull Project project) {
            if (project == null) {
                VisualizationManagerPostStartupActivity.$$$reportNull$$$0(0);
            }
            VisualizationManager.getInstance(project).onToolWindowReady();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/visual/VisualizationManager$VisualizationManagerPostStartupActivity", "runActivity"));
        }
    }
}

