/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual;

import com.android.annotations.concurrency.UiThread;
import com.android.resources.ResourceFolderType;
import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.adtui.common.AdtPrimaryPanel;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.workbench.WorkBench;
import com.android.tools.editor.ActionToolbarUtil;
import com.android.tools.editor.PanZoomListener;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.startup.ClearResourceCacheAfterFirstBuild;
import com.android.tools.idea.uibuilder.analytics.NlAnalyticsManager;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.NlScreenViewProvider;
import com.android.tools.idea.uibuilder.surface.layout.GridSurfaceLayoutManager;
import com.android.tools.idea.uibuilder.visual.ConfigurationSet;
import com.android.tools.idea.uibuilder.visual.ConfigurationSetListener;
import com.android.tools.idea.uibuilder.visual.ConfigurationSetMenuAction;
import com.android.tools.idea.uibuilder.visual.VisualizationActionManager;
import com.android.tools.idea.uibuilder.visual.VisualizationInteractionHandler;
import com.android.tools.idea.uibuilder.visual.VisualizationModelsProvider;
import com.android.tools.idea.uibuilder.visual.VisualizationToolProjectSettings;
import com.android.tools.idea.uibuilder.visual.VisualizationToolSettings;
import com.android.tools.idea.uibuilder.visual.analytics.MultiViewMetricTrackerKt;
import com.android.tools.idea.util.SyncUtil;
import com.google.common.collect.ImmutableList;
import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.LayoutManager;
import java.awt.event.AdjustmentEvent;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.jvm.functions.Function0;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisualizationForm
implements Disposable,
ConfigurationSetListener,
PanZoomListener {
    public static final String VISUALIZATION_DESIGN_SURFACE = "VisualizationFormDesignSurface";
    private static final String RENDERING_MESSAGE = "Rendering Previews...";
    private static final int HORIZONTAL_SCREEN_DELTA = 100;
    private static final int VERTICAL_SCREEN_DELTA = 48;
    private final Project myProject;
    private final NlDesignSurface mySurface;
    private final WorkBench<DesignSurface> myWorkBench;
    private final JPanel myRoot;
    private VirtualFile myFile;
    private boolean isActive;
    private JComponent myContentPanel;
    private JComponent myActionToolbarPanel;
    @Nullable
    private Runnable myCancelPreviousAddModelsRequestTask;
    private FileEditor myPendingEditor;
    private FileEditor myEditor;
    @NotNull
    private ConfigurationSet myCurrentConfigurationSet;
    @NotNull
    private VisualizationModelsProvider myCurrentModelsProvider;
    private AtomicBoolean myCancelPendingModelLoad;
    @NotNull
    private final EmptyProgressIndicator myProgressIndicator;

    public VisualizationForm(@NotNull Project project) {
        if (project == null) {
            VisualizationForm.$$$reportNull$$$0(0);
        }
        this.myRoot = new JPanel(new BorderLayout());
        this.isActive = false;
        this.myCancelPreviousAddModelsRequestTask = null;
        this.myCancelPendingModelLoad = new AtomicBoolean(false);
        this.myProgressIndicator = new EmptyProgressIndicator();
        this.myProject = project;
        this.myCurrentConfigurationSet = VisualizationToolSettings.getInstance().getGlobalState().getConfigurationSet();
        this.myCurrentModelsProvider = (VisualizationModelsProvider)this.myCurrentConfigurationSet.getModelsProviderCreator().invoke((Object)this);
        this.mySurface = NlDesignSurface.builder(this.myProject, (Disposable)this.myProject).showModelNames().setIsPreview(false).setEditable(true).setSceneManagerProvider((surface2, model2) -> {
            LayoutlibSceneManager sceneManager = new LayoutlibSceneManager((NlModel)model2, (DesignSurface)((Object)surface2));
            sceneManager.setShowDecorations(VisualizationToolSettings.getInstance().getGlobalState().getShowDecoration());
            sceneManager.setUseImagePool(false);
            sceneManager.setQuality(0.0f);
            return sceneManager;
        }).setActionManagerProvider(surface2 -> new VisualizationActionManager((NlDesignSurface)surface2, (Function0<? extends VisualizationModelsProvider>)((Function0)() -> this.myCurrentModelsProvider))).setInteractionHandlerProvider(surface2 -> new VisualizationInteractionHandler((DesignSurface)((Object)surface2), (Function0<? extends VisualizationModelsProvider>)((Function0)() -> this.myCurrentModelsProvider))).setLayoutManager(new GridSurfaceLayoutManager(50, 50, 100, 48, false)).setMinScale(0.1).setMaxScale(4.0).build();
        this.mySurface.addPanZoomListener(this);
        this.updateScreenMode();
        Disposer.register((Disposable)this, (Disposable)this.mySurface);
        this.mySurface.setName(VISUALIZATION_DESIGN_SURFACE);
        this.myWorkBench = new WorkBench(this.myProject, "Visualization", null, (Disposable)this);
        this.myWorkBench.setLoadingText(CommonBundle.getLoadingTreeNodeText());
        this.myWorkBench.setToolContext((Object)this.mySurface);
        this.myRoot.add((Component)this.createToolbarPanel(), "North");
        this.myRoot.add((Component)this.myWorkBench, "Center");
        this.myRoot.setFocusCycleRoot(true);
        this.myRoot.setFocusTraversalPolicy(new VisualizationTraversalPolicy(this.mySurface));
    }

    private void updateScreenMode() {
        switch (this.myCurrentConfigurationSet) {
            case COLOR_BLIND_MODE: {
                this.mySurface.setScreenViewProvider(NlScreenViewProvider.COLOR_BLIND, false);
                break;
            }
            default: {
                this.mySurface.setScreenViewProvider(NlScreenViewProvider.VISUALIZATION, false);
            }
        }
    }

    @NotNull
    private JComponent createToolbarPanel() {
        this.myActionToolbarPanel = new AdtPrimaryPanel((LayoutManager)new BorderLayout());
        this.myActionToolbarPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, (Color)StudioColorsKt.getBorder()), BorderFactory.createEmptyBorder(0, 6, 0, 0)));
        this.updateActionToolbar();
        JComponent jComponent = this.myActionToolbarPanel;
        if (jComponent == null) {
            VisualizationForm.$$$reportNull$$$0(1);
        }
        return jComponent;
    }

    private void updateActionToolbar() {
        this.myActionToolbarPanel.removeAll();
        DefaultActionGroup group2 = new DefaultActionGroup();
        String fileName = this.myFile != null ? this.myFile.getName() : "";
        group2.add((AnAction)new TextLabelAction(fileName));
        group2.addSeparator();
        group2.add((AnAction)new DefaultActionGroup(new AnAction[]{new ConfigurationSetMenuAction(this, this.myCurrentConfigurationSet)}));
        if (this.myFile != null) {
            AndroidFacet facet2;
            PsiFile file2 = PsiManager.getInstance((Project)this.myProject).findFile(this.myFile);
            AndroidFacet androidFacet = facet2 = file2 != null ? AndroidFacet.getInstance((PsiElement)file2) : null;
            if (facet2 != null) {
                ActionGroup configurationActions = this.myCurrentModelsProvider.createActions(file2, facet2);
                group2.addAll(configurationActions);
            }
        }
        DropDownAction viewOptions = new DropDownAction(null, "View Options", StudioIcons.Common.VISIBILITY_INLINE);
        viewOptions.add((AnAction)new ToggleShowDecorationAction());
        viewOptions.setPopup(true);
        group2.add((AnAction)viewOptions);
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("EditorToolbar", (ActionGroup)group2, true);
        ActionToolbarUtil.makeToolbarNavigable(actionToolbar);
        this.myActionToolbarPanel.add((Component)actionToolbar.getComponent(), "Center");
    }

    private void createContentPanel() {
        this.myContentPanel = new JPanel(new BorderLayout());
        this.myContentPanel.add((Component)((Object)this.mySurface), "Center");
    }

    private void setEditor(@Nullable FileEditor editor2) {
        if (editor2 != this.myEditor) {
            this.myEditor = editor2;
            this.mySurface.setFileEditorDelegate(editor2);
            this.updateActionToolbar();
        }
    }

    @Nullable
    public JComponent getToolbarComponent() {
        return null;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myRoot;
        if (jPanel == null) {
            VisualizationForm.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    public void dispose() {
        this.deactivate();
        this.removeAndDisposeModels((List<NlModel>)this.mySurface.getModels());
    }

    private void removeAndDisposeModels(@NotNull List<NlModel> models2) {
        if (models2 == null) {
            VisualizationForm.$$$reportNull$$$0(3);
        }
        for (NlModel model2 : models2) {
            model2.deactivate(this);
            this.mySurface.removeModel(model2);
            Disposer.dispose((Disposable)model2);
        }
    }

    public boolean setNextEditor(@NotNull FileEditor editor2) {
        if (editor2 == null) {
            VisualizationForm.$$$reportNull$$$0(4);
        }
        if (IdeResourcesUtil.getFolderType(editor2.getFile()) != ResourceFolderType.LAYOUT) {
            return false;
        }
        this.myPendingEditor = editor2;
        this.myFile = editor2.getFile();
        this.myCancelPendingModelLoad.set(true);
        if (this.isActive) {
            this.initPreviewForm();
        }
        return true;
    }

    private void initPreviewForm() {
        if (this.myContentPanel == null) {
            ClearResourceCacheAfterFirstBuild.getInstance(this.myProject).runWhenResourceCacheClean(this::initPreviewFormAfterInitialBuild, this::buildError);
        } else {
            this.initNeleModel();
        }
    }

    private void initPreviewFormAfterInitialBuild() {
        this.myWorkBench.setLoadingText("Waiting for build to finish...");
        SyncUtil.runWhenSmartAndSyncedOnEdt(this.myProject, this, result2 -> {
            if (result2.isSuccessful()) {
                this.initPreviewFormAfterBuildOnEventDispatchThread();
            } else {
                this.buildError();
                SyncUtil.listenUntilNextSync(this.myProject, this, ignore -> this.initPreviewFormAfterBuildOnEventDispatchThread());
            }
        });
    }

    private void buildError() {
        this.myWorkBench.loadingStopped("Previews are unavailable until after a successful project sync");
    }

    private void initPreviewFormAfterBuildOnEventDispatchThread() {
        if (Disposer.isDisposed((Disposable)this)) {
            return;
        }
        if (this.myContentPanel == null) {
            this.createContentPanel();
            this.myWorkBench.init(this.myContentPanel, (Object)this.mySurface, (List)ImmutableList.of(), false);
            this.myWorkBench.setFocusCycleRoot(false);
        }
        this.initNeleModel();
    }

    private void initNeleModel() {
        DumbService.getInstance((Project)this.myProject).smartInvokeLater(() -> this.initNeleModelWhenSmart());
    }

    @UiThread
    private void initNeleModelWhenSmart() {
        AtomicBoolean isRequestCancelled;
        AndroidFacet facet2;
        this.setNoActiveModel();
        if (this.myCancelPreviousAddModelsRequestTask != null) {
            this.myCancelPreviousAddModelsRequestTask.run();
            this.myCancelPreviousAddModelsRequestTask = null;
        }
        if (this.myFile == null) {
            return;
        }
        PsiFile file2 = PsiManager.getInstance((Project)this.myProject).findFile(this.myFile);
        AndroidFacet androidFacet = facet2 = file2 != null ? AndroidFacet.getInstance((PsiElement)file2) : null;
        if (facet2 == null) {
            return;
        }
        this.updateActionToolbar();
        this.myCancelPendingModelLoad = isRequestCancelled = new AtomicBoolean(false);
        CompletableFuture.supplyAsync(() -> {
            List<NlModel> models2 = this.myCurrentModelsProvider.createNlModels(this, file2, facet2);
            if (models2.isEmpty()) {
                this.myWorkBench.showLoading("No Device Found");
                return null;
            }
            return models2;
        }, AppExecutorUtil.getAppExecutorService()).thenAcceptAsync(models2 -> {
            if (models2 == null || isRequestCancelled.get()) {
                return;
            }
            this.myWorkBench.showContent();
            if (this.myCancelPreviousAddModelsRequestTask != null) {
                this.myCancelPreviousAddModelsRequestTask.run();
            }
            AtomicBoolean isAddingModelCanceled = new AtomicBoolean(false);
            ApplicationManager.getApplication().invokeLater(() -> this.mySurface.registerIndicator((ProgressIndicator)this.myProgressIndicator));
            CompletionStage<Object> addModelFuture = CompletableFuture.completedFuture(null);
            for (NlModel model2 : models2) {
                addModelFuture = addModelFuture.thenCompose(it -> {
                    if (isAddingModelCanceled.get()) {
                        return CompletableFuture.completedFuture(null);
                    }
                    return this.mySurface.addAndRenderModel(model2);
                });
            }
            this.myCancelPreviousAddModelsRequestTask = () -> isAddingModelCanceled.set(true);
            addModelFuture.thenRunAsync(() -> {
                ApplicationManager.getApplication().invokeLater(() -> this.mySurface.unregisterIndicator((ProgressIndicator)this.myProgressIndicator));
                if (!(isRequestCancelled.get() || facet2.isDisposed() || isAddingModelCanceled.get())) {
                    this.activeModels((List<NlModel>)models2);
                    double lastScaling = VisualizationToolProjectSettings.getInstance(this.myProject).getProjectState().getScale();
                    if (!this.mySurface.setScale(lastScaling)) {
                        this.mySurface.revalidateScrollArea();
                    }
                } else {
                    this.removeAndDisposeModels((List<NlModel>)models2);
                }
            }, (Executor)EdtExecutorService.getInstance());
        }, (Executor)EdtExecutorService.getInstance());
    }

    public void fileClosed(@NotNull FileEditorManager editorManager, @NotNull VirtualFile file2) {
        if (editorManager == null) {
            VisualizationForm.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            VisualizationForm.$$$reportNull$$$0(6);
        }
        if (this.myEditor == null) {
            this.setNoActiveModel();
        } else if (file2.equals(this.myFile) && ArrayUtil.find((Object[])editorManager.getAllEditors(file2), (Object)this.myEditor) < 0) {
            this.setNoActiveModel();
        }
        if (this.myPendingEditor != null && file2.equals(this.myPendingEditor.getFile()) && ArrayUtil.find((Object[])editorManager.getAllEditors(file2), (Object)this.myPendingEditor) < 0) {
            this.myPendingEditor = null;
        }
    }

    private void setNoActiveModel() {
        this.myCancelPendingModelLoad.set(true);
        this.setEditor(null);
        this.myWorkBench.setFileEditor(null);
        this.removeAndDisposeModels((List<NlModel>)this.mySurface.getModels());
    }

    private void activeModels(@NotNull List<NlModel> models2) {
        if (models2 == null) {
            VisualizationForm.$$$reportNull$$$0(7);
        }
        this.myCancelPendingModelLoad.set(true);
        if (models2.isEmpty()) {
            this.setEditor(null);
            this.myWorkBench.setFileEditor(null);
        } else {
            this.myFile = models2.get(0).getVirtualFile();
            this.setEditor(this.myPendingEditor);
            this.myPendingEditor = null;
            for (NlModel model2 : models2) {
                model2.activate(this);
            }
            this.myWorkBench.setFileEditor(this.myEditor);
        }
    }

    @NotNull
    public NlDesignSurface getSurface() {
        NlDesignSurface nlDesignSurface = this.mySurface;
        if (nlDesignSurface == null) {
            VisualizationForm.$$$reportNull$$$0(8);
        }
        return nlDesignSurface;
    }

    public void activate() {
        if (this.isActive) {
            return;
        }
        this.isActive = true;
        this.initPreviewForm();
        this.mySurface.activate();
        this.getAnalyticsManager().trackVisualizationToolWindow(true);
    }

    public void deactivate() {
        if (!this.isActive) {
            return;
        }
        this.myCancelPendingModelLoad.set(true);
        this.mySurface.deactivate();
        this.isActive = false;
        if (this.myContentPanel != null) {
            this.setNoActiveModel();
        }
        this.getAnalyticsManager().trackVisualizationToolWindow(false);
    }

    @Override
    public void onSelectedConfigurationSetChanged(@NotNull ConfigurationSet newConfigurationSet) {
        if (newConfigurationSet == null) {
            VisualizationForm.$$$reportNull$$$0(9);
        }
        if (this.myCurrentConfigurationSet != newConfigurationSet) {
            this.myCurrentConfigurationSet = newConfigurationSet;
            MultiViewMetricTrackerKt.trackOpenConfigSet(this.mySurface, this.myCurrentConfigurationSet);
            VisualizationToolSettings.getInstance().getGlobalState().setConfigurationSet(newConfigurationSet);
            this.myCurrentModelsProvider = (VisualizationModelsProvider)newConfigurationSet.getModelsProviderCreator().invoke((Object)this);
            this.refresh();
        }
    }

    @Override
    public void onCurrentConfigurationSetUpdated() {
        this.refresh();
    }

    private void refresh() {
        this.updateScreenMode();
        this.updateActionToolbar();
        this.initNeleModel();
    }

    private NlAnalyticsManager getAnalyticsManager() {
        return this.mySurface.getAnalyticsManager();
    }

    @Nullable
    public final FileEditor getEditor() {
        return this.myEditor;
    }

    @Override
    public void zoomChanged() {
        VisualizationToolProjectSettings.getInstance(this.myProject).getProjectState().setScale(this.mySurface.getScale());
    }

    @Override
    public void panningChanged(AdjustmentEvent adjustmentEvent) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/visual/VisualizationForm";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newConfigurationSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/visual/VisualizationForm";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSurface";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeAndDisposeModels";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setNextEditor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fileClosed";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "activeModels";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "onSelectedConfigurationSetChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EmptyProgressIndicator
    extends AbstractProgressIndicatorBase {
        private EmptyProgressIndicator() {
        }

        public boolean isRunning() {
            return true;
        }
    }

    private static class VisualizationTraversalPolicy
    extends DefaultFocusTraversalPolicy {
        @NotNull
        private DesignSurface mySurface;

        private VisualizationTraversalPolicy(@NotNull DesignSurface surface2) {
            if (surface2 == null) {
                VisualizationTraversalPolicy.$$$reportNull$$$0(0);
            }
            this.mySurface = surface2;
        }

        @Override
        public Component getDefaultComponent(Container aContainer) {
            return this.mySurface.getLayeredPane();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/visual/VisualizationForm$VisualizationTraversalPolicy", "<init>"));
        }
    }

    private final class ToggleShowDecorationAction
    extends ToggleAction {
        private ToggleShowDecorationAction() {
            super("Show System UI");
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleShowDecorationAction.$$$reportNull$$$0(0);
            }
            return VisualizationToolSettings.getInstance().getGlobalState().getShowDecoration();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ToggleShowDecorationAction.$$$reportNull$$$0(1);
            }
            VisualizationToolSettings.getInstance().getGlobalState().setShowDecoration(state);
            VisualizationForm.this.mySurface.getModels().stream().map(model2 -> VisualizationForm.this.mySurface.getSceneManager((NlModel)model2)).filter(manager -> manager instanceof LayoutlibSceneManager).forEach(manager -> ((LayoutlibSceneManager)manager).setShowDecorations(state));
            VisualizationForm.this.mySurface.requestRender().thenRun(() -> {
                if (!Disposer.isDisposed(VisualizationForm.this.myWorkBench)) {
                    VisualizationForm.this.myWorkBench.showContent();
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/android/tools/idea/uibuilder/visual/VisualizationForm$ToggleShowDecorationAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class TextLabelAction
    extends AnAction {
        TextLabelAction(@NotNull String text2) {
            if (text2 == null) {
                TextLabelAction.$$$reportNull$$$0(0);
            }
            super((String)null);
            this.getTemplatePresentation().setText(text2, false);
            this.getTemplatePresentation().setEnabled(false);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                TextLabelAction.$$$reportNull$$$0(1);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                TextLabelAction.$$$reportNull$$$0(2);
            }
            e.getPresentation().setEnabled(false);
        }

        public boolean displayTextInToolbar() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/visual/VisualizationForm$TextLabelAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

