/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual;

import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.NlModelBuilder;
import com.android.tools.idea.common.type.DesignerEditorFileTypeKt;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.uibuilder.type.LayoutFileType;
import com.android.tools.idea.uibuilder.visual.LocaleModelsProvider;
import com.android.tools.idea.uibuilder.visual.VisualizationModelsProvider;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/uibuilder/visual/LocaleModelsProvider;", "Lcom/android/tools/idea/uibuilder/visual/VisualizationModelsProvider;", "()V", "createNlModels", "", "Lcom/android/tools/idea/common/model/NlModel;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "file", "Lcom/intellij/psi/PsiFile;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "intellij.android.designer"})
public final class LocaleModelsProvider
implements VisualizationModelsProvider {
    @NotNull
    public static final LocaleModelsProvider INSTANCE;

    @Override
    @NotNull
    public List<NlModel> createNlModels(@NotNull Disposable parentDisposable, @NotNull PsiFile file2, @NotNull AndroidFacet facet2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        if (Intrinsics.areEqual((Object)DesignerEditorFileTypeKt.typeOf(file2), (Object)LayoutFileType.INSTANCE) ^ true) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile currentFile = virtualFile;
        ConfigurationManager configurationManager = ConfigurationManager.getOrCreateInstance(facet2);
        Intrinsics.checkNotNullExpressionValue((Object)configurationManager, (String)"ConfigurationManager.getOrCreateInstance(facet)");
        ConfigurationManager configurationManager2 = configurationManager;
        Configuration configuration = configurationManager2.getConfiguration(currentFile);
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"configurationManager.getConfiguration(currentFile)");
        Configuration currentFileConfig = configuration;
        boolean bl = false;
        List models2 = new ArrayList();
        VirtualFile virtualFile2 = ConfigurationMatcher.getBetterMatch(currentFileConfig, null, null, Locale.ANY, null);
        if (virtualFile2 == null) {
            virtualFile2 = currentFile;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"ConfigurationMatcher.get\u2026ANY, null) ?: currentFile");
        VirtualFile defaultFile = virtualFile2;
        Configuration configuration2 = Configuration.create(currentFileConfig, defaultFile);
        boolean bl2 = false;
        boolean bl3 = false;
        Configuration $this$apply = configuration2;
        boolean bl4 = false;
        $this$apply.setLocale(Locale.ANY);
        Configuration configuration3 = configuration2;
        Intrinsics.checkNotNullExpressionValue((Object)configuration3, (String)"Configuration.create(cur\u2026ly { locale = Locale.ANY}");
        Configuration defaultLocaleConfig = configuration3;
        models2.add(NlModel.builder(facet2, defaultFile, defaultLocaleConfig).withParentDisposable(parentDisposable).withModelDisplayName("Default (no locale)").withComponentRegistrar(createNlModels.1.INSTANCE).build());
        ResourceRepositoryManager resourceRepositoryManager = ResourceRepositoryManager.getInstance(facet2);
        Intrinsics.checkNotNullExpressionValue((Object)resourceRepositoryManager, (String)"ResourceRepositoryManager.getInstance(facet)");
        ImmutableList<Locale> immutableList = resourceRepositoryManager.getLocalesInProject();
        Intrinsics.checkNotNullExpressionValue(immutableList, (String)"ResourceRepositoryManage\u2026e(facet).localesInProject");
        Iterable iterable = (Iterable)immutableList;
        Comparator<Locale> comparator2 = Locale.LANGUAGE_CODE_COMPARATOR;
        Intrinsics.checkNotNullExpressionValue(comparator2, (String)"Locale.LANGUAGE_CODE_COMPARATOR");
        List locales = CollectionsKt.sortedWith((Iterable)iterable, comparator2);
        for (Locale locale : locales) {
            Configuration config;
            VirtualFile virtualFile3 = ConfigurationMatcher.getBetterMatch(defaultLocaleConfig, null, null, locale, null);
            if (virtualFile3 == null) {
                virtualFile3 = defaultFile;
            }
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"ConfigurationMatcher.get\u2026ale, null) ?: defaultFile");
            VirtualFile betterFile = virtualFile3;
            Intrinsics.checkNotNullExpressionValue((Object)Configuration.create(defaultLocaleConfig, betterFile), (String)"Configuration.create(def\u2026LocaleConfig, betterFile)");
            config.setLocale(locale);
            String label = LocaleMenuAction.getLocaleLabel(locale, false);
            NlModelBuilder nlModelBuilder = NlModel.builder(facet2, betterFile, config).withParentDisposable(parentDisposable);
            String string = label;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"label");
            models2.add(nlModelBuilder.withModelDisplayName(string).withComponentRegistrar(createNlModels.2.INSTANCE).build());
        }
        return models2;
    }

    private LocaleModelsProvider() {
    }

    static {
        LocaleModelsProvider localeModelsProvider;
        INSTANCE = localeModelsProvider = new LocaleModelsProvider();
    }

    @Override
    @NotNull
    public ActionGroup createActions(@NotNull PsiFile file2, @NotNull AndroidFacet facet2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        return VisualizationModelsProvider.DefaultImpls.createActions(this, file2, facet2);
    }
}

