/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.imagepool.ImagePool;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenViewLayer
extends Layer {
    public static final Map<RenderingHints.Key, Object> HQ_RENDERING_HINTS = ImmutableMap.of((Object)RenderingHints.KEY_ANTIALIASING, (Object)RenderingHints.VALUE_ANTIALIAS_ON, (Object)RenderingHints.KEY_RENDERING, (Object)RenderingHints.VALUE_RENDER_QUALITY, (Object)RenderingHints.KEY_INTERPOLATION, (Object)RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    public static final int REQUEST_SCALE_DEBOUNCE_TIME_IN_MS = 300;
    private final ScreenView myScreenView;
    @Nullable
    private BufferedImage myCachedVisibleImage;
    @Nullable
    private RenderResult myLastRenderResult;
    private final ScheduledExecutorService myScheduledExecutorService;
    private final RescaleRunnable myRescaleRunnable;
    @Nullable
    private ScheduledFuture<?> myScheduledFuture;
    private final Rectangle myScreenViewVisibleRect;
    private final Dimension myScreenViewSize;
    private final Rectangle myCachedScreenViewDisplayRect;
    private double myLastScale;
    private static final Color CLEAR_BACKGROUND = new Color(255, 255, 255, 0);

    public ScreenViewLayer(@NotNull ScreenView screenView) {
        if (screenView == null) {
            ScreenViewLayer.$$$reportNull$$$0(0);
        }
        this(screenView, null);
    }

    @VisibleForTesting
    ScreenViewLayer(@NotNull ScreenView screenView, @Nullable ScheduledExecutorService executor) {
        if (screenView == null) {
            ScreenViewLayer.$$$reportNull$$$0(1);
        }
        this.myRescaleRunnable = new RescaleRunnable(this::onScaledResultReady);
        this.myScreenViewVisibleRect = new Rectangle();
        this.myScreenViewSize = new Dimension();
        this.myCachedScreenViewDisplayRect = new Rectangle();
        this.myScreenView = screenView;
        this.myScheduledExecutorService = executor != null ? executor : Executors.newScheduledThreadPool(1);
        this.myLastScale = this.myScreenView.getScale();
        Disposer.register((Disposable)screenView.getSurface(), (Disposable)this);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static BufferedImage getPreviewImage(@NotNull GraphicsConfiguration configuration, @NotNull BufferedImage renderedImage, int screenViewX, int screenViewY, @NotNull Rectangle screenViewVisibleSize, double xScaleFactor, double yScaleFactor, @Nullable BufferedImage bufferedImage, boolean bl) {
        boolean clearBackground;
        BufferedImage image;
        void screenViewHasBorderLayer;
        BufferedImage existingBuffer;
        boolean bufferWithScreenViewSizeExists;
        if (configuration == null) {
            ScreenViewLayer.$$$reportNull$$$0(2);
        }
        if (renderedImage == null) {
            ScreenViewLayer.$$$reportNull$$$0(3);
        }
        if (screenViewVisibleSize == null) {
            ScreenViewLayer.$$$reportNull$$$0(4);
        }
        int sx1 = (int)Math.round((double)(screenViewVisibleSize.x - screenViewX) * xScaleFactor);
        int sy1 = (int)Math.round((double)(screenViewVisibleSize.y - screenViewY) * yScaleFactor);
        int sx2 = sx1 + (int)Math.round((double)screenViewVisibleSize.width * xScaleFactor);
        int sy2 = sy1 + (int)Math.round((double)screenViewVisibleSize.height * yScaleFactor);
        boolean bl2 = bufferWithScreenViewSizeExists = existingBuffer != null && existingBuffer.getWidth() == screenViewVisibleSize.width && existingBuffer.getHeight() == screenViewVisibleSize.height;
        if (screenViewHasBorderLayer != false && bufferWithScreenViewSizeExists) {
            image = existingBuffer instanceof JBHiDPIScaledImage ? (BufferedImage)((JBHiDPIScaledImage)existingBuffer).getDelegate() : existingBuffer;
            clearBackground = true;
        } else {
            image = configuration.createCompatibleImage(screenViewVisibleSize.width, screenViewVisibleSize.height, 3);
            assert (image != null);
            existingBuffer = image;
            clearBackground = false;
        }
        Graphics2D cacheImageGraphics = image.createGraphics();
        cacheImageGraphics.setRenderingHints(HQ_RENDERING_HINTS);
        if (clearBackground) {
            cacheImageGraphics.setColor(CLEAR_BACKGROUND);
            cacheImageGraphics.setComposite(AlphaComposite.Clear);
            cacheImageGraphics.fillRect(0, 0, image.getWidth(), image.getHeight());
            cacheImageGraphics.setComposite(AlphaComposite.Src);
        }
        cacheImageGraphics.drawImage(renderedImage, 0, 0, image.getWidth(), image.getHeight(), sx1, sy1, sx2, sy2, null);
        cacheImageGraphics.dispose();
        BufferedImage bufferedImage2 = existingBuffer;
        if (bufferedImage2 == null) {
            ScreenViewLayer.$$$reportNull$$$0(5);
        }
        return bufferedImage2;
    }

    @Override
    public void paint(@NotNull Graphics2D graphics2D) {
        BufferedImage renderedImage;
        if (graphics2D == null) {
            ScreenViewLayer.$$$reportNull$$$0(6);
        }
        this.myScreenView.getScaledContentSize(this.myScreenViewSize);
        this.myScreenViewVisibleRect.setBounds(this.myScreenView.getX(), this.myScreenView.getY(), this.myScreenViewSize.width, this.myScreenViewSize.height);
        Rectangle clipBounds = graphics2D.getClipBounds();
        if (!this.myScreenViewVisibleRect.intersects((Rectangle2D)clipBounds)) {
            return;
        }
        if ((double)this.myScreenViewVisibleRect.width > ((RectangularShape)clipBounds).getWidth() || (double)this.myScreenViewVisibleRect.height > ((RectangularShape)clipBounds).getHeight()) {
            Rectangle2D.intersect(this.myScreenViewVisibleRect, clipBounds, this.myScreenViewVisibleRect);
        }
        BufferedImage previousVisibleImage = this.myCachedVisibleImage;
        RenderResult renderResult = this.myScreenView.getResult();
        boolean drawNewImg = false;
        if (this.newRenderImageAvailable(renderResult)) {
            this.setLastRenderResult(renderResult);
            this.myScreenView.getScene().needsRebuildList();
            drawNewImg = true;
        }
        Graphics2D g = (Graphics2D)graphics2D.create();
        BufferedImage cachedVisibleImage = drawNewImg ? null : previousVisibleImage;
        double currentScale = this.myScreenView.getScale();
        if ((drawNewImg || currentScale != this.myLastScale || !this.myScreenViewVisibleRect.equals(this.myCachedScreenViewDisplayRect)) && this.myLastRenderResult != null && (renderedImage = this.myLastRenderResult.getRenderedImage().getCopy()) != null) {
            int resultImageWidth = renderedImage.getWidth();
            int resultImageHeight = renderedImage.getHeight();
            this.myCachedScreenViewDisplayRect.setBounds(this.myScreenViewVisibleRect);
            double xScaleFactor = (double)resultImageWidth / (double)this.myScreenViewSize.width;
            double yScaleFactor = (double)resultImageHeight / (double)this.myScreenViewSize.height;
            this.cancelHighQualityScaleRequests();
            if (xScaleFactor > 1.2 && yScaleFactor > 1.2 && !this.myScreenView.isAnimated()) {
                this.requestHighQualityScaledImage(ScaleContext.create((Graphics2D)g));
            }
            this.myCachedVisibleImage = cachedVisibleImage = ScreenViewLayer.getPreviewImage(g.getDeviceConfiguration(), renderedImage, this.myScreenView.getX(), this.myScreenView.getY(), this.myScreenViewVisibleRect, xScaleFactor, yScaleFactor, previousVisibleImage, this.myScreenView.hasBorderLayer());
            this.myLastScale = currentScale;
        }
        if (cachedVisibleImage != null) {
            Shape screenShape = this.myScreenView.getScreenShape();
            if (screenShape != null) {
                g.clip(screenShape);
            }
            StartupUiUtil.drawImage((Graphics)g, (Image)cachedVisibleImage, (int)this.myScreenViewVisibleRect.x, (int)this.myScreenViewVisibleRect.y, null);
        }
        g.dispose();
    }

    protected void setLastRenderResult(@Nullable RenderResult result2) {
        this.myLastRenderResult = result2;
    }

    private boolean newRenderImageAvailable(@Nullable RenderResult renderResult) {
        return renderResult != null && renderResult.getRenderResult().isSuccess() && renderResult != this.myLastRenderResult;
    }

    private void cancelHighQualityScaleRequests() {
        if (this.myScheduledFuture != null && !this.myScheduledFuture.isDone()) {
            this.myScheduledFuture.cancel(true);
        }
    }

    private void requestHighQualityScaledImage(@NotNull ScaleContext ctx) {
        if (ctx == null) {
            ScreenViewLayer.$$$reportNull$$$0(7);
        }
        if (this.myLastRenderResult == null) {
            return;
        }
        ImagePool.Image image = this.myLastRenderResult.getRenderedImage();
        double xScaleFactor = (double)image.getWidth() / (double)this.myScreenViewSize.width;
        double yScaleFactor = (double)image.getHeight() / (double)this.myScreenViewSize.height;
        int sx = (int)Math.round((double)(this.myScreenViewVisibleRect.x - this.myScreenView.getX()) * xScaleFactor);
        int sy = (int)Math.round((double)(this.myScreenViewVisibleRect.y - this.myScreenView.getY()) * yScaleFactor);
        int sw = (int)Math.round((double)this.myScreenViewVisibleRect.width * xScaleFactor);
        int sh = (int)Math.round((double)this.myScreenViewVisibleRect.height * yScaleFactor);
        if (sx + sw > image.getWidth()) {
            sw = image.getWidth() - sx;
        }
        if (sy + sh > image.getHeight()) {
            sh = image.getHeight() - sy;
        }
        if (sw <= 0 || sh <= 0) {
            Logger.getInstance(ScreenViewLayer.class).warn(String.format("requestHighQualityScaledImage with invalid size (sw=%d, sh=%d)", sw, sh));
            return;
        }
        BufferedImage imageCopy = image.getCopy(sx, sy, sw, sh);
        if (imageCopy == null) {
            return;
        }
        this.myRescaleRunnable.setSource(imageCopy, xScaleFactor, yScaleFactor, ctx);
        try {
            this.myScheduledFuture = this.myScheduledExecutorService.schedule(this.myRescaleRunnable, 300L, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            Logger.getInstance(ScreenViewLayer.class).warn((Throwable)e);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.setLastRenderResult(null);
        this.myScheduledExecutorService.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static BufferedImage getRetinaScaledImage(@NotNull BufferedImage original, double scaleX, double scaleY, @NotNull ScaleContext scaleContext, boolean bl) {
        void fastScaling;
        void ctx;
        if (original == null) {
            ScreenViewLayer.$$$reportNull$$$0(8);
        }
        if (scaleContext == null) {
            ScreenViewLayer.$$$reportNull$$$0(9);
        }
        double xRetinaScale = JBUIScale.sysScale((ScaleContext)ctx) * scaleX;
        double yRetinaScale = JBUIScale.sysScale((ScaleContext)ctx) * scaleY;
        original = fastScaling != false ? ImageUtils.lowQualityFastScale((BufferedImage)original, (double)xRetinaScale, (double)yRetinaScale) : ImageUtils.scale((BufferedImage)original, (double)xRetinaScale, (double)yRetinaScale);
        return ImageUtils.convertToRetina((BufferedImage)original, (ScaleContext)ctx);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    static BufferedImage scaleOriginalImage(@NotNull BufferedImage source, double xScaleFactor, double yScaleFactor, @NotNull ScaleContext scaleContext) {
        void ctx;
        if (source == null) {
            ScreenViewLayer.$$$reportNull$$$0(10);
        }
        if (scaleContext == null) {
            ScreenViewLayer.$$$reportNull$$$0(11);
        }
        BufferedImage scaledImage = null;
        if (StartupUiUtil.isJreHiDPI((ScaleContext)ctx) && ImageUtils.supportsRetina()) {
            scaledImage = ScreenViewLayer.getRetinaScaledImage(source, 1.0 / xScaleFactor, 1.0 / yScaleFactor, (ScaleContext)ctx, false);
        }
        if (scaledImage == null) {
            scaledImage = ImageUtils.scale((BufferedImage)source, (double)(1.0 / xScaleFactor), (double)(1.0 / yScaleFactor));
        }
        BufferedImage bufferedImage = scaledImage;
        if (bufferedImage == null) {
            ScreenViewLayer.$$$reportNull$$$0(12);
        }
        return bufferedImage;
    }

    private void onScaledResultReady(BufferedImage result2) {
        this.myCachedVisibleImage = result2;
        UIUtil.invokeLaterIfNeeded(() -> this.myScreenView.getSurface().repaint());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenView";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderedImage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenViewVisibleSize";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/surface/ScreenViewLayer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphics2D";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/surface/ScreenViewLayer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviewImage";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "scaleOriginalImage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPreviewImage";
                break;
            }
            case 5: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "requestHighQualityScaledImage";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRetinaScaledImage";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "scaleOriginalImage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RescaleRunnable
    implements Runnable {
        @NotNull
        private final Consumer<BufferedImage> myOnReadyCallback;
        private final Object lock;
        private BufferedImage mySourceImage;
        private double myXScaleFactor;
        private double myYScaleFactor;
        private ScaleContext myScaleContext;

        private RescaleRunnable(@NotNull Consumer<BufferedImage> onReadyCallback) {
            if (onReadyCallback == null) {
                RescaleRunnable.$$$reportNull$$$0(0);
            }
            this.lock = new Object();
            this.myOnReadyCallback = onReadyCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void setSource(@NotNull BufferedImage sourceImage, double xScaleFactor, double yScaleFactor, @NotNull ScaleContext scaleContext) {
            if (sourceImage == null) {
                RescaleRunnable.$$$reportNull$$$0(1);
            }
            if (scaleContext == null) {
                RescaleRunnable.$$$reportNull$$$0(2);
            }
            Object object = this.lock;
            synchronized (object) {
                void ctx;
                this.mySourceImage = sourceImage;
                this.myXScaleFactor = xScaleFactor;
                this.myYScaleFactor = yScaleFactor;
                this.myScaleContext = ctx;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ScaleContext ctx;
            double yScaleFactor;
            double xScaleFactor;
            BufferedImage source;
            Object object = this.lock;
            synchronized (object) {
                source = this.mySourceImage;
                xScaleFactor = this.myXScaleFactor;
                yScaleFactor = this.myYScaleFactor;
                ctx = this.myScaleContext;
                this.mySourceImage = null;
            }
            if (source == null) {
                return;
            }
            BufferedImage result2 = ScreenViewLayer.scaleOriginalImage(source, xScaleFactor, yScaleFactor, ctx);
            this.myOnReadyCallback.accept(result2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "onReadyCallback";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceImage";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ctx";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/surface/ScreenViewLayer$RescaleRunnable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSource";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

