/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import android.view.View;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssueModel;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.surface.AccessibilityLintIntegrator;
import com.android.tools.idea.uibuilder.surface.NlLayoutScannerMetricTracker;
import com.android.tools.idea.validator.ValidatorData;
import com.android.tools.idea.validator.ValidatorResult;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00013B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0019J\u0010\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020\u000bH\u0007J\u0006\u0010%\u001a\u00020!J\b\u0010&\u001a\u00020!H\u0016J&\u0010'\u001a\u0004\u0018\u00010\u000b2\u0006\u0010(\u001a\u00020)2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u001d0\tH\u0007J\u000e\u0010,\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0019J\u0010\u0010-\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u000bH\u0007J\u0016\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202R(\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\b\u0012\u0004\u0012\u00020\u0012`\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u00190\u0011j\b\u0012\u0004\u0012\u00020\u0019`\u00138\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001a\u0010\r\u001a\u0004\b\u001b\u0010\u0015R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u000b0\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001e\u0010\r\u001a\u0004\b\u001f\u0010\u000f\u00a8\u00064"}, d2={"Lcom/android/tools/idea/uibuilder/surface/NlLayoutScanner;", "Lcom/intellij/openapi/Disposable;", "issueModel", "Lcom/android/tools/idea/common/error/IssueModel;", "parent", "metricTracker", "Lcom/android/tools/idea/uibuilder/surface/NlLayoutScannerMetricTracker;", "(Lcom/android/tools/idea/common/error/IssueModel;Lcom/intellij/openapi/Disposable;Lcom/android/tools/idea/uibuilder/surface/NlLayoutScannerMetricTracker;)V", "idToComponent", "Lcom/google/common/collect/BiMap;", "", "Lcom/android/tools/idea/common/model/NlComponent;", "getIdToComponent$annotations", "()V", "getIdToComponent", "()Lcom/google/common/collect/BiMap;", "issues", "Ljava/util/HashSet;", "Lcom/android/tools/idea/common/error/Issue;", "Lkotlin/collections/HashSet;", "getIssues", "()Ljava/util/HashSet;", "lintIntegrator", "Lcom/android/tools/idea/uibuilder/surface/AccessibilityLintIntegrator;", "listeners", "Lcom/android/tools/idea/uibuilder/surface/NlLayoutScanner$Listener;", "getListeners$annotations", "getListeners", "viewToComponent", "Landroid/view/View;", "getViewToComponent$annotations", "getViewToComponent", "addListener", "", "listener", "buildViewToComponentMap", "component", "disable", "dispose", "findComponent", "result", "Lcom/android/tools/idea/validator/ValidatorData$Issue;", "map", "", "removeListener", "tryFindingRootWithViewInfo", "validateAndUpdateLint", "renderResult", "Lcom/android/tools/idea/rendering/RenderResult;", "model", "Lcom/android/tools/idea/common/model/NlModel;", "Listener", "intellij.android.designer"})
public final class NlLayoutScanner
implements Disposable {
    private final AccessibilityLintIntegrator lintIntegrator;
    @NotNull
    private final BiMap<View, NlComponent> viewToComponent;
    @NotNull
    private final BiMap<Integer, NlComponent> idToComponent;
    @NotNull
    private final HashSet<Listener> listeners;
    private final NlLayoutScannerMetricTracker metricTracker;

    @NotNull
    public final HashSet<Issue> getIssues() {
        return this.lintIntegrator.getIssues();
    }

    @VisibleForTesting
    public static /* synthetic */ void getViewToComponent$annotations() {
    }

    @NotNull
    public final BiMap<View, NlComponent> getViewToComponent() {
        return this.viewToComponent;
    }

    @VisibleForTesting
    public static /* synthetic */ void getIdToComponent$annotations() {
    }

    @NotNull
    public final BiMap<Integer, NlComponent> getIdToComponent() {
        return this.idToComponent;
    }

    @VisibleForTesting
    public static /* synthetic */ void getListeners$annotations() {
    }

    @NotNull
    public final HashSet<Listener> getListeners() {
        return this.listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void validateAndUpdateLint(@NotNull RenderResult renderResult, @NotNull NlModel model2) {
        Intrinsics.checkNotNullParameter((Object)renderResult, (String)"renderResult");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Object validatorResult = renderResult.getValidatorResult();
        HashSet listeners = new HashSet(this.listeners);
        if (validatorResult == null || !(validatorResult instanceof ValidatorResult)) {
            Iterable $this$forEach$iv = listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Listener it = (Listener)element$iv;
                boolean bl = false;
                it.lintUpdated(null);
            }
            return;
        }
        this.lintIntegrator.disableAccessibilityLint();
        this.viewToComponent.clear();
        this.idToComponent.clear();
        ValidatorResult result2 = null;
        try {
            NlComponent root2;
            ImmutableList<NlComponent> immutableList = model2.getComponents();
            Intrinsics.checkNotNullExpressionValue(immutableList, (String)"model.components");
            ImmutableList<NlComponent> components = immutableList;
            if (!(validatorResult instanceof ValidatorResult) || components.isEmpty()) {
                return;
            }
            NlComponent nlComponent = root2 = (NlComponent)components.get(0);
            Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"root");
            this.buildViewToComponentMap(nlComponent);
            List list = ((ValidatorResult)validatorResult).getIssues();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"validatorResult.issues");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            Iterator element$iv = $this$forEach$iv.iterator();
            while (element$iv.hasNext()) {
                Object element$iv2 = element$iv.next();
                ValidatorData.Issue it = (ValidatorData.Issue)element$iv2;
                boolean bl = false;
                if ((it.mLevel == ValidatorData.Level.ERROR || it.mLevel == ValidatorData.Level.WARNING) && it.mType == ValidatorData.Type.ACCESSIBILITY) {
                    ValidatorData.Issue issue2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)issue2, (String)"it");
                    ImmutableBiMap immutableBiMap = ((ValidatorResult)validatorResult).getSrcMap();
                    Intrinsics.checkNotNullExpressionValue((Object)immutableBiMap, (String)"validatorResult.srcMap");
                    this.lintIntegrator.createIssue(issue2, this.findComponent(it, (BiMap<Long, View>)((BiMap)immutableBiMap)));
                }
                ValidatorData.Issue issue3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)issue3, (String)"it");
                this.metricTracker.trackIssue(issue3);
            }
            this.lintIntegrator.populateLints();
            result2 = (ValidatorResult)validatorResult;
        }
        finally {
            this.viewToComponent.clear();
            this.idToComponent.clear();
            this.metricTracker.trackResult(renderResult);
            this.metricTracker.logEvents();
            Iterable $this$forEach$iv = listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Listener it = (Listener)element$iv;
                boolean bl = false;
                it.lintUpdated(result2);
            }
        }
    }

    public final void addListener(@NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    public final void removeListener(@NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    public final void disable() {
        this.lintIntegrator.disableAccessibilityLint();
    }

    @VisibleForTesting
    @Nullable
    public final NlComponent findComponent(@NotNull ValidatorData.Issue result2, @NotNull BiMap<Long, View> map2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        View view = (View)map2.get((Object)result2.mSrcId);
        if (view == null) {
            return null;
        }
        View view2 = view;
        NlComponent toReturn = (NlComponent)this.viewToComponent.get((Object)view2);
        if (toReturn == null) {
            toReturn = (NlComponent)this.idToComponent.get((Object)view2.getId());
        }
        return toReturn;
    }

    @VisibleForTesting
    public final void buildViewToComponentMap(@NotNull NlComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        NlComponent root2 = this.tryFindingRootWithViewInfo(component);
        Object object = NlComponentHelperKt.getViewInfo(root2);
        if (object != null && (object = object.getViewObject()) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object viewObj = object2;
            boolean bl3 = false;
            Object object3 = viewObj;
            if (object3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.view.View");
            }
            View view = (View)object3;
            ((Map)this.viewToComponent).put(view, component);
            if (-1 != view.getId()) {
                ((Map)this.idToComponent).put(view.getId(), component);
            }
            List<NlComponent> list = component.getChildren();
            Intrinsics.checkNotNullExpressionValue(list, (String)"component.children");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NlComponent it = (NlComponent)element$iv;
                boolean bl4 = false;
                NlComponent nlComponent = it;
                Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"it");
                this.buildViewToComponentMap(nlComponent);
            }
        }
    }

    @VisibleForTesting
    @NotNull
    public final NlComponent tryFindingRootWithViewInfo(@NotNull NlComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(component);
        if ((viewInfo != null ? viewInfo.getViewObject() : null) != null) {
            return component;
        }
        List<NlComponent> list = component.getChildren();
        Intrinsics.checkNotNullExpressionValue(list, (String)"component.children");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NlComponent it = (NlComponent)element$iv;
            boolean bl = false;
            NlComponent nlComponent = it;
            Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"it");
            ViewInfo viewInfo2 = NlComponentHelperKt.getViewInfo(nlComponent);
            if ((viewInfo2 != null ? viewInfo2.getViewObject() : null) == null) continue;
            return it;
        }
        return component;
    }

    public void dispose() {
        this.viewToComponent.clear();
        this.idToComponent.clear();
        this.listeners.clear();
        this.lintIntegrator.disableAccessibilityLint();
    }

    public NlLayoutScanner(@NotNull IssueModel issueModel, @NotNull Disposable parent, @NotNull NlLayoutScannerMetricTracker metricTracker) {
        Intrinsics.checkNotNullParameter((Object)issueModel, (String)"issueModel");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)metricTracker, (String)"metricTracker");
        this.metricTracker = metricTracker;
        this.lintIntegrator = new AccessibilityLintIntegrator(issueModel);
        HashBiMap hashBiMap = HashBiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)hashBiMap, (String)"HashBiMap.create()");
        this.viewToComponent = (BiMap)hashBiMap;
        HashBiMap hashBiMap2 = HashBiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)hashBiMap2, (String)"HashBiMap.create()");
        this.idToComponent = (BiMap)hashBiMap2;
        this.listeners = new HashSet();
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/uibuilder/surface/NlLayoutScanner$Listener;", "", "lintUpdated", "", "result", "Lcom/android/tools/idea/validator/ValidatorResult;", "intellij.android.designer"})
    public static interface Listener {
        public void lintUpdated(@Nullable ValidatorResult var1);
    }
}

