/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.idea.actions.DesignerDataKeys;
import com.android.tools.idea.actions.LayoutPreviewHandler;
import com.android.tools.idea.actions.LayoutPreviewHandlerKt;
import com.android.tools.idea.common.editor.ActionManager;
import com.android.tools.idea.common.error.IssueProvider;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.DefaultSelectionModel;
import com.android.tools.idea.common.model.DnDTransferComponent;
import com.android.tools.idea.common.model.DnDTransferItem;
import com.android.tools.idea.common.model.ItemTransferable;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.ScaleKt;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceActionHandler;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.common.surface.InteractionHandler;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.rendering.RenderErrorModelFactory;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderSettings;
import com.android.tools.idea.rendering.errors.ui.RenderErrorModel;
import com.android.tools.idea.uibuilder.adaptiveicon.ShapeMenuAction;
import com.android.tools.idea.uibuilder.analytics.NlAnalyticsManager;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.editor.NlActionManager;
import com.android.tools.idea.uibuilder.error.RenderIssueProvider;
import com.android.tools.idea.uibuilder.mockup.editor.MockupEditor;
import com.android.tools.idea.uibuilder.model.NlComponentHelper;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.scene.RenderListener;
import com.android.tools.idea.uibuilder.surface.AccessoryPanel;
import com.android.tools.idea.uibuilder.surface.LayoutScannerControl;
import com.android.tools.idea.uibuilder.surface.LayoutScannerEnabled;
import com.android.tools.idea.uibuilder.surface.NlDesignSurfaceActionHandler;
import com.android.tools.idea.uibuilder.surface.NlDesignSurfacePositionableContentLayoutManager;
import com.android.tools.idea.uibuilder.surface.NlInteractionHandler;
import com.android.tools.idea.uibuilder.surface.NlLayoutScannerControl;
import com.android.tools.idea.uibuilder.surface.NlScreenViewProvider;
import com.android.tools.idea.uibuilder.surface.ScreenViewProvider;
import com.android.tools.idea.uibuilder.surface.layout.SingleDirectionLayoutManager;
import com.android.tools.idea.uibuilder.surface.layout.SurfaceLayoutManager;
import com.android.utils.ImmutableCollectors;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlDesignSurface
extends DesignSurface
implements ViewGroupHandler.AccessoryPanelVisibility,
LayoutPreviewHandler {
    private boolean myPreviewWithToolsVisibilityAndPosition;
    private static final double DEFAULT_MIN_SCALE = 0.1;
    private static final double DEFAULT_MAX_SCALE = 10.0;
    @Nullable
    private final DataProvider myDelegateDataProvider;
    @NotNull
    private ScreenViewProvider myScreenViewProvider;
    private boolean myIsCanvasResizing;
    private boolean myShowModelNames;
    private boolean myMockupVisible;
    private MockupEditor myMockupEditor;
    private final boolean myIsInPreview;
    private ShapeMenuAction.AdaptiveIconShape myAdaptiveIconShape;
    private final RenderListener myRenderListener;
    @NotNull
    private ImmutableList<? extends IssueProvider> myRenderIssueProviders;
    private AccessoryPanel myAccessoryPanel;
    @NotNull
    private final NlAnalyticsManager myAnalyticsManager;
    private final BiFunction<NlDesignSurface, NlModel, LayoutlibSceneManager> mySceneManagerProvider;
    @NotNull
    private SurfaceLayoutManager myLayoutManager;
    @Nullable
    private final NavigationHandler myNavigationHandler;
    private final double myMinScale;
    private final double myMaxScale;
    private boolean myIsRenderingSynchronously;
    private boolean myIsAnimationScrubbing;
    private final Dimension myScrollableViewMinSize;
    @Nullable
    private LayoutScannerControl myValidatorControl;

    /*
     * WARNING - void declaration
     */
    private NlDesignSurface(@NotNull Project project, @NotNull Disposable parentDisposable, boolean isInPreview, boolean isEditable, boolean showModelNames, @NotNull BiFunction<NlDesignSurface, NlModel, LayoutlibSceneManager> sceneManagerProvider, @NotNull SurfaceLayoutManager defaultLayoutManager, @NotNull Function<DesignSurface, ActionManager<? extends DesignSurface>> actionManagerProvider, @NotNull Function<DesignSurface, InteractionHandler> interactionHandlerProvider, @Nullable NavigationHandler navigationHandler, double minScale, double maxScale, @NotNull ZoomType onChangeZoom, @NotNull Function<DesignSurface, DesignSurfaceActionHandler> actionHandlerProvider, @Nullable DataProvider dataProvider, @NotNull SelectionModel selectionModel) {
        void delegateDataProvider;
        void selectionModel2;
        if (project == null) {
            NlDesignSurface.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            NlDesignSurface.$$$reportNull$$$0(1);
        }
        if (sceneManagerProvider == null) {
            NlDesignSurface.$$$reportNull$$$0(2);
        }
        if (defaultLayoutManager == null) {
            NlDesignSurface.$$$reportNull$$$0(3);
        }
        if (actionManagerProvider == null) {
            NlDesignSurface.$$$reportNull$$$0(4);
        }
        if (interactionHandlerProvider == null) {
            NlDesignSurface.$$$reportNull$$$0(5);
        }
        if (onChangeZoom == null) {
            NlDesignSurface.$$$reportNull$$$0(6);
        }
        if (actionHandlerProvider == null) {
            NlDesignSurface.$$$reportNull$$$0(7);
        }
        if (selectionModel == null) {
            NlDesignSurface.$$$reportNull$$$0(8);
        }
        super(project, parentDisposable, actionManagerProvider, interactionHandlerProvider, isEditable, onChangeZoom, surface2 -> new NlDesignSurfacePositionableContentLayoutManager((NlDesignSurface)surface2, defaultLayoutManager), actionHandlerProvider, (SelectionModel)selectionModel2);
        this.myPreviewWithToolsVisibilityAndPosition = true;
        this.myScreenViewProvider = NlScreenViewProvider.Companion.loadPreferredMode();
        this.myIsCanvasResizing = false;
        this.myShowModelNames = false;
        this.myAdaptiveIconShape = ShapeMenuAction.AdaptiveIconShape.getDefaultShape();
        this.myRenderListener = this::modelRendered;
        this.myRenderIssueProviders = ImmutableList.of();
        this.myAccessoryPanel = new AccessoryPanel(AccessoryPanel.Type.SOUTH_PANEL, true);
        this.myIsRenderingSynchronously = false;
        this.myIsAnimationScrubbing = false;
        this.myScrollableViewMinSize = new Dimension();
        this.myAnalyticsManager = new NlAnalyticsManager(this);
        this.myAccessoryPanel.setSurface(this);
        this.myIsInPreview = isInPreview;
        this.myShowModelNames = showModelNames;
        this.myLayoutManager = defaultLayoutManager;
        this.mySceneManagerProvider = sceneManagerProvider;
        this.myNavigationHandler = navigationHandler;
        if (this.myNavigationHandler != null) {
            Disposer.register((Disposable)this, (Disposable)this.myNavigationHandler);
        }
        this.myMinScale = minScale;
        this.myMaxScale = maxScale;
        if (((Boolean)StudioFlags.NELE_LAYOUT_SCANNER_IN_EDITOR.get()).booleanValue()) {
            this.myValidatorControl = new NlLayoutScannerControl(this, this);
        }
        this.myDelegateDataProvider = delegateDataProvider;
    }

    @NotNull
    public static LayoutlibSceneManager defaultSceneManagerProvider(@NotNull NlDesignSurface surface2, @NotNull NlModel model2) {
        if (surface2 == null) {
            NlDesignSurface.$$$reportNull$$$0(9);
        }
        if (model2 == null) {
            NlDesignSurface.$$$reportNull$$$0(10);
        }
        LayoutlibSceneManager sceneManager = new LayoutlibSceneManager(model2, surface2, new LayoutScannerEnabled());
        RenderSettings settings = RenderSettings.getProjectSettings(model2.getProject());
        sceneManager.setShowDecorations(settings.getShowDecorations());
        sceneManager.setUseImagePool(settings.getUseLiveRendering());
        sceneManager.setQuality(settings.getQuality());
        LayoutlibSceneManager layoutlibSceneManager = sceneManager;
        if (layoutlibSceneManager == null) {
            NlDesignSurface.$$$reportNull$$$0(11);
        }
        return layoutlibSceneManager;
    }

    @NotNull
    public static SurfaceLayoutManager createDefaultSurfaceLayoutManager() {
        return new SingleDirectionLayoutManager(50, 50, 48, 48, SingleDirectionLayoutManager.Alignment.CENTER);
    }

    @NotNull
    public static ActionManager<? extends NlDesignSurface> defaultActionManagerProvider(@NotNull DesignSurface surface2) {
        if (surface2 == null) {
            NlDesignSurface.$$$reportNull$$$0(12);
        }
        return new NlActionManager((NlDesignSurface)surface2);
    }

    @NotNull
    public static NlInteractionHandler defaultInteractionHandlerProvider(@NotNull DesignSurface surface2) {
        if (surface2 == null) {
            NlDesignSurface.$$$reportNull$$$0(13);
        }
        return new NlInteractionHandler(surface2);
    }

    @NotNull
    public static NlDesignSurfaceActionHandler defaultActionHandlerProvider(@NotNull DesignSurface surface2) {
        if (surface2 == null) {
            NlDesignSurface.$$$reportNull$$$0(14);
        }
        return new NlDesignSurfaceActionHandler(surface2);
    }

    @NotNull
    public static Builder builder(@NotNull Project project, @NotNull Disposable parentDisposable) {
        if (project == null) {
            NlDesignSurface.$$$reportNull$$$0(15);
        }
        if (parentDisposable == null) {
            NlDesignSurface.$$$reportNull$$$0(16);
        }
        return new Builder(project, parentDisposable);
    }

    @Override
    @NotNull
    protected SceneManager createSceneManager(@NotNull NlModel model2) {
        if (model2 == null) {
            NlDesignSurface.$$$reportNull$$$0(17);
        }
        LayoutlibSceneManager manager = this.mySceneManagerProvider.apply(this, model2);
        manager.addRenderListener(this.myRenderListener);
        LayoutlibSceneManager layoutlibSceneManager = manager;
        if (layoutlibSceneManager == null) {
            NlDesignSurface.$$$reportNull$$$0(18);
        }
        return layoutlibSceneManager;
    }

    @Override
    @NotNull
    public NlAnalyticsManager getAnalyticsManager() {
        NlAnalyticsManager nlAnalyticsManager = this.myAnalyticsManager;
        if (nlAnalyticsManager == null) {
            NlDesignSurface.$$$reportNull$$$0(19);
        }
        return nlAnalyticsManager;
    }

    public boolean isPreviewSurface() {
        return this.myIsInPreview;
    }

    public void setResizeMode(boolean isResizing) {
        this.myIsCanvasResizing = isResizing;
        this.myScrollPane.setAutoscrolls(isResizing);
    }

    public boolean isCanvasResizing() {
        return this.myIsCanvasResizing;
    }

    @Override
    public boolean isLayoutDisabled() {
        return this.myIsCanvasResizing;
    }

    public boolean isShowModelNames() {
        return this.myShowModelNames;
    }

    @NotNull
    public ScreenViewProvider getScreenViewProvider() {
        ScreenViewProvider screenViewProvider = this.myScreenViewProvider;
        if (screenViewProvider == null) {
            NlDesignSurface.$$$reportNull$$$0(20);
        }
        return screenViewProvider;
    }

    public void setScreenViewProvider(@NotNull ScreenViewProvider screenViewProvider, boolean setAsDefault) {
        if (screenViewProvider == null) {
            NlDesignSurface.$$$reportNull$$$0(21);
        }
        if (setAsDefault && screenViewProvider instanceof NlScreenViewProvider) {
            NlScreenViewProvider.Companion.savePreferredMode((NlScreenViewProvider)screenViewProvider);
        }
        if (screenViewProvider != this.myScreenViewProvider) {
            this.myScreenViewProvider = screenViewProvider;
            for (SceneManager manager : this.getSceneManagers()) {
                manager.updateSceneView();
                manager.requestLayoutAndRender(false);
            }
            this.revalidateScrollArea();
        }
    }

    @Nullable
    public NavigationHandler getNavigationHandler() {
        return this.myNavigationHandler;
    }

    @NotNull
    public static NlDesignSurface build(@NotNull Project project, @NotNull Disposable parentDisposable) {
        if (project == null) {
            NlDesignSurface.$$$reportNull$$$0(22);
        }
        if (parentDisposable == null) {
            NlDesignSurface.$$$reportNull$$$0(23);
        }
        NlDesignSurface nlDesignSurface = new Builder(project, parentDisposable).build();
        if (nlDesignSurface == null) {
            NlDesignSurface.$$$reportNull$$$0(24);
        }
        return nlDesignSurface;
    }

    @Override
    @Nullable
    public LayoutlibSceneManager getSceneManager() {
        return (LayoutlibSceneManager)super.getSceneManager();
    }

    public void forceLayersPaint(boolean value2) {
        for (SceneView view : this.getSceneViews()) {
            view.setForceLayersRepaint(value2);
        }
        this.repaint();
    }

    @Override
    @Nullable
    public SceneView getSceneView(int x, int y) {
        LayoutlibSceneManager manager;
        SceneView view = this.getHoverSceneView(x, y);
        if (view == null && (manager = this.getSceneManager()) != null) {
            view = manager.getSceneView();
        }
        return view;
    }

    @Override
    @Nullable
    public SceneView getHoverSceneView(int x, int y) {
        ImmutableCollection<SceneView> sceneViews = this.getSceneViews();
        Dimension scaledSize = new Dimension();
        for (SceneView view : sceneViews) {
            ScaleKt.scaleBy(view.getContentSize(scaledSize), view.getScale());
            if (view.getX() > x || x > view.getX() + scaledSize.width || view.getY() > y || y > view.getY() + scaledSize.height) continue;
            return view;
        }
        return null;
    }

    @Override
    @NotNull
    protected ImmutableCollection<SceneView> getSceneViews() {
        ImmutableList.Builder builder2 = new ImmutableList.Builder();
        builder2.addAll(super.getSceneViews());
        for (SceneManager manager : this.getSceneManagers()) {
            SceneView secondarySceneView = ((LayoutlibSceneManager)manager).getSecondarySceneView();
            if (secondarySceneView == null) continue;
            builder2.add((Object)secondarySceneView);
        }
        ImmutableList immutableList = builder2.build();
        if (immutableList == null) {
            NlDesignSurface.$$$reportNull$$$0(25);
        }
        return immutableList;
    }

    public void setAdaptiveIconShape(@NotNull ShapeMenuAction.AdaptiveIconShape adaptiveIconShape) {
        if (adaptiveIconShape == null) {
            NlDesignSurface.$$$reportNull$$$0(26);
        }
        this.myAdaptiveIconShape = adaptiveIconShape;
    }

    @NotNull
    public ShapeMenuAction.AdaptiveIconShape getAdaptiveIconShape() {
        ShapeMenuAction.AdaptiveIconShape adaptiveIconShape = this.myAdaptiveIconShape;
        if (adaptiveIconShape == null) {
            NlDesignSurface.$$$reportNull$$$0(27);
        }
        return adaptiveIconShape;
    }

    @Override
    @NotNull
    public AccessoryPanel getAccessoryPanel() {
        AccessoryPanel accessoryPanel = this.myAccessoryPanel;
        if (accessoryPanel == null) {
            NlDesignSurface.$$$reportNull$$$0(28);
        }
        return accessoryPanel;
    }

    public void showInspectorAccessoryPanel(boolean show) {
        for (DesignSurfaceListener listener2 : ImmutableList.copyOf((Collection)this.myListeners)) {
            listener2.showAccessoryPanel(this, show);
        }
    }

    @Override
    public void show(@NotNull AccessoryPanel.Type type, boolean show) {
        if (type == null) {
            NlDesignSurface.$$$reportNull$$$0(29);
        }
        this.showInspectorAccessoryPanel(show);
    }

    @Override
    public double getScreenScalingFactor() {
        return JBUIScale.sysScale((Component)((Object)this));
    }

    @Override
    @NotNull
    public ActionManager<NlDesignSurface> getActionManager() {
        ActionManager actionManager = super.getActionManager();
        if (actionManager == null) {
            NlDesignSurface.$$$reportNull$$$0(30);
        }
        return actionManager;
    }

    @Override
    @NotNull
    public ItemTransferable getSelectionAsTransferable() {
        NlModel model2 = this.getModel();
        ImmutableList components = (ImmutableList)this.getSelectionModel().getSelection().stream().map(component -> new DnDTransferComponent(component.getTagName(), component.getTagDeprecated().getText(), NlComponentHelperKt.getW(component), NlComponentHelperKt.getH(component))).collect(ImmutableCollectors.toImmutableList());
        return new ItemTransferable(new DnDTransferItem(model2 != null ? model2.getId() : 0L, (ImmutableList<DnDTransferComponent>)components));
    }

    @Override
    protected Dimension getDefaultOffset() {
        return new Dimension(100, 100);
    }

    @Override
    @NotNull
    protected Dimension getPreferredContentSize(int availableWidth, int availableHeight) {
        Dimension extent = this.getExtentSize();
        Dimension dimension2 = ((NlDesignSurfacePositionableContentLayoutManager)this.getSceneViewLayoutManager()).getLayoutManager().getPreferredSize(this.getPositionableContent(), extent.width, extent.height, null);
        if (dimension2 == null) {
            NlDesignSurface.$$$reportNull$$$0(31);
        }
        return dimension2;
    }

    @Override
    public CompletableFuture<Void> setModel(@Nullable NlModel model2) {
        this.myAccessoryPanel.setModel(model2);
        return super.setModel(model2);
    }

    @Override
    public void dispose() {
        this.myAccessoryPanel.setSurface(null);
        super.dispose();
    }

    @Override
    public void notifyComponentActivate(@NotNull NlComponent component, int x, int y) {
        ViewHandler handler2;
        if (component == null) {
            NlDesignSurface.$$$reportNull$$$0(32);
        }
        if ((handler2 = NlComponentHelperKt.getViewHandler(component)) != null) {
            handler2.onActivateInDesignSurface(component, this.getSceneManager().getViewEditor(), x, y);
        }
        super.notifyComponentActivate(component, x, y);
    }

    @Override
    @NotNull
    public Consumer<NlComponent> getComponentRegistrar() {
        Consumer<NlComponent> consumer = component -> NlComponentHelper.INSTANCE.registerComponent((NlComponent)component);
        if (consumer == null) {
            NlDesignSurface.$$$reportNull$$$0(33);
        }
        return consumer;
    }

    public void setMockupVisible(boolean mockupVisible) {
        this.myMockupVisible = mockupVisible;
        this.repaint();
    }

    public boolean isMockupVisible() {
        return this.myMockupVisible;
    }

    public void setMockupEditor(@Nullable MockupEditor mockupEditor) {
        this.myMockupEditor = mockupEditor;
    }

    @Nullable
    public MockupEditor getMockupEditor() {
        return this.myMockupEditor;
    }

    public void updateErrorDisplay() {
        if (this.myIsRenderingSynchronously) {
            return;
        }
        assert (ApplicationManager.getApplication().isDispatchThread() || !ApplicationManager.getApplication().isReadAccessAllowed()) : "Do not hold read lock when calling updateErrorDisplay!";
        this.getErrorQueue().cancelAllUpdates();
        this.getErrorQueue().queue(new Update("errors"){

            public void run() {
                Project project;
                Map results = NlDesignSurface.this.getSceneManagers().stream().filter(LayoutlibSceneManager.class::isInstance).map(LayoutlibSceneManager.class::cast).filter(sceneManager -> sceneManager.getRenderResult() != null).collect(Collectors.toMap(Function.identity(), LayoutlibSceneManager::getRenderResult));
                if (results.isEmpty()) {
                    return;
                }
                if (((Boolean)StudioFlags.NELE_LAYOUT_SCANNER_IN_EDITOR.get()).booleanValue() && NlDesignSurface.this.myValidatorControl != null) {
                    for (Map.Entry entry : results.entrySet()) {
                        NlDesignSurface.this.myValidatorControl.getScanner().validateAndUpdateLint(entry.getValue(), ((LayoutlibSceneManager)entry.getKey()).getModel());
                    }
                }
                if ((project = NlDesignSurface.this.getProject()).isDisposed()) {
                    return;
                }
                DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
                    BuildMode gradleBuildMode = BuildSettings.getInstance(project).getBuildMode();
                    ImmutableList renderIssueProviders = null;
                    if (gradleBuildMode != null) {
                        for (Map.Entry entry2 : results.entrySet()) {
                            if (!((RenderResult)entry2.getValue()).getLogger().hasErrors()) continue;
                            renderIssueProviders = ImmutableList.of((Object)new RenderIssueProvider(((LayoutlibSceneManager)entry2.getKey()).getModel(), RenderErrorModel.STILL_BUILDING_ERROR_MODEL));
                            break;
                        }
                    }
                    if (renderIssueProviders == null) {
                        renderIssueProviders = (ImmutableList)results.entrySet().stream().map(entry -> {
                            RenderErrorModel errorModel = RenderErrorModelFactory.createErrorModel(NlDesignSurface.this, (RenderResult)entry.getValue(), null);
                            return new RenderIssueProvider(((LayoutlibSceneManager)entry.getKey()).getModel(), errorModel);
                        }).collect(ImmutableList.toImmutableList());
                    }
                    NlDesignSurface.this.myRenderIssueProviders.forEach(renderIssueProvider -> NlDesignSurface.this.getIssueModel().removeIssueProvider((IssueProvider)renderIssueProvider));
                    NlDesignSurface.this.myRenderIssueProviders = renderIssueProviders;
                    renderIssueProviders.forEach(renderIssueProvider -> NlDesignSurface.this.getIssueModel().addIssueProvider((IssueProvider)renderIssueProvider));
                });
            }

            public boolean canEat(Update update2) {
                return true;
            }
        });
    }

    private void modelRendered() {
        this.updateErrorDisplay();
        UIUtil.invokeLaterIfNeeded(() -> this.revalidateScrollArea());
    }

    @Override
    @NotNull
    public CompletableFuture<Void> forceUserRequestedRefresh() {
        CompletableFuture<Void> completableFuture = this.requestSequentialRender(manager -> ((LayoutlibSceneManager)manager).requestUserInitiatedRender());
        if (completableFuture == null) {
            NlDesignSurface.$$$reportNull$$$0(34);
        }
        return completableFuture;
    }

    @Override
    protected boolean useSmallProgressIcon() {
        if (this.getFocusedSceneView() == null) {
            return false;
        }
        LayoutlibSceneManager manager = this.getSceneManager();
        assert (manager != null);
        return manager.getRenderResult() != null;
    }

    @Override
    protected double getMinScale() {
        return Math.max(this.getFitScale(true), this.myMinScale);
    }

    @Override
    protected double getMaxScale() {
        return this.myMaxScale;
    }

    @Override
    public boolean canZoomToFit() {
        double minZoomLevel = this.myMinScale;
        double maxZoomLevel = this.myMaxScale;
        double zoomToFitLevel = Math.max(minZoomLevel, Math.min(this.getFitScale(true), maxZoomLevel));
        return Math.abs(this.getScale() - zoomToFitLevel) > 0.005 / this.getScreenScalingFactor();
    }

    @Override
    public boolean canZoomToActual() {
        double scaleOfActual;
        double currentScale = this.getScale();
        return currentScale > (scaleOfActual = 1.0 / this.getScreenScalingFactor()) && this.canZoomOut() || currentScale < scaleOfActual && this.canZoomIn();
    }

    @Override
    public void scrollToCenter(@NotNull List<NlComponent> list) {
        if (list == null) {
            NlDesignSurface.$$$reportNull$$$0(35);
        }
        Scene scene = this.getScene();
        SceneView view = this.getFocusedSceneView();
        if (list.isEmpty() || scene == null || view == null) {
            return;
        }
        Rectangle componentsArea = new Rectangle(0, 0, -1, -1);
        Rectangle componentRect = new Rectangle();
        list.stream().filter(nlComponent -> !nlComponent.isRoot()).forEach(nlComponent -> {
            SceneComponent component = scene.getSceneComponent((NlComponent)nlComponent);
            if (component == null) {
                return;
            }
            component.fillRect(componentRect);
            if (componentsArea.width < 0) {
                componentsArea.setBounds(componentRect);
            } else {
                componentsArea.add(componentRect);
            }
        });
        Rectangle areaToCenter = Coordinates.getSwingRectDip(view, componentsArea);
        if (areaToCenter.isEmpty() || this.getLayeredPane().getVisibleRect().contains(areaToCenter)) {
            return;
        }
        Dimension swingViewportSize = this.getExtentSize();
        int targetSwingX = (int)areaToCenter.getCenterX();
        int targetSwingY = (int)areaToCenter.getCenterY();
        this.setScrollPosition(targetSwingX - swingViewportSize.width / 2, targetSwingY - swingViewportSize.height / 2);
        double fitScale = this.getFitScale(areaToCenter.getSize(), false);
        if (this.getScale() > fitScale) {
            this.setScale(fitScale, targetSwingX, targetSwingY);
        }
    }

    @Override
    protected void notifySelectionListeners(@NotNull List<NlComponent> newSelection) {
        if (newSelection == null) {
            NlDesignSurface.$$$reportNull$$$0(36);
        }
        super.notifySelectionListeners(newSelection);
        this.scrollToCenter(newSelection);
    }

    @Override
    @NotNull
    public List<NlComponent> getSelectableComponents() {
        NlModel model2 = this.getModel();
        if (model2 == null) {
            List<NlComponent> list = Collections.emptyList();
            if (list == null) {
                NlDesignSurface.$$$reportNull$$$0(37);
            }
            return list;
        }
        ImmutableList<NlComponent> roots = model2.getComponents();
        if (roots.isEmpty()) {
            List<NlComponent> list = Collections.emptyList();
            if (list == null) {
                NlDesignSurface.$$$reportNull$$$0(38);
            }
            return list;
        }
        NlComponent root2 = (NlComponent)roots.get(0);
        if (root2 == null) {
            List<NlComponent> list = Collections.emptyList();
            if (list == null) {
                NlDesignSurface.$$$reportNull$$$0(39);
            }
            return list;
        }
        List<NlComponent> list = root2.flatten().collect(Collectors.toList());
        if (list == null) {
            NlDesignSurface.$$$reportNull$$$0(40);
        }
        return list;
    }

    public void setRenderSynchronously(boolean enabled) {
        this.myIsRenderingSynchronously = enabled;
    }

    public boolean isRenderingSynchronously() {
        return this.myIsRenderingSynchronously;
    }

    public void setAnimationScrubbing(boolean value2) {
        this.myIsAnimationScrubbing = value2;
    }

    public boolean isInAnimationScrubbing() {
        return this.myIsAnimationScrubbing;
    }

    public void setScrollableViewMinSize(@NotNull Dimension dimension2) {
        if (dimension2 == null) {
            NlDesignSurface.$$$reportNull$$$0(41);
        }
        this.myScrollableViewMinSize.setSize(dimension2);
    }

    @Override
    public final Object getData(@NotNull String dataId) {
        Object data;
        if (dataId == null) {
            NlDesignSurface.$$$reportNull$$$0(42);
        }
        Object object = data = this.myDelegateDataProvider != null ? this.myDelegateDataProvider.getData(dataId) : null;
        if (data != null) {
            return data;
        }
        if (LayoutPreviewHandlerKt.LAYOUT_PREVIEW_HANDLER_KEY.is(dataId)) {
            return this;
        }
        if (DesignerDataKeys.LAYOUT_SCANNER_KEY.is(dataId)) {
            return this.myValidatorControl;
        }
        return super.getData(dataId);
    }

    @Override
    public boolean getPreviewWithToolsVisibilityAndPosition() {
        return this.myPreviewWithToolsVisibilityAndPosition;
    }

    @Override
    public void setPreviewWithToolsVisibilityAndPosition(boolean isPreviewWithToolsVisibilityAndPosition) {
        if (this.myPreviewWithToolsVisibilityAndPosition != isPreviewWithToolsVisibilityAndPosition) {
            this.myPreviewWithToolsVisibilityAndPosition = isPreviewWithToolsVisibilityAndPosition;
            this.forceUserRequestedRefresh();
        }
    }

    @NotNull
    Dimension getScrollableViewMinSize() {
        Dimension dimension2 = this.myScrollableViewMinSize;
        if (dimension2 == null) {
            NlDesignSurface.$$$reportNull$$$0(43);
        }
        return dimension2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneManagerProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultLayoutManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManagerProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interactionHandlerProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onChangeZoom";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionHandlerProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionModel";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/surface/NlDesignSurface";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenViewProvider";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adaptiveIconShape";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSelection";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dimension";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/surface/NlDesignSurface";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultSceneManagerProvider";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createSceneManager";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnalyticsManager";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getScreenViewProvider";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneViews";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdaptiveIconShape";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessoryPanel";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionManager";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredContentSize";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentRegistrar";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "forceUserRequestedRefresh";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectableComponents";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getScrollableViewMinSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "defaultSceneManagerProvider";
                break;
            }
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "defaultActionManagerProvider";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "defaultInteractionHandlerProvider";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "defaultActionHandlerProvider";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "builder";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createSceneManager";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setScreenViewProvider";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setAdaptiveIconShape";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "notifyComponentActivate";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "scrollToCenter";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "notifySelectionListeners";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "setScrollableViewMinSize";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface NavigationHandler
    extends Disposable {
        public boolean handleNavigate(@NotNull SceneView var1, @NotNull SceneComponent var2, int var3, int var4, boolean var5);
    }

    public static class Builder {
        private final Project myProject;
        private final Disposable myParentDisposable;
        private boolean myIsPreview;
        private BiFunction<NlDesignSurface, NlModel, LayoutlibSceneManager> mySceneManagerProvider;
        private boolean myShowModelName;
        private boolean myIsEditable;
        private SurfaceLayoutManager myLayoutManager;
        private NavigationHandler myNavigationHandler;
        private double myMinScale;
        private double myMaxScale;
        @NotNull
        private ZoomType myOnChangeZoom;
        @Nullable
        private DataProvider myDelegateDataProvider;
        private Function<DesignSurface, ActionManager<? extends DesignSurface>> myActionManagerProvider;
        private Function<DesignSurface, InteractionHandler> myInteractionHandlerProvider;
        private Function<DesignSurface, DesignSurfaceActionHandler> myActionHandlerProvider;
        @Nullable
        private SelectionModel mySelectionModel;

        private Builder(@NotNull Project project, @NotNull Disposable parentDisposable) {
            if (project == null) {
                Builder.$$$reportNull$$$0(0);
            }
            if (parentDisposable == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myIsPreview = false;
            this.mySceneManagerProvider = NlDesignSurface::defaultSceneManagerProvider;
            this.myShowModelName = false;
            this.myIsEditable = true;
            this.myMinScale = 0.1;
            this.myMaxScale = 10.0;
            this.myOnChangeZoom = ZoomType.FIT_INTO;
            this.myDelegateDataProvider = null;
            this.myActionManagerProvider = NlDesignSurface::defaultActionManagerProvider;
            this.myInteractionHandlerProvider = NlDesignSurface::defaultInteractionHandlerProvider;
            this.myActionHandlerProvider = NlDesignSurface::defaultActionHandlerProvider;
            this.mySelectionModel = null;
            this.myProject = project;
            this.myParentDisposable = parentDisposable;
        }

        @NotNull
        public Builder setIsPreview(boolean isPreview) {
            this.myIsPreview = isPreview;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder2;
        }

        @NotNull
        public Builder setSceneManagerProvider(@NotNull BiFunction<NlDesignSurface, NlModel, LayoutlibSceneManager> sceneManagerProvider) {
            if (sceneManagerProvider == null) {
                Builder.$$$reportNull$$$0(3);
            }
            this.mySceneManagerProvider = sceneManagerProvider;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder2;
        }

        @NotNull
        public Builder showModelNames() {
            this.myShowModelName = true;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder2;
        }

        @NotNull
        public Builder setLayoutManager(@NotNull SurfaceLayoutManager layoutManager) {
            if (layoutManager == null) {
                Builder.$$$reportNull$$$0(6);
            }
            this.myLayoutManager = layoutManager;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder2;
        }

        @NotNull
        public Builder setActionManagerProvider(@NotNull Function<DesignSurface, ActionManager<? extends DesignSurface>> actionManagerProvider) {
            if (actionManagerProvider == null) {
                Builder.$$$reportNull$$$0(8);
            }
            this.myActionManagerProvider = actionManagerProvider;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(9);
            }
            return builder2;
        }

        @NotNull
        public Builder setEditable(boolean editable) {
            this.myIsEditable = editable;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return builder2;
        }

        @NotNull
        public Builder setInteractionHandlerProvider(@NotNull Function<DesignSurface, InteractionHandler> interactionHandlerProvider) {
            if (interactionHandlerProvider == null) {
                Builder.$$$reportNull$$$0(11);
            }
            this.myInteractionHandlerProvider = interactionHandlerProvider;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(12);
            }
            return builder2;
        }

        @NotNull
        public Builder setNavigationHandler(NavigationHandler navigationHandler) {
            this.myNavigationHandler = navigationHandler;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(13);
            }
            return builder2;
        }

        public Builder setMinScale(double scale) {
            if (scale <= 0.0) {
                throw new IllegalStateException("The min scale (" + scale + ") is not larger than 0");
            }
            this.myMinScale = scale;
            return this;
        }

        public Builder setMaxScale(double scale) {
            this.myMaxScale = scale;
            return this;
        }

        public Builder setOnConfigurationChangedZoom(@NotNull ZoomType onChangeZoom) {
            if (onChangeZoom == null) {
                Builder.$$$reportNull$$$0(14);
            }
            this.myOnChangeZoom = onChangeZoom;
            return this;
        }

        @NotNull
        public Builder setActionHandler(@NotNull Function<DesignSurface, DesignSurfaceActionHandler> actionHandlerProvider) {
            if (actionHandlerProvider == null) {
                Builder.$$$reportNull$$$0(15);
            }
            this.myActionHandlerProvider = actionHandlerProvider;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(16);
            }
            return builder2;
        }

        @NotNull
        public Builder setDelegateDataProvider(@NotNull DataProvider dataProvider) {
            if (dataProvider == null) {
                Builder.$$$reportNull$$$0(17);
            }
            this.myDelegateDataProvider = dataProvider;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(18);
            }
            return builder2;
        }

        @NotNull
        public Builder setSelectionModel(@NotNull SelectionModel selectionModel) {
            if (selectionModel == null) {
                Builder.$$$reportNull$$$0(19);
            }
            this.mySelectionModel = selectionModel;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(20);
            }
            return builder2;
        }

        @NotNull
        public NlDesignSurface build() {
            SurfaceLayoutManager layoutManager;
            SurfaceLayoutManager surfaceLayoutManager = layoutManager = this.myLayoutManager != null ? this.myLayoutManager : NlDesignSurface.createDefaultSurfaceLayoutManager();
            if (this.myMinScale > this.myMaxScale) {
                throw new IllegalStateException("The max scale (" + this.myMaxScale + ") is lower than min scale (" + this.myMinScale + ")");
            }
            return new NlDesignSurface(this.myProject, this.myParentDisposable, this.myIsPreview, this.myIsEditable, this.myShowModelName, this.mySceneManagerProvider, layoutManager, this.myActionManagerProvider, this.myInteractionHandlerProvider, this.myNavigationHandler, this.myMinScale, this.myMaxScale, this.myOnChangeZoom, this.myActionHandlerProvider, this.myDelegateDataProvider, this.mySelectionModel != null ? this.mySelectionModel : new DefaultSelectionModel());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 16: 
                case 18: 
                case 20: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 16: 
                case 18: 
                case 20: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 16: 
                case 18: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/surface/NlDesignSurface$Builder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sceneManagerProvider";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "layoutManager";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionManagerProvider";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interactionHandlerProvider";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "onChangeZoom";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionHandlerProvider";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataProvider";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectionModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/surface/NlDesignSurface$Builder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setIsPreview";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setSceneManagerProvider";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "showModelNames";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setLayoutManager";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setActionManagerProvider";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setEditable";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setInteractionHandlerProvider";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setNavigationHandler";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setActionHandler";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setDelegateDataProvider";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setSelectionModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 16: 
                case 18: 
                case 20: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setSceneManagerProvider";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setLayoutManager";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "setActionManagerProvider";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "setInteractionHandlerProvider";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "setOnConfigurationChangedZoom";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "setActionHandler";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "setDelegateDataProvider";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelectionModel";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 16: 
                case 18: 
                case 20: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

