/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scout;

import com.android.tools.idea.uibuilder.scout.ScoutWidget;
import java.util.ArrayList;
import java.util.Random;

public class RectangleGenerator {
    public static final int MIN_WIDTH = 100;
    public static final int MIN_HEIGHT = 40;
    public static final int MIN_GAP = 40;
    public static final int MAX_TRIES = 100;
    ArrayList<ScoutWidget> recs;

    public ArrayList<ScoutWidget> random(int count, int sizeRatio, int width, int height) {
        this.recs = new ArrayList();
        FakeWidget parent = new FakeWidget(null);
        parent.setX(0);
        parent.setY(0);
        parent.setWidth(width);
        parent.setHeight(height);
        int minWidth = 100;
        int minHeight = 40;
        int minGap = 40;
        int gapBy2 = 80;
        Random rand = new Random(System.currentTimeMillis());
        FakeWidget test = new FakeWidget(null);
        for (int i2 = 0; i2 < count; ++i2) {
            FakeWidget rn = new FakeWidget(null);
            boolean found = false;
            int attempt = 0;
            while (!found) {
                if (rand.nextInt(100) < sizeRatio) {
                    rn.setX(rand.nextInt(width - minWidth - gapBy2) + minGap);
                    rn.setY(rand.nextInt(height - minHeight - gapBy2) + minGap);
                    rn.setWidth(minWidth + rand.nextInt(width - (int)rn.getX() - minWidth - minGap));
                    rn.setHeight(minHeight + rand.nextInt(height - (int)rn.getY() - minHeight - minGap));
                } else {
                    rn.setX(rand.nextInt(width - minWidth - gapBy2) + minGap);
                    rn.setY(rand.nextInt(height - minHeight - gapBy2) + minGap);
                    rn.setWidth(minWidth);
                    rn.setHeight(minHeight);
                }
                rn.setBaseline((int)(rn.getY() / 2.0f));
                test.setX((int)rn.getX() - minGap);
                test.setY((int)rn.getY() - minGap);
                test.setWidth((int)rn.getWidth() + gapBy2);
                test.setHeight((int)rn.getHeight() + gapBy2);
                found = true;
                int size = this.recs.size();
                for (int j = 0; j < size; ++j) {
                    if (!this.recs.get(j).getRectangle().intersects(test.getRectangle())) continue;
                    found = false;
                    break;
                }
                if (++attempt <= 100) continue;
                break;
            }
            if (!found) continue;
            this.recs.add(rn);
        }
        this.recs.add(0, parent);
        return this.recs;
    }

    public String displayRecs(ScoutWidget[] recs) {
        Object display2 = "";
        for (int i2 = 0; i2 < recs.length; ++i2) {
            ScoutWidget wrect = recs[i2];
            if (i2 != 0) {
                display2 = (String)display2 + String.format("DrawComponentBackground,%d,%d,%d,%d,1,false\n", (int)wrect.getX(), (int)wrect.getY(), (int)wrect.getWidth(), (int)wrect.getHeight());
                display2 = (String)display2 + String.format("DrawTextRegion,%d,%d,%d,%d,0,0,false,false,5,5,28,1.0,\"\"\n", (int)wrect.getX(), (int)wrect.getY(), (int)wrect.getWidth(), (int)wrect.getHeight());
            }
            display2 = (String)display2 + String.format("DrawNlComponentFrame,%d,%d,%d,%d,1,20,20\n", (int)wrect.getX(), (int)wrect.getY(), (int)wrect.getWidth(), (int)wrect.getHeight());
        }
        display2 = (String)display2 + String.format("Clip,0,0,%d,%d\n", (int)recs[0].getWidth(), (int)recs[0].getHeight());
        return display2;
    }

    public class FakeWidget
    extends ScoutWidget {
        public FakeWidget(FakeWidget parent) {
            this.mParent = parent;
        }

        @Override
        public void setX(int x) {
            this.mX = x;
        }

        @Override
        public void setY(int y) {
            this.mY = y;
        }

        public void setBaseline(int baseline) {
            this.mBaseLine = baseline;
        }

        public int baseline() {
            return this.mBaseLine;
        }

        @Override
        public void setWidth(int width) {
            this.mWidth = width;
        }

        @Override
        public void setHeight(int height) {
            this.mHeight = height;
        }
    }
}

