/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawRegion;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawConnectionUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class DrawHorizontalNotch
extends DrawRegion {
    public DrawHorizontalNotch(String s) {
        super(s);
    }

    public DrawHorizontalNotch(int x, int y, int width) {
        super(x, y, width, x);
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        ColorSet colorSet = sceneContext.getColorSet();
        Color background = colorSet.getFrames();
        g.setColor(background);
        Stroke stroke = g.getStroke();
        g.setStroke(DrawConnectionUtils.sDashedStroke);
        g.drawLine(this.x, this.y, this.x + this.width, this.y);
        g.setStroke(stroke);
    }

    public static void add(DisplayList list, SceneContext transform, float left2, float top, float right2) {
        int l = transform.getSwingXDip(left2);
        int t = transform.getSwingYDip(top);
        int w = transform.getSwingDimensionDip(right2 - left2);
        list.add(new DrawHorizontalNotch(l, t, w));
    }
}

