/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.decorator;

import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.decorator.SceneDecorator;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawRegion;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.decorator.ColorTheme;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

public class ImageViewDecorator
extends SceneDecorator {
    /*
     * WARNING - void declaration
     */
    @Override
    public void addContent(@NotNull DisplayList list, long time2, @NotNull SceneContext sceneContext, @NotNull SceneComponent sceneComponent) {
        void component;
        if (list == null) {
            ImageViewDecorator.$$$reportNull$$$0(0);
        }
        if (sceneContext == null) {
            ImageViewDecorator.$$$reportNull$$$0(1);
        }
        if (sceneComponent == null) {
            ImageViewDecorator.$$$reportNull$$$0(2);
        }
        Rectangle rect = new Rectangle();
        component.fillDrawRect(time2, rect);
        int l = sceneContext.getSwingXDip(rect.x);
        int t = sceneContext.getSwingYDip(rect.y);
        int w = sceneContext.getSwingDimensionDip(rect.width);
        int h = sceneContext.getSwingDimensionDip(rect.height);
        list.add(new DrawImageView(l, t, w, h));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "list";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "sceneContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "component";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/uibuilder/scene/decorator/ImageViewDecorator";
        objectArray[2] = "addContent";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class DrawImageView
    extends DrawRegion {
        static double[] move = new double[]{196.0, 319.99908};
        String TITLE = "ImageView";
        private Font mFont = new Font("Helvetica", 0, 12);
        static double[][] curve = new double[][]{{3.9168854, -4.08313, 18.501312, -17.415588, 23.501312, -24.498688}, {5.0, -7.08313, 1.7489014, -10.666687, 6.4986877, -18.0}, {4.7497864, -7.3333435, 14.166672, -19.916443, 22.0, -26.0}, {7.8333282, -6.083557, 13.416443, 2.9986877, 25.0, -10.501312}, {11.583557, -13.5, 35.334656, -58.498688, 44.501312, -70.49869}, {9.1666565, -12.0, 6.3320312, 1.0822296, 10.498688, -1.5013123}, {4.1666565, -2.5835571, 11.167969, -11.5, 14.501312, -14.0}, {3.3333435, -2.5, -4.417755, 9.083115, 5.4986877, -1.0}, {9.916443, -10.083115, 38.5, -53.41558, 54.0, -59.498695}, {15.5, -6.0831146, 30.666656, 18.416885, 39.0, 23.0}, {8.3333435, 4.5831146, 3.1666565, -4.0013123, 11.0, 4.4986877}, {7.8333435, 8.500008, 19.249786, 33.417763, 36.0, 46.50132}, {16.750214, 13.083542, 50.917786, 27.250214, 64.50134, 32.0}, {13.583496, 4.749771, 6.833313, -12.251099, 17.0, -3.5013123}, {10.166626, 8.749771, 26.166626, 36.74977, 44.0, 56.0}, {17.833313, 19.250214, 51.750183, 49.001312, 63.0, 59.501312}, {11.249756, 10.5, 3.7489014, 2.9155579, 4.498657, 3.4986877}};
        static Path2D sPath2D = new Path2D.Float();
        static Path2D sClosedPath2D;
        static int sPathWidth;
        static int sPathHeight;
        private AffineTransform mTransform = new AffineTransform();

        @Override
        public int getLevel() {
            return 20;
        }

        DrawImageView(int x, int y, int width, int height) {
            super(x, y, width, height);
        }

        public DrawImageView(String s) {
            String[] sp = s.split(",");
            super.parse(sp, 0);
        }

        @Override
        public void paint(Graphics2D g, SceneContext sceneContext) {
            g.drawRect(this.x, this.y, this.width, this.height);
            ColorSet colorSet = sceneContext.getColorSet();
            if (colorSet.drawBackground()) {
                this.mTransform.setToIdentity();
                double sw = (double)(this.width - 1) / (double)sPathWidth;
                double sh = (double)this.height / (double)sPathHeight;
                double s = Math.max(sw, sh);
                double dx = 1.0 + ((double)this.width - (double)sPathWidth * s) / 2.0;
                double dy = ((double)this.height - (double)sPathHeight * s) / 2.0;
                this.mTransform.translate(dx, 0.0);
                this.mTransform.scale(s, s);
                Graphics2D clipGraphics = (Graphics2D)g.create(this.x, this.y, this.width, this.height);
                clipGraphics.setColor(ColorTheme.updateBrightness(colorSet.getBackground(), 0.8f, 64));
                Shape shape = sClosedPath2D.createTransformedShape(this.mTransform);
                clipGraphics.fill(shape);
                shape = sPath2D.createTransformedShape(this.mTransform);
                clipGraphics.setColor(colorSet.getFrames());
                clipGraphics.draw(shape);
                int stringWidth = g.getFontMetrics(this.mFont).stringWidth(this.TITLE);
                float scale = (float)this.width / ((float)stringWidth * 3.0f / 2.0f);
                g.setFont(this.mFont.deriveFont((float)this.mFont.getSize() * scale));
                FontMetrics fontMetrics = g.getFontMetrics();
                g.setColor(colorSet.getFrames());
                Rectangle2D bounds2 = fontMetrics.getStringBounds(this.TITLE, g);
                g.drawString(this.TITLE, this.x + (int)(((double)this.width - bounds2.getWidth()) / 2.0), this.y + (int)((double)this.height - ((double)this.height - bounds2.getHeight()) / 3.0));
            }
        }

        static {
            sPath2D.moveTo(move[0], move[1]);
            double cx = move[0];
            double cy = move[1];
            for (double[] val : curve) {
                int k = 0;
                sPath2D.curveTo(cx + val[k], cy + val[k + 1], cx + val[k + 2], cy + val[k + 3], cx + val[k + 4], cy + val[k + 5]);
                cx += val[k + 4];
                cy += val[k + 5];
            }
            Rectangle bounds2 = sPath2D.getBounds();
            sClosedPath2D = (Path2D)sPath2D.clone();
            sClosedPath2D.lineTo(cx, cy += 20.0);
            sClosedPath2D.lineTo(move[0], cy);
            sClosedPath2D.closePath();
            AffineTransform transform = new AffineTransform();
            transform.translate(-bounds2.x, -bounds2.y);
            sPath2D.transform(transform);
            sClosedPath2D.transform(transform);
            double scale = 100.0 / (double)Math.max(bounds2.width, bounds2.height);
            transform.setToIdentity();
            transform.scale(scale, scale);
            sPath2D.transform(transform);
            sClosedPath2D.transform(transform);
            bounds2 = sPath2D.getBounds();
            sPathWidth = bounds2.width;
            sPathHeight = bounds2.height;
        }
    }
}

