/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene;

import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.resources.Density;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.common.analytics.CommonUsageTracker;
import com.android.tools.idea.common.diagnostics.NlDiagnosticsManager;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionListener;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.DefaultSceneManagerHierarchyProvider;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.decorator.SceneDecoratorFactory;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.type.DesignerEditorFileType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.parsers.LayoutPullParsers;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.tools.idea.res.ResourceNotificationManager;
import com.android.tools.idea.uibuilder.analytics.NlAnalyticsManager;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ConstraintDragDndTarget;
import com.android.tools.idea.uibuilder.menu.NavigationViewSceneView;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.DesignSurfaceProgressIndicator;
import com.android.tools.idea.uibuilder.scene.MergingRenderingQueue;
import com.android.tools.idea.uibuilder.scene.RenderListener;
import com.android.tools.idea.uibuilder.scene.RenderingQueue;
import com.android.tools.idea.uibuilder.scene.decorator.NlSceneDecoratorFactory;
import com.android.tools.idea.uibuilder.surface.LayoutScannerConfiguration;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.NlScreenViewProvider;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.idea.uibuilder.surface.ScreenViewLayer;
import com.android.tools.idea.uibuilder.type.MenuFileType;
import com.android.tools.idea.util.ListenerCollection;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.wireless.android.sdk.stats.LayoutEditorRenderResult;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SlowOperations;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Update;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

public class LayoutlibSceneManager
extends SceneManager {
    private static final SceneDecoratorFactory DECORATOR_FACTORY = new NlSceneDecoratorFactory();
    @Nullable
    private SceneView mySecondarySceneView;
    private int myDpi;
    private final SelectionChangeListener mySelectionChangeListener;
    private final ModelChangeListener myModelChangeListener;
    private final ConfigurationListener myConfigurationChangeListener;
    private final boolean myAreListenersRegistered;
    private final DesignSurfaceProgressIndicator myProgressIndicator;
    private final RenderingQueue myRenderingQueue;
    private RenderTask myRenderTask;
    private long myTaskStartTimeNanos;
    private final Object myRenderingTaskLock;
    private ResourceNotificationManager.ResourceVersion myRenderedVersion;
    private final ReentrantReadWriteLock myRenderResultLock;
    @Nullable
    private RenderResult myRenderResult;
    private String myPreviousDeviceName;
    private Locale myPreviousLocale;
    private String myPreviousVersion;
    private String myPreviousTheme;
    private static final int VISUAL_EMPTY_COMPONENT_SIZE = 1;
    private long myElapsedFrameTimeMs;
    private final Object myFuturesLock;
    private final LinkedList<CompletableFuture<Void>> myRenderFutures;
    private final LinkedList<CompletableFuture<Void>> myPendingFutures;
    private final Semaphore myUpdateHierarchyLock;
    @NotNull
    private final ViewEditor myViewEditor;
    private final ListenerCollection<RenderListener> myRenderListeners;
    @NotNull
    private final Executor myRenderTaskDisposerExecutor;
    private Boolean myIsCurrentlyRendering;
    private boolean useTransparentRendering;
    private boolean useShrinkRendering;
    private boolean myUsePrivateClassLoader;
    private boolean useShowDecorations;
    private boolean myIsInteractive;
    private boolean useImagePool;
    private float quality;
    private Function<ClassVisitor, ClassVisitor> myAdditionalProjectTransform;
    private Function<ClassVisitor, ClassVisitor> myAdditionalNonProjectTransform;
    private final AtomicBoolean myForceInflate;
    private final AtomicBoolean isDisposed;
    private AtomicInteger myTouchEventsCounter;
    @NotNull
    private final LayoutScannerConfiguration myLayoutScannerConfig;
    private static boolean ourRenderViewPort;

    protected static LayoutEditorRenderResult.Trigger getTriggerFromChangeType(@Nullable NlModel.ChangeType changeType) {
        if (changeType == null) {
            return null;
        }
        switch (changeType) {
            case RESOURCE_EDIT: 
            case RESOURCE_CHANGED: {
                return LayoutEditorRenderResult.Trigger.RESOURCE_CHANGE;
            }
            case EDIT: 
            case ADD_COMPONENTS: 
            case DELETE: 
            case DND_COMMIT: 
            case DND_END: 
            case DROP: 
            case RESIZE_END: 
            case RESIZE_COMMIT: {
                return LayoutEditorRenderResult.Trigger.EDIT;
            }
            case BUILD: {
                return LayoutEditorRenderResult.Trigger.BUILD;
            }
        }
        return null;
    }

    protected LayoutlibSceneManager(@NotNull NlModel model2, @NotNull DesignSurface designSurface, @NotNull Executor renderTaskDisposerExecutor, @NotNull Function<Disposable, RenderingQueue> renderingQueueFactory, @NotNull SceneManager.SceneComponentHierarchyProvider sceneComponentProvider, @Nullable SceneManager.SceneUpdateListener sceneUpdateListener, @NotNull LayoutScannerConfiguration layoutScannerConfig) {
        if (model2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(0);
        }
        if (designSurface == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(1);
        }
        if (renderTaskDisposerExecutor == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(2);
        }
        if (renderingQueueFactory == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(3);
        }
        if (sceneComponentProvider == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(4);
        }
        if (layoutScannerConfig == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(5);
        }
        super(model2, designSurface, false, sceneComponentProvider, sceneUpdateListener);
        this.myDpi = 0;
        this.mySelectionChangeListener = new SelectionChangeListener();
        this.myModelChangeListener = new ModelChangeListener();
        this.myConfigurationChangeListener = new ConfigurationChangeListener();
        this.myRenderingTaskLock = new Object();
        this.myRenderResultLock = new ReentrantReadWriteLock();
        this.myElapsedFrameTimeMs = -1L;
        this.myFuturesLock = new Object();
        this.myRenderFutures = new LinkedList();
        this.myPendingFutures = new LinkedList();
        this.myUpdateHierarchyLock = new Semaphore(1);
        this.myRenderListeners = ListenerCollection.createWithDirectExecutor();
        this.myIsCurrentlyRendering = false;
        this.useTransparentRendering = false;
        this.useShrinkRendering = false;
        this.myUsePrivateClassLoader = false;
        this.useImagePool = true;
        this.quality = 1.0f;
        this.myAdditionalProjectTransform = Function.identity();
        this.myAdditionalNonProjectTransform = Function.identity();
        this.myForceInflate = new AtomicBoolean(false);
        this.isDisposed = new AtomicBoolean(false);
        this.myTouchEventsCounter = new AtomicInteger(0);
        this.myProgressIndicator = new DesignSurfaceProgressIndicator(designSurface);
        this.myRenderTaskDisposerExecutor = renderTaskDisposerExecutor;
        this.myRenderingQueue = renderingQueueFactory.apply(this);
        this.createSceneView();
        if (IdeInfo.getInstance().isAndroidStudio()) {
            this.updateTrackingConfiguration();
        } else {
            SlowOperations.allowSlowOperations(this::updateTrackingConfiguration);
        }
        this.getDesignSurface().getSelectionModel().addListener(this.mySelectionChangeListener);
        Scene scene = this.getScene();
        this.myViewEditor = new ViewEditorImpl(model2, scene);
        model2.getConfiguration().addListener(this.myConfigurationChangeListener);
        ImmutableList<NlComponent> components = model2.getComponents();
        if (!components.isEmpty()) {
            NlComponent rootComponent2 = ((NlComponent)components.get(0)).getRoot();
            boolean previous = this.getScene().isAnimated();
            scene.setAnimated(false);
            List<SceneComponent> hierarchy = sceneComponentProvider.createHierarchy(this, rootComponent2);
            SceneComponent root2 = hierarchy.isEmpty() ? null : hierarchy.get(0);
            this.updateFromComponent(root2, new HashSet<SceneComponent>());
            scene.setRoot(root2);
            this.updateTargets();
            scene.setAnimated(previous);
        }
        model2.addListener(this.myModelChangeListener);
        this.myAreListenersRegistered = true;
        this.myLayoutScannerConfig = layoutScannerConfig;
        scene.selectionChanged(this.getDesignSurface().getSelectionModel(), this.getDesignSurface().getSelectionModel().getSelection());
    }

    public LayoutlibSceneManager(@NotNull NlModel model2, @NotNull DesignSurface designSurface, @NotNull SceneManager.SceneComponentHierarchyProvider sceneComponentProvider, @NotNull SceneManager.SceneUpdateListener sceneUpdateListener) {
        if (model2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(6);
        }
        if (designSurface == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(7);
        }
        if (sceneComponentProvider == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(8);
        }
        if (sceneUpdateListener == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(9);
        }
        this(model2, designSurface, AppExecutorUtil.getAppExecutorService(), disposable2 -> new MergingRenderingQueue((Disposable)disposable2), sceneComponentProvider, sceneUpdateListener, LayoutScannerConfiguration.getDISABLED());
    }

    public LayoutlibSceneManager(@NotNull NlModel model2, @NotNull DesignSurface designSurface) {
        if (model2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(10);
        }
        if (designSurface == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(11);
        }
        this(model2, designSurface, AppExecutorUtil.getAppExecutorService(), disposable2 -> new MergingRenderingQueue((Disposable)disposable2), new LayoutlibSceneManagerHierarchyProvider(), null, LayoutScannerConfiguration.getDISABLED());
    }

    public LayoutlibSceneManager(@NotNull NlModel model2, @NotNull DesignSurface designSurface, LayoutScannerConfiguration config) {
        if (model2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(12);
        }
        if (designSurface == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(13);
        }
        this(model2, designSurface, PooledThreadExecutor.INSTANCE, disposable2 -> new MergingRenderingQueue((Disposable)disposable2), new LayoutlibSceneManagerHierarchyProvider(), null, config);
    }

    @NotNull
    public ViewEditor getViewEditor() {
        ViewEditor viewEditor = this.myViewEditor;
        if (viewEditor == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(14);
        }
        return viewEditor;
    }

    @Override
    @NotNull
    public TemporarySceneComponent createTemporaryComponent(@NotNull NlComponent component) {
        if (component == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(15);
        }
        Scene scene = this.getScene();
        assert (scene.getRoot() != null);
        TemporarySceneComponent tempComponent = new TemporarySceneComponent(this.getScene(), component);
        tempComponent.setTargetProvider(sceneComponent -> ImmutableList.of((Object)new ConstraintDragDndTarget()));
        scene.setAnimated(false);
        scene.getRoot().addChild(tempComponent);
        this.syncFromNlComponent(tempComponent);
        scene.setAnimated(true);
        TemporarySceneComponent temporarySceneComponent = tempComponent;
        if (temporarySceneComponent == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(16);
        }
        return temporarySceneComponent;
    }

    @Override
    @NotNull
    public SceneDecoratorFactory getSceneDecoratorFactory() {
        SceneDecoratorFactory sceneDecoratorFactory = DECORATOR_FACTORY;
        if (sceneDecoratorFactory == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(17);
        }
        return sceneDecoratorFactory;
    }

    @Override
    public float getSceneScalingFactor() {
        return (float)this.getModel().getConfiguration().getDensity().getDpiValue() / (float)Density.DEFAULT_DENSITY;
    }

    @NotNull
    public LayoutScannerConfiguration getLayoutScannerConfig() {
        LayoutScannerConfiguration layoutScannerConfiguration = this.myLayoutScannerConfig;
        if (layoutScannerConfiguration == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(18);
        }
        return layoutScannerConfiguration;
    }

    @Override
    public void dispose() {
        if (this.isDisposed.getAndSet(true)) {
            return;
        }
        try {
            if (this.myAreListenersRegistered) {
                NlModel model2 = this.getModel();
                this.getDesignSurface().getSelectionModel().removeListener(this.mySelectionChangeListener);
                model2.getConfiguration().removeListener(this.myConfigurationChangeListener);
                model2.removeListener(this.myModelChangeListener);
            }
            this.myRenderListeners.clear();
            this.myProgressIndicator.stop();
        }
        finally {
            super.dispose();
            if (ApplicationManager.getApplication().isReadAccessAllowed()) {
                this.myRenderTaskDisposerExecutor.execute(this::disposeRenderTask);
            } else {
                this.disposeRenderTask();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRenderTask(@Nullable RenderTask newTask) {
        Object object = this.myRenderingTaskLock;
        synchronized (object) {
            if (this.myRenderTask != null && !this.myRenderTask.isDisposed()) {
                try {
                    this.myRenderTask.dispose();
                }
                catch (Throwable t) {
                    Logger.getInstance(LayoutlibSceneManager.class).warn(t);
                }
            }
            this.myTaskStartTimeNanos = System.nanoTime();
            this.myRenderTask = newTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeRenderTask() {
        RenderTask renderTask;
        Object object = this.myRenderingTaskLock;
        synchronized (object) {
            renderTask = this.myRenderTask;
            this.myRenderTask = null;
        }
        if (renderTask != null) {
            try {
                renderTask.dispose();
            }
            catch (Throwable t) {
                Logger.getInstance(LayoutlibSceneManager.class).warn(t);
            }
        }
        this.myRenderResultLock.writeLock().lock();
        try {
            if (this.myRenderResult != null) {
                this.myRenderResult.dispose();
            }
            this.myRenderResult = null;
        }
        finally {
            this.myRenderResultLock.writeLock().unlock();
        }
    }

    @Override
    @NotNull
    protected NlDesignSurface getDesignSurface() {
        NlDesignSurface nlDesignSurface = (NlDesignSurface)super.getDesignSurface();
        if (nlDesignSurface == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(19);
        }
        return nlDesignSurface;
    }

    @Override
    @NotNull
    protected SceneView doCreateSceneView() {
        NlModel model2 = this.getModel();
        DesignerEditorFileType type = model2.getType();
        if (type == MenuFileType.INSTANCE) {
            SceneView sceneView = this.createSceneViewsForMenu();
            if (sceneView == null) {
                LayoutlibSceneManager.$$$reportNull$$$0(20);
            }
            return sceneView;
        }
        ScreenView primarySceneView = this.getDesignSurface().getScreenViewProvider().createPrimarySceneView(this.getDesignSurface(), this);
        this.mySecondarySceneView = this.getDesignSurface().getScreenViewProvider().createSecondarySceneView(this.getDesignSurface(), this);
        this.getDesignSurface().updateErrorDisplay();
        ScreenView screenView = primarySceneView;
        if (screenView == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(21);
        }
        return screenView;
    }

    @Override
    @NotNull
    public List<SceneView> getSceneViews() {
        ImmutableList.Builder builder2 = ImmutableList.builder().addAll(super.getSceneViews());
        if (this.mySecondarySceneView != null) {
            builder2.add((Object)this.mySecondarySceneView);
        }
        ImmutableList immutableList = builder2.build();
        if (immutableList == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(22);
        }
        return immutableList;
    }

    private SceneView createSceneViewsForMenu() {
        NlModel model2 = this.getModel();
        XmlTag tag = model2.getFile().getRootTag();
        ScreenView sceneView = tag != null && Objects.equals(tag.getAttributeValue("showIn", "http://schemas.android.com/tools"), "navigation_view") ? ScreenView.newBuilder(this.getDesignSurface(), this).withLayersProvider(sv -> ImmutableList.of((Object)new ScreenViewLayer((ScreenView)sv))).withContentSizePolicy(NavigationViewSceneView.CONTENT_SIZE_POLICY).withShapePolicy(SceneView.SQUARE_SHAPE_POLICY).build() : ScreenView.newBuilder(this.getDesignSurface(), this).build();
        this.getDesignSurface().updateErrorDisplay();
        return sceneView;
    }

    @Nullable
    public SceneView getSecondarySceneView() {
        return this.mySecondarySceneView;
    }

    public void updateTargets() {
        SceneComponent root2 = this.getScene().getRoot();
        if (root2 != null) {
            LayoutlibSceneManager.updateTargetProviders(root2);
            root2.updateTargets();
        }
    }

    private static void updateTargetProviders(@NotNull SceneComponent component) {
        if (component == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(23);
        }
        ViewHandler handler2 = NlComponentHelperKt.getViewHandler(component.getNlComponent());
        component.setTargetProvider(handler2);
        for (SceneComponent child : component.getChildren()) {
            LayoutlibSceneManager.updateTargetProviders(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private CompletableFuture<Void> requestRender(@Nullable LayoutEditorRenderResult.Trigger trigger) {
        if (this.isDisposed.get()) {
            Logger.getInstance(LayoutlibSceneManager.class).warn("requestRender after LayoutlibSceneManager has been disposed");
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                LayoutlibSceneManager.$$$reportNull$$$0(24);
            }
            return completableFuture;
        }
        CompletableFuture<Void> callback2 = new CompletableFuture<Void>();
        Object object = this.myFuturesLock;
        synchronized (object) {
            this.myPendingFutures.add(callback2);
            if (this.myIsCurrentlyRendering.booleanValue()) {
                CompletableFuture<Void> completableFuture = callback2;
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl14 : MonitorExitStatement: MONITOREXIT : var3_3
                if (completableFuture == null) {
                    LayoutlibSceneManager.$$$reportNull$$$0(25);
                }
                return completableFuture;
            }
            this.myIsCurrentlyRendering = true;
        }
        this.myRenderingQueue.queue(this.createRenderUpdate(trigger));
        CompletableFuture<Void> completableFuture = callback2;
        if (completableFuture == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(26);
        }
        return completableFuture;
    }

    private Update createRenderUpdate(final @Nullable LayoutEditorRenderResult.Trigger trigger) {
        return new Update("model.render", 999){

            public void run() {
                LayoutlibSceneManager.this.render(trigger);
            }

            public boolean canEat(Update update2) {
                return this.equals(update2);
            }
        };
    }

    @Override
    @NotNull
    public CompletableFuture<Void> requestRender() {
        return this.requestRender(LayoutlibSceneManager.getTriggerFromChangeType(this.getModel().getLastChangeType()));
    }

    @NotNull
    public CompletableFuture<Void> requestUserInitiatedRender() {
        this.forceReinflate();
        return this.requestRender(LayoutEditorRenderResult.Trigger.USER);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> requestLayoutAndRender(boolean animate) {
        if (this.getDesignSurface().getScreenViewProvider() == NlScreenViewProvider.BLUEPRINT) {
            CompletableFuture<Void> completableFuture = this.requestLayout(animate);
            if (completableFuture == null) {
                LayoutlibSceneManager.$$$reportNull$$$0(27);
            }
            return completableFuture;
        }
        if (this.getDesignSurface().isRenderingSynchronously()) {
            CompletionStage completionStage = this.render(LayoutlibSceneManager.getTriggerFromChangeType(this.getModel().getLastChangeType())).thenRun(() -> this.notifyListenersModelLayoutComplete(animate));
            if (completionStage == null) {
                LayoutlibSceneManager.$$$reportNull$$$0(28);
            }
            return completionStage;
        }
        CompletableFuture<Void> completableFuture = this.doRequestLayoutAndRender(animate);
        if (completableFuture == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(29);
        }
        return completableFuture;
    }

    @NotNull
    CompletableFuture<Void> doRequestLayoutAndRender(boolean animate) {
        CompletionStage completionStage = this.requestRender(LayoutlibSceneManager.getTriggerFromChangeType(this.getModel().getLastChangeType())).whenCompleteAsync((result2, ex) -> this.notifyListenersModelLayoutComplete(animate), (Executor)AppExecutorUtil.getAppExecutorService());
        if (completionStage == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(30);
        }
        return completionStage;
    }

    protected void requestModelUpdate() {
        if (this.isDisposed.get()) {
            return;
        }
        this.myProgressIndicator.start();
        this.myRenderingQueue.queue(new Update("model.update", 10){

            public void run() {
                NlModel model2 = LayoutlibSceneManager.this.getModel();
                Project project = model2.getModule().getProject();
                if (!project.isOpen()) {
                    return;
                }
                DumbService.getInstance((Project)project).runWhenSmart(() -> {
                    if (model2.getVirtualFile().isValid() && !model2.getFacet().isDisposed()) {
                        LayoutlibSceneManager.this.updateModel().whenComplete((result2, ex) -> LayoutlibSceneManager.this.myProgressIndicator.stop());
                    } else {
                        LayoutlibSceneManager.this.myProgressIndicator.stop();
                    }
                });
            }

            public boolean canEat(Update update2) {
                return this.equals(update2);
            }
        });
    }

    public static void setRenderViewPort(boolean state) {
        ourRenderViewPort = state;
    }

    public static boolean isRenderViewPort() {
        return ourRenderViewPort;
    }

    public void setTransparentRendering(boolean enabled) {
        this.useTransparentRendering = enabled;
    }

    public void setShrinkRendering(boolean enabled) {
        this.useShrinkRendering = enabled;
    }

    public void setShowDecorations(boolean enabled) {
        if (this.useShowDecorations != enabled) {
            this.useShowDecorations = enabled;
            this.forceReinflate();
        }
    }

    public boolean isShowingDecorations() {
        return this.useShowDecorations;
    }

    public void setUseImagePool(boolean enabled) {
        this.useImagePool = enabled;
    }

    public void setQuality(float quality) {
        this.quality = quality;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public CompletableFuture<Void> requestLayout(boolean animate) {
        if (this.isDisposed.get()) {
            Logger.getInstance(LayoutlibSceneManager.class).warn("requestLayout after LayoutlibSceneManager has been disposed");
        }
        Object object = this.myRenderingTaskLock;
        // MONITORENTER : object
        if (this.myRenderTask == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            // MONITOREXIT : object
            if (completableFuture != null) return completableFuture;
            LayoutlibSceneManager.$$$reportNull$$$0(31);
            return completableFuture;
        }
        CompletionStage completionStage = this.myRenderTask.layout().thenAccept(result2 -> {
            if (result2 != null && !this.isDisposed.get()) {
                this.updateHierarchy((RenderResult)result2);
                this.notifyListenersModelLayoutComplete(animate);
            }
        });
        // MONITOREXIT : object
        if (completionStage != null) return completionStage;
        LayoutlibSceneManager.$$$reportNull$$$0(32);
        return completionStage;
    }

    @Override
    public void layout(boolean animate) {
        try {
            this.requestLayout(animate).get(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            Logger.getInstance(LayoutlibSceneManager.class).warn("Unable to run layout()", (Throwable)e);
        }
    }

    @Nullable
    public RenderResult getRenderResult() {
        this.myRenderResultLock.readLock().lock();
        try {
            RenderResult renderResult = this.myRenderResult;
            return renderResult;
        }
        finally {
            this.myRenderResultLock.readLock().unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public Map<Object, Map<ResourceReference, ResourceValue>> getDefaultProperties() {
        this.myRenderResultLock.readLock().lock();
        if (this.myRenderResult == null) {
            Map<Object, Map<ResourceReference, ResourceValue>> map2 = Collections.emptyMap();
            Map<Object, Map<ResourceReference, ResourceValue>> map3 = map2;
            if (map3 == null) {
                LayoutlibSceneManager.$$$reportNull$$$0(33);
            }
            return map3;
        }
        Map<Object, Map<ResourceReference, ResourceValue>> map4 = this.myRenderResult.getDefaultProperties();
        Map<Object, Map<ResourceReference, ResourceValue>> map5 = map4;
        if (map5 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(34);
        }
        return map5;
        finally {
            this.myRenderResultLock.readLock().unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public Map<Object, ResourceReference> getDefaultStyles() {
        this.myRenderResultLock.readLock().lock();
        if (this.myRenderResult == null) {
            Map<Object, ResourceReference> map2 = Collections.emptyMap();
            Map<Object, ResourceReference> map3 = map2;
            if (map3 == null) {
                LayoutlibSceneManager.$$$reportNull$$$0(35);
            }
            return map3;
        }
        Map<Object, ResourceReference> map4 = this.myRenderResult.getDefaultStyles();
        Map<Object, ResourceReference> map5 = map4;
        if (map5 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(36);
        }
        return map5;
        finally {
            this.myRenderResultLock.readLock().unlock();
        }
    }

    private void updateHierarchy(@Nullable RenderResult result2) {
        try {
            this.myUpdateHierarchyLock.acquire();
            try {
                if (result2 == null || !result2.getRenderResult().isSuccess()) {
                    LayoutlibSceneManager.updateHierarchy(Collections.emptyList(), this.getModel());
                } else {
                    LayoutlibSceneManager.updateHierarchy(this.getRootViews(result2), this.getModel());
                }
            }
            finally {
                this.myUpdateHierarchyLock.release();
            }
            this.getModel().checkStructure();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @NotNull
    private List<ViewInfo> getRootViews(@NotNull RenderResult result2) {
        if (result2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(37);
        }
        ImmutableList<ViewInfo> immutableList = this.getModel().getType() == MenuFileType.INSTANCE ? result2.getSystemRootViews() : result2.getRootViews();
        if (immutableList == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(38);
        }
        return immutableList;
    }

    @VisibleForTesting
    public static void updateHierarchy(@NotNull XmlTag rootTag, @NotNull List<ViewInfo> rootViews, @NotNull NlModel model2) {
        if (rootTag == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(39);
        }
        if (rootViews == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(40);
        }
        if (model2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(41);
        }
        model2.syncWithPsi(rootTag, ContainerUtil.map(rootViews, x$0 -> new ViewInfoTagSnapshotNode((ViewInfo)x$0)));
        LayoutlibSceneManager.updateBounds(rootViews, model2);
    }

    @VisibleForTesting
    public static void updateHierarchy(@NotNull List<ViewInfo> rootViews, @NotNull NlModel model2) {
        XmlTag root2;
        if (rootViews == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(42);
        }
        if (model2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(43);
        }
        if ((root2 = LayoutlibSceneManager.getRootTag(model2)) != null) {
            LayoutlibSceneManager.updateHierarchy(root2, rootViews, model2);
        }
    }

    @Nullable
    private static XmlTag getRootTag(@NotNull NlModel model2) {
        if (model2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(44);
        }
        if (Disposer.isDisposed((Disposable)model2)) {
            return null;
        }
        return AndroidPsiUtils.getRootTagSafely((XmlFile)model2.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private CompletableFuture<RenderResult> inflate(boolean force) {
        long startInflateTimeMs = System.currentTimeMillis();
        Configuration configuration = this.getModel().getConfiguration();
        Project project = this.getModel().getProject();
        if (project.isDisposed() || this.isDisposed.get()) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                LayoutlibSceneManager.$$$reportNull$$$0(45);
            }
            return completableFuture;
        }
        ResourceNotificationManager resourceNotificationManager = ResourceNotificationManager.getInstance(project);
        LayoutPullParsers.saveFileIfNecessary((PsiFile)this.getModel().getFile());
        Object object = this.myRenderingTaskLock;
        synchronized (object) {
            if (this.myRenderTask != null && !force) {
                CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl15 : MonitorExitStatement: MONITOREXIT : var7_6
                if (completableFuture == null) {
                    LayoutlibSceneManager.$$$reportNull$$$0(46);
                }
                return completableFuture;
            }
        }
        AndroidFacet facet2 = this.getModel().getFacet();
        this.myRenderedVersion = resourceNotificationManager.getCurrentVersion(facet2, (PsiFile)this.getModel().getFile(), configuration);
        RenderService renderService = RenderService.getInstance(this.getModel().getProject());
        RenderLogger logger2 = renderService.createLogger(facet2);
        RenderService.RenderTaskBuilder renderTaskBuilder = renderService.taskBuilder(facet2, configuration).withPsiFile((PsiFile)this.getModel().getFile()).withLayoutScanner(this.myLayoutScannerConfig.isLayoutScannerEnabled()).withLogger(logger2);
        CompletionStage completionStage = ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.setupRenderTaskBuilder(renderTaskBuilder).build().thenCompose(newTask -> {
            if (newTask != null) {
                newTask.getLayoutlibCallback().setAdaptiveIconMaskPath(this.getDesignSurface().getAdaptiveIconShape().getPathDescription());
                return ((CompletableFuture)newTask.inflate().whenComplete((result2, inflateException) -> {
                    Throwable exception = null;
                    if (inflateException != null) {
                        exception = inflateException;
                    } else if (result2 != null) {
                        exception = result2.getRenderResult().getException();
                    }
                    if (exception != null) {
                        if (result2 == null || !result2.getRenderResult().isSuccess()) {
                            logger2.error("INFLATE", "Error inflating the preview", exception, null, null);
                        }
                        Logger.getInstance(LayoutlibSceneManager.class).warn(exception);
                    }
                    if (this.getModel().getModule().isDisposed() || result2 == null || !result2.getRenderResult().isSuccess() || this.isDisposed.get()) {
                        newTask.dispose();
                    } else {
                        this.updateRenderTask((RenderTask)newTask);
                    }
                })).handle((result2, exception) -> {
                    if (result2 != null) {
                        return result2.createWithDuration(System.currentTimeMillis() - startInflateTimeMs);
                    }
                    return RenderResult.createRenderTaskErrorResult((PsiFile)this.getModel().getFile(), exception);
                });
            }
            this.updateRenderTask(null);
            return CompletableFuture.completedFuture(RenderResult.createRenderTaskErrorResult((PsiFile)this.getModel().getFile(), logger2));
        })).thenApply(result2 -> {
            this.myRenderResultLock.writeLock().lock();
            try {
                this.updateCachedRenderResult((RenderResult)result2);
            }
            finally {
                this.myRenderResultLock.writeLock().unlock();
            }
            return result2;
        })).thenApply(result2 -> {
            if (project.isDisposed() || !result2.getRenderResult().isSuccess()) {
                return result2;
            }
            this.updateHierarchy((RenderResult)result2);
            return result2;
        })).thenApply(result2 -> this.logIfSuccessful((RenderResult)result2, null, true));
        if (completionStage == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(47);
        }
        return completionStage;
    }

    private void updateCachedRenderResult(@NotNull RenderResult result2) {
        if (result2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(48);
        }
        if (this.myRenderResult != null && this.myRenderResult != result2) {
            this.myRenderResult.dispose();
        }
        this.myRenderResult = result2;
    }

    @VisibleForTesting
    @NotNull
    protected RenderService.RenderTaskBuilder setupRenderTaskBuilder(@NotNull RenderService.RenderTaskBuilder taskBuilder) {
        if (taskBuilder == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(49);
        }
        if (!this.useImagePool) {
            taskBuilder.disableImagePool();
        }
        if (this.quality < 1.0f) {
            taskBuilder.withDownscaleFactor(this.quality);
        }
        if (!this.useShowDecorations) {
            taskBuilder.disableDecorations();
        }
        if (this.useShrinkRendering) {
            taskBuilder.withRenderingMode(SessionParams.RenderingMode.SHRINK);
        }
        if (this.useTransparentRendering) {
            taskBuilder.useTransparentBackground();
        }
        if (!this.getDesignSurface().getPreviewWithToolsVisibilityAndPosition()) {
            taskBuilder.disableToolsVisibilityAndPosition();
        }
        if (this.myUsePrivateClassLoader) {
            taskBuilder.usePrivateClassLoader();
        }
        taskBuilder.setProjectClassesTransform(this.myAdditionalProjectTransform).setNonProjectClassesTransform(this.myAdditionalNonProjectTransform);
        RenderService.RenderTaskBuilder renderTaskBuilder = taskBuilder;
        if (renderTaskBuilder == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(50);
        }
        return renderTaskBuilder;
    }

    protected CompletableFuture<Void> updateModel() {
        if (this.isDisposed.get()) {
            return CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)this.inflate(true).whenCompleteAsync((result2, exception) -> this.notifyListenersModelUpdateComplete(), (Executor)AppExecutorUtil.getAppExecutorService())).thenApply(result2 -> null);
    }

    protected void notifyListenersModelLayoutComplete(boolean animate) {
        this.getModel().notifyListenersModelChangedOnLayout(animate);
    }

    protected void notifyListenersModelUpdateComplete() {
        this.getModel().notifyListenersModelDerivedDataChanged();
    }

    private void logConfigurationChange(@NotNull DesignSurface surface2) {
        if (surface2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(51);
        }
        Configuration configuration = this.getModel().getConfiguration();
        if (this.getModel().getConfigurationModificationCount() != configuration.getModificationCount()) {
            NlAnalyticsManager analyticsManager = ((NlDesignSurface)surface2).getAnalyticsManager();
            if (!StringUtil.equals((CharSequence)configuration.getTheme(), (CharSequence)this.myPreviousTheme)) {
                this.myPreviousTheme = configuration.getTheme();
                analyticsManager.trackThemeChange();
            } else if (configuration.getTarget() != null && !StringUtil.equals((CharSequence)configuration.getTarget().getVersionName(), (CharSequence)this.myPreviousVersion)) {
                this.myPreviousVersion = configuration.getTarget().getVersionName();
                analyticsManager.trackApiLevelChange();
            } else if (!configuration.getLocale().equals(this.myPreviousLocale)) {
                this.myPreviousLocale = configuration.getLocale();
                analyticsManager.trackLanguageChange();
            } else if (configuration.getDevice() != null && !StringUtil.equals((CharSequence)configuration.getDevice().getDisplayName(), (CharSequence)this.myPreviousDeviceName)) {
                this.myPreviousDeviceName = configuration.getDevice().getDisplayName();
                analyticsManager.trackDeviceChange();
            }
        }
    }

    @Nullable
    private RenderResult logIfSuccessful(@Nullable RenderResult result2, @Nullable LayoutEditorRenderResult.Trigger trigger, boolean wasInflated) {
        if (result2 != null && result2.getRenderResult().isSuccess()) {
            CommonUsageTracker.Companion.getInstance(this.getDesignSurface()).logRenderResult(trigger, result2, wasInflated);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected CompletableFuture<RenderResult> render(@Nullable LayoutEditorRenderResult.Trigger trigger) {
        CompletionStage completionStage;
        if (this.isDisposed.get()) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                LayoutlibSceneManager.$$$reportNull$$$0(52);
            }
            return completableFuture;
        }
        Object object = this.myFuturesLock;
        synchronized (object) {
            this.myIsCurrentlyRendering = true;
            this.myRenderFutures.addAll(this.myPendingFutures);
            this.myPendingFutures.clear();
        }
        try {
            NlDesignSurface surface2 = this.getDesignSurface();
            this.logConfigurationChange(surface2);
            this.getModel().resetLastChange();
            this.fireOnRenderStart();
            long renderStartTimeMs = System.currentTimeMillis();
            completionStage = ((CompletableFuture)this.renderImpl().thenApply(result2 -> this.logIfSuccessful((RenderResult)result2, trigger, false))).thenApply(result2 -> {
                this.myRenderResultLock.writeLock().lock();
                try {
                    if (result2 != null) {
                        this.updateCachedRenderResult((RenderResult)result2);
                    }
                    this.myRenderResultLock.readLock().lock();
                }
                finally {
                    this.myRenderResultLock.writeLock().unlock();
                }
                try {
                    if (this.myRenderResult != null) {
                        long renderTimeMs = System.currentTimeMillis() - renderStartTimeMs;
                        NlDiagnosticsManager.getWriteInstance(surface2).recordRender(renderTimeMs, (long)(this.myRenderResult.getRenderedImage().getWidth() * this.myRenderResult.getRenderedImage().getHeight()) * 4L);
                    }
                }
                finally {
                    this.myRenderResultLock.readLock().unlock();
                }
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (!this.isDisposed.get()) {
                        this.update();
                    }
                });
                this.fireOnRenderComplete();
                this.completeRender();
                return result2;
            });
        }
        catch (Throwable e) {
            if (!this.getModel().getFacet().isDisposed()) {
                this.completeRender();
                throw e;
            }
            this.completeRender();
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                LayoutlibSceneManager.$$$reportNull$$$0(54);
            }
            return completableFuture;
        }
        if (completionStage == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(53);
        }
        return completionStage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasPendingRenders() {
        Object object = this.myFuturesLock;
        synchronized (object) {
            return !this.myPendingFutures.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeRender() {
        ImmutableList callbacks;
        Object object = this.myFuturesLock;
        synchronized (object) {
            callbacks = ImmutableList.copyOf(this.myRenderFutures);
            this.myRenderFutures.clear();
            this.myIsCurrentlyRendering = false;
        }
        callbacks.forEach(callback2 -> callback2.complete(null));
        if (this.hasPendingRenders()) {
            this.requestRender(LayoutlibSceneManager.getTriggerFromChangeType(this.getModel().getLastChangeType()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public boolean isRendering() {
        Object object = this.myFuturesLock;
        synchronized (object) {
            return this.myIsCurrentlyRendering;
        }
    }

    @NotNull
    private CompletableFuture<RenderResult> renderImpl() {
        CompletionStage completionStage = ((CompletableFuture)((CompletableFuture)this.inflate(this.myForceInflate.getAndSet(false)).whenCompleteAsync((result2, ex) -> {
            if (ex != null) {
                Logger.getInstance(LayoutlibSceneManager.class).warn(ex);
            }
            if (result2 != null && result2.getRenderResult().isSuccess()) {
                this.notifyListenersModelUpdateComplete();
            }
        }, (Executor)PooledThreadExecutor.INSTANCE)).thenCompose(inflateResult -> {
            boolean inflated = inflateResult != null && inflateResult.getRenderResult().isSuccess();
            long elapsedFrameTimeMs = this.myElapsedFrameTimeMs;
            Object object = this.myRenderingTaskLock;
            synchronized (object) {
                if (this.myRenderTask == null) {
                    this.getDesignSurface().updateErrorDisplay();
                    return CompletableFuture.completedFuture(null);
                }
                long startRenderTimeMs = System.currentTimeMillis();
                if (elapsedFrameTimeMs != -1L) {
                    this.myRenderTask.setElapsedFrameTimeNanos(TimeUnit.MILLISECONDS.toNanos(elapsedFrameTimeMs));
                }
                return this.myRenderTask.render().thenApply(result2 -> {
                    if (result2 != null && !inflated) {
                        this.updateHierarchy((RenderResult)result2);
                    }
                    if (result2 != null) {
                        return result2.createWithDuration(System.currentTimeMillis() - startRenderTimeMs);
                    }
                    return null;
                });
            }
        })).handle((result2, exception) -> {
            if (exception != null) {
                return RenderResult.createRenderTaskErrorResult((PsiFile)this.getModel().getFile(), exception);
            }
            return result2;
        });
        if (completionStage == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(55);
        }
        return completionStage;
    }

    public void setElapsedFrameTimeMs(long ms) {
        this.myElapsedFrameTimeMs = ms;
    }

    private void updateTrackingConfiguration() {
        Configuration configuration = this.getModel().getConfiguration();
        this.myPreviousDeviceName = configuration.getCachedDevice() != null ? configuration.getCachedDevice().getDisplayName() : null;
        this.myPreviousVersion = configuration.getTarget() != null ? configuration.getTarget().getVersionName() : null;
        this.myPreviousLocale = configuration.getLocale();
        this.myPreviousTheme = configuration.getTheme();
    }

    private static void clearDerivedData(@NotNull NlComponent component) {
        if (component == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(56);
        }
        NlComponentHelperKt.setBounds(component, 0, 0, -1, -1);
        NlComponentHelperKt.setViewInfo(component, null);
    }

    private static void updateBounds(@NotNull List<ViewInfo> rootViews, @NotNull NlModel model2) {
        if (rootViews == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(57);
        }
        if (model2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(58);
        }
        model2.flattenComponents().forEach(LayoutlibSceneManager::clearDerivedData);
        Map<TagSnapshot, NlComponent> snapshotToComponent = model2.flattenComponents().collect(Collectors.toMap(NlComponent::getSnapshot, Function.identity(), (n1, n2) -> n1));
        Map<XmlTag, NlComponent> tagToComponent = model2.flattenComponents().collect(Collectors.toMap(NlComponent::getTagDeprecated, Function.identity()));
        for (ViewInfo view : rootViews) {
            LayoutlibSceneManager.updateBounds(view, 0, 0, snapshotToComponent, tagToComponent);
        }
        ImmutableList<NlComponent> components = model2.getComponents();
        if (!rootViews.isEmpty() && !components.isEmpty()) {
            LayoutlibSceneManager.fixBounds((NlComponent)components.get(0));
        }
    }

    private static void fixBounds(@NotNull NlComponent root2) {
        List<NlComponent> children;
        if (root2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(59);
        }
        boolean computeBounds = false;
        if (NlComponentHelperKt.getW(root2) == -1 && NlComponentHelperKt.getH(root2) == -1) {
            computeBounds = true;
            NlComponent parent = root2.getParent();
            if (parent != null && NlComponentHelperKt.getW(parent) >= 0) {
                NlComponentHelperKt.setBounds(root2, NlComponentHelperKt.getX(parent), NlComponentHelperKt.getY(parent), 0, 0);
            }
        }
        if (!(children = root2.getChildren()).isEmpty()) {
            for (NlComponent child : children) {
                LayoutlibSceneManager.fixBounds(child);
            }
            if (computeBounds) {
                Rectangle rectangle = new Rectangle(NlComponentHelperKt.getX(root2), NlComponentHelperKt.getY(root2), NlComponentHelperKt.getW(root2), NlComponentHelperKt.getH(root2));
                for (NlComponent child : children) {
                    rectangle = rectangle.union(new Rectangle(NlComponentHelperKt.getX(child), NlComponentHelperKt.getY(child), NlComponentHelperKt.getW(child), NlComponentHelperKt.getH(child)));
                }
                NlComponentHelperKt.setBounds(root2, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    private static void updateBounds(@NotNull ViewInfo view, int parentX, int parentY, Map<TagSnapshot, NlComponent> snapshotToComponent, Map<XmlTag, NlComponent> tagToComponent) {
        if (view == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(60);
        }
        ViewInfo bounds2 = RenderService.getSafeBounds(view);
        Object cookie = view.getCookie();
        if (cookie != null && cookie instanceof TagSnapshot) {
            TagSnapshot snapshot = (TagSnapshot)cookie;
            NlComponent component = snapshotToComponent.get(snapshot);
            if (component == null) {
                component = tagToComponent.get(snapshot.tag);
            }
            if (component != null && NlComponentHelperKt.getViewInfo(component) == null) {
                NlComponentHelperKt.setViewInfo(component, view);
                int left2 = parentX + bounds2.getLeft();
                int top = parentY + bounds2.getTop();
                int width = bounds2.getRight() - bounds2.getLeft();
                int height = bounds2.getBottom() - bounds2.getTop();
                NlComponentHelperKt.setBounds(component, left2, top, Math.max(width, 1), Math.max(height, 1));
            }
        }
        parentX += bounds2.getLeft();
        parentY += bounds2.getTop();
        for (ViewInfo child : view.getChildren()) {
            LayoutlibSceneManager.updateBounds(child, parentX, parentY, snapshotToComponent, tagToComponent);
        }
    }

    protected void fireOnRenderStart() {
        this.myRenderListeners.forEach(RenderListener::onRenderStarted);
    }

    protected void fireOnRenderComplete() {
        this.myRenderListeners.forEach(RenderListener::onRenderCompleted);
    }

    public void addRenderListener(@NotNull RenderListener listener2) {
        if (listener2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(61);
        }
        if (this.isDisposed.get()) {
            Logger.getInstance(LayoutlibSceneManager.class).warn("addRenderListener after LayoutlibSceneManager has been disposed");
        }
        this.myRenderListeners.add(listener2);
    }

    public void removeRenderListener(@NotNull RenderListener listener2) {
        if (listener2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(62);
        }
        this.myRenderListeners.remove(listener2);
    }

    public void forceReinflate() {
        this.myForceInflate.set(true);
    }

    @NotNull
    public CompletableFuture<Boolean> executeCallbacks() {
        CompletableFuture<Boolean> completableFuture = this.executeCallbacks(this.currentTimeNanos());
        if (completableFuture == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(63);
        }
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public CompletableFuture<Boolean> executeCallbacks(long timeNanos) {
        if (this.isDisposed.get()) {
            Logger.getInstance(LayoutlibSceneManager.class).warn("executeCallbacks after LayoutlibSceneManager has been disposed");
        }
        Object object = this.myRenderingTaskLock;
        // MONITORENTER : object
        if (this.myRenderTask == null) {
            CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(false);
            // MONITOREXIT : object
            if (completableFuture != null) return completableFuture;
            LayoutlibSceneManager.$$$reportNull$$$0(64);
            return completableFuture;
        }
        CompletableFuture<Boolean> completableFuture = this.myRenderTask.executeCallbacks(timeNanos);
        // MONITOREXIT : object
        if (completableFuture != null) return completableFuture;
        LayoutlibSceneManager.$$$reportNull$$$0(65);
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long currentTimeNanos() {
        Object object = this.myRenderingTaskLock;
        synchronized (object) {
            return System.nanoTime() - this.myTaskStartTimeNanos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected CompletableFuture<Void> triggerTouchEvent(@NotNull RenderSession.TouchEventType type, int x, int y, long timeNanos) {
        if (type == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(66);
        }
        if (this.isDisposed.get()) {
            Logger.getInstance(LayoutlibSceneManager.class).warn("executeCallbacks after LayoutlibSceneManager has been disposed");
        }
        Object object = this.myRenderingTaskLock;
        // MONITORENTER : object
        if (this.myRenderTask == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            // MONITOREXIT : object
            if (completableFuture != null) return completableFuture;
            LayoutlibSceneManager.$$$reportNull$$$0(67);
            return completableFuture;
        }
        this.myTouchEventsCounter.incrementAndGet();
        CompletableFuture<Void> completableFuture = this.myRenderTask.triggerTouchEvent(type, x, y, timeNanos);
        // MONITOREXIT : object
        if (completableFuture != null) return completableFuture;
        LayoutlibSceneManager.$$$reportNull$$$0(68);
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<Void> triggerTouchEvent(@NotNull RenderSession.TouchEventType type, int x, int y) {
        if (type == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(69);
        }
        CompletableFuture<Void> completableFuture = this.triggerTouchEvent(type, x, y, this.currentTimeNanos());
        if (completableFuture == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(70);
        }
        return completableFuture;
    }

    public CompletableFuture<Void> executeCallbacksAndRequestRender(@Nullable Runnable callback2) {
        try {
            if (callback2 != null) {
                RenderService.getRenderAsyncActionExecutor().runAsyncActionWithTimeout(30L, TimeUnit.MILLISECONDS, Executors.callable(callback2)).get();
            }
            return this.executeCallbacks().thenCompose(b -> this.requestRender());
        }
        catch (Exception e) {
            Logger.getInstance(LayoutlibSceneManager.class).warn("executeCallbacksAndRequestRender did not complete successfully", (Throwable)e);
            return CompletableFuture.completedFuture(null);
        }
    }

    public void setInteractive(boolean interactive) {
        this.myIsInteractive = interactive;
        this.getSceneViews().forEach(sv -> sv.setAnimated(interactive));
    }

    public boolean getInteractive() {
        return this.myIsInteractive;
    }

    public void setUsePrivateClassLoader(boolean usePrivateClassLoader) {
        this.myUsePrivateClassLoader = usePrivateClassLoader;
    }

    public boolean isUsePrivateClassLoader() {
        return this.myUsePrivateClassLoader;
    }

    @NotNull
    public void setProjectClassesTransform(@NotNull Function<ClassVisitor, ClassVisitor> transform) {
        if (transform == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(71);
        }
        this.myAdditionalProjectTransform = transform;
    }

    @NotNull
    public void setNonProjectClassesTransform(@NotNull Function<ClassVisitor, ClassVisitor> transform) {
        if (transform == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(72);
        }
        this.myAdditionalNonProjectTransform = transform;
    }

    @Override
    public boolean activate(@NotNull Object source) {
        boolean active;
        if (source == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(73);
        }
        if (active = super.activate(source)) {
            ResourceNotificationManager manager = ResourceNotificationManager.getInstance(this.getModel().getProject());
            ResourceNotificationManager.ResourceVersion version2 = manager.getCurrentVersion(this.getModel().getFacet(), (PsiFile)this.getModel().getFile(), this.getModel().getConfiguration());
            if (!version2.equals(this.myRenderedVersion)) {
                this.requestModelUpdate();
                this.getModel().updateTheme();
            } else {
                this.requestLayoutAndRender(false);
            }
        }
        return active;
    }

    @Override
    public boolean deactivate(@NotNull Object source) {
        boolean deactivated;
        if (source == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(74);
        }
        if (deactivated = super.deactivate(source)) {
            this.myRenderingQueue.deactivate();
            this.completeRender();
            this.disposeRenderTask();
        }
        return deactivated;
    }

    public void resetTouchEventsCounter() {
        this.myTouchEventsCounter.set(0);
    }

    public int getTouchEventsCount() {
        return this.myTouchEventsCounter.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 70: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 70: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 7: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "designSurface";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderTaskDisposerExecutor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderingQueueFactory";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneComponentProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutScannerConfig";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneUpdateListener";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/scene/LayoutlibSceneManager";
                break;
            }
            case 15: 
            case 23: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 37: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTag";
                break;
            }
            case 40: 
            case 42: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootViews";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskBuilder";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 61: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 66: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 71: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
            case 73: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/scene/LayoutlibSceneManager";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewEditor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemporaryComponent";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneDecoratorFactory";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayoutScannerConfig";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDesignSurface";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateSceneView";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneViews";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "requestRender";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "requestLayoutAndRender";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "doRequestLayoutAndRender";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "requestLayout";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultProperties";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultStyles";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootViews";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "inflate";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "setupRenderTaskBuilder";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "render";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "renderImpl";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "executeCallbacks";
                break;
            }
            case 67: 
            case 68: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "triggerTouchEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 70: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createTemporaryComponent";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "updateTargetProviders";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getRootViews";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "updateHierarchy";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getRootTag";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "updateCachedRenderResult";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "setupRenderTaskBuilder";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "logConfigurationChange";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "clearDerivedData";
                break;
            }
            case 57: 
            case 58: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "updateBounds";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "fixBounds";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "addRenderListener";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "removeRenderListener";
                break;
            }
            case 66: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "triggerTouchEvent";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "setProjectClassesTransform";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "setNonProjectClassesTransform";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "activate";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "deactivate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 70: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class LayoutlibSceneManagerHierarchyProvider
    extends DefaultSceneManagerHierarchyProvider {
        protected LayoutlibSceneManagerHierarchyProvider() {
        }

        @Override
        public void syncFromNlComponent(@NotNull SceneComponent sceneComponent) {
            if (sceneComponent == null) {
                LayoutlibSceneManagerHierarchyProvider.$$$reportNull$$$0(0);
            }
            super.syncFromNlComponent(sceneComponent);
            NlComponent component = sceneComponent.getNlComponent();
            boolean animate = sceneComponent.getScene().isAnimated() && !sceneComponent.hasNoDimension();
            SceneManager manager = sceneComponent.getScene().getSceneManager();
            if (animate) {
                long time2 = System.currentTimeMillis();
                sceneComponent.setPositionTarget(Coordinates.pxToDp(manager, NlComponentHelperKt.getX(component)), Coordinates.pxToDp(manager, NlComponentHelperKt.getY(component)), time2);
                sceneComponent.setSizeTarget(Coordinates.pxToDp(manager, NlComponentHelperKt.getW(component)), Coordinates.pxToDp(manager, NlComponentHelperKt.getH(component)), time2);
            } else {
                sceneComponent.setPosition(Coordinates.pxToDp(manager, NlComponentHelperKt.getX(component)), Coordinates.pxToDp(manager, NlComponentHelperKt.getY(component)));
                sceneComponent.setSize(Coordinates.pxToDp(manager, NlComponentHelperKt.getW(component)), Coordinates.pxToDp(manager, NlComponentHelperKt.getH(component)));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sceneComponent", "com/android/tools/idea/uibuilder/scene/LayoutlibSceneManager$LayoutlibSceneManagerHierarchyProvider", "syncFromNlComponent"));
        }
    }

    private static class ViewInfoTagSnapshotNode
    implements NlModel.TagSnapshotTreeNode {
        private final ViewInfo myViewInfo;

        private ViewInfoTagSnapshotNode(ViewInfo info2) {
            this.myViewInfo = info2;
        }

        @Override
        @Nullable
        public TagSnapshot getTagSnapshot() {
            Object result2 = this.myViewInfo.getCookie();
            return result2 instanceof TagSnapshot ? (TagSnapshot)result2 : null;
        }

        @Override
        @NotNull
        public List<NlModel.TagSnapshotTreeNode> getChildren() {
            List list = ContainerUtil.map((Collection)this.myViewInfo.getChildren(), ViewInfoTagSnapshotNode::new);
            if (list == null) {
                ViewInfoTagSnapshotNode.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/scene/LayoutlibSceneManager$ViewInfoTagSnapshotNode", "getChildren"));
        }
    }

    private class ConfigurationChangeListener
    implements ConfigurationListener {
        private ConfigurationChangeListener() {
        }

        @Override
        public boolean changed(int flags) {
            int newDpi;
            if ((flags & 2) != 0 && LayoutlibSceneManager.this.myDpi != (newDpi = LayoutlibSceneManager.this.getModel().getConfiguration().getDensity().getDpiValue())) {
                LayoutlibSceneManager.this.myDpi = newDpi;
                LayoutlibSceneManager.this.update();
            }
            return true;
        }
    }

    private class SelectionChangeListener
    implements SelectionListener {
        private SelectionChangeListener() {
        }

        @Override
        public void selectionChanged(@NotNull SelectionModel model2, @NotNull List<NlComponent> selection) {
            if (model2 == null) {
                SelectionChangeListener.$$$reportNull$$$0(0);
            }
            if (selection == null) {
                SelectionChangeListener.$$$reportNull$$$0(1);
            }
            LayoutlibSceneManager.this.updateTargets();
            Scene scene = LayoutlibSceneManager.this.getScene();
            scene.needsRebuildList();
            scene.repaint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "model";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "selection";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/uibuilder/scene/LayoutlibSceneManager$SelectionChangeListener";
            objectArray[2] = "selectionChanged";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ModelChangeListener
    implements ModelListener {
        private ModelChangeListener() {
        }

        @Override
        public void modelDerivedDataChanged(@NotNull NlModel model2) {
            if (model2 == null) {
                ModelChangeListener.$$$reportNull$$$0(0);
            }
            NlDesignSurface surface2 = LayoutlibSceneManager.this.getDesignSurface();
            LayoutlibSceneManager.this.requestRender(LayoutlibSceneManager.getTriggerFromChangeType(model2.getLastChangeType())).thenRunAsync(() -> LayoutlibSceneManager.this.mySelectionChangeListener.selectionChanged(surface2.getSelectionModel(), surface2.getSelectionModel().getSelection()), (Executor)EdtExecutorService.getInstance());
        }

        @Override
        public void modelChanged(@NotNull NlModel model2) {
            if (model2 == null) {
                ModelChangeListener.$$$reportNull$$$0(1);
            }
            LayoutlibSceneManager.this.requestModelUpdate();
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!LayoutlibSceneManager.this.isDisposed.get()) {
                    LayoutlibSceneManager.this.mySelectionChangeListener.selectionChanged(LayoutlibSceneManager.this.getDesignSurface().getSelectionModel(), LayoutlibSceneManager.this.getDesignSurface().getSelectionModel().getSelection());
                }
            });
        }

        @Override
        public void modelChangedOnLayout(@NotNull NlModel model2, boolean animate) {
            if (model2 == null) {
                ModelChangeListener.$$$reportNull$$$0(2);
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                if (!Disposer.isDisposed((Disposable)LayoutlibSceneManager.this)) {
                    boolean previous = LayoutlibSceneManager.this.getScene().isAnimated();
                    LayoutlibSceneManager.this.getScene().setAnimated(animate);
                    LayoutlibSceneManager.this.update();
                    LayoutlibSceneManager.this.getScene().setAnimated(previous);
                }
            });
        }

        @Override
        public void modelLiveUpdate(@NotNull NlModel model2, boolean animate) {
            if (model2 == null) {
                ModelChangeListener.$$$reportNull$$$0(3);
            }
            LayoutlibSceneManager.this.requestLayoutAndRender(animate);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "model";
            objectArray2[1] = "com/android/tools/idea/uibuilder/scene/LayoutlibSceneManager$ModelChangeListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelDerivedDataChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelChangedOnLayout";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelLiveUpdate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

