/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene;

import com.android.tools.idea.common.surface.DesignSurface;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.util.ui.TimerUtil;
import com.intellij.util.ui.UIUtil;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;

public class DesignSurfaceProgressIndicator {
    private AndroidPreviewProgressIndicator myCurrentIndicator;
    private final DesignSurface myDesignSurface;

    public DesignSurfaceProgressIndicator(@NotNull DesignSurface designSurface) {
        if (designSurface == null) {
            DesignSurfaceProgressIndicator.$$$reportNull$$$0(0);
        }
        this.myDesignSurface = designSurface;
    }

    public synchronized void start() {
        if (this.myCurrentIndicator == null) {
            this.myCurrentIndicator = new AndroidPreviewProgressIndicator();
            this.myCurrentIndicator.start();
        }
    }

    public synchronized void stop() {
        if (this.myCurrentIndicator != null) {
            this.myCurrentIndicator.stop();
            this.myCurrentIndicator = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "designSurface", "com/android/tools/idea/uibuilder/scene/DesignSurfaceProgressIndicator", "<init>"));
    }

    private class AndroidPreviewProgressIndicator
    extends ProgressIndicatorBase {
        private final Object myLock = new Object();

        private AndroidPreviewProgressIndicator() {
        }

        public void start() {
            super.start();
            UIUtil.invokeLaterIfNeeded(() -> {
                Timer timer2 = TimerUtil.createNamedTimer((String)"Android rendering progress timer", (int)0, event -> {
                    Object object = this.myLock;
                    synchronized (object) {
                        if (this.isRunning()) {
                            DesignSurfaceProgressIndicator.this.myDesignSurface.registerIndicator((ProgressIndicator)this);
                        }
                    }
                });
                timer2.setRepeats(false);
                timer2.start();
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Object object = this.myLock;
            synchronized (object) {
                super.stop();
                ApplicationManager.getApplication().invokeLater(() -> DesignSurfaceProgressIndicator.this.myDesignSurface.unregisterIndicator((ProgressIndicator)this));
            }
        }
    }
}

