/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property2.ui;

import com.android.tools.adtui.common.StudioColorsKt;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class GraphBase
extends JPanel {
    int myInsTop = 30;
    int myInsLeft = 30;
    int myInsBottom = 30;
    int myInsRight = 30;
    float[][] myXPoints = new float[0][];
    float[][] myYPoints = new float[0][];
    Color[] myPointColor = new Color[0];
    float myActualMinx;
    float myActualMiny;
    float myActualMaxx;
    float myActualMaxy;
    float myLastMinx;
    float myLastMiny;
    float myLastMaxx;
    float myLastMaxy;
    float myMinx;
    float myMiny;
    float myMaxx;
    float myMaxy;
    float myTickX;
    float myTickY;
    int myTextGap = 2;
    int myFrameCount = 0;
    private static Color ourGridColor = StudioColorsKt.getSecondaryGraphLines();
    private static Color ourTextGridColor = StudioColorsKt.getGraphLabel();
    private static Color ourEndPointColor = StudioColorsKt.getContentSelectionBackground();
    private static Stroke ourStroke = new BasicStroke(1.5f, 1, 2);
    Vector<DrawItem> myDrawItems = new Vector();
    private int[] pointMode = new int[0];
    DrawItem mAxis = new DrawItem(){

        @Override
        public void paint(Graphics2D g, int w, int h) {
            g.setColor(ourGridColor);
            g.drawLine(GraphBase.this.myInsLeft, GraphBase.this.myInsTop, GraphBase.this.myInsLeft, h - GraphBase.this.myInsBottom);
            g.drawLine(GraphBase.this.myInsLeft, h - GraphBase.this.myInsBottom, w - GraphBase.this.myInsRight, h - GraphBase.this.myInsBottom);
        }
    };
    DrawItem mGrid = new DrawItem(){
        DecimalFormat df = new DecimalFormat("###.#");

        @Override
        public void paint(Graphics2D g, int w, int h) {
            g.setColor(ourTextGridColor);
            int draw_width = w - GraphBase.this.myInsLeft - GraphBase.this.myInsRight;
            float e = 1.0E-4f * (GraphBase.this.myMaxx - GraphBase.this.myMinx);
            FontMetrics fm = g.getFontMetrics();
            int ascent = fm.getAscent();
            for (float i2 = GraphBase.this.myMinx; i2 <= GraphBase.this.myMaxx + e; i2 += GraphBase.this.myTickX) {
                int ix = (int)((float)draw_width * (i2 - GraphBase.this.myMinx) / (GraphBase.this.myMaxx - GraphBase.this.myMinx) + (float)GraphBase.this.myInsLeft);
                g.drawLine(ix, GraphBase.this.myInsTop, ix, h - GraphBase.this.myInsBottom);
                String str = this.df.format(i2);
                int sw = fm.stringWidth(str) / 2;
                g.drawString(str, ix - sw, h - GraphBase.this.myInsBottom + ascent + GraphBase.this.myTextGap);
            }
            int draw_height = h - GraphBase.this.myInsTop - GraphBase.this.myInsLeft;
            e = 1.0E-4f * (GraphBase.this.myMaxy - GraphBase.this.myMiny);
            int hightoff = -fm.getHeight() / 2 + ascent;
            for (float i3 = GraphBase.this.myMiny; i3 <= GraphBase.this.myMaxy + e; i3 += GraphBase.this.myTickY) {
                int iy = (int)((float)draw_height * (1.0f - (i3 - GraphBase.this.myMiny) / (GraphBase.this.myMaxy - GraphBase.this.myMiny)) + (float)GraphBase.this.myInsTop);
                g.drawLine(GraphBase.this.myInsLeft, iy, w - GraphBase.this.myInsRight, iy);
                String str = this.df.format(i3);
                int sw = fm.stringWidth(str);
                g.drawString(str, GraphBase.this.myInsLeft - sw - GraphBase.this.myTextGap, iy + hightoff);
            }
        }
    };
    DrawItem mAxisVLabel = new DrawItem(){

        @Override
        public void paint(Graphics2D g, int w, int h) {
        }
    };
    DrawItem mAxisHLabel = new DrawItem(){

        @Override
        public void paint(Graphics2D g, int w, int h) {
        }
    };
    DrawItem mDrawGraph = new DrawItem(){
        int[] xp = new int[0];
        int[] yp = new int[0];

        @Override
        public void paint(Graphics2D g, int w, int h) {
            g.setColor(ourGridColor);
            if (GraphBase.this.myXPoints.length == 0) {
                return;
            }
            if (this.xp.length != GraphBase.this.myXPoints[0].length) {
                this.xp = new int[GraphBase.this.myXPoints[0].length];
                this.yp = new int[GraphBase.this.myXPoints[0].length];
            }
            int draw_width = w - GraphBase.this.myInsLeft - GraphBase.this.myInsRight;
            int draw_height = h - GraphBase.this.myInsTop - GraphBase.this.myInsLeft;
            for (int k = 0; k < GraphBase.this.myXPoints.length; ++k) {
                int pointY;
                if (GraphBase.this.myXPoints[k] == null || GraphBase.this.myYPoints[k] == null) continue;
                for (int i2 = 0; i2 < GraphBase.this.myXPoints[k].length; ++i2) {
                    float x = (float)draw_width * (GraphBase.this.myXPoints[k][i2] - GraphBase.this.myMinx) / (GraphBase.this.myMaxx - GraphBase.this.myMinx) + (float)GraphBase.this.myInsLeft;
                    float y = (float)draw_height * (1.0f - (GraphBase.this.myYPoints[k][i2] - GraphBase.this.myMiny) / (GraphBase.this.myMaxy - GraphBase.this.myMiny)) + (float)GraphBase.this.myInsTop;
                    this.xp[i2] = (int)x;
                    this.yp[i2] = (int)y;
                }
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setColor(GraphBase.this.myPointColor[k]);
                g.setStroke(ourStroke);
                if (GraphBase.this.pointMode[k] == 0) {
                    g.drawPolyline(this.xp, this.yp, GraphBase.this.myXPoints[k].length);
                    continue;
                }
                if (GraphBase.this.pointMode[k] == 2) {
                    int TICK_SIZE = 2;
                    for (int i3 = 0; i3 < GraphBase.this.myXPoints[k].length; ++i3) {
                        int pointX = this.xp[i3];
                        pointY = this.yp[i3];
                        g.fillRoundRect(pointX - 2, pointY - 8, 4, 16, 4, 16);
                    }
                    continue;
                }
                int CIRCLE_SIZE = 4;
                for (int i4 = 0; i4 < GraphBase.this.myXPoints[k].length; ++i4) {
                    if (i4 == 0 || i4 == 3) {
                        g.setColor(ourEndPointColor);
                    } else {
                        g.setColor(GraphBase.this.myPointColor[k]);
                    }
                    int pointX = this.xp[i4];
                    pointY = this.yp[i4];
                    g.fillRoundRect(pointX - 4, pointY - 4, 8, 8, 8, 8);
                }
            }
        }
    };

    void waveGen(int base) {
        float fb = (float)base / 100.0f;
        float sc = (float)(base % 10000) / 10000.0f + 1.0f;
        float[] xPoints = new float[1024];
        float[] yPoints = new float[xPoints.length];
        for (int i2 = 0; i2 < xPoints.length; ++i2) {
            float x;
            xPoints[i2] = x = (float)((double)(((float)i2 + fb) * 10.0f) * Math.PI / (double)xPoints.length);
            yPoints[i2] = (float)Math.sin(x) * sc;
        }
        this.addGraph(0, xPoints, yPoints, Color.WHITE, 0);
    }

    public GraphBase() {
        this.myDrawItems.addElement(this.mGrid);
        this.myDrawItems.addElement(this.mAxis);
        this.myDrawItems.addElement(this.mAxisVLabel);
        this.myDrawItems.addElement(this.mAxisHLabel);
        this.myDrawItems.addElement(this.mDrawGraph);
        this.waveGen(0);
        this.calcRange();
    }

    public void addGraph(int n, double[] x, double[] y, Color c, int mode) {
        float[] xf = new float[x.length];
        float[] yf = new float[y.length];
        for (int i2 = 0; i2 < yf.length; ++i2) {
            xf[i2] = (float)x[i2];
            yf[i2] = (float)y[i2];
        }
        this.addGraph(n, xf, yf, c, mode);
        this.calcRange();
        this.repaint();
    }

    public void addGraph(int n, double[][] p, Color c, int mode) {
        float[] xf = new float[p.length];
        float[] yf = new float[p.length];
        for (int i2 = 0; i2 < yf.length; ++i2) {
            xf[i2] = (float)p[i2][0];
            yf[i2] = (float)p[i2][1];
        }
        this.addGraph(n, xf, yf, c, mode);
        this.calcRange();
        this.repaint();
    }

    public void addGraph(int n, float[] x, float[] y, Color c, int mode) {
        if (this.myXPoints.length <= n) {
            float[][] yp = new float[n + 1][];
            float[][] xp = new float[n + 1][];
            Color[] ncol = new Color[n + 1];
            int[] m = new int[n + 1];
            for (int i2 = 0; i2 < this.myXPoints.length; ++i2) {
                xp[i2] = this.myXPoints[i2];
                yp[i2] = this.myYPoints[i2];
                ncol[i2] = this.myPointColor[i2];
                m[i2] = this.pointMode[i2];
            }
            this.myPointColor = ncol;
            this.myXPoints = xp;
            this.myYPoints = yp;
            this.pointMode = m;
        }
        this.myXPoints[n] = x;
        this.myYPoints[n] = y;
        this.myPointColor[n] = c;
        this.pointMode[n] = mode;
        this.calcRange();
        this.repaint();
    }

    public void calcRange() {
        this.myActualMinx = Float.MAX_VALUE;
        this.myActualMiny = Float.MAX_VALUE;
        this.myActualMaxx = -3.4028235E38f;
        this.myActualMaxy = -3.4028235E38f;
        for (int g = 0; g < this.myXPoints.length; ++g) {
            if (this.myXPoints[g] == null || this.myYPoints[g] == null) continue;
            for (int i2 = 0; i2 < this.myXPoints[g].length; ++i2) {
                float x = this.myXPoints[g][i2];
                float y = this.myYPoints[g][i2];
                this.myActualMinx = Math.min(this.myActualMinx, x);
                this.myActualMiny = Math.min(this.myActualMiny, y);
                this.myActualMaxx = Math.max(this.myActualMaxx, x);
                this.myActualMaxy = Math.max(this.myActualMaxy, y);
            }
        }
    }

    void calcRangeTicks() {
        double dx = this.myActualMaxx - this.myActualMinx;
        double dy = this.myActualMaxy - this.myActualMiny;
        int sw = this.getWidth();
        int sh = this.getHeight();
        double border = 1.09345;
        if ((double)(Math.abs(this.myLastMinx - this.myActualMinx) + Math.abs(this.myLastMaxx - this.myActualMaxx)) > 0.1 * (double)(this.myActualMaxx - this.myActualMinx)) {
            this.myTickX = (float)GraphBase.calcTick(sw, dx);
            dx = (double)this.myTickX * Math.ceil(border * dx / (double)this.myTickX);
            double tx = ((double)(this.myActualMinx + this.myActualMaxx) - dx) / 2.0;
            tx = (double)this.myTickX * Math.floor(tx / (double)this.myTickX);
            this.myMinx = (float)tx;
            tx = ((double)(this.myActualMinx + this.myActualMaxx) + dx) / 2.0;
            tx = (double)this.myTickX * Math.ceil(tx / (double)this.myTickX);
            this.myMaxx = (float)tx;
            this.myLastMinx = this.myActualMinx;
            this.myLastMaxx = this.myActualMaxx;
        }
        if ((double)(Math.abs(this.myLastMiny - this.myActualMiny) + Math.abs(this.myLastMaxy - this.myActualMaxy)) > 0.1 * (double)(this.myActualMaxy - this.myActualMiny)) {
            this.myTickY = (float)GraphBase.calcTick(sh, dy);
            dy = (double)this.myTickY * Math.ceil(border * dy / (double)this.myTickY);
            double ty = ((double)(this.myActualMiny + this.myActualMaxy) - dy) / 2.0;
            ty = (double)this.myTickY * Math.floor(ty / (double)this.myTickY);
            this.myMiny = (float)ty;
            ty = ((double)(this.myActualMiny + this.myActualMaxy) + dy) / 2.0;
            ty = (double)this.myTickY * Math.ceil(ty / (double)this.myTickY);
            this.myMaxy = (float)ty;
            this.myLastMiny = this.myActualMiny;
            this.myLastMaxy = this.myActualMaxy;
        }
        this.myMinx = 0.0f;
        this.myMiny = 0.0f;
        this.myMaxx = 1.0f;
        this.myMaxy = 1.0f;
    }

    public static double calcTick(int scr, double range) {
        int aprox_x_ticks = scr / 50;
        int type = 1;
        double best = Math.log10(range / (double)aprox_x_ticks);
        double n = Math.log10(range / ((double)aprox_x_ticks * 2.0));
        if (GraphBase.frac(n) < GraphBase.frac(best)) {
            best = n;
            type = 2;
        }
        if (GraphBase.frac(n = Math.log10(range / (double)(aprox_x_ticks * 5))) < GraphBase.frac(best)) {
            best = n;
            type = 5;
        }
        return (double)type * Math.pow(10.0, Math.floor(best));
    }

    static double frac(double x) {
        return x - Math.floor(x);
    }

    @Override
    protected void paintComponent(Graphics g) {
        ++this.myFrameCount;
        this.calcRangeTicks();
        int w = this.getWidth();
        int h = this.getHeight();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GradientPaint paint = new GradientPaint(0.0f, 0.0f, Color.BLACK, 0.0f, (float)(h * 2) / 3.0f, new Color(1581859), true);
        g2d.setPaint(paint);
        g2d.setColor(this.getBackground());
        g2d.fillRect(0, 0, w, h);
        g2d.setColor(ourGridColor);
        for (DrawItem drawItem : this.myDrawItems) {
            drawItem.paint(g2d, w, h);
        }
    }

    public void screenToGraph(Point scr, Point2D graph) {
        int draw_width = this.getWidth() - this.myInsLeft - this.myInsRight;
        int draw_height = this.getHeight() - this.myInsTop - this.myInsLeft;
        float x = this.myMinx + (this.myMaxx - this.myMinx) * ((float)(scr.x - this.myInsLeft) / (float)draw_width);
        float y = this.myMiny + (this.myMaxy - this.myMiny) * ((float)(this.myInsBottom + draw_height - scr.y) / (float)draw_height);
        graph.setLocation(x, y);
    }

    public static GraphBase create(String title) {
        JFrame f = new JFrame(title);
        f.setBounds(new Rectangle(200, 200));
        f.setDefaultCloseOperation(3);
        JPanel base = new JPanel(new BorderLayout());
        JPanel ctl = new JPanel();
        base.add((Component)ctl, "South");
        JButton button2 = new JButton("Save...");
        GraphBase p = new GraphBase();
        button2.addActionListener(e -> GraphBase.save(e, p));
        ctl.add(button2);
        base.add(p);
        f.setContentPane(base);
        f.validate();
        f.setVisible(true);
        return p;
    }

    public static void save(ActionEvent e, GraphBase graph) {
        int w = graph.getWidth();
        int h = graph.getHeight();
        BufferedImage img = new BufferedImage(w, h, 1);
        graph.paint(img.createGraphics());
        JFileChooser chooser2 = new JFileChooser(new File(System.getProperty("user.home")));
        int c = chooser2.showSaveDialog(graph);
        if (c == 1) {
            System.out.println("cancel");
            return;
        }
        try {
            File f = chooser2.getSelectedFile();
            ImageIO.write((RenderedImage)img, "png", f);
            System.out.println(f.getAbsolutePath());
            Desktop.getDesktop().open(f.getParentFile());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    static interface DrawItem {
        public void paint(Graphics2D var1, int var2, int var3);
    }
}

