/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property2.support;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.property2.NelePropertyItem;
import com.android.tools.property.panel.api.HelpSupport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.html.HtmlEscapers;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.text.StringKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fH\u0007J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/uibuilder/property2/support/HelpActions;", "", "()V", "help", "Lcom/intellij/openapi/actionSystem/AnAction;", "getHelp", "()Lcom/intellij/openapi/actionSystem/AnAction;", "lineEndingRegex", "Lkotlin/text/Regex;", "secondaryHelp", "getSecondaryHelp", "createHelpText", "", "property", "Lcom/android/tools/idea/uibuilder/property2/NelePropertyItem;", "allowEmptyDescription", "", "filterRawAttributeComment", "comment", "findNamespacePrefix", "getAttributeAnchor", "componentName", "getHelpUrl", "toHelpUrl", "intellij.android.designer"})
public final class HelpActions {
    @NotNull
    private static final AnAction help;
    @NotNull
    private static final AnAction secondaryHelp;
    private static final Regex lineEndingRegex;
    @NotNull
    public static final HelpActions INSTANCE;

    @NotNull
    public final AnAction getHelp() {
        return help;
    }

    @NotNull
    public final AnAction getSecondaryHelp() {
        return secondaryHelp;
    }

    @VisibleForTesting
    @Nullable
    public final String toHelpUrl(@NotNull String componentName, @NotNull NelePropertyItem property2) {
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        String string = this.getAttributeAnchor(componentName, property2);
        if (string == null) {
            return null;
        }
        String anchor = string;
        return Intrinsics.stringPlus((String)this.getHelpUrl(componentName, property2), (Object)anchor);
    }

    private final String getHelpUrl(String componentName, NelePropertyItem property2) {
        String dotLayoutParams = Intrinsics.areEqual((Object)componentName, (Object)"android.view.ViewGroup") && StringsKt.startsWith$default((String)property2.getName(), (String)"layout_margin", (boolean)false, (int)2, null) ? ".MarginLayoutParams" : (StringsKt.startsWith$default((String)property2.getName(), (String)"layout_", (boolean)false, (int)2, null) ? ".LayoutParams" : "");
        return "https://developer.android.com/reference/" + StringsKt.replace$default((String)componentName, (char)'.', (char)'/', (boolean)false, (int)4, null) + dotLayoutParams + ".html";
    }

    private final String getAttributeAnchor(String componentName, NelePropertyItem property2) {
        return StringsKt.startsWith$default((String)componentName, (String)"android.view.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)componentName, (String)"android.widget.", (boolean)false, (int)2, null) ? "#attr_android:" + property2.getName() : (StringsKt.startsWith$default((String)componentName, (String)"android.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)componentName, (String)"androidx.", (boolean)false, (int)2, null) ? "" : null);
    }

    @NlsSafe
    @NotNull
    public final String createHelpText(@NotNull NelePropertyItem property2, boolean allowEmptyDescription) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        Object object = property2.getDefinition();
        if (object == null || (object = ((AttributeDefinition)object).getDescription(null)) == null) {
            object = "";
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"property.definition?.getDescription(null) ?: \"\"");
        String description2 = this.filterRawAttributeComment((String)object);
        CharSequence charSequence = description2;
        boolean bl = false;
        if (charSequence.length() == 0 && !allowEmptyDescription) {
            return "";
        }
        StringBuilder sb = new StringBuilder(100);
        sb.append("<html><b>");
        sb.append(this.findNamespacePrefix(property2));
        sb.append(property2.getName());
        CharSequence charSequence2 = description2;
        boolean bl2 = false;
        if (charSequence2.length() == 0) {
            sb.append("</b>");
        } else {
            sb.append(":</b><br/>");
            sb.append(description2);
        }
        sb.append("</html>");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    private final String findNamespacePrefix(NelePropertyItem property2) {
        ResourceNamespace.Resolver resolver = property2.getNamespaceResolver();
        if (Intrinsics.areEqual((Object)resolver, (Object)ResourceNamespace.Resolver.TOOLS_ONLY) && Intrinsics.areEqual((Object)property2.getNamespace(), (Object)"http://schemas.android.com/apk/res/android")) {
            return "android:";
        }
        String string = resolver.uriToPrefix(property2.getNamespace());
        if (string == null) {
            return "";
        }
        String prefix = string;
        return prefix + ':';
    }

    @VisibleForTesting
    @NotNull
    public final String filterRawAttributeComment(@NotNull String comment) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        CharSequence charSequence = comment;
        Regex regex = lineEndingRegex;
        String string = " ";
        boolean bl = false;
        String string2 = HtmlEscapers.htmlEscaper().escape(regex.replace(charSequence, string));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"HtmlEscapers.htmlEscaper\u2026ce(lineEndingRegex, \" \"))");
        return string2;
    }

    private HelpActions() {
    }

    static {
        HelpActions helpActions;
        INSTANCE = helpActions = new HelpActions();
        help = new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                NelePropertyItem nelePropertyItem = (NelePropertyItem)event.getDataContext().getData(HelpSupport.Companion.getPROPERTY_ITEM());
                if (nelePropertyItem == null) {
                    return;
                }
                NelePropertyItem property2 = nelePropertyItem;
                XmlTag xmlTag = ((NlComponent)CollectionsKt.first(property2.getComponents())).getBackend().getTag();
                if (xmlTag == null) {
                    return;
                }
                XmlTag tag = xmlTag;
                String string = StringKt.nullize$default((String)HelpActions.INSTANCE.createHelpText(property2, false), (boolean)false, (int)1, null);
                if (string == null) {
                    return;
                }
                String documentation = string;
                DocumentationManager.getInstance((Project)property2.getProject()).showJavaDocInfo((PsiElement)tag, (PsiElement)tag, true, null, documentation, true);
            }
        };
        secondaryHelp = new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                NelePropertyItem property2 = (NelePropertyItem)event.getDataContext().getData(HelpSupport.Companion.getPROPERTY_ITEM());
                Object object = property2;
                if (object == null || (object = ((NelePropertyItem)object).getComponentName()) == null) {
                    return;
                }
                Object componentName = object;
                String string = HelpActions.INSTANCE.toHelpUrl((String)componentName, property2);
                if (string == null) {
                    return;
                }
                String url = string;
                BrowserUtil.browse((String)url);
            }
        };
        lineEndingRegex = new Regex("\n *");
    }
}

