/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.imagepool.ImagePool;
import com.android.tools.idea.uibuilder.palette.DependencyManager;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PreviewProvider
implements Disposable {
    private static final int SHADOW_SIZE = 6;
    private static final String PREVIEW_PLACEHOLDER_FILE = "preview.xml";
    private static final String CONTAINER_ID = "TopLevelContainer";
    private static final String LINEAR_LAYOUT = "<LinearLayout\n    xmlns:android=\"http://schemas.android.com/apk/res/android\"\n    xmlns:app=\"http://schemas.android.com/apk/res-auto\"\n    android:id=\"@+id/%1$s\"\n    android:layout_width=\"match_parent\"\n    android:layout_height=\"wrap_content\"\n    android:orientation=\"vertical\">\n  %2$s\n</LinearLayout>\n";
    private final Supplier<DesignSurface> myDesignSurfaceSupplier;
    private final DependencyManager myDependencyManager;
    private RenderTask myRenderTask;
    @VisibleForTesting
    public long myRenderTaskTimeoutMillis;
    @VisibleForTesting
    public long myRenderTimeoutMillis;

    public PreviewProvider(@NotNull Supplier<DesignSurface> supplier2, @NotNull DependencyManager manager) {
        if (supplier2 == null) {
            PreviewProvider.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            PreviewProvider.$$$reportNull$$$0(1);
        }
        this.myRenderTaskTimeoutMillis = 300L;
        this.myRenderTimeoutMillis = 300L;
        this.myDesignSurfaceSupplier = supplier2;
        this.myDependencyManager = manager;
    }

    @NotNull
    public ImageAndDimension createPreview(@NotNull JComponent component, @NotNull Palette.Item item) {
        Image image;
        BufferedImage renderedItem;
        if (component == null) {
            PreviewProvider.$$$reportNull$$$0(2);
        }
        if (item == null) {
            PreviewProvider.$$$reportNull$$$0(3);
        }
        ScaleContext scaleContext = ScaleContext.create((Component)component);
        BufferedImage bufferedImage = renderedItem = this.myDependencyManager.needsLibraryLoad(item) ? null : this.renderDragImage(item);
        if (renderedItem == null) {
            Icon icon2 = item.getIcon();
            image = IconLoader.toImage((Icon)icon2, (ScaleContext)scaleContext);
        } else {
            image = ImageUtil.ensureHiDPI((Image)renderedItem, (ScaleContext)scaleContext);
        }
        int width = ImageUtil.getRealWidth((Image)image);
        int height = ImageUtil.getRealHeight((Image)image);
        image = ImageUtil.scaleImage((Image)image, (double)this.getScale());
        Dimension size = new Dimension(width, height);
        boolean inUserScale = !SystemInfo.isWindows || !StartupUiUtil.isJreHiDPI((Component)component);
        BufferedImage bufferedImage2 = ImageUtil.toBufferedImage((Image)image, (boolean)inUserScale);
        return new ImageAndDimension(bufferedImage2, size);
    }

    @Nullable
    @VisibleForTesting
    BufferedImage renderDragImage(@NotNull Palette.Item item) {
        XmlTag tag;
        SceneView sceneView;
        if (item == null) {
            PreviewProvider.$$$reportNull$$$0(4);
        }
        if ((sceneView = this.getSceneView()) == null) {
            this.disposeRenderTaskNoWait();
            return null;
        }
        XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)sceneView.getModel().getProject());
        String xml = item.getDragPreviewXml();
        if (xml.equals("")) {
            return null;
        }
        try {
            tag = elementFactory.createTagFromText((CharSequence)xml);
        }
        catch (IncorrectOperationException exception) {
            return null;
        }
        NlModel model2 = sceneView.getSceneManager().getModel();
        NlComponent component = (NlComponent)ApplicationManager.getApplication().runWriteAction(() -> model2.createComponent(sceneView.getSurface(), tag, null, null, InsertType.CREATE_PREVIEW));
        if (component == null) {
            return null;
        }
        XmlTag componentTag = component.getTag();
        if (componentTag == null) {
            return null;
        }
        xml = String.format(LINEAR_LAYOUT, CONTAINER_ID, componentTag.getText());
        try {
            this.myRenderTask = this.getRenderTask(model2.getConfiguration()).get(this.myRenderTaskTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            this.myRenderTask = null;
            return null;
        }
        RenderResult result2 = PreviewProvider.renderImage(this.myRenderTimeoutMillis, this.myRenderTask, xml);
        this.disposeRenderTaskNoWait();
        if (result2 == null) {
            return null;
        }
        ImagePool.Image image = result2.getRenderedImage();
        if (!image.isValid()) {
            return null;
        }
        Object infos = result2.getRootViews();
        if (infos.isEmpty()) {
            return null;
        }
        if ((infos = ((ViewInfo)infos.get(0)).getChildren()) == null || infos.isEmpty()) {
            return null;
        }
        ViewInfo view = (ViewInfo)infos.get(0);
        if (image.getHeight() < view.getBottom() || image.getWidth() < view.getRight() || view.getBottom() <= view.getTop() || view.getRight() <= view.getLeft()) {
            return null;
        }
        int shadowIncrement = 1 + Coordinates.getSwingDimension(sceneView, 6);
        BufferedImage imageCopy = image.getCopy();
        if (imageCopy == null) {
            return null;
        }
        try {
            return imageCopy.getSubimage(view.getLeft(), view.getTop(), Math.min(view.getRight() + shadowIncrement, image.getWidth()), Math.min(view.getBottom() + shadowIncrement, image.getHeight()));
        }
        catch (RasterFormatException e) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static RenderResult renderImage(long renderTimeoutMillis, @Nullable RenderTask renderTask, @NotNull String string) {
        void xml;
        if (string == null) {
            PreviewProvider.$$$reportNull$$$0(5);
        }
        if (renderTask == null) {
            return null;
        }
        PsiFile file2 = PsiFileFactory.getInstance((Project)renderTask.getContext().getModule().getProject()).createFileFromText(PREVIEW_PLACEHOLDER_FILE, (FileType)XmlFileType.INSTANCE, (CharSequence)xml);
        assert (file2 instanceof XmlFile);
        renderTask.setXmlFile((XmlFile)file2);
        renderTask.setTransparentBackground();
        renderTask.setDecorations(false);
        renderTask.setRenderingMode(SessionParams.RenderingMode.V_SCROLL);
        renderTask.getContext().setFolderType(ResourceFolderType.LAYOUT);
        renderTask.inflate();
        try {
            return renderTask.render().get(renderTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            Logger.getInstance(PreviewProvider.class).debug((Throwable)e);
            return null;
        }
    }

    private double getScale() {
        DesignSurface surface2 = this.myDesignSurfaceSupplier.get();
        return surface2 != null ? surface2.getScale() * surface2.getScreenScalingFactor() : 1.0;
    }

    @Nullable
    private SceneView getSceneView() {
        DesignSurface surface2 = this.myDesignSurfaceSupplier.get();
        return surface2 != null ? surface2.getFocusedSceneView() : null;
    }

    @NotNull
    private Future<RenderTask> getRenderTask(@NotNull Configuration configuration) {
        if (configuration == null) {
            PreviewProvider.$$$reportNull$$$0(6);
        }
        Module module2 = configuration.getModule();
        if (this.myRenderTask != null && this.myRenderTask.getContext().getModule() == module2) {
            ListenableFuture listenableFuture = Futures.immediateFuture((Object)this.myRenderTask);
            if (listenableFuture == null) {
                PreviewProvider.$$$reportNull$$$0(7);
            }
            return listenableFuture;
        }
        this.disposeRenderTaskNoWait();
        if (module2 == null) {
            ListenableFuture listenableFuture = Futures.immediateFuture(null);
            if (listenableFuture == null) {
                PreviewProvider.$$$reportNull$$$0(8);
            }
            return listenableFuture;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 == null) {
            ListenableFuture listenableFuture = Futures.immediateFuture(null);
            if (listenableFuture == null) {
                PreviewProvider.$$$reportNull$$$0(9);
            }
            return listenableFuture;
        }
        RenderService renderService = RenderService.getInstance(module2.getProject());
        RenderLogger logger2 = renderService.createLogger(facet2);
        CompletableFuture<RenderTask> completableFuture = renderService.taskBuilder(facet2, configuration).withLogger(logger2).build();
        if (completableFuture == null) {
            PreviewProvider.$$$reportNull$$$0(10);
        }
        return completableFuture;
    }

    public void dispose() {
        if (this.myRenderTask != null) {
            Futures.getUnchecked(this.myRenderTask.dispose());
            this.myRenderTask = null;
        }
    }

    private void disposeRenderTaskNoWait() {
        if (this.myRenderTask != null) {
            this.myRenderTask.dispose();
            this.myRenderTask = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xml";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/palette/PreviewProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/palette/PreviewProvider";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPreview";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "renderDragImage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "renderImage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRenderTask";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ImageAndDimension {
        public BufferedImage image;
        public Dimension dimension;

        private ImageAndDimension(@NotNull BufferedImage image, @NotNull Dimension dimension2) {
            if (image == null) {
                ImageAndDimension.$$$reportNull$$$0(0);
            }
            if (dimension2 == null) {
                ImageAndDimension.$$$reportNull$$$0(1);
            }
            this.image = image;
            this.dimension = dimension2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "image";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dimension";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/uibuilder/palette/PreviewProvider$ImageAndDimension";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

