/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.annotations.concurrency.AnyThread;
import com.android.annotations.concurrency.UiThread;
import com.android.tools.adtui.common.AdtSecondaryPanel;
import com.android.tools.adtui.workbench.ToolContent;
import com.android.tools.adtui.workbench.ToolWindowCallback;
import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.DnDTransferComponent;
import com.android.tools.idea.common.model.DnDTransferItem;
import com.android.tools.idea.common.model.ItemTransferable;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.uibuilder.actions.ComponentHelpAction;
import com.android.tools.idea.uibuilder.analytics.NlUsageTracker;
import com.android.tools.idea.uibuilder.palette.CategoryList;
import com.android.tools.idea.uibuilder.palette.DataModel;
import com.android.tools.idea.uibuilder.palette.DependencyManager;
import com.android.tools.idea.uibuilder.palette.ItemList;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.android.tools.idea.uibuilder.palette.PreviewProvider;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.type.LayoutEditorFileType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@UiThread
public class PalettePanel
extends AdtSecondaryPanel
implements Disposable,
DataProvider,
ToolContent<DesignSurface> {
    private static final int DOWNLOAD_WIDTH = 16;
    private static final int VERTICAL_SCROLLING_UNIT_INCREMENT = 50;
    private static final int VERTICAL_SCROLLING_BLOCK_INCREMENT = 25;
    private final Project myProject;
    private final DependencyManager myDependencyManager;
    private final DataModel myDataModel;
    private final CopyProvider myCopyProvider;
    private final CategoryList myCategoryList;
    private final JScrollPane myCategoryScrollPane;
    private final ItemList myItemList;
    private final AddToDesignAction myAddToDesignAction;
    private final FavoriteAction myFavoriteAction;
    private final ComponentHelpAction myAndroidDocAction;
    private final MaterialDocAction myMaterialDocAction;
    private final ActionGroup myActionGroup;
    private final KeyListener myFilterKeyListener;
    @NotNull
    private WeakReference<DesignSurface> myDesignSurface;
    private LayoutEditorFileType myLayoutType;
    private ToolWindowCallback myToolWindow;
    private Palette.Group myLastSelectedGroup;

    public PalettePanel(@NotNull Project project, @NotNull Disposable parentDisposable) {
        if (project == null) {
            PalettePanel.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            PalettePanel.$$$reportNull$$$0(1);
        }
        this(project, new DependencyManager(project), parentDisposable);
    }

    @VisibleForTesting
    PalettePanel(@NotNull Project project, @NotNull DependencyManager dependencyManager, @NotNull Disposable parentDisposable) {
        if (project == null) {
            PalettePanel.$$$reportNull$$$0(2);
        }
        if (dependencyManager == null) {
            PalettePanel.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            PalettePanel.$$$reportNull$$$0(4);
        }
        super((LayoutManager)new BorderLayout());
        this.myDesignSurface = new WeakReference<Object>(null);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myProject = project;
        this.myDependencyManager = dependencyManager;
        this.myDataModel = new DataModel(this, this.myDependencyManager);
        this.myDependencyManager.addDependencyChangeListener(() -> this.repaint());
        this.myCopyProvider = new CopyProviderImpl();
        Disposer.register((Disposable)this, (Disposable)dependencyManager);
        this.myCategoryList = new CategoryList();
        this.myItemList = new ItemList(this.myDependencyManager);
        this.myAddToDesignAction = new AddToDesignAction();
        this.myFavoriteAction = new FavoriteAction();
        this.myAndroidDocAction = new ComponentHelpAction(project, this::getSelectedTagName);
        this.myMaterialDocAction = new MaterialDocAction();
        this.myActionGroup = this.createPopupActionGroup();
        this.myCategoryScrollPane = PalettePanel.createScrollPane((JComponent)((Object)this.myCategoryList));
        this.add(this.myCategoryScrollPane, "West");
        this.add(PalettePanel.createScrollPane((JComponent)((Object)this.myItemList)), "Center");
        this.myFilterKeyListener = this.createFilterKeyListener();
        KeyListener keyListener2 = this.createKeyListener();
        this.myCategoryList.addListSelectionListener(event -> this.categorySelectionChanged());
        this.myCategoryList.setModel(this.myDataModel.getCategoryListModel());
        this.myCategoryList.addKeyListener(keyListener2);
        this.myCategoryList.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)0, (int)0, (int)1));
        PreviewProvider provider2 = new PreviewProvider(() -> (DesignSurface)((Object)((Object)this.myDesignSurface.get())), this.myDependencyManager);
        Disposer.register((Disposable)this, (Disposable)provider2);
        this.myItemList.setModel(this.myDataModel.getItemListModel());
        this.myItemList.setTransferHandler(new ItemTransferHandler(provider2, () -> this.myItemList.getSelectedValue()));
        if (!GraphicsEnvironment.isHeadless()) {
            this.myItemList.setDragEnabled(true);
        }
        this.myItemList.addMouseListener(this.createItemListMouseListener());
        this.myItemList.addKeyListener(keyListener2);
        this.registerKeyboardActions();
        this.myLastSelectedGroup = DataModel.COMMON;
    }

    @NotNull
    @TestOnly
    AnAction getAddToDesignAction() {
        AddToDesignAction addToDesignAction = this.myAddToDesignAction;
        if (addToDesignAction == null) {
            PalettePanel.$$$reportNull$$$0(5);
        }
        return addToDesignAction;
    }

    @NotNull
    @TestOnly
    AnAction getAndroidDocAction() {
        ComponentHelpAction componentHelpAction = this.myAndroidDocAction;
        if (componentHelpAction == null) {
            PalettePanel.$$$reportNull$$$0(6);
        }
        return componentHelpAction;
    }

    @NotNull
    @TestOnly
    AnAction getMaterialDocAction() {
        MaterialDocAction materialDocAction = this.myMaterialDocAction;
        if (materialDocAction == null) {
            PalettePanel.$$$reportNull$$$0(7);
        }
        return materialDocAction;
    }

    @NotNull
    private static JScrollPane createScrollPane(@NotNull JComponent component) {
        if (component == null) {
            PalettePanel.$$$reportNull$$$0(8);
        }
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)component, (int)20, (int)31);
        scrollPane.getVerticalScrollBar().setUnitIncrement(50);
        scrollPane.getVerticalScrollBar().setBlockIncrement(25);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        JScrollPane jScrollPane = scrollPane;
        if (jScrollPane == null) {
            PalettePanel.$$$reportNull$$$0(9);
        }
        return jScrollPane;
    }

    @NotNull
    private MouseListener createItemListMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event.isPopupTrigger()) {
                    this.showPopupMenu(event);
                }
            }

            @Override
            public void mouseReleased(@NotNull MouseEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (event.isPopupTrigger()) {
                    this.showPopupMenu(event);
                } else if (SwingUtilities.isLeftMouseButton(event) && !event.isControlDown()) {
                    this.mouseClick(event);
                }
            }

            private void mouseClick(@NotNull MouseEvent event) {
                Rectangle rect;
                int width;
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                int n = width = (rect = PalettePanel.this.myItemList.getCellBounds(0, 0)) != null ? rect.width : PalettePanel.this.myItemList.getWidth();
                if (event.getX() < width - JBUI.scale((int)16) || event.getX() >= PalettePanel.this.myItemList.getWidth()) {
                    return;
                }
                int index2 = PalettePanel.this.myItemList.locationToIndex(event.getPoint());
                Palette.Item item = (Palette.Item)PalettePanel.this.myItemList.getModel().getElementAt(index2);
                PalettePanel.this.myDependencyManager.ensureLibraryIsIncluded(item);
            }

            private void showPopupMenu(@NotNull MouseEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (PalettePanel.this.myItemList.isEmpty()) {
                    return;
                }
                PalettePanel.this.myItemList.setSelectedIndex(PalettePanel.this.myItemList.locationToIndex(event.getPoint()));
                ActionPopupMenu popupMenu2 = ActionManager.getInstance().createActionPopupMenu("ToolwindowPopup", PalettePanel.this.myActionGroup);
                popupMenu2.getComponent().show((Component)((Object)PalettePanel.this.myItemList), event.getX(), event.getY());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/android/tools/idea/uibuilder/palette/PalettePanel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mousePressed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseReleased";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseClick";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "showPopupMenu";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    private KeyListener createKeyListener() {
        return new KeyAdapter(){

            @Override
            public void keyTyped(@NotNull KeyEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (Character.isAlphabetic(event.getKeyChar())) {
                    PalettePanel.this.startFiltering(String.valueOf(event.getKeyChar()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/uibuilder/palette/PalettePanel$2", "keyTyped"));
            }
        };
    }

    private void registerKeyboardActions() {
        this.myItemList.registerKeyboardAction(event -> this.keyboardActionPerformed(event, this.myAddToDesignAction), KeyStroke.getKeyStroke(10, 0), 1);
        this.myItemList.registerKeyboardAction(event -> this.keyboardActionPerformed(event, this.myAndroidDocAction), KeyStroke.getKeyStroke(112, 64), 1);
    }

    private void startFiltering(@NotNull String initialSearchString) {
        if (initialSearchString == null) {
            PalettePanel.$$$reportNull$$$0(10);
        }
        if (this.myToolWindow != null) {
            this.myToolWindow.startFiltering(initialSearchString);
        }
    }

    private void keyboardActionPerformed(@NotNull ActionEvent event, @NotNull AnAction action2) {
        if (event == null) {
            PalettePanel.$$$reportNull$$$0(11);
        }
        if (action2 == null) {
            PalettePanel.$$$reportNull$$$0(12);
        }
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)this));
        InputEvent inputEvent = event.getSource() instanceof InputEvent ? (InputEvent)event.getSource() : null;
        action2.actionPerformed(AnActionEvent.createFromAnAction((AnAction)action2, (InputEvent)inputEvent, (String)"ToolwindowPopup", (DataContext)dataContext));
    }

    @NotNull
    private ActionGroup createPopupActionGroup() {
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.add((AnAction)this.myAddToDesignAction);
        group2.add((AnAction)this.myFavoriteAction);
        group2.addSeparator();
        group2.add((AnAction)this.myAndroidDocAction);
        group2.add((AnAction)this.myMaterialDocAction);
        DefaultActionGroup defaultActionGroup = group2;
        if (defaultActionGroup == null) {
            PalettePanel.$$$reportNull$$$0(13);
        }
        return defaultActionGroup;
    }

    @Nullable
    private String getSelectedTagName() {
        Palette.Item item = (Palette.Item)this.myItemList.getSelectedValue();
        return item != null ? item.getTagName() : null;
    }

    private void categorySelectionChanged() {
        Palette.Group newSelection = (Palette.Group)this.myCategoryList.getSelectedValue();
        if (newSelection == null) {
            this.myLastSelectedGroup = DataModel.COMMON;
            this.myCategoryList.setSelectedIndex(0);
            return;
        }
        this.myDataModel.categorySelectionChanged(newSelection);
        this.myLastSelectedGroup = newSelection;
        this.myItemList.setSelectedIndex(0);
        this.myItemList.setEmptyText(PalettePanel.generateEmptyText(newSelection));
    }

    @NotNull
    private static Pair<String, String> generateEmptyText(@NotNull Palette.Group group2) {
        if (group2 == null) {
            PalettePanel.$$$reportNull$$$0(14);
        }
        if (group2 == DataModel.COMMON) {
            Pair pair = Pair.create((Object)"No favorites", (Object)"Right click to add");
            if (pair == null) {
                PalettePanel.$$$reportNull$$$0(15);
            }
            return pair;
        }
        if (group2 == DataModel.RESULTS) {
            Pair pair = Pair.create((Object)"No matches found", (Object)"");
            if (pair == null) {
                PalettePanel.$$$reportNull$$$0(16);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)"Empty group", (Object)"");
        if (pair == null) {
            PalettePanel.$$$reportNull$$$0(17);
        }
        return pair;
    }

    @NotNull
    public JComponent getComponent() {
        PalettePanel palettePanel = this;
        if (palettePanel == null) {
            PalettePanel.$$$reportNull$$$0(18);
        }
        return palettePanel;
    }

    @NotNull
    public JComponent getFocusedComponent() {
        CategoryList categoryList = this.myCategoryList;
        if (categoryList == null) {
            PalettePanel.$$$reportNull$$$0(19);
        }
        return categoryList;
    }

    @AnyThread
    @NotNull
    @VisibleForTesting
    public CategoryList getCategoryList() {
        CategoryList categoryList = this.myCategoryList;
        if (categoryList == null) {
            PalettePanel.$$$reportNull$$$0(20);
        }
        return categoryList;
    }

    @AnyThread
    @NotNull
    @VisibleForTesting
    public ItemList getItemList() {
        ItemList itemList = this.myItemList;
        if (itemList == null) {
            PalettePanel.$$$reportNull$$$0(21);
        }
        return itemList;
    }

    public void requestFocus() {
        this.myCategoryList.requestFocus();
    }

    public void registerCallbacks(@NotNull ToolWindowCallback toolWindow) {
        if (toolWindow == null) {
            PalettePanel.$$$reportNull$$$0(22);
        }
        this.myToolWindow = toolWindow;
    }

    public boolean supportsFiltering() {
        return true;
    }

    public void setFilter(@NotNull String filter2) {
        if (filter2 == null) {
            PalettePanel.$$$reportNull$$$0(23);
        }
        this.myDataModel.setFilterPattern(filter2);
        Palette.Group newSelection = this.myDataModel.getCategoryListModel().contains(this.myLastSelectedGroup) ? this.myLastSelectedGroup : null;
        this.myCategoryList.clearSelection();
        this.myCategoryList.setSelectedValue(newSelection, true);
    }

    @NotNull
    public KeyListener getFilterKeyListener() {
        KeyListener keyListener2 = this.myFilterKeyListener;
        if (keyListener2 == null) {
            PalettePanel.$$$reportNull$$$0(24);
        }
        return keyListener2;
    }

    @NotNull
    private KeyListener createFilterKeyListener() {
        return new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (PalettePanel.this.myDataModel.hasFilterPattern() && event.getKeyCode() == 10 && event.getModifiers() == 0 && PalettePanel.this.myItemList.getModel().getSize() == 1) {
                    PalettePanel.this.myItemList.requestFocus();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/uibuilder/palette/PalettePanel$3", "keyPressed"));
            }
        };
    }

    @NotNull
    CompletableFuture<Void> setToolContextAsyncImpl(@Nullable DesignSurface designSurface) {
        CompletionStage<Object> result2;
        assert (designSurface == null || designSurface instanceof NlDesignSurface);
        Module module2 = PalettePanel.getModule(designSurface);
        if (designSurface != null && module2 != null && this.myLayoutType != designSurface.getLayoutType()) {
            AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
            assert (facet2 != null);
            assert (designSurface.getLayoutType() instanceof LayoutEditorFileType);
            this.myLayoutType = (LayoutEditorFileType)designSurface.getLayoutType();
            result2 = this.myDataModel.setLayoutTypeAsync(facet2, this.myLayoutType).thenRunAsync(() -> {
                if (this.myDataModel.getCategoryListModel().hasExplicitGroups()) {
                    this.setCategoryListVisible(true);
                    this.myCategoryList.setSelectedIndex(0);
                } else {
                    this.setCategoryListVisible(false);
                    this.myDataModel.categorySelectionChanged(DataModel.COMMON);
                    this.myItemList.setSelectedIndex(0);
                }
            }, (Executor)EdtExecutorService.getInstance());
        } else {
            result2 = CompletableFuture.completedFuture(null);
        }
        this.myDesignSurface = new WeakReference<DesignSurface>(designSurface);
        CompletableFuture<Object> completableFuture = result2;
        if (completableFuture == null) {
            PalettePanel.$$$reportNull$$$0(25);
        }
        return completableFuture;
    }

    public void setToolContext(@Nullable DesignSurface designSurface) {
        this.setToolContextAsyncImpl(designSurface);
    }

    private void setCategoryListVisible(boolean visible) {
        this.myCategoryScrollPane.setVisible(visible);
    }

    @Nullable
    private static Module getModule(@Nullable DesignSurface designSurface) {
        Configuration configuration = designSurface != null && designSurface.getLayoutType().isEditable() ? designSurface.getConfiguration() : null;
        return configuration != null ? configuration.getModule() : null;
    }

    public void dispose() {
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            PalettePanel.$$$reportNull$$$0(26);
        }
        return PlatformDataKeys.COPY_PROVIDER.is(dataId) ? this.myCopyProvider : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyManager";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/palette/PalettePanel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialSearchString";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/palette/PalettePanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddToDesignAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidDocAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMaterialDocAction";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createScrollPane";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "generateEmptyText";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusedComponent";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getCategoryList";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemList";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterKeyListener";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "setToolContextAsyncImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createScrollPane";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "startFiltering";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "keyboardActionPerformed";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "generateEmptyText";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "registerCallbacks";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setFilter";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MaterialDocAction
    extends AnAction {
        private static final String MATERIAL_DEFAULT_REFERENCE = "https://material.io/guidelines/material-design/introduction.html";

        private MaterialDocAction() {
            super("Material Guidelines");
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            String reference2;
            if (event == null) {
                MaterialDocAction.$$$reportNull$$$0(0);
            }
            if (!(reference2 = this.getReference()).isEmpty()) {
                BrowserUtil.browse((String)reference2);
            }
        }

        public void update(@NotNull AnActionEvent event) {
            if (event == null) {
                MaterialDocAction.$$$reportNull$$$0(1);
            }
            event.getPresentation().setEnabled(!this.getReference().isEmpty());
        }

        private String getReference() {
            Palette.Item item = (Palette.Item)PalettePanel.this.myItemList.getSelectedValue();
            if (item == null) {
                return "";
            }
            String reference2 = item.getMaterialReference();
            if (reference2 == null) {
                reference2 = MATERIAL_DEFAULT_REFERENCE;
            }
            return StringUtil.notNullize((String)reference2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/android/tools/idea/uibuilder/palette/PalettePanel$MaterialDocAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class FavoriteAction
    extends ToggleAction {
        private FavoriteAction() {
            super("Favorite");
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            Palette.Item item;
            if (event == null) {
                FavoriteAction.$$$reportNull$$$0(0);
            }
            return (item = (Palette.Item)PalettePanel.this.myItemList.getSelectedValue()) != null && PalettePanel.this.myDataModel.isFavoriteItem(item);
        }

        public void setSelected(@NotNull AnActionEvent event, boolean state) {
            Palette.Item item;
            if (event == null) {
                FavoriteAction.$$$reportNull$$$0(1);
            }
            if ((item = (Palette.Item)PalettePanel.this.myItemList.getSelectedValue()) != null) {
                if (state) {
                    PalettePanel.this.myDataModel.addFavoriteItem(item);
                } else {
                    PalettePanel.this.myDataModel.removeFavoriteItem(item);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/android/tools/idea/uibuilder/palette/PalettePanel$FavoriteAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class AddToDesignAction
    extends AnAction {
        private AddToDesignAction() {
            super("Add to Design");
            this.setShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(10, 0)));
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                AddToDesignAction.$$$reportNull$$$0(0);
            }
            this.addComponentToModel(false);
        }

        public void update(@NotNull AnActionEvent event) {
            if (event == null) {
                AddToDesignAction.$$$reportNull$$$0(1);
            }
            event.getPresentation().setEnabled(this.addComponentToModel(true));
        }

        private boolean addComponentToModel(boolean checkOnly) {
            NlComponent root2;
            InsertType insertType;
            Palette.Item item = (Palette.Item)PalettePanel.this.myItemList.getSelectedValue();
            if (item == null) {
                return false;
            }
            DesignSurface surface2 = (DesignSurface)((Object)PalettePanel.this.myDesignSurface.get());
            if (surface2 == null) {
                return false;
            }
            NlModel model2 = surface2.getModel();
            if (model2 == null) {
                return false;
            }
            ImmutableList<NlComponent> roots = model2.getComponents();
            if (roots.isEmpty()) {
                return false;
            }
            SceneView sceneView = surface2.getFocusedSceneView();
            if (sceneView == null) {
                return false;
            }
            DnDTransferComponent dndComponent = new DnDTransferComponent(item.getTagName(), item.getXml(), 0, 0);
            DnDTransferItem dndItem = new DnDTransferItem(dndComponent);
            List<NlComponent> toAdd = model2.createComponents(dndItem, insertType = model2.determineInsertType(DragType.COPY, dndItem, checkOnly), surface2);
            if (!model2.canAddComponents(toAdd, root2 = (NlComponent)roots.get(0), null, checkOnly)) {
                return false;
            }
            if (!checkOnly) {
                model2.addComponents(toAdd, root2, null, insertType, sceneView.getSurface());
                surface2.getSelectionModel().setSelection(toAdd);
                surface2.getLayeredPane().requestFocus();
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/android/tools/idea/uibuilder/palette/PalettePanel$AddToDesignAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ItemTransferHandler
    extends TransferHandler {
        private final PreviewProvider myPreviewProvider;
        private final Supplier<Palette.Item> myItemSupplier;

        private ItemTransferHandler(@NotNull PreviewProvider provider2, Supplier<Palette.Item> itemSupplier) {
            if (provider2 == null) {
                ItemTransferHandler.$$$reportNull$$$0(0);
            }
            if (itemSupplier == null) {
                ItemTransferHandler.$$$reportNull$$$0(1);
            }
            this.myPreviewProvider = provider2;
            this.myItemSupplier = itemSupplier;
        }

        @Override
        public int getSourceActions(@NotNull JComponent component) {
            if (component == null) {
                ItemTransferHandler.$$$reportNull$$$0(2);
            }
            return 3;
        }

        @Override
        @Nullable
        protected Transferable createTransferable(@NotNull JComponent component) {
            Palette.Item item;
            if (component == null) {
                ItemTransferHandler.$$$reportNull$$$0(3);
            }
            if ((item = this.myItemSupplier.get()) == null) {
                return null;
            }
            DumbService dumbService = DumbService.getInstance((Project)PalettePanel.this.myProject);
            if (dumbService.isDumb()) {
                dumbService.showDumbModeNotification("Dragging from the Palette is not available while indices are updating.");
                return null;
            }
            PreviewProvider.ImageAndDimension imageAndSize = this.myPreviewProvider.createPreview(component, item);
            BufferedImage image = imageAndSize.image;
            Dimension size = imageAndSize.dimension;
            this.setDragImage(image);
            if (SystemInfo.isWindows) {
                this.setDragImageOffset(new Point(image.getWidth() / 2, image.getHeight() / 2));
            } else {
                this.setDragImageOffset(new Point(-image.getWidth() / 2, -image.getHeight() / 2));
            }
            DnDTransferComponent dndComponent = new DnDTransferComponent(item.getTagName(), item.getXml(), size.width, size.height);
            ItemTransferable transferable = new ItemTransferable(new DnDTransferItem(dndComponent));
            if (PalettePanel.this.myToolWindow != null) {
                PalettePanel.this.myToolWindow.autoHide();
            }
            return transferable;
        }

        @Override
        protected void exportDone(@NotNull JComponent source, @Nullable Transferable data, int action2) {
            if (source == null) {
                ItemTransferHandler.$$$reportNull$$$0(4);
            }
            if (action2 == 0 || data == null) {
                return;
            }
            DnDTransferComponent component = this.getDndComponent(data);
            if (component == null) {
                return;
            }
            if (PalettePanel.this.myToolWindow != null) {
                PalettePanel.this.myToolWindow.stopFiltering();
            }
            NlUsageTracker.getInstance((DesignSurface)((Object)PalettePanel.this.myDesignSurface.get())).logDropFromPalette(component.getTag(), component.getRepresentation(), this.getGroupName(), PalettePanel.this.myDataModel.getMatchCount());
        }

        @NotNull
        private String getGroupName() {
            Palette.Group group2 = (Palette.Group)PalettePanel.this.myCategoryList.getSelectedValue();
            return group2 != null ? group2.getName() : "";
        }

        @Nullable
        private DnDTransferComponent getDndComponent(@NotNull Transferable data) {
            if (data == null) {
                ItemTransferHandler.$$$reportNull$$$0(5);
            }
            try {
                ImmutableList<DnDTransferComponent> components;
                DnDTransferItem item = (DnDTransferItem)data.getTransferData(ItemTransferable.DESIGNER_FLAVOR);
                if (item != null && (components = item.getComponents()).size() == 1) {
                    return (DnDTransferComponent)components.get(0);
                }
            }
            catch (UnsupportedFlavorException | IOException ex) {
                Logger.getInstance(PalettePanel.class).warn("Could not un-serialize a transferable", (Throwable)ex);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "itemSupplier";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/palette/PalettePanel$ItemTransferHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSourceActions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createTransferable";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "exportDone";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getDndComponent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class CopyProviderImpl
    implements CopyProvider {
        private CopyProviderImpl() {
        }

        public void performCopy(@NotNull DataContext dataContext) {
            Palette.Item item;
            if (dataContext == null) {
                CopyProviderImpl.$$$reportNull$$$0(0);
            }
            if ((item = (Palette.Item)PalettePanel.this.myItemList.getSelectedValue()) != null && !PalettePanel.this.myDependencyManager.needsLibraryLoad(item)) {
                DnDTransferComponent component = new DnDTransferComponent(item.getTagName(), item.getXml(), 0, 0);
                CopyPasteManager.getInstance().setContents((Transferable)new ItemTransferable(new DnDTransferItem(component)));
            }
        }

        public boolean isCopyEnabled(@NotNull DataContext dataContext) {
            Palette.Item item;
            if (dataContext == null) {
                CopyProviderImpl.$$$reportNull$$$0(1);
            }
            return (item = (Palette.Item)PalettePanel.this.myItemList.getSelectedValue()) != null && !PalettePanel.this.myDependencyManager.needsLibraryLoad(item);
        }

        public boolean isCopyVisible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                CopyProviderImpl.$$$reportNull$$$0(2);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "dataContext";
            objectArray2[1] = "com/android/tools/idea/uibuilder/palette/PalettePanel$CopyProviderImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performCopy";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCopyEnabled";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCopyVisible";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

