/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor.tools;

import com.android.SdkConstants;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.editor.MockupEditor;
import com.android.tools.idea.uibuilder.mockup.editor.MockupViewPanel;
import com.android.tools.idea.uibuilder.mockup.editor.creators.WidgetCreator;
import com.android.tools.idea.uibuilder.mockup.editor.creators.WidgetCreatorFactory;
import com.android.tools.idea.uibuilder.mockup.editor.creators.forms.ToolRootPanel;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.JBColor;
import icons.StudioIcons;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;

public class ExtractWidgetTool
extends ToolRootPanel
implements MockupEditor.Tool {
    private static final Logger LOGGER = Logger.getInstance((String)ExtractWidgetTool.class.getName());
    private static final String[] LIST_CLASSES = new String[]{SdkConstants.RECYCLER_VIEW.oldName(), SdkConstants.RECYCLER_VIEW.newName(), "ListView"};
    private static ImmutableList<CreatorAction> ourWidgetCreationActions = new ImmutableList.Builder().add((Object)new CreatorAction("View", "Create new widget from selection", StudioIcons.LayoutEditor.Toolbar.ADD_COMPONENT)).add((Object)new CreatorAction("include", "Create new layout from selection", StudioIcons.NavEditor.Toolbar.ADD_DESTINATION, true)).add((Object)new CreatorAction("ImageView", "Create new ImageView", StudioIcons.LayoutEditor.Palette.IMAGE_VIEW)).add((Object)new CreatorAction(SdkConstants.FLOATING_ACTION_BUTTON.defaultName(), "Create new FloatingActionButton", StudioIcons.LayoutEditor.Palette.FLOATING_ACTION_BUTTON)).add((Object)new CreatorAction("TextView", "Create new TextView", StudioIcons.LayoutEditor.Palette.TEXT_VIEW)).add((Object)new CreatorAction(SdkConstants.RECYCLER_VIEW.defaultName(), "Create new RecyclerView", StudioIcons.LayoutEditor.Palette.RECYCLER_VIEW)).build();
    private static ImmutableList<CreatorAction> ourOtherCreationActions = new ImmutableList.Builder().add((Object)new CreatorAction("drawable", "Create drawable", StudioIcons.LayoutEditor.Properties.IMAGE_PICKER)).build();
    private final MockupViewPanel myMockupViewPanel;
    private final MockupEditor myMockupEditor;
    private NlDesignSurface mySurface;
    private Rectangle mySelection;
    private MySelectionListener mySelectionListener;
    private float myAlpha;

    public ExtractWidgetTool(@NotNull MockupEditor mockupEditor) {
        if (mockupEditor == null) {
            ExtractWidgetTool.$$$reportNull$$$0(0);
        }
        this.myAlpha = 0.0f;
        this.myMockupViewPanel = mockupEditor.getMockupViewPanel();
        this.mySelectionListener = new MySelectionListener();
        this.myMockupEditor = mockupEditor;
        MockupEditor.MockupEditorListener mockupEditorListener = newMockup -> this.hideTooltipActions();
        mockupEditor.addListener(mockupEditorListener);
        this.add(this.createActionToolbar());
        this.setOpaque(false);
    }

    public void setDesignSurface(NlDesignSurface surface2) {
        this.mySurface = surface2;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Composite composite = g2d.getComposite();
        if (this.myAlpha == 1.0f) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g2d.setComposite(AlphaComposite.getInstance(3, this.myAlpha));
        super.paintComponent(g);
        g2d.setComposite(composite);
    }

    private void displayTooltipActions() {
        this.myMockupViewPanel.removeAll();
        if (!this.mySelection.isEmpty()) {
            Timer timer2 = new Timer(20, e -> {
                float alpha = this.myAlpha;
                if ((alpha = (float)((double)alpha + 0.1)) > 1.0f) {
                    alpha = 1.0f;
                    ((Timer)e.getSource()).setRepeats(false);
                }
                this.myAlpha = alpha;
                this.repaint();
            });
            timer2.setRepeats(true);
            timer2.setRepeats(true);
            timer2.setCoalesce(true);
            timer2.start();
            this.myMockupViewPanel.add(this);
            this.myMockupViewPanel.doLayout();
        }
    }

    private void hideTooltipActions() {
        this.myMockupViewPanel.remove(this);
        this.myAlpha = 0.0f;
    }

    private JComponent createActionToolbar() {
        DefaultActionGroup group2 = new DefaultActionGroup(this.createActionsButtons());
        if (!ourOtherCreationActions.isEmpty()) {
            group2.addSeparator();
            for (CreatorAction otherCreationAction : ourOtherCreationActions) {
                group2.add(this.createAnActionButton(otherCreationAction, false));
            }
        }
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("AndroidDesignerExtractWidgetTool", (ActionGroup)group2, false);
        actionToolbar.setLayoutPolicy(1);
        actionToolbar.setTargetComponent((JComponent)this);
        actionToolbar.getComponent().setBackground((Color)JBColor.WHITE);
        return actionToolbar.getComponent();
    }

    @Override
    public void enable(@NotNull MockupEditor mockupEditor) {
        if (mockupEditor == null) {
            ExtractWidgetTool.$$$reportNull$$$0(1);
        }
        MockupViewPanel mockupViewPanel = mockupEditor.getMockupViewPanel();
        mockupViewPanel.addSelectionListener(this.mySelectionListener);
        mockupViewPanel.resetState();
    }

    @Override
    public void disable(@NotNull MockupEditor mockupEditor) {
        if (mockupEditor == null) {
            ExtractWidgetTool.$$$reportNull$$$0(2);
        }
        MockupViewPanel mockupViewPanel = mockupEditor.getMockupViewPanel();
        mockupViewPanel.removeSelectionListener(this.mySelectionListener);
        this.hideTooltipActions();
    }

    private List<AnAction> createActionsButtons() {
        ArrayList<AnAction> actions2 = new ArrayList<AnAction>(ourWidgetCreationActions.size());
        for (CreatorAction creatorAction : ourWidgetCreationActions) {
            actions2.add(this.createAnActionButton(creatorAction, true));
        }
        return actions2;
    }

    @NotNull
    private AnAction createAnActionButton(final @NotNull CreatorAction creatorAction, final boolean viewGroupOnly) {
        if (creatorAction == null) {
            ExtractWidgetTool.$$$reportNull$$$0(3);
        }
        return new AnAction(creatorAction.myTitle, creatorAction.myTitle, creatorAction.myIcon){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                Mockup mockup = ExtractWidgetTool.this.myMockupEditor.getMockup();
                if (viewGroupOnly && (mockup == null || !ExtractWidgetTool.canAddChild(creatorAction, mockup.getComponent()))) {
                    e.getPresentation().setEnabledAndVisible(false);
                } else {
                    e.getPresentation().setEnabledAndVisible(true);
                }
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                Mockup mockup = ExtractWidgetTool.this.myMockupEditor.getMockup();
                SceneView currentScreenView = ExtractWidgetTool.this.mySurface.getFocusedSceneView();
                if (mockup == null) {
                    ExtractWidgetTool.this.myMockupEditor.showError("Cannot create a widget from an empty mockup");
                    LOGGER.warn("MockupEditor has no associated mockup");
                    return;
                }
                if (currentScreenView == null) {
                    ExtractWidgetTool.this.myMockupEditor.showError("The designer is not ready to create a new widget");
                    LOGGER.warn("The NlDesignSurface does not have a current screen view");
                    return;
                }
                WidgetCreator creator = WidgetCreatorFactory.create(creatorAction.myAndroidClassName, mockup, currentScreenView.getModel(), currentScreenView, ExtractWidgetTool.this.mySelection);
                ExtractWidgetTool.this.executeCreator(creator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/android/tools/idea/uibuilder/mockup/editor/tools/ExtractWidgetTool$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean canAddChild(@NotNull CreatorAction creatorAction, @NotNull NlComponent component) {
        if (creatorAction == null) {
            ExtractWidgetTool.$$$reportNull$$$0(4);
        }
        if (component == null) {
            ExtractWidgetTool.$$$reportNull$$$0(5);
        }
        if (!NlComponentHelperKt.isOrHasSuperclass(component, "android.view.ViewGroup")) {
            return false;
        }
        return !ExtractWidgetTool.isListClass(component) || creatorAction.myHandleListComponent;
    }

    private static boolean isListClass(@NotNull NlComponent component) {
        if (component == null) {
            ExtractWidgetTool.$$$reportNull$$$0(6);
        }
        for (String className2 : LIST_CLASSES) {
            if (!NlComponentHelperKt.isOrHasSuperclass(component, className2)) continue;
            return true;
        }
        return false;
    }

    private void executeCreator(@NotNull WidgetCreator creator) {
        if (creator == null) {
            ExtractWidgetTool.$$$reportNull$$$0(7);
        }
        for (int i2 = 0; i2 < this.myMockupViewPanel.getComponentCount(); ++i2) {
            if (this.myMockupViewPanel.getComponent(i2) == this) continue;
            this.myMockupViewPanel.remove(i2);
        }
        this.myMockupViewPanel.doLayout();
        if (creator.hasOptionsComponent()) {
            this.setEnabled(false);
            JComponent optionsComponent = creator.getOptionsComponent(type -> {
                this.setEnabled(true);
                this.myMockupViewPanel.removeAll();
                if (1 == type) {
                    creator.addToModel();
                }
            });
            if (optionsComponent != null) {
                optionsComponent.setEnabled(true);
                this.myMockupViewPanel.add(optionsComponent);
                this.myMockupViewPanel.doLayout();
            }
        } else {
            creator.addToModel();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mockupEditor";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creatorAction";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/mockup/editor/tools/ExtractWidgetTool";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "enable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "disable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createAnActionButton";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "canAddChild";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isListClass";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "executeCreator";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CreatorAction {
        String myAndroidClassName;
        String myTitle;
        Icon myIcon;
        boolean myHandleListComponent;

        public CreatorAction(String androidClassName, String title, Icon icon2) {
            this(androidClassName, title, icon2, false);
        }

        public CreatorAction(String androidClassName, String title, Icon icon2, boolean handleListComponent) {
            this.myAndroidClassName = androidClassName;
            this.myTitle = title;
            this.myIcon = icon2;
            this.myHandleListComponent = handleListComponent;
        }
    }

    private class MySelectionListener
    implements MockupViewPanel.SelectionListener {
        private MySelectionListener() {
        }

        @Override
        public void selectionStarted(MockupViewPanel mockupViewPanel, int x, int y) {
            ExtractWidgetTool.this.hideTooltipActions();
        }

        @Override
        public void selectionEnded(MockupViewPanel mockupViewPanel, Rectangle selection) {
            ExtractWidgetTool.this.mySelection = selection;
            Mockup mockup = ExtractWidgetTool.this.myMockupEditor.getMockup();
            if (mockup != null) {
                ExtractWidgetTool.this.displayTooltipActions();
            }
        }
    }
}

