/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor.creators;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.editor.creators.WidgetCreator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.SourceProviderManager;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

public final class ResourcesUtil {
    private static final Logger LOGGER = Logger.getInstance(ResourcesUtil.class);

    public static boolean checkDrawableExist(@NotNull String drawableName, @NotNull String drawableType, @NotNull AndroidFacet facet2) {
        if (drawableName == null) {
            ResourcesUtil.$$$reportNull$$$0(0);
        }
        if (drawableType == null) {
            ResourcesUtil.$$$reportNull$$$0(1);
        }
        if (facet2 == null) {
            ResourcesUtil.$$$reportNull$$$0(2);
        }
        List<VirtualFile> drawableSubDirs = IdeResourcesUtil.getResourceSubdirs(ResourceFolderType.DRAWABLE, ResourceRepositoryManager.getModuleResources(facet2).getResourceDirs());
        for (VirtualFile dir : drawableSubDirs) {
            if (dir.findChild(String.format("%s.%s", drawableName, drawableType)) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean createDrawable(@NotNull String drawableName, @NotNull String drawableType, @NotNull WidgetCreator.DoneCallback doneCallback, @NotNull NlModel model2, @NotNull BufferedImage image, @NotNull Object requestor) {
        if (drawableName == null) {
            ResourcesUtil.$$$reportNull$$$0(3);
        }
        if (drawableType == null) {
            ResourcesUtil.$$$reportNull$$$0(4);
        }
        if (doneCallback == null) {
            ResourcesUtil.$$$reportNull$$$0(5);
        }
        if (model2 == null) {
            ResourcesUtil.$$$reportNull$$$0(6);
        }
        if (image == null) {
            ResourcesUtil.$$$reportNull$$$0(7);
        }
        if (requestor == null) {
            ResourcesUtil.$$$reportNull$$$0(8);
        }
        AndroidFacet facet2 = model2.getFacet();
        List<VirtualFile> drawableSubDirs = IdeResourcesUtil.getResourceSubdirs(ResourceFolderType.DRAWABLE, ResourceRepositoryManager.getModuleResources(facet2).getResourceDirs());
        try {
            byte[] imageInByte = ResourcesUtil.imageToByteArray(image, drawableType);
            Project project = model2.getProject();
            if (!drawableSubDirs.isEmpty()) {
                ResourcesUtil.createDrawableFile(drawableName + "." + drawableType, imageInByte, project, drawableSubDirs.get(0), doneCallback, requestor);
            } else {
                ResourcesUtil.createDrawableAndFolder(drawableName, drawableType, facet2, imageInByte, project, doneCallback, requestor);
            }
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Error while converting image to bytes");
            return false;
        }
    }

    public static boolean createDrawable(@NotNull String drawableName, @NotNull String drawableType, @NotNull WidgetCreator.DoneCallback doneCallback, @NotNull Mockup mockup, @NotNull NlModel model2, @NotNull Rectangle selectionBounds, @NotNull Object requestor) {
        BufferedImage image;
        if (drawableName == null) {
            ResourcesUtil.$$$reportNull$$$0(9);
        }
        if (drawableType == null) {
            ResourcesUtil.$$$reportNull$$$0(10);
        }
        if (doneCallback == null) {
            ResourcesUtil.$$$reportNull$$$0(11);
        }
        if (mockup == null) {
            ResourcesUtil.$$$reportNull$$$0(12);
        }
        if (model2 == null) {
            ResourcesUtil.$$$reportNull$$$0(13);
        }
        if (selectionBounds == null) {
            ResourcesUtil.$$$reportNull$$$0(14);
        }
        if (requestor == null) {
            ResourcesUtil.$$$reportNull$$$0(15);
        }
        if ((image = mockup.getImage()) == null) {
            return false;
        }
        Rectangle realCropping = mockup.getComputedCropping();
        BufferedImage subImage = image.getSubimage(selectionBounds.x + realCropping.x, selectionBounds.y + realCropping.y, selectionBounds.width, selectionBounds.height);
        return ResourcesUtil.createDrawable(drawableName, drawableType, doneCallback, model2, subImage, requestor);
    }

    public static byte[] imageToByteArray(BufferedImage subImage, String imageType) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)subImage, imageType, baos);
        baos.flush();
        byte[] imageInByte = baos.toByteArray();
        baos.close();
        return imageInByte;
    }

    private static void createDrawableAndFolder(@NotNull String drawableName, @NotNull String drawableType, @NotNull AndroidFacet facet2, @NotNull byte[] imageInByte, @NotNull Project project, @NotNull WidgetCreator.DoneCallback doneCallback, @NotNull Object requestor) {
        Iterable<VirtualFile> resDirectories;
        Iterator<VirtualFile> iterator;
        if (drawableName == null) {
            ResourcesUtil.$$$reportNull$$$0(16);
        }
        if (drawableType == null) {
            ResourcesUtil.$$$reportNull$$$0(17);
        }
        if (facet2 == null) {
            ResourcesUtil.$$$reportNull$$$0(18);
        }
        if (project == null) {
            ResourcesUtil.$$$reportNull$$$0(19);
        }
        if (doneCallback == null) {
            ResourcesUtil.$$$reportNull$$$0(20);
        }
        if (requestor == null) {
            ResourcesUtil.$$$reportNull$$$0(21);
        }
        if (imageInByte == null) {
            ResourcesUtil.$$$reportNull$$$0(22);
        }
        if ((iterator = (resDirectories = SourceProviderManager.getInstance(facet2).getMainIdeaSourceProvider().getResDirectories()).iterator()).hasNext()) {
            CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    VirtualFile drawableDir = AndroidUtils.createChildDirectoryIfNotExist(project, (VirtualFile)iterator.next(), "drawable");
                    ResourcesUtil.createDrawableFile(drawableName + "." + drawableType, imageInByte, project, drawableDir, doneCallback, requestor);
                }
                catch (IOException e) {
                    LOGGER.error((Throwable)e);
                }
            }), "Export selection to drawable", null);
        }
    }

    private static void createDrawableFile(@NotNull String fileName, @NotNull byte[] imageInByte, @NotNull Project project, @NotNull VirtualFile drawableDir, @NotNull WidgetCreator.DoneCallback doneCallback, @NotNull Object requestor) {
        if (fileName == null) {
            ResourcesUtil.$$$reportNull$$$0(23);
        }
        if (project == null) {
            ResourcesUtil.$$$reportNull$$$0(24);
        }
        if (drawableDir == null) {
            ResourcesUtil.$$$reportNull$$$0(25);
        }
        if (doneCallback == null) {
            ResourcesUtil.$$$reportNull$$$0(26);
        }
        if (requestor == null) {
            ResourcesUtil.$$$reportNull$$$0(27);
        }
        if (imageInByte == null) {
            ResourcesUtil.$$$reportNull$$$0(28);
        }
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                VirtualFile folder = drawableDir.createChildData(requestor, fileName);
                folder.setBinaryContent(imageInByte);
                doneCallback.done(1);
            }
            catch (IOException e) {
                LOGGER.error((Throwable)e);
                doneCallback.done(0);
            }
        }), "Export selection to drawable", null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drawableName";
                break;
            }
            case 1: 
            case 4: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drawableType";
                break;
            }
            case 2: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 5: 
            case 11: 
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doneCallback";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 8: 
            case 15: 
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mockup";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionBounds";
                break;
            }
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageInByte";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drawableDir";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDrawableExist";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "createDrawable";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "createDrawableAndFolder";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "createDrawableFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

