/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor;

import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.editor.MockupEditor;
import com.android.tools.idea.uibuilder.mockup.editor.SelectionLayer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockupViewPanel
extends JPanel {
    private static final int MAX_SCALE = 20;
    public static final int MAX_HD_SCALE_LEVEL = 2;
    private static final float MIN_SCALE = 0.95f;
    private static final Color BACKGROUND = UIUtil.getPanelBackground();
    private static RenderingHints HQ_RENDERING = new RenderingHints(null);
    private final SelectionLayer mySelectionLayer;
    @Nullable
    private Mockup myMockup;
    private float myZoom;
    @Nullable
    private BufferedImage myDisplayedImage;
    @Nullable
    private BufferedImage myImage;
    private boolean myDisplayOnlyCroppedRegion;
    private boolean mySelectionMode;
    private PanZoomManager myPanZoomManager;
    private Mockup.MockupModelListener myMockupListener;
    private List<SelectionListener> mySelectionListeners;
    private final AffineTransform myImageTransform;
    private final Point2D.Float myImageOffset;
    private boolean myHqRendering;

    public MockupViewPanel(@NotNull MockupEditor mockupEditor) {
        if (mockupEditor == null) {
            MockupViewPanel.$$$reportNull$$$0(0);
        }
        this.myZoom = 0.95f;
        this.myDisplayOnlyCroppedRegion = true;
        this.mySelectionMode = true;
        this.mySelectionListeners = new ArrayList<SelectionListener>();
        this.myImageTransform = new AffineTransform();
        this.myImageOffset = new Point2D.Float();
        this.myHqRendering = true;
        this.myMockupListener = (mockup1, changedFlags) -> this.updateDisplayedImage(mockup1);
        mockupEditor.addListener(this::update);
        this.setLayout(new MyLayoutManager());
        this.setBackground(BACKGROUND);
        this.setOpaque(true);
        this.mySelectionLayer = new SelectionLayer(this, this.myImageTransform);
        Mockup mockup = mockupEditor.getMockup();
        if (mockup != null) {
            this.setMockup(mockup);
            this.updateDisplayedImage(mockup);
        }
        MyMouseInteraction mouseInteraction = new MyMouseInteraction();
        this.addMouseListener(mouseInteraction);
        this.addMouseMotionListener(mouseInteraction);
        this.addMouseWheelListener(mouseInteraction);
        this.addComponentListener(new MyComponentListener());
        this.addKeyListener(new MyKeyListener());
        this.addContainerListener(MockupViewPanel.createContainerListener());
        this.myDisplayedImage = this.myImage;
        this.setPreferredSize(new Dimension(200, 200));
        this.setMinimumSize(new Dimension(100, 100));
        this.myPanZoomManager = new PanZoomManager();
        this.resetState();
        this.setFocusable(true);
        this.requestFocusInWindow();
    }

    @NotNull
    private static ContainerAdapter createContainerListener() {
        return new ContainerAdapter(){
            private MouseAdapter myMouseAdapter = new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    e.consume();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    e.consume();
                }
            };

            @Override
            public void componentAdded(ContainerEvent e) {
                Component component = e.getChild();
                component.addMouseListener(this.myMouseAdapter);
                component.addMouseMotionListener(this.myMouseAdapter);
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                Component component = e.getChild();
                component.removeMouseListener(this.myMouseAdapter);
                component.removeMouseMotionListener(this.myMouseAdapter);
            }
        };
    }

    private void update(Mockup mockup) {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myMockup != mockup) {
                this.resetState();
            }
            this.setMockup(mockup);
            this.repaint();
        });
    }

    private void updateDisplayedImage(@Nullable Mockup mockup) {
        if (mockup == null || !Mockup.hasMockupAttribute(mockup.getComponent())) {
            this.myImage = null;
            this.myDisplayedImage = null;
            return;
        }
        this.myImage = mockup.getImage();
        if (this.myImage != null) {
            this.myDisplayedImage = this.createDisplayedImage(this.myImage, mockup.getComputedCropping());
        }
        this.updateSelectionLayerBounds();
        this.repaint();
    }

    public void resetState() {
        this.removeAll();
        this.setDisplayOnlyCroppedRegion(true);
        this.getSelectionLayer().clearSelection();
        this.getSelectionLayer().setFixedRatio(false);
        this.repaint();
    }

    public void setMockup(@Nullable Mockup mockup) {
        if (mockup != this.myMockup) {
            if (this.myMockup != null) {
                this.myMockup.removeMockupListener(this.myMockupListener);
            }
            this.myMockup = mockup;
            this.myImage = null;
            this.myDisplayedImage = null;
            if (this.myMockup != null) {
                this.myMockup.addMockupListener(this.myMockupListener);
            }
        }
        this.updateDisplayedImage(mockup);
    }

    public void setDisplayOnlyCroppedRegion(boolean displayOnlyCroppedRegion) {
        if (this.myDisplayOnlyCroppedRegion != displayOnlyCroppedRegion) {
            this.myDisplayOnlyCroppedRegion = displayOnlyCroppedRegion;
            if (this.myImage != null && this.myMockup != null) {
                this.myDisplayedImage = this.createDisplayedImage(this.myImage, this.myMockup.getComputedCropping());
                this.updateSelectionLayerBounds();
            }
            this.repaint();
        }
    }

    public void setSelectionMode(boolean selectionMode) {
        this.mySelectionMode = selectionMode;
        this.mySelectionLayer.clearSelection();
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g.create();
        if (this.myHqRendering) {
            g2d.setRenderingHints(HQ_RENDERING);
        }
        this.paintMockup(g2d);
        if (this.mySelectionMode) {
            this.mySelectionLayer.paint(g2d);
        }
        g2d.dispose();
    }

    private void paintMockup(Graphics2D g2d) {
        if (this.myDisplayedImage == null) {
            return;
        }
        AffineTransform tx = g2d.getTransform();
        int sw = this.getWidth();
        int sh = this.getHeight();
        int iw = this.myDisplayedImage.getWidth();
        int ih = this.myDisplayedImage.getHeight();
        float scale = (float)((double)this.myZoom * Math.min((double)sw / (double)iw, (double)sh / (double)ih));
        this.updateTransform(sw, sh, iw, ih, scale);
        if (!this.isValid()) {
            this.doLayout();
        }
        g2d.transform(this.myImageTransform);
        g2d.drawImage(this.myDisplayedImage, 0, 0, iw, ih, null);
        this.painScaled(g2d);
        g2d.setTransform(tx);
    }

    private void updateTransform(int sw, int sh, int iw, int ih, float scale) {
        this.myImageTransform.setToIdentity();
        this.myImageTransform.translate((1.0f + this.myImageOffset.x) * ((float)sw - (float)iw * scale) / 2.0f, (1.0f + this.myImageOffset.y) * ((float)sh - (float)ih * scale) / 2.0f);
        this.myImageTransform.scale(scale, scale);
    }

    private void painScaled(Graphics2D g2d) {
    }

    @Nullable
    private BufferedImage createDisplayedImage(@Nullable BufferedImage image, @NotNull Rectangle cropping) {
        BufferedImage displayedImage;
        if (cropping == null) {
            MockupViewPanel.$$$reportNull$$$0(1);
        }
        if (image == null) {
            return null;
        }
        if (this.myDisplayOnlyCroppedRegion) {
            Rectangle2D.intersect(cropping, new Rectangle(image.getWidth(), image.getHeight()), cropping);
            displayedImage = image.getSubimage(cropping.x, cropping.y, cropping.width, cropping.height);
        } else {
            displayedImage = image;
        }
        return displayedImage;
    }

    public void setSelectionToMockupCrop() {
        if (this.myMockup == null) {
            this.mySelectionLayer.setSelection(0, 0, 0, 0);
            return;
        }
        this.mySelectionLayer.setSelection(this.myMockup.getComputedCropping());
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        if (!this.mySelectionListeners.contains(selectionListener)) {
            this.mySelectionListeners.add(selectionListener);
        }
    }

    public void removeSelectionListener(SelectionListener listener2) {
        this.mySelectionListeners.remove(listener2);
    }

    public SelectionLayer getSelectionLayer() {
        return this.mySelectionLayer;
    }

    private void resizeSelection() {
        if (this.mySelectionMode) {
            this.mySelectionLayer.contentResized();
        }
    }

    private void notifySelectionEnded() {
        for (int i2 = 0; i2 < this.mySelectionListeners.size(); ++i2) {
            this.mySelectionListeners.get(i2).selectionEnded(this, this.mySelectionLayer.getSelection());
        }
    }

    private void notifySelectionStarted(int x, int y) {
        for (int i2 = 0; i2 < this.mySelectionListeners.size(); ++i2) {
            this.mySelectionListeners.get(i2).selectionStarted(this, x, y);
        }
    }

    @Nullable
    public Mockup getMockup() {
        return this.myMockup;
    }

    private void updateSelectionLayerBounds() {
        if (this.myDisplayedImage == null) {
            this.mySelectionLayer.setBounds(0, 0, this.getWidth(), this.getHeight());
        } else {
            this.mySelectionLayer.setBounds(0, 0, this.myDisplayedImage.getWidth(), this.myDisplayedImage.getHeight());
        }
    }

    private static boolean isPanAction(MouseEvent e) {
        return SwingUtilities.isMiddleMouseButton(e) || MockupViewPanel.isPanKey(e);
    }

    private static boolean isPanKey(InputEvent e) {
        return e.isControlDown();
    }

    static {
        HQ_RENDERING.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        HQ_RENDERING.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mockupEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cropping";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/mockup/editor/MockupViewPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createDisplayedImage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyKeyListener
    extends KeyAdapter {
        private MyKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            int keyCode = e.getKeyCode();
            if (keyCode == 16 || keyCode == 17) {
                MockupViewPanel.this.myPanZoomManager.mouseReleased(null);
            }
        }
    }

    private class PanZoomManager {
        private static final int ANIMATION_DURATION = 200;
        private static final int ZOOM_DELAY = 20;
        private float myTargetZoom;
        private Timer myZoomTimer;
        private Point myMouseDown = new Point();
        private Point2D.Float myImageDown = new Point2D.Float();
        private Point2D.Float myDownOffset = new Point2D.Float();
        private Point2D.Float myBounds = new Point2D.Float(1.0f, 1.0f);
        private long myStartTime;
        private float myStartZoom;
        private boolean myIsPanning;

        private PanZoomManager() {
            this.myZoomTimer = new Timer(20, et -> {
                float zoom;
                long currentTime = System.currentTimeMillis();
                float t = (float)(currentTime - this.myStartTime) / 200.0f;
                if (t > 1.0f) {
                    ((Timer)et.getSource()).stop();
                    zoom = this.myTargetZoom;
                    MockupViewPanel.this.myHqRendering = true;
                } else {
                    MockupViewPanel.this.myHqRendering = false;
                    zoom = this.myStartZoom + (this.myTargetZoom - this.myStartZoom) * t;
                }
                this.zoomExact(zoom, this.myMouseDown);
            });
            this.myZoomTimer.setRepeats(true);
            this.myZoomTimer.setInitialDelay(0);
        }

        private void zoomAnimate(float amount, Point screenDown) {
            this.myMouseDown.setLocation(screenDown);
            if (!this.myZoomTimer.isRunning()) {
                this.myTargetZoom = MockupViewPanel.this.myZoom;
                this.myStartTime = System.currentTimeMillis();
                this.myStartZoom = MockupViewPanel.this.myZoom;
                this.myZoomTimer.restart();
            }
            this.myTargetZoom *= 1.0f - amount / 10.0f;
        }

        private void zoom(float amount, Point screenDown) {
            this.zoomExact(MockupViewPanel.this.myZoom * (1.0f - amount / 10.0f), screenDown);
        }

        private void zoomExact(float zoom, Point screenDown) {
            if (MockupViewPanel.this.myDisplayedImage == null) {
                return;
            }
            float oldZoom = MockupViewPanel.this.myZoom;
            MockupViewPanel.this.myZoom = Math.max(0.95f, Math.min(20.0f, zoom));
            int screenDownX = screenDown.x;
            int screenDownY = screenDown.y;
            this.myDownOffset.x = MockupViewPanel.this.myImageOffset.x;
            this.myDownOffset.y = MockupViewPanel.this.myImageOffset.y;
            try {
                MockupViewPanel.this.myImageTransform.inverseTransform(screenDown, this.myImageDown);
                int sw = MockupViewPanel.this.getWidth();
                int sh = MockupViewPanel.this.getHeight();
                int iw = MockupViewPanel.this.myDisplayedImage.getWidth();
                int ih = MockupViewPanel.this.myDisplayedImage.getHeight();
                float scale = (float)((double)MockupViewPanel.this.myZoom * Math.min((double)sw / (double)iw, (double)sh / (double)ih));
                MockupViewPanel.this.updateTransform(sw, sh, iw, ih, scale);
                MockupViewPanel.this.myImageTransform.transform(this.myImageDown, this.myImageDown);
                float wrongDownX = (float)this.myImageDown.getX();
                float wrongDownY = (float)this.myImageDown.getY();
                float dx = (float)screenDownX - wrongDownX;
                float dy = (float)screenDownY - wrongDownY;
                MockupViewPanel.this.myImageOffset.x = (float)iw * scale <= (float)sw && oldZoom > MockupViewPanel.this.myZoom ? 0.0f : this.myDownOffset.x + 2.0f * (dx / ((float)sw - scale * (float)iw));
                MockupViewPanel.this.myImageOffset.y = (float)ih * scale <= (float)sh && oldZoom > MockupViewPanel.this.myZoom ? 0.0f : this.myDownOffset.y + 2.0f * (dy / ((float)sh - scale * (float)ih));
                this.myBounds.x = Math.max(1.0f, Math.abs(MockupViewPanel.this.myImageOffset.x));
                this.myBounds.y = Math.max(1.0f, Math.abs(MockupViewPanel.this.myImageOffset.y));
            }
            catch (NoninvertibleTransformException e1) {
                Logger.getInstance(MockupViewPanel.class).warn((Throwable)e1);
            }
            MockupViewPanel.this.myHqRendering = zoom <= 2.0f;
            MockupViewPanel.this.mySelectionLayer.contentResized();
            MockupViewPanel.this.repaint();
        }

        private void stop() {
            this.myZoomTimer.stop();
        }

        public void mousePressed(MouseEvent e) {
            this.myIsPanning = true;
            this.myMouseDown.setLocation(e.getPoint());
            this.myDownOffset.setLocation(MockupViewPanel.this.myImageOffset);
        }

        public void mouseDragged(MouseEvent e) {
            int ih;
            float scale;
            if (MockupViewPanel.this.myDisplayedImage == null) {
                return;
            }
            if (!this.myIsPanning) {
                this.mousePressed(e);
            }
            int dx = e.getX() - this.myMouseDown.x;
            int dy = e.getY() - this.myMouseDown.y;
            int sw = MockupViewPanel.this.getWidth();
            int sh = MockupViewPanel.this.getHeight();
            int iw = MockupViewPanel.this.myDisplayedImage.getWidth();
            if ((float)iw * (scale = MockupViewPanel.this.myZoom * Math.min((float)sw / (float)iw, (float)sh / (float)(ih = MockupViewPanel.this.myDisplayedImage.getHeight()))) > (float)sw) {
                MockupViewPanel.this.myImageOffset.x = this.myDownOffset.x + 2.0f * ((float)dx / ((float)sw - scale * (float)iw));
                MockupViewPanel.this.myImageOffset.x = Math.max(Math.min(MockupViewPanel.this.myImageOffset.x, this.myBounds.x), -this.myBounds.x);
            }
            if ((float)ih * scale > (float)sh) {
                MockupViewPanel.this.myImageOffset.y = this.myDownOffset.y + 2.0f * ((float)dy / ((float)sh - scale * (float)ih));
                MockupViewPanel.this.myImageOffset.y = Math.max(Math.min(MockupViewPanel.this.myImageOffset.y, this.myBounds.y), -this.myBounds.y);
            }
            MockupViewPanel.this.invalidate();
            MockupViewPanel.this.repaint();
        }

        public void mouseReleased(@Nullable MouseEvent e) {
            this.myIsPanning = false;
        }

        public boolean isPanning() {
            return this.myIsPanning;
        }
    }

    private class MyLayoutManager
    implements LayoutManager {
        public static final int H_GAP = 10;
        public static final int V_GAP = 10;

        private MyLayoutManager() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return null;
        }

        @Override
        public void layoutContainer(Container parent) {
            Rectangle selection = MockupViewPanel.this.mySelectionLayer.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            int componentCount = parent.getComponentCount();
            int totalWidth = componentCount * 10;
            int totalHeight = 0;
            for (int i2 = 0; i2 < componentCount; ++i2) {
                Component component = parent.getComponent(i2);
                Dimension preferredSize = component.getPreferredSize();
                if (preferredSize.width <= 0 || preferredSize.height <= 0) {
                    preferredSize.setSize(component.getSize());
                }
                totalWidth += preferredSize.width;
                totalHeight = Math.max(preferredSize.height, totalHeight);
            }
            int selectionWidth = (int)Math.round((double)selection.width * MockupViewPanel.this.myImageTransform.getScaleX());
            int selectionHeight = (int)Math.round((double)selection.height * MockupViewPanel.this.myImageTransform.getScaleY());
            float[] selectionOrigin = new float[]{selection.x, selection.y};
            MockupViewPanel.this.myImageTransform.transform(selectionOrigin, 0, selectionOrigin, 0, 1);
            int selectionX = Math.round(selectionOrigin[0]);
            int y = Math.round(selectionOrigin[1]);
            int x = selectionX + selectionWidth + 10;
            if (x + totalWidth > MockupViewPanel.this.getWidth()) {
                if ((double)totalWidth < 0.9 * (double)selectionWidth) {
                    x = Math.min(MockupViewPanel.this.getWidth(), selectionX + selectionWidth) - 10 - totalWidth;
                } else {
                    x = selectionX - totalWidth - 10;
                    if (x < 0) {
                        x = 0;
                    }
                    if (x + totalWidth > selectionX) {
                        y = y < MockupViewPanel.this.getHeight() / 2 ? (y += selectionHeight + 10) : (y -= totalHeight + 10);
                        x = Math.max(0, (selectionX + selectionWidth - totalWidth) / 2);
                    }
                }
            }
            for (int i3 = 0; i3 < componentCount; ++i3) {
                Component component = parent.getComponent(i3);
                Dimension preferredSize = component.getPreferredSize();
                if (y + preferredSize.height > MockupViewPanel.this.getHeight()) {
                    y -= y + preferredSize.height - MockupViewPanel.this.getHeight();
                }
                y = Math.max(y, 10);
                component.setBounds(x, y, preferredSize.width, preferredSize.height);
                x += 10 + preferredSize.width;
            }
        }
    }

    private class MyMouseInteraction
    extends MouseAdapter {
        private MyMouseInteraction() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (MockupViewPanel.isPanAction(e)) {
                MockupViewPanel.this.myPanZoomManager.mousePressed(e);
                return;
            }
            Point origin = new Point(e.getPoint());
            MockupViewPanel.this.myImageTransform.transform(e.getPoint(), e.getPoint());
            if (MockupViewPanel.this.mySelectionMode) {
                MockupViewPanel.this.removeAll();
                this.toSelectionLayer(e);
                MockupViewPanel.this.notifySelectionStarted(e.getX(), e.getY());
                MockupViewPanel.this.repaint();
            }
            e.getPoint().setLocation(origin);
        }

        private void toSelectionLayer(MouseEvent e) {
            MockupViewPanel.this.updateSelectionLayerBounds();
            MockupViewPanel.this.mySelectionLayer.mousePressed(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (MockupViewPanel.isPanAction(e)) {
                if (!MockupViewPanel.this.myPanZoomManager.isPanning()) {
                    MockupViewPanel.this.myPanZoomManager.mousePressed(e);
                }
                MockupViewPanel.this.myPanZoomManager.mouseDragged(e);
            } else {
                if (MockupViewPanel.this.mySelectionMode) {
                    MockupViewPanel.this.mySelectionLayer.mouseDragged(e);
                }
                if (MockupViewPanel.this.myPanZoomManager.isPanning()) {
                    MockupViewPanel.this.myPanZoomManager.mouseReleased(e);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            MockupViewPanel.this.myPanZoomManager.mouseReleased(e);
            MockupViewPanel.this.mySelectionLayer.mouseReleased(e);
            if (!MockupViewPanel.isPanAction(e)) {
                MockupViewPanel.this.notifySelectionEnded();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (MockupViewPanel.this.mySelectionMode) {
                MockupViewPanel.this.mySelectionLayer.mouseMoved(e);
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (MockupViewPanel.isPanAction(e)) {
                MockupViewPanel.this.myPanZoomManager.zoomAnimate(e.getWheelRotation(), e.getPoint());
            }
            if (SwingUtilities.isLeftMouseButton(e)) {
                MockupViewPanel.this.mySelectionLayer.mouseDragged(e);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            super.mouseExited(e);
            MockupViewPanel.this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private class MyComponentListener
    implements ComponentListener {
        private MyComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (MockupViewPanel.this.mySelectionMode) {
                MockupViewPanel.this.resizeSelection();
            }
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            MockupViewPanel.this.myPanZoomManager.stop();
        }
    }

    public static interface SelectionListener {
        public void selectionStarted(MockupViewPanel var1, int var2, int var3);

        public void selectionEnded(MockupViewPanel var1, Rectangle var2);
    }
}

