/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.menu;

import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.menu.ActionBar;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Ints;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GroupDragHandler
extends DragHandler {
    private final SceneComponent myGroup;
    private final List<NlComponent> myItems;
    private final ActionBar myActionBar;
    private SceneComponent myActiveItem;

    GroupDragHandler(@NotNull ViewEditor editor2, @NotNull ViewGroupHandler handler2, @NotNull SceneComponent group2, @NotNull List<NlComponent> items2, @NotNull DragType type) {
        if (editor2 == null) {
            GroupDragHandler.$$$reportNull$$$0(0);
        }
        if (handler2 == null) {
            GroupDragHandler.$$$reportNull$$$0(1);
        }
        if (group2 == null) {
            GroupDragHandler.$$$reportNull$$$0(2);
        }
        if (items2 == null) {
            GroupDragHandler.$$$reportNull$$$0(3);
        }
        if (type == null) {
            GroupDragHandler.$$$reportNull$$$0(4);
        }
        super(editor2, handler2, group2, items2, type);
        assert (!items2.isEmpty());
        this.myGroup = group2;
        this.myItems = items2;
        this.myActionBar = new ActionBar(group2);
    }

    @Override
    public void commit(int x, int y, int modifiers, @NotNull InsertType insertType) {
        if (insertType == null) {
            GroupDragHandler.$$$reportNull$$$0(5);
        }
        NlComponent groupComponent = this.myGroup.getNlComponent();
        int insertIndex = this.getInsertIndex();
        NlWriteCommandActionUtil.run(this.myItems.get(0), "menu item addition", () -> {
            this.updateOrderInCategoryAttributes();
            this.updateShowAsActionAttribute();
        });
        this.editor.insertChildren(groupComponent, this.myItems, insertIndex, insertType);
    }

    private void updateOrderInCategoryAttributes() {
        if (this.myActiveItem == null || this.myActiveItem == this.layout.getSceneComponent(this.myItems.get(0))) {
            return;
        }
        Integer order = GroupDragHandler.getOrderInCategory(this.myActiveItem.getNlComponent());
        if (order == null) {
            return;
        }
        if (this.isActionBarGroupActive()) {
            this.updateActionBarGroupOrderInCategoryAttributes(order);
        } else {
            this.updateOverflowGroupOrderInCategoryAttributes(order);
        }
    }

    private void updateActionBarGroupOrderInCategoryAttributes(int order) {
        if (this.lastX >= this.myActiveItem.getCenterX()) {
            ++order;
        }
        GroupDragHandler.incrementOrderInCategoryAttributes(this.createOrderToItemMultimap(this.myActionBar.getItems()), order);
        this.myItems.get(0).setAndroidAttribute("orderInCategory", Integer.toString(order));
    }

    private void updateOverflowGroupOrderInCategoryAttributes(int order) {
        if (this.lastY >= this.myActiveItem.getCenterY()) {
            ++order;
        }
        GroupDragHandler.incrementOrderInCategoryAttributes(this.createOrderToItemMultimap(this.myActionBar.getOverflowItems()), order);
        this.myItems.get(0).setAndroidAttribute("orderInCategory", Integer.toString(order));
    }

    private static void incrementOrderInCategoryAttributes(@NotNull Multimap<Integer, SceneComponent> orderToItemMultimap, int order) {
        Collection items2;
        if (orderToItemMultimap == null) {
            GroupDragHandler.$$$reportNull$$$0(6);
        }
        if (!(items2 = orderToItemMultimap.get((Object)order)).isEmpty()) {
            items2.forEach(item -> item.getNlComponent().setAndroidAttribute("orderInCategory", Integer.toString(order + 1)));
            GroupDragHandler.incrementOrderInCategoryAttributes(orderToItemMultimap, order + 1);
        }
    }

    @NotNull
    private Multimap<Integer, SceneComponent> createOrderToItemMultimap(@NotNull Iterable<SceneComponent> group2) {
        if (group2 == null) {
            GroupDragHandler.$$$reportNull$$$0(7);
        }
        SceneComponent draggedItem = this.layout.getSceneComponent(this.myItems.get(0));
        ArrayListMultimap orderToItemMultimap = ArrayListMultimap.create();
        for (SceneComponent item : group2) {
            Integer order;
            if (item == draggedItem || (order = GroupDragHandler.getOrderInCategory(item.getNlComponent())) == null) continue;
            orderToItemMultimap.put((Object)order, (Object)item);
        }
        ArrayListMultimap arrayListMultimap = orderToItemMultimap;
        if (arrayListMultimap == null) {
            GroupDragHandler.$$$reportNull$$$0(8);
        }
        return arrayListMultimap;
    }

    @Nullable
    private static Integer getOrderInCategory(@NotNull NlComponent item) {
        String order;
        if (item == null) {
            GroupDragHandler.$$$reportNull$$$0(9);
        }
        return (order = item.getAndroidAttribute("orderInCategory")) == null ? null : Ints.tryParse((String)order);
    }

    private void updateShowAsActionAttribute() {
        String namespace;
        String string = namespace = this.editor.moduleDependsOnAppCompat() ? "http://schemas.android.com/apk/res-auto" : "http://schemas.android.com/apk/res/android";
        if (this.isActionBarGroupActive()) {
            this.myItems.get(0).setAttribute(namespace, "showAsAction", "always");
        } else {
            this.myItems.get(0).removeAttribute(namespace, "showAsAction");
        }
    }

    @Override
    @Nullable
    public String update(int x, int y, int modifiers, @NotNull SceneContext sceneContext) {
        String message2;
        if (sceneContext == null) {
            GroupDragHandler.$$$reportNull$$$0(10);
        }
        if ((message2 = super.update(x, y, modifiers, sceneContext)) != null) {
            this.myActiveItem = null;
            return message2;
        }
        if (this.isActionBarGroupActive()) {
            this.updateUsingActionBarGroup();
        } else if (this.isOverflowGroupActive()) {
            this.updateUsingOverflowGroup();
        } else {
            this.myActiveItem = null;
        }
        return null;
    }

    private void updateUsingActionBarGroup() {
        SceneComponent component;
        List<SceneComponent> items2 = this.myActionBar.getItems();
        if (this.lastX < items2.get(0).getDrawX()) {
            component = items2.get(0);
        } else {
            Optional<SceneComponent> activeItem = items2.stream().filter(item -> item.containsX(this.lastX)).findFirst();
            component = activeItem.orElse(items2.get(items2.size() - 1));
        }
        this.myActiveItem = component;
    }

    private void updateUsingOverflowGroup() {
        SceneComponent component;
        List<SceneComponent> overflowItems = this.myActionBar.getOverflowItems();
        if (this.lastY < overflowItems.get(0).getDrawY()) {
            component = overflowItems.get(0);
        } else {
            Optional<SceneComponent> activeItem = overflowItems.stream().filter(item -> item.containsY(this.lastY)).findFirst();
            component = activeItem.orElse(overflowItems.get(overflowItems.size() - 1));
        }
        this.myActiveItem = component;
    }

    @Override
    public void paint(@NotNull NlGraphics graphics) {
        if (graphics == null) {
            GroupDragHandler.$$$reportNull$$$0(11);
        }
        if (this.isActionBarGroupActive()) {
            this.drawActionBarGroupDropPreviewLine(graphics);
            this.drawActionBarGroupDropRecipientLines(graphics);
            this.drawActionBarGroupDropZoneLines(graphics);
        } else if (this.isOverflowGroupActive()) {
            this.drawOverflowGroupDropPreviewLine(graphics);
            this.drawOverflowGroupDropRecipientLines(graphics);
            this.drawOverflowGroupDropZoneLines(graphics);
        }
    }

    private void drawActionBarGroupDropPreviewLine(@NotNull NlGraphics graphics) {
        if (graphics == null) {
            GroupDragHandler.$$$reportNull$$$0(12);
        }
        graphics.useStyle(NlDrawingStyle.DROP_PREVIEW);
        SceneComponent activeItem = this.myActiveItem;
        if (this.lastX < activeItem.getCenterX()) {
            graphics.drawLeft(this.myActiveItem.getNlComponent());
        } else {
            graphics.drawRight(this.myActiveItem.getNlComponent());
        }
    }

    private void drawActionBarGroupDropRecipientLines(@NotNull NlGraphics graphics) {
        if (graphics == null) {
            GroupDragHandler.$$$reportNull$$$0(13);
        }
        Rectangle itemBounds = this.myActionBar.getItemBounds();
        assert (itemBounds != null);
        List<SceneComponent> items2 = this.myActionBar.getItems();
        graphics.useStyle(NlDrawingStyle.DROP_RECIPIENT);
        graphics.drawTopDp(itemBounds);
        if (this.lastX >= items2.get(0).getCenterX()) {
            graphics.drawLeftDp(itemBounds);
        }
        if (this.lastX < items2.get(items2.size() - 1).getCenterX()) {
            graphics.drawRightDp(itemBounds);
        }
        graphics.drawBottomDp(itemBounds);
    }

    private void drawActionBarGroupDropZoneLines(@NotNull NlGraphics graphics) {
        if (graphics == null) {
            GroupDragHandler.$$$reportNull$$$0(14);
        }
        List<SceneComponent> items2 = this.myActionBar.getItems();
        int midpointX = this.myActiveItem.getCenterX();
        graphics.useStyle(NlDrawingStyle.DROP_ZONE);
        int size = items2.size();
        for (int i2 = 1; i2 < size; ++i2) {
            SceneComponent item = items2.get(i2);
            if (this.myActiveItem == items2.get(i2 - 1)) {
                if (this.lastX >= midpointX) continue;
                graphics.drawLeft(item.getNlComponent());
                continue;
            }
            if (this.myActiveItem == item) {
                if (this.lastX < midpointX) continue;
                graphics.drawLeft(item.getNlComponent());
                continue;
            }
            graphics.drawLeft(item.getNlComponent());
        }
    }

    private void drawOverflowGroupDropPreviewLine(@NotNull NlGraphics graphics) {
        if (graphics == null) {
            GroupDragHandler.$$$reportNull$$$0(15);
        }
        graphics.useStyle(NlDrawingStyle.DROP_PREVIEW);
        if (this.lastY < this.myActiveItem.getCenterY()) {
            graphics.drawTop(this.myActiveItem.getNlComponent());
        } else {
            graphics.drawBottom(this.myActiveItem.getNlComponent());
        }
    }

    private void drawOverflowGroupDropRecipientLines(@NotNull NlGraphics graphics) {
        if (graphics == null) {
            GroupDragHandler.$$$reportNull$$$0(16);
        }
        List<SceneComponent> overflowItems = this.myActionBar.getOverflowItems();
        Rectangle overflowItemBounds = this.myActionBar.getOverflowItemBounds();
        assert (overflowItemBounds != null);
        graphics.useStyle(NlDrawingStyle.DROP_RECIPIENT);
        if (this.lastY >= overflowItems.get(0).getCenterX()) {
            graphics.drawTopDp(overflowItemBounds);
        }
        graphics.drawLeftDp(overflowItemBounds);
        graphics.drawRightDp(overflowItemBounds);
        if (this.lastY < overflowItems.get(overflowItems.size() - 1).getCenterY()) {
            graphics.drawBottomDp(overflowItemBounds);
        }
    }

    private void drawOverflowGroupDropZoneLines(@NotNull NlGraphics graphics) {
        if (graphics == null) {
            GroupDragHandler.$$$reportNull$$$0(17);
        }
        List<SceneComponent> overflowItems = this.myActionBar.getOverflowItems();
        int midpointY = this.myActiveItem.getCenterY();
        graphics.useStyle(NlDrawingStyle.DROP_ZONE);
        int size = overflowItems.size();
        for (int i2 = 1; i2 < size; ++i2) {
            SceneComponent item = overflowItems.get(i2);
            if (this.myActiveItem == overflowItems.get(i2 - 1)) {
                if (this.lastY >= midpointY) continue;
                graphics.drawTop(item.getNlComponent());
                continue;
            }
            if (this.myActiveItem == item) {
                if (this.lastY < midpointY) continue;
                graphics.drawTop(item.getNlComponent());
                continue;
            }
            graphics.drawTop(item.getNlComponent());
        }
    }

    @VisibleForTesting
    int getInsertIndex() {
        if (this.isActionBarGroupActive()) {
            return this.getInsertIndexUsingActionBarGroup();
        }
        if (this.isOverflowGroupActive()) {
            return this.getInsertIndexUsingOverflowGroup();
        }
        return -1;
    }

    private int getInsertIndexUsingActionBarGroup() {
        Rectangle itemBounds = this.myActionBar.getItemBounds();
        assert (itemBounds != null);
        if (this.lastX < itemBounds.x) {
            return 0;
        }
        if (this.lastX >= itemBounds.x + itemBounds.width) {
            return -1;
        }
        int i2 = this.myGroup.getChildren().indexOf(this.myActiveItem);
        assert (i2 != -1);
        if (this.lastX >= this.myActiveItem.getCenterX()) {
            ++i2;
        }
        return i2 == this.myGroup.getChildCount() ? -1 : i2;
    }

    private int getInsertIndexUsingOverflowGroup() {
        Rectangle overflowItemBounds = this.myActionBar.getOverflowItemBounds();
        assert (overflowItemBounds != null);
        if (this.lastY < overflowItemBounds.y) {
            return 0;
        }
        if (this.lastY >= overflowItemBounds.y + overflowItemBounds.height) {
            return -1;
        }
        int i2 = this.myGroup.getChildren().indexOf(this.myActiveItem);
        assert (i2 != -1);
        if (this.lastY >= this.myActiveItem.getCenterY()) {
            ++i2;
        }
        return i2 == this.myGroup.getChildCount() ? -1 : i2;
    }

    private boolean isActionBarGroupActive() {
        Rectangle itemBounds = this.myActionBar.getItemBounds();
        return itemBounds != null && this.lastY < itemBounds.y + itemBounds.height;
    }

    private boolean isOverflowGroupActive() {
        return this.myActionBar.getOverflowItemBounds() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderToItemMultimap";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/menu/GroupDragHandler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneContext";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/menu/GroupDragHandler";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createOrderToItemMultimap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "commit";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "incrementOrderInCategoryAttributes";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createOrderToItemMultimap";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOrderInCategory";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "drawActionBarGroupDropPreviewLine";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "drawActionBarGroupDropRecipientLines";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "drawActionBarGroupDropZoneLines";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "drawOverflowGroupDropPreviewLine";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "drawOverflowGroupDropRecipientLines";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "drawOverflowGroupDropZoneLines";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

