/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.utils;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.Utils;

public class Debug {
    public static void log(String msg) {
        StackTraceElement s = new Throwable().getStackTrace()[1];
        System.out.println(".(" + s.getFileName() + ":" + s.getLineNumber() + ")" + msg);
    }

    public static void logStack(String msg, int n) {
        StackTraceElement[] st = new Throwable().getStackTrace();
        Object s = " ";
        n = Math.min(n, st.length - 1);
        for (int i2 = 1; i2 <= n; ++i2) {
            StackTraceElement ste = st[i2];
            String stack = ".(" + st[i2].getFileName() + ":" + st[i2].getLineNumber() + ") ";
            s = (String)s + " ";
            System.out.println(msg + (String)s + stack + (String)s);
        }
    }

    public static String getLocation() {
        StackTraceElement s = new Throwable().getStackTrace()[1];
        return ".(" + s.getFileName() + ":" + s.getLineNumber() + ")";
    }

    public static String toString(MTag[] tags2) {
        if (tags2 == null) {
            return " null";
        }
        if (tags2.length == 0) {
            return " []";
        }
        Object str = " [";
        for (int i2 = 0; i2 < tags2.length; ++i2) {
            MTag tag = tags2[i2];
            if (i2 > 0) {
                str = (String)str + ",";
            }
            str = (String)str + Utils.stripID(tag.getAttributeValue("id"));
        }
        return (String)str + "]";
    }
}

