/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.ui;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEIcons;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEJTable;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEUI;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.Track;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MeModel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditorSelector;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.Utils;
import com.android.tools.idea.uibuilder.handlers.motion.editor.utils.Debug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

class LayoutPanel
extends JPanel {
    private static boolean DEBUG = false;
    ArrayList<MTag> mParent;
    MTag mMotionLayout;
    boolean building = false;
    String[] mask = new String[]{"Value", "Layout", "Motion", "Transform", "PropertySet"};
    ArrayList<MTag> mDisplayedRows = new ArrayList();
    DefaultTableModel mConstraintSetModel = new DefaultTableModel(new String[]{"Type", "id", "Constrained"}, 0);
    JTable mConstraintSetTable = new MEJTable(this.mConstraintSetModel);
    private String mDerived;
    boolean showAll = false;
    private MeModel mMeModel;
    private JLabel mTitle;
    private MotionEditorSelector mMotionEditorSelector;
    private boolean mBuildingTable;
    static String[] ourLayoutDir = new String[]{"Left_", "Right_", "Start_", "End_", "Top_", "Bottom_", "Baseline_"};
    static String[] ourConstraintLabel = new String[]{"horizontal", "horizontal", "horizontal", "horizontal", "vertical", "vertical", "vertical"};
    static HashMap<String, String> labelType = new HashMap();

    LayoutPanel() {
        super(new BorderLayout());
        JPanel left2 = new JPanel(new FlowLayout(0));
        JPanel right2 = new JPanel(new FlowLayout(2));
        JPanel top = new JPanel(new BorderLayout());
        top.add((Component)left2, "West");
        top.add((Component)right2, "East");
        top.setBorder(MEUI.getPanelBottomBorder());
        this.mConstraintSetTable.setShowHorizontalLines(false);
        this.mTitle = new JLabel("Layout ", MEIcons.LIST_LAYOUT, 2);
        left2.add(this.mTitle);
        JScrollPane transitionProperties = new JScrollPane(this.mConstraintSetTable);
        transitionProperties.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)transitionProperties, "Center");
        this.add((Component)top, "North");
        this.mConstraintSetTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table2, value2, isSelected, hasFocus, row, column);
                this.setBorder(noFocusBorder);
                return this;
            }
        });
        this.mConstraintSetTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting() && !this.mBuildingTable) {
                this.tableSelection();
            }
        });
    }

    private void tableSelection() {
        MTag[] mTagArray;
        int index2 = this.mConstraintSetTable.getSelectedRow();
        Track.layoutTableSelect(this.mMeModel.myTrack);
        if (index2 == -1 || this.mDisplayedRows.size() == 0) {
            mTagArray = new MTag[]{};
        } else {
            MTag[] mTagArray2 = new MTag[1];
            mTagArray = mTagArray2;
            mTagArray2[0] = this.mDisplayedRows.get(index2);
        }
        MTag[] tag = mTagArray;
        if (tag.length != 0) {
            this.mMeModel.setSelectedViewIDs(Arrays.asList(Utils.stripID(tag[0].getAttributeValue("id"))));
        } else {
            this.mMeModel.setSelectedViewIDs(MeModel.EMPTY_STRING_ARRAY);
        }
        this.mMotionEditorSelector.notifyListeners(MotionEditorSelector.Type.LAYOUT_VIEW, tag, 0);
    }

    String buildListString(MTag tag) {
        String cid = tag.getAttributeValue("id");
        int noc = tag.getChildTags().length;
        String end = tag.getAttributeValue("constraintSetEnd");
        return "<html> <b> " + cid + " </b><br>" + noc + " Constraint" + (noc == 1 ? "" : "s") + "</html>";
    }

    public void buildTable() {
        this.mBuildingTable = true;
        HashSet found = new HashSet();
        this.mConstraintSetModel.setNumRows(0);
        this.mDisplayedRows.clear();
        if (this.mMotionLayout == null) {
            return;
        }
        MTag[] sets = this.mMotionLayout.getChildTags();
        for (int i2 = 0; i2 < sets.length; ++i2) {
            MTag view = sets[i2];
            Object[] row = new String[3];
            String id = Utils.stripID(view.getAttributeValue("id"));
            row[0] = view.getTagName();
            ArrayList<MTag> children = view.getChildren();
            HashMap<String, MTag.Attribute> attrs = view.getAttrList();
            row[1] = id;
            HashSet<String> constrained_sides = new HashSet<String>();
            Set<String> alist = attrs.keySet();
            for (String key : alist) {
                if (!key.contains("layout_")) continue;
                for (String s : labelType.keySet()) {
                    if (!key.contains(s)) continue;
                    constrained_sides.add(labelType.get(s));
                }
            }
            row[2] = Arrays.toString(constrained_sides.toArray(new String[0]));
            this.mDisplayedRows.add(view);
            this.mConstraintSetModel.addRow(row);
        }
        this.mBuildingTable = false;
        this.mConstraintSetModel.fireTableDataChanged();
    }

    private void updateModelIfNecessary() {
        Set found;
        Set ids2 = Arrays.stream(this.mMotionLayout.getChildTags()).map(view -> Utils.stripID(view.getAttributeValue("id"))).filter(Objects::nonNull).collect(Collectors.toSet());
        if (!ids2.equals(found = this.mConstraintSetModel.getDataVector().stream().map(row -> row.get(1)).collect(Collectors.toSet()))) {
            this.buildTable();
        }
    }

    private String getDerived(String viewId, String[] row) {
        if (DEBUG) {
            Debug.log(". getDerived");
        }
        if (this.mDerived != null && this.mParent != null && this.mParent.size() > 0) {
            for (MTag cSet : this.mParent) {
                for (MTag child : cSet.getChildren()) {
                    String setName = Utils.stripID(child.getAttributeValue("id"));
                    if (!setName.endsWith(viewId)) continue;
                    if (row != null) {
                        row[1] = this.getMask(child.getChildren(), child.getAttrList(), setName);
                    }
                    return Utils.stripID(cSet.getAttributeValue("id"));
                }
            }
        }
        return "layout";
    }

    private String getMask(ArrayList<MTag> children, HashMap<String, MTag.Attribute> attrs, String id) {
        if (children.size() == 0 || attrs.size() > 1 && id != null) {
            return "all";
        }
        Object mask = "";
        for (MTag child : children) {
            mask = (String)mask + (((String)mask).equals("") ? "" : "|") + child.getTagName();
        }
        return mask;
    }

    public void setMTag(MTag layout2, MeModel meModel) {
        this.mMeModel = meModel;
        this.mMotionLayout = layout2;
        this.mDerived = null;
        String label = "Layout " + meModel.layoutFileName;
        if (layout2 != null) {
            label = label + " (" + Utils.stripID(layout2.getAttributeValue("id")) + ")";
        }
        this.mTitle.setText(label);
        String[] selected = this.mMeModel != null ? this.mMeModel.getSelectedViewIDs() : MeModel.EMPTY_STRING_ARRAY;
        this.buildTable();
        if (layout2 != null) {
            this.selectByIds(selected);
        }
    }

    public void setListeners(MotionEditorSelector listeners) {
        this.mMotionEditorSelector = listeners;
    }

    public void selectByIds(String[] ids2) {
        this.updateModelIfNecessary();
        HashSet<String> selectedSet = new HashSet<String>(Arrays.asList(ids2));
        this.mConstraintSetTable.clearSelection();
        for (int i2 = 0; i2 < this.mConstraintSetModel.getRowCount(); ++i2) {
            String id = (String)this.mConstraintSetModel.getValueAt(i2, 1);
            if (!selectedSet.contains(id)) continue;
            this.mConstraintSetTable.addRowSelectionInterval(i2, i2);
        }
    }

    public void clearSelection() {
        this.mConstraintSetTable.clearSelection();
    }

    static {
        for (int i2 = 0; i2 < ourLayoutDir.length; ++i2) {
            labelType.put(ourLayoutDir[i2], ourConstraintLabel[i2]);
        }
    }
}

