/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.ui;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEUI;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ErrorPanel
extends JPanel {
    JLabel myBanner = new JLabel();
    JLabel myLabel = new JLabel();
    JLabel myErrorLabel = new JLabel();
    String error;
    HashSet<String> validTop = new HashSet<String>(Arrays.asList("Transition", "ConstraintSet"));
    HashMap<String, String> containedIn = new HashMap();

    ErrorPanel() {
        super(new GridBagLayout());
        this.containedIn.put("Constraint", "ConstraintSet");
        this.containedIn.put("KeyFrameSet", "Transition");
        this.containedIn.put("KeyAttribute", "KeyFrameSet");
        this.containedIn.put("KeyCycle", "KeyFrameSet");
        this.containedIn.put("KeyPosition", "KeyFrameSet");
        this.containedIn.put("KeyTrigger", "KeyFrameSet");
        this.containedIn.put("KeyTimeCycle", "KeyFrameSet");
        this.containedIn.put("OnClick", "Transition");
        this.containedIn.put("OnSwipe", "Transition");
        this.containedIn.put("CustomAttribute", "Constraint");
        this.containedIn.put("Motion", "Constraint");
        this.containedIn.put("Layout", "Constraint");
        this.containedIn.put("PropertySet", "Constraint");
        this.containedIn.put("Transform", "Constraint");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.myBanner.setText("Motion Editor cannot be used");
        this.myBanner.setOpaque(true);
        this.myBanner.setMinimumSize(new Dimension(1, MEUI.scale(16)));
        this.myBanner.setBackground(MEUI.ourBannerColor);
        this.add((Component)this.myBanner, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.myLabel.setText("Motion Editor");
        this.add((Component)this.myLabel, gbc);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.insets = MEUI.insets(10, 10, 10, 10);
        this.myLabel.setVerticalAlignment(3);
        this.myLabel.setHorizontalAlignment(0);
        Font font = this.myLabel.getFont();
        this.myLabel.setFont(font.deriveFont((float)font.getSize() * 2.0f));
        this.myErrorLabel.setVerticalAlignment(1);
        this.myErrorLabel.setText(null);
        this.add((Component)this.myErrorLabel, gbc);
        this.myErrorLabel.setForeground(MEUI.ourErrorColor);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.myBanner != null) {
            this.myBanner.setBackground(MEUI.ourBannerColor);
        }
    }

    public boolean validateMotionScene(MTag scene) {
        Object str = null;
        if (scene == null) {
            this.myErrorLabel.setText("<HTML>MotionScene Syntax error:<ul>No valid LayoutDescription</ul></HTML>");
            return false;
        }
        MTag[] layer0 = scene.getChildTags();
        for (int i2 = 0; i2 < layer0.length; ++i2) {
            String tagName = layer0[i2].getTagName();
            if (!this.validTop.contains(tagName)) {
                str = (String)(str != null ? (String)str + "\n" : "") + "<li> &lt;" + tagName + "&gt; cannot be a top level component </li>";
            }
            str = this.validateChildren(layer0[i2], (String)str);
        }
        if (str != null) {
            str = "<HTML>MotionScene Syntax error:<ul>" + str + "</ul></HTML>";
        }
        this.error = str;
        this.myErrorLabel.setText(this.error);
        return this.error == null;
    }

    public String validateChildren(MTag tag, String ret2) {
        MTag[] child = tag.getChildTags();
        String parent = tag.getTagName();
        for (int i2 = 0; i2 < child.length; ++i2) {
            String childName = child[i2].getTagName();
            if ("CustomAttribute".equals(childName) && (parent.equals("Constraint") || parent.equals("KeyCycle") || parent.equals("KeyAttribute") || parent.equals("KeyTimeCycle"))) continue;
            String shouldBeIn = this.containedIn.get(childName);
            if (shouldBeIn == null) {
                ret2 = (String)(ret2 != null ? (String)ret2 + "\n" : "") + "<li> &lt;" + childName + "&gt; of parent &lt;" + parent + "&gt; unknown</li>";
            }
            if (!parent.equals(shouldBeIn)) {
                ret2 = (String)(ret2 != null ? (String)ret2 + "\n" : "") + "<li> &lt;" + childName + "&gt; of parent &lt;" + parent + "&gt; should be in &lt;" + shouldBeIn + "&gt;</li>";
            }
            ret2 = this.validateChildren(child[i2], (String)ret2);
        }
        return ret2;
    }

    public static void main(String[] arg) {
        JFrame frame = new JFrame("  error panel ");
        frame.setContentPane(new ErrorPanel());
        frame.setBounds(100, 100, 500, 800);
        frame.setTitle("JFrame");
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

