/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.ui;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEIcons;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEJTable;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEScrollPane;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEUI;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.StringMTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.Track;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.ConstraintSetPanelCommands;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MeModel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditorSelector;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.Utils;
import com.android.tools.idea.uibuilder.handlers.motion.editor.utils.Debug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

class ConstraintSetPanel
extends JPanel {
    private MTag mSelectedTag;
    private MTag[] mMultiSelectedTag;
    MotionEditorSelector mListeners;
    private static boolean DEBUG = false;
    ArrayList<MTag> mParent;
    MTag mConstraintSet;
    ArrayList<MTag> mDisplayedRows = new ArrayList();
    JPopupMenu myPopupMenu = new JPopupMenu();
    DefaultTableModel mConstraintSetModel = new DefaultTableModel(new String[]{"Constraint", "ID", "Source"}, 0){

        public Class getColumnClass(int column) {
            return column == 0 ? Icon.class : String.class;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    };
    JTable mConstraintSetTable = new MEJTable(this.mConstraintSetModel);
    private String mDerived;
    boolean showAll = true;
    private MeModel mMeModel;
    private final JLabel mTitle;
    JButton mModifyMenu;
    boolean mBuildingTable;
    AbstractAction createConstraint = new AbstractAction("Create Constraint"){

        @Override
        public void actionPerformed(ActionEvent e) {
            Track.createConstraint(ConstraintSetPanel.this.mMeModel.myTrack);
            ConstraintSetPanelCommands.createConstraint(ConstraintSetPanel.this.mSelectedTag, ConstraintSetPanel.this.mConstraintSet);
            ConstraintSetPanel.this.buildTable();
        }
    };
    AbstractAction createSectionedConstraint = new AbstractAction("Create Sectioned Constraint"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ConstraintSetPanelCommands.createSectionedConstraint(ConstraintSetPanel.this.mMultiSelectedTag, ConstraintSetPanel.this.mConstraintSet);
            ConstraintSetPanel.this.buildTable();
        }
    };
    AbstractAction clearConstraint = new AbstractAction("Clear Constraint"){

        @Override
        public void actionPerformed(ActionEvent e) {
            Track.clearConstraint(ConstraintSetPanel.this.mMeModel.myTrack);
            ConstraintSetPanelCommands.clearConstraint(ConstraintSetPanel.this.mSelectedTag, ConstraintSetPanel.this.mConstraintSet);
            ConstraintSetPanel.this.buildTable();
        }
    };
    AbstractAction moveConstraint = new AbstractAction("Move Constraints to layout"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ConstraintSetPanelCommands.moveConstraint(ConstraintSetPanel.this.mSelectedTag, ConstraintSetPanel.this.mConstraintSet);
        }
    };
    AbstractAction overrideConstraint = new AbstractAction("Convert from sectioned constraints"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ConstraintSetPanelCommands.convertFromSectioned(ConstraintSetPanel.this.mSelectedTag, ConstraintSetPanel.this.mConstraintSet);
        }
    };
    private String mConstraintSetId;

    ConstraintSetPanel() {
        super(new BorderLayout());
        JPanel left2 = new JPanel(new GridBagLayout());
        JPanel right2 = new JPanel(new FlowLayout(2));
        JPanel top = new JPanel(new BorderLayout());
        top.add((Component)left2, "West");
        top.add((Component)right2, "East");
        top.setBorder(MEUI.getPanelBottomBorder());
        this.mConstraintSetTable.setShowHorizontalLines(false);
        this.mConstraintSetTable.setAlignmentY(0.0f);
        this.mConstraintSetTable.getColumnModel().getColumn(0).setPreferredWidth(MEUI.scale(32));
        this.mConstraintSetTable.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table2, value2, isSelected, hasFocus, row, column);
                this.setBorder(noFocusBorder);
                return this;
            }
        });
        this.mConstraintSetTable.setDefaultRenderer(Icon.class, new TableCellRenderer(){
            JLabel myLabel = new JLabel();

            @Override
            public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                this.myLabel.setIcon((Icon)value2);
                this.myLabel.setHorizontalAlignment(0);
                this.myLabel.setSize(new Dimension(MEUI.scale(18), MEUI.scale(12)));
                if (isSelected) {
                    if (value2 == MEIcons.LIST_STATE_DERIVED) {
                        this.myLabel.setIcon(MEIcons.LIST_STATE_DERIVED_SELECTED);
                    } else if (value2 == MEIcons.LIST_STATE) {
                        this.myLabel.setIcon(MEIcons.LIST_STATE_SELECTED);
                    }
                    this.myLabel.setBackground(table2.hasFocus() ? MEUI.CSPanel.our_SelectedFocusBackground : MEUI.CSPanel.our_SelectedBackground);
                    this.myLabel.setOpaque(true);
                } else {
                    this.myLabel.setOpaque(false);
                    this.myLabel.setBackground(MEUI.ourPrimaryPanelBackground);
                }
                return this.myLabel;
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel leftLabel = new JLabel("ConstraintSet (", MEIcons.CONSTRAINT_SET, 0);
        this.mTitle = new JLabel("", 0);
        JLabel rightLabel = new JLabel(")", 0);
        gbc.fill = 2;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.ipadx = 16;
        left2.add((Component)leftLabel, gbc);
        gbc.fill = 2;
        gbc.gridy = 0;
        ++gbc.gridx;
        gbc.weightx = 0.5;
        gbc.ipadx = 0;
        left2.add((Component)this.mTitle, gbc);
        gbc.fill = 2;
        gbc.gridy = 0;
        gbc.gridx = 2;
        gbc.weightx = 1.0;
        gbc.ipadx = 16;
        left2.add((Component)rightLabel, gbc);
        this.makeRightMenu(right2);
        ActionListener copyListener = e -> this.copy();
        ActionListener pasteListener = e -> this.paste();
        MEUI.addCopyPaste(copyListener, pasteListener, this.mConstraintSetTable);
        this.mConstraintSetTable.getSelectionModel().addListSelectionListener(e -> {
            MTag[] mTagArray;
            if (this.mBuildingTable) {
                return;
            }
            int index2 = this.mConstraintSetTable.getSelectedRow();
            int[] allSelect = this.mConstraintSetTable.getSelectedRows();
            this.mModifyMenu.setEnabled(index2 != -1);
            this.mSelectedTag = null;
            if (index2 == -1) {
                this.mSelectedTag = null;
                return;
            }
            this.mMultiSelectedTag = new MTag[allSelect.length];
            for (int i2 = 0; i2 < allSelect.length; ++i2) {
                int k = allSelect[i2];
                this.mMultiSelectedTag[i2] = this.mDisplayedRows.get(k);
            }
            if (this.mDisplayedRows.isEmpty()) {
                mTagArray = new MTag[]{};
            } else {
                MTag[] mTagArray2 = new MTag[1];
                mTagArray = mTagArray2;
                mTagArray2[0] = this.mSelectedTag = this.mDisplayedRows.get(index2);
            }
            MTag[] tag = mTagArray;
            this.mListeners.notifyListeners(MotionEditorSelector.Type.CONSTRAINT, tag, 0);
            this.enableMenuItems(tag);
        });
        MEScrollPane transitionProperties = new MEScrollPane(this.mConstraintSetTable);
        ((JComponent)((Object)transitionProperties)).setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)((Object)transitionProperties), "Center");
        this.add((Component)top, "North");
    }

    private void enableMenuItems(MTag[] selected) {
        boolean hasSelection = selected.length > 0;
        this.mModifyMenu.setEnabled(hasSelection);
        if (!hasSelection) {
            return;
        }
        boolean inCurrentSelection = false;
        MTag[] tags2 = this.mConstraintSet.getChildTags();
        for (int i2 = 0; i2 < tags2.length; ++i2) {
            if (!tags2[i2].equals(selected[0])) continue;
            inCurrentSelection = true;
            break;
        }
        if (inCurrentSelection) {
            this.createConstraint.setEnabled(false);
            this.createSectionedConstraint.setEnabled(false);
            this.clearConstraint.setEnabled(true);
            this.moveConstraint.setEnabled(true);
            this.overrideConstraint.setEnabled(true);
        } else {
            this.createConstraint.setEnabled(true);
            this.createSectionedConstraint.setEnabled(true);
            this.clearConstraint.setEnabled(false);
            this.moveConstraint.setEnabled(false);
            this.overrideConstraint.setEnabled(false);
        }
    }

    private void copy() {
        MEUI.copy(this.mSelectedTag);
    }

    private void paste() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            String buff = (String)clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor);
            StringMTag pastedTag = StringMTag.parse(buff);
            HashMap<String, MTag.Attribute> attr = pastedTag.getAttrList();
            if (this.mSelectedTag != null) {
                String tagName = this.mSelectedTag.getTagName();
                if ("Constraint".equals(tagName)) {
                    MTag.Attribute a;
                    HashMap<String, MTag.Attribute> toDel = new HashMap<String, MTag.Attribute>(this.mSelectedTag.getAttrList());
                    toDel.remove("id");
                    MTag.TagWriter writer = this.mSelectedTag.getTagWriter();
                    if (writer == null) {
                        return;
                    }
                    for (String s : toDel.keySet()) {
                        a = toDel.get(s);
                        writer.setAttribute(a.mNamespace, a.mAttribute, null);
                    }
                    for (String s : attr.keySet()) {
                        a = attr.get(s);
                        if (a == null || a.mAttribute.equals("id")) continue;
                        writer.setAttribute(a.mNamespace, a.mAttribute, a.mValue);
                    }
                    StringMTag[] children = pastedTag.getChildTags();
                    for (int i2 = 0; i2 < children.length; ++i2) {
                        StringMTag child = children[i2];
                        MTag.TagWriter cw = writer.getChildTagWriter(child.getTagName());
                        HashMap<String, MTag.Attribute> cwAttrMap = pastedTag.getAttrList();
                        for (String cwAttrStr : cwAttrMap.keySet()) {
                            MTag.Attribute cwAttr = cwAttrMap.get(cwAttrStr);
                            cw.setAttribute(cwAttr.mNamespace, cwAttr.mAttribute, cwAttr.mValue);
                        }
                    }
                    writer.commit("paste");
                } else if (!"Guideline".equals(tagName)) {
                    String id = this.mSelectedTag.getAttributeValue("id");
                    MTag.TagWriter writer = this.mConstraintSet.getChildTagWriter("Constraint");
                    for (String s : attr.keySet()) {
                        MTag.Attribute a = attr.get(s);
                        if (a == null || a.mAttribute.equals("id")) {
                            writer.setAttribute(a.mNamespace, a.mAttribute, "@+id/" + Utils.stripID(id));
                            continue;
                        }
                        writer.setAttribute(a.mNamespace, a.mAttribute, a.mValue);
                    }
                    StringMTag[] children = pastedTag.getChildTags();
                    for (int i3 = 0; i3 < children.length; ++i3) {
                        StringMTag child = children[i3];
                        MTag.TagWriter cw = writer.getChildTagWriter(child.getTagName());
                        HashMap<String, MTag.Attribute> cwAttrMap = pastedTag.getAttrList();
                        for (String cwAttrStr : cwAttrMap.keySet()) {
                            MTag.Attribute cwAttr = cwAttrMap.get(cwAttrStr);
                            cw.setAttribute(cwAttr.mNamespace, cwAttr.mAttribute, cwAttr.mValue);
                        }
                    }
                    writer.commit("paste");
                }
            }
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void makeRightMenu(JPanel right2) {
        this.mModifyMenu = MEUI.createToolBarButton(MEIcons.EDIT_MENU, MEIcons.EDIT_MENU_DISABLED, "modify constraint set");
        right2.add(this.mModifyMenu);
        this.mModifyMenu.setEnabled(false);
        this.myPopupMenu.add(this.createConstraint);
        this.myPopupMenu.add(this.clearConstraint);
        if (DEBUG) {
            this.myPopupMenu.add(this.moveConstraint);
            this.myPopupMenu.add(this.createSectionedConstraint);
            this.myPopupMenu.add(this.overrideConstraint);
        }
        this.mModifyMenu.addActionListener(e -> this.myPopupMenu.show(this.mModifyMenu, 0, 0));
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.myPopupMenu != null) {
            this.myPopupMenu.updateUI();
            int n = this.myPopupMenu.getComponentCount();
            for (int i2 = 0; i2 < n; ++i2) {
                Component component = this.myPopupMenu.getComponent(i2);
                if (!(component instanceof JComponent)) continue;
                ((JComponent)component).updateUI();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildTable() {
        this.mBuildingTable = true;
        try {
            Object[] row;
            int i2;
            HashSet<String> found = new HashSet<String>();
            this.mConstraintSetModel.setNumRows(0);
            this.mDisplayedRows.clear();
            if (this.mConstraintSet == null) {
                return;
            }
            String cset_id = Utils.stripID(this.mConstraintSet.getAttributeValue("id"));
            MTag[] sets = this.mConstraintSet.getChildTags("Constraint");
            String derived = this.mConstraintSet.getAttributeValue("deriveConstraintsFrom");
            if (DEBUG) {
                for (i2 = 0; i2 < sets.length; ++i2) {
                    MTag set = sets[i2];
                    Debug.log(i2 + " " + set.getTagName() + " " + set.getTreeId());
                }
            }
            for (i2 = 0; i2 < sets.length; ++i2) {
                MTag constraint = sets[i2];
                row = new Object[4];
                String id = Utils.stripID(constraint.getAttributeValue("id"));
                found.add(id);
                row[1] = id;
                ArrayList<MTag> children = constraint.getChildren();
                HashMap<String, MTag.Attribute> attrs = constraint.getAttrList();
                row[2] = cset_id;
                row[0] = MEIcons.LIST_STATE;
                this.mDisplayedRows.add(constraint);
                this.mConstraintSetModel.addRow(row);
            }
            if (this.showAll && this.mMeModel.layout != null) {
                MTag[] allViews = this.mMeModel.layout.getChildTags();
                for (int j = 0; j < allViews.length; ++j) {
                    row = new Object[4];
                    MTag view = allViews[j];
                    String layoutId = view.getAttributeValue("id");
                    if (layoutId == null) {
                        row[0] = view.getTagName().substring(1 + view.getTagName().lastIndexOf("/"));
                        continue;
                    }
                    if (found.contains(layoutId = Utils.stripID(layoutId))) continue;
                    row[1] = layoutId;
                    row[3] = derived == null ? "layout" : this.findFirstDefOfView(layoutId, this.mConstraintSet);
                    row[2] = row[3];
                    row[0] = "layout".equals(row[3]) ? null : MEIcons.LIST_STATE_DERIVED;
                    this.mDisplayedRows.add(view);
                    this.mConstraintSetModel.addRow(row);
                }
            }
            this.mConstraintSetModel.fireTableDataChanged();
        }
        finally {
            this.mBuildingTable = false;
        }
    }

    private void updateModelIfNecessary() {
        Set found;
        Set ids2 = Arrays.stream(this.mConstraintSet.getChildTags("Constraint")).map(view -> view.getAttributeValue("id")).filter(Objects::nonNull).collect(Collectors.toSet());
        if (this.showAll && this.mMeModel.layout != null) {
            Arrays.stream(this.mMeModel.layout.getChildTags()).map(view -> Utils.stripID(view.getAttributeValue("id"))).filter(Objects::nonNull).forEach(ids2::add);
        }
        if (!ids2.equals(found = this.mConstraintSetModel.getDataVector().stream().map(row -> row.get(1)).collect(Collectors.toSet()))) {
            this.buildTable();
        }
    }

    private String findFirstDefOfView(String viewId, MTag constraintSet) {
        MTag[] sets = constraintSet.getChildTags("Constraint");
        for (int i2 = 0; i2 < sets.length; ++i2) {
            String cid = Utils.stripID(sets[i2].getAttributeValue("id"));
            if (!viewId.equals(cid)) continue;
            return Utils.stripID(constraintSet.getAttributeValue("id"));
        }
        String derive = constraintSet.getAttributeValue("deriveConstraintsFrom");
        if (derive == null) {
            return "layout";
        }
        derive = Utils.stripID(derive);
        for (MTag child : this.mMeModel.motionScene.getChildren()) {
            String cid;
            if (!child.getTagName().equals("ConstraintSet") || !derive.equals(cid = Utils.stripID(child.getAttributeValue("id")))) continue;
            return this.findFirstDefOfView(viewId, child);
        }
        return "???";
    }

    private String getMask(ArrayList<MTag> children, HashMap<String, MTag.Attribute> attrs, String id) {
        if (children.size() == 0 || attrs.size() > 1 && id != null) {
            return "all";
        }
        Object mask = "";
        for (MTag child : children) {
            mask = (String)mask + (((String)mask).equals("") ? "" : "|") + child.getTagName();
        }
        return mask;
    }

    public void setMTag(MTag constraintSet, MeModel meModel) {
        if (DEBUG) {
            if (constraintSet == null) {
                Debug.logStack("setMTag constraintSet = null", 4);
            }
            Debug.log("ConstraintSetPanel.setMTag constraintSet = " + constraintSet);
            Debug.log("ConstraintSetPanel.setMTag motionScene = " + meModel.motionScene);
            Debug.log("ConstraintSetPanel.setMTag layout = " + meModel.layout);
        }
        String[] selected = this.mMeModel != null ? this.mMeModel.getSelectedViewIDs() : new String[]{};
        this.mMeModel = meModel;
        this.mConstraintSet = constraintSet;
        this.mDerived = null;
        if (this.mConstraintSet != null) {
            this.mMeModel.setSelected(MotionEditorSelector.Type.CONSTRAINT_SET, new MTag[]{constraintSet});
            String derived = this.mConstraintSet.getAttributeValue("deriveConstraintsFrom");
            if (derived != null) {
                this.mDerived = Utils.stripID(derived);
                MTag[] constraintSets = meModel.motionScene.getChildTags("ConstraintSet");
                this.mParent = this.getDerived(constraintSets, this.mDerived);
            }
            this.mConstraintSetId = Utils.stripID(this.mConstraintSet.getAttributeValue("id"));
            this.mTitle.setText(this.mConstraintSetId);
        } else if (this.mConstraintSetId != null) {
            this.mConstraintSet = this.mMeModel.getConstraintSet(this.mConstraintSetId);
        }
        this.buildTable();
        if (constraintSet != null) {
            HashSet<String> selectedSet = new HashSet<String>(Arrays.asList(selected));
            for (int i2 = 0; i2 < this.mConstraintSetModel.getRowCount(); ++i2) {
                String id = (String)this.mConstraintSetModel.getValueAt(i2, 1);
                if (!selectedSet.contains(id)) continue;
                this.mConstraintSetTable.addRowSelectionInterval(i2, i2);
            }
        }
    }

    public void clearSelection() {
        this.mConstraintSetTable.clearSelection();
    }

    ArrayList<MTag> getDerived(MTag[] constraintSets, String derived) {
        for (int i2 = 0; i2 < constraintSets.length; ++i2) {
            String id = Utils.stripID(constraintSets[i2].getAttributeValue("id"));
            if (!derived.equals(id)) continue;
            String also2 = constraintSets[i2].getAttributeValue("deriveConstraintsFrom");
            if (also2 != null) {
                also2 = Utils.stripID(also2);
                ArrayList<MTag> ret2 = this.getDerived(constraintSets, also2);
                ret2.add(0, constraintSets[i2]);
                return ret2;
            }
            ArrayList<MTag> ret3 = new ArrayList<MTag>();
            ret3.add(constraintSets[i2]);
            return ret3;
        }
        return new ArrayList<MTag>();
    }

    public void setListeners(MotionEditorSelector listeners) {
        this.mListeners = listeners;
        this.mListeners.addSelectionListener(new MotionEditorSelector.Listener(){
            boolean in = false;

            @Override
            public void selectionChanged(MotionEditorSelector.Type selection, MTag[] tag, int flags) {
                ArrayList<String> selectedIds = new ArrayList<String>();
                if (this.in) {
                    return;
                }
                this.in = true;
                ConstraintSetPanel.this.mBuildingTable = true;
                if (DEBUG) {
                    Debug.log(" selectionChanged " + selection);
                }
                if (selection == MotionEditorSelector.Type.CONSTRAINT) {
                    int i2;
                    HashSet<String> selectedSet = new HashSet<String>();
                    for (i2 = 0; i2 < tag.length; ++i2) {
                        MTag mTag = tag[i2];
                        String id = Utils.stripID(mTag.getAttributeValue("id"));
                        selectedSet.add(id);
                    }
                    ConstraintSetPanel.this.mConstraintSetTable.clearSelection();
                    for (i2 = 0; i2 < ConstraintSetPanel.this.mConstraintSetModel.getRowCount(); ++i2) {
                        String id = (String)ConstraintSetPanel.this.mConstraintSetModel.getValueAt(i2, 1);
                        if (!selectedSet.contains(id)) continue;
                        selectedIds.add(id);
                        ConstraintSetPanel.this.mConstraintSetTable.addRowSelectionInterval(i2, i2);
                    }
                }
                if (ConstraintSetPanel.this.isVisible() && selection.equals((Object)MotionEditorSelector.Type.CONSTRAINT)) {
                    ConstraintSetPanel.this.mMeModel.setSelectedViewIDs(selectedIds);
                }
                this.in = false;
                ConstraintSetPanel.this.mBuildingTable = false;
            }
        });
    }

    public void selectById(String[] ids2) {
        if (this.mConstraintSet == null) {
            if (this.mConstraintSetModel != null) {
                int count = this.mConstraintSetModel.getRowCount();
                for (int i2 = 0; i2 < count; ++i2) {
                    this.mConstraintSetModel.removeRow(0);
                }
            }
            return;
        }
        this.updateModelIfNecessary();
        HashSet<String> selectedSet = new HashSet<String>(Arrays.asList(ids2));
        this.mConstraintSetTable.clearSelection();
        for (int i3 = 0; i3 < this.mConstraintSetModel.getRowCount(); ++i3) {
            String id = (String)this.mConstraintSetModel.getValueAt(i3, 1);
            if (!selectedSet.contains(id)) continue;
            this.mConstraintSetTable.addRowSelectionInterval(i3, i3);
        }
    }
}

