/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEIcons;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEUI;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.Track;
import com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs.BaseCreatePanel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MeModel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.Utils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;

public class CreateOnSwipe
extends BaseCreatePanel {
    static String TITLE = "Create onSwipe";
    JComboBox<String> mTransitions = MEUI.makeComboBox(new String[0]);
    MTag[] mTransitionTags;
    JComboBox<String> mAnchorIdBox = MEUI.makeComboBox(new String[]{""});
    JComboBox<String> mDragDirection;
    JComboBox<String> mAnchorSide;
    String[] options = new String[]{"autoComplete", "Jump to Start", "Jump to End", "Animate to Start", "Animate to End"};
    JComboBox<String> comboBox = new JComboBox<String>(this.options);

    public CreateOnSwipe() {
        this.icon = MEIcons.CREATE_ON_SWIPE;
        GridBagConstraints gbc = new GridBagConstraints();
        int y = 0;
        CreateOnSwipe.grid(gbc, 0, y++, 1, 1);
        gbc.weighty = 0.0;
        gbc.ipadx = MEUI.scale(60);
        gbc.insets = MEUI.dialogLabelInsets();
        gbc.fill = 2;
        this.add((Component)new JLabel("CREATE ONSWIPE"), gbc);
        CreateOnSwipe.grid(gbc, 0, y++);
        gbc.weighty = 0.0;
        gbc.insets = MEUI.dialogSeparatorInsets();
        gbc.anchor = 10;
        this.add((Component)new JSeparator(), gbc);
        CreateOnSwipe.grid(gbc, 0, y++);
        gbc.weighty = 0.0;
        gbc.insets = MEUI.dialogLabelInsets();
        gbc.anchor = 10;
        this.add((Component)new JLabel("In Transition"), gbc);
        CreateOnSwipe.grid(gbc, 0, y++);
        gbc.insets = MEUI.dialogControlInsets();
        gbc.anchor = 10;
        this.add(this.mTransitions, gbc);
        CreateOnSwipe.grid(gbc, 0, y++);
        gbc.weighty = 0.0;
        gbc.insets = MEUI.dialogLabelInsets();
        gbc.anchor = 10;
        this.add((Component)new JLabel("Drag Direction"), gbc);
        CreateOnSwipe.grid(gbc, 0, y++);
        gbc.insets = MEUI.dialogControlInsets();
        gbc.anchor = 10;
        this.mDragDirection = this.newComboBox("dragUp", "dragDown", "dragLeft", "dragRight");
        this.add(this.mDragDirection, gbc);
        CreateOnSwipe.grid(gbc, 0, y++);
        gbc.weighty = 0.0;
        gbc.insets = MEUI.dialogLabelInsets();
        gbc.anchor = 10;
        this.add((Component)new JLabel("Anchor Side"), gbc);
        CreateOnSwipe.grid(gbc, 0, y++);
        gbc.insets = MEUI.dialogControlInsets();
        gbc.anchor = 10;
        this.mAnchorSide = this.newComboBox("Top", "Left", "Bottom", "Right");
        this.add(this.mAnchorSide, gbc);
        CreateOnSwipe.grid(gbc, 0, y++);
        gbc.weighty = 0.0;
        gbc.insets = MEUI.dialogLabelInsets();
        gbc.anchor = 10;
        this.add((Component)new JLabel("Anchor ID"), gbc);
        CreateOnSwipe.grid(gbc, 0, y++);
        gbc.insets = MEUI.dialogControlInsets();
        gbc.anchor = 10;
        this.add(this.mAnchorIdBox, gbc);
        gbc.weighty = 1.0;
        CreateOnSwipe.grid(gbc, 0, y++, 2, 1);
        this.add((Component)new JComponent(){}, gbc);
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.insets = MEUI.dialogBottomButtonInsets();
        gbc.anchor = 14;
        CreateOnSwipe.grid(gbc, 0, y++, 2, 1);
        JButton ok = new JButton("Add");
        this.add((Component)ok, gbc);
        ok.addActionListener(e -> this.create());
    }

    @Override
    protected boolean populateDialog() {
        MeModel model2 = this.mMotionEditor.getMeModel();
        this.mTransitionTags = model2.motionScene.getChildTags("Transition");
        if (this.mTransitionTags.length == 0) {
            this.showPreconditionDialog("You must create a transition first");
            return false;
        }
        this.mTransitions.removeAllItems();
        for (int i2 = 0; i2 < this.mTransitionTags.length; ++i2) {
            String id = Utils.stripID(this.mTransitionTags[i2].getAttributeValue("id"));
            String start2 = Utils.stripID(this.mTransitionTags[i2].getAttributeValue("constraintSetStart"));
            String end = Utils.stripID(this.mTransitionTags[i2].getAttributeValue("constraintSetEnd"));
            this.mTransitions.addItem(Utils.formatTransition(id, start2, end));
        }
        MTag tag = this.mMotionEditor.getSelectedTag();
        if (tag != null && tag.getTagName().equals("Transition")) {
            for (int i3 = 0; i3 < this.mTransitionTags.length; ++i3) {
                if (this.mTransitionTags[i3] != tag) continue;
                this.mTransitions.setSelectedIndex(i3);
            }
        }
        this.mAnchorIdBox.removeAllItems();
        this.mAnchorIdBox.addItem("(none)");
        if (model2.layout != null) {
            ArrayList<MTag> children = model2.layout.getChildren();
            for (MTag child : children) {
                String id = child.getAttributeValue("id");
                if (id == null) continue;
                this.mAnchorIdBox.addItem(Utils.stripID(id));
            }
        }
        return true;
    }

    @Override
    public MTag create() {
        String str;
        MTag transition = this.mTransitionTags[this.mTransitions.getSelectedIndex()];
        MeModel model2 = this.mMotionEditor.getMeModel();
        MTag.TagWriter writer = transition.getChildTagWriter("OnSwipe");
        if (this.mAnchorIdBox.getSelectedIndex() != 0) {
            str = (String)this.mAnchorIdBox.getSelectedItem();
            writer.setAttribute("motion", "touchAnchorId", this.addIdPrefix(str));
        }
        if (this.mDragDirection.getSelectedIndex() != 0) {
            str = (String)this.mDragDirection.getSelectedItem();
            writer.setAttribute("motion", "dragDirection", str);
        }
        if (this.mAnchorSide.getSelectedIndex() != 0) {
            str = (String)this.mAnchorSide.getSelectedItem();
            if (str != null) {
                str = str.toLowerCase(Locale.getDefault());
            }
            writer.setAttribute("motion", "touchAnchorSide", str);
        }
        MTag ret2 = writer.commit("Create OnSwipe");
        Track.createOnSwipe(this.mMotionEditor.myTrack);
        this.mMotionEditor.setMTag(model2);
        super.create();
        return ret2;
    }

    @Override
    public String getName() {
        return "Swipe Handler";
    }
}

