/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEIcons;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEUI;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.Track;
import com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs.BaseCreatePanel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MeModel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.Utils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;

public class CreateOnClick
extends BaseCreatePanel {
    static String TITLE = "Create OnClick";
    JComboBox<String> mTransitions = MEUI.makeComboBox(new String[0]);
    MTag[] mTransitionTags;
    JComboBox<String> viewIds = MEUI.makeComboBox(new String[]{"layout"});

    public CreateOnClick() {
        this.icon = MEIcons.CREATE_ON_CLICK;
        this.viewIds.setEditable(true);
        GridBagConstraints gbc = new GridBagConstraints();
        int y = 0;
        CreateOnClick.grid(gbc, 0, y++, 1, 1);
        gbc.weighty = 0.0;
        gbc.ipadx = MEUI.scale(60);
        gbc.insets = MEUI.dialogTitleInsets();
        gbc.fill = 2;
        this.add((Component)new JLabel("CREATE ONCLICK"), gbc);
        CreateOnClick.grid(gbc, 0, y++);
        gbc.weighty = 0.0;
        gbc.insets = MEUI.dialogSeparatorInsets();
        gbc.anchor = 10;
        this.add((Component)new JSeparator(), gbc);
        CreateOnClick.grid(gbc, 0, y++);
        gbc.weighty = 0.0;
        gbc.insets = MEUI.dialogLabelInsets();
        gbc.anchor = 10;
        this.add((Component)new JLabel("In Transition"), gbc);
        CreateOnClick.grid(gbc, 0, y++);
        gbc.insets = MEUI.dialogControlInsets();
        gbc.anchor = 10;
        this.add(this.mTransitions, gbc);
        CreateOnClick.grid(gbc, 0, y++);
        gbc.weighty = 0.0;
        gbc.insets = MEUI.dialogLabelInsets();
        gbc.anchor = 10;
        this.add((Component)new JLabel("View To Click"), gbc);
        CreateOnClick.grid(gbc, 0, y++);
        gbc.insets = MEUI.dialogControlInsets();
        gbc.anchor = 10;
        this.add(this.viewIds, gbc);
        gbc.fill = 2;
        gbc.weighty = 1.0;
        CreateOnClick.grid(gbc, 0, y++, 2, 1);
        this.add((Component)new JComponent(){}, gbc);
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.insets = MEUI.dialogBottomButtonInsets();
        gbc.anchor = 14;
        CreateOnClick.grid(gbc, 0, y++, 2, 1);
        JButton ok = new JButton("Add");
        this.add((Component)ok, gbc);
        ok.addActionListener(e -> this.create());
    }

    @Override
    protected boolean populateDialog() {
        MeModel model2 = this.mMotionEditor.getMeModel();
        this.mTransitionTags = model2.motionScene.getChildTags("Transition");
        this.mTransitions.removeAllItems();
        for (int i2 = 0; i2 < this.mTransitionTags.length; ++i2) {
            String id = Utils.stripID(this.mTransitionTags[i2].getAttributeValue("id"));
            String start2 = Utils.stripID(this.mTransitionTags[i2].getAttributeValue("constraintSetStart"));
            String end = Utils.stripID(this.mTransitionTags[i2].getAttributeValue("constraintSetEnd"));
            this.mTransitions.addItem(Utils.formatTransition(id, start2, end));
        }
        MTag tag = this.mMotionEditor.getSelectedTag();
        if (tag != null && tag.getTagName().equals("Transition")) {
            for (int i3 = 0; i3 < this.mTransitionTags.length; ++i3) {
                if (this.mTransitionTags[i3] != tag) continue;
                this.mTransitions.setSelectedIndex(i3);
            }
        }
        this.viewIds.removeAllItems();
        this.viewIds.addItem("(Base Layout)");
        if (model2.layout != null) {
            ArrayList<MTag> children = model2.layout.getChildren();
            for (MTag child : children) {
                String id = child.getAttributeValue("id");
                if (id == null) continue;
                this.viewIds.addItem(Utils.stripID(id));
            }
        }
        return true;
    }

    @Override
    public String getName() {
        return "Click Handler";
    }

    @Override
    public MTag create() {
        MTag transition = this.mTransitionTags[this.mTransitions.getSelectedIndex()];
        MeModel model2 = this.mMotionEditor.getMeModel();
        MTag.TagWriter writer = transition.getChildTagWriter("OnClick");
        if (this.viewIds.getSelectedIndex() != 0) {
            String str = (String)this.viewIds.getSelectedItem();
            writer.setAttribute("motion", "targetId", this.addIdPrefix(str));
        }
        MTag ret2 = writer.commit("Create OnClick");
        Track.createOnClick(this.mMotionEditor.myTrack);
        this.mMotionEditor.setMTag(model2);
        super.create();
        return ret2;
    }
}

