/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion;

import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Placeholder;
import com.android.tools.idea.common.scene.Region;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SnappingInfo;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.uibuilder.handlers.common.ViewGroupPlaceholder;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.GuidelineTarget;
import com.android.tools.idea.uibuilder.handlers.motion.editor.targets.MotionLayoutDragTarget;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scout.Scout;
import com.android.tools.idea.uibuilder.scout.ScoutArrange;
import com.android.tools.idea.uibuilder.scout.ScoutWidget;
import java.awt.Point;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J(\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/uibuilder/handlers/motion/MotionLayoutPlaceholder;", "Lcom/android/tools/idea/common/scene/Placeholder;", "host", "Lcom/android/tools/idea/common/scene/SceneComponent;", "(Lcom/android/tools/idea/common/scene/SceneComponent;)V", "delegator", "Lcom/android/tools/idea/uibuilder/handlers/common/ViewGroupPlaceholder;", "dominate", "", "getDominate", "()Z", "isLiveUpdatable", "region", "Lcom/android/tools/idea/common/scene/Region;", "getRegion", "()Lcom/android/tools/idea/common/scene/Region;", "snap", "info", "Lcom/android/tools/idea/common/scene/SnappingInfo;", "retPoint", "Ljava/awt/Point;", "updateAttribute", "", "sceneComponent", "attributes", "Lcom/android/tools/idea/common/model/NlAttributesHolder;", "updateLiveAttribute", "x", "", "y", "intellij.android.designer"})
public final class MotionLayoutPlaceholder
extends Placeholder {
    private final ViewGroupPlaceholder delegator;
    private final boolean isLiveUpdatable;
    private final boolean dominate;
    @NotNull
    private final Region region;

    @Override
    public boolean isLiveUpdatable() {
        return this.isLiveUpdatable;
    }

    @Override
    public boolean getDominate() {
        return this.dominate;
    }

    @Override
    @NotNull
    public Region getRegion() {
        return this.region;
    }

    @Override
    public boolean snap(@NotNull SnappingInfo info2, @NotNull Point retPoint) {
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        Intrinsics.checkNotNullParameter((Object)retPoint, (String)"retPoint");
        return this.delegator.snap(info2, retPoint);
    }

    @Override
    public void updateAttribute(@NotNull SceneComponent sceneComponent, @NotNull NlAttributesHolder attributes) {
        Intrinsics.checkNotNullParameter((Object)sceneComponent, (String)"sceneComponent");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        this.updateLiveAttribute(sceneComponent, attributes, sceneComponent.getDrawX(), sceneComponent.getDrawY());
    }

    @Override
    public void updateLiveAttribute(@NotNull SceneComponent sceneComponent, @NotNull NlAttributesHolder attributes, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)sceneComponent, (String)"sceneComponent");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        if (ConstraintComponentUtilities.isGuideLine(sceneComponent.getAuthoritativeNlComponent())) {
            boolean horizontal = Intrinsics.areEqual((Object)attributes.getAndroidAttribute("orientation"), (Object)"vertical") ^ true;
            new GuidelineTarget.GuidelineDropHandler(sceneComponent, horizontal).updateAttributes(attributes, x, y);
        } else if (!(sceneComponent instanceof TemporarySceneComponent)) {
            new MotionLayoutDragTarget.DropHandler(sceneComponent).updateAttributes(attributes, this.getHost(), x, y);
        } else {
            NlComponent nlComponent = ((TemporarySceneComponent)sceneComponent).getAuthoritativeNlComponent();
            Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"sceneComponent.authoritativeNlComponent");
            NlComponent nlComponent2 = nlComponent;
            boolean horizontalMatchParent = false;
            boolean verticalMatchParent = false;
            if (Intrinsics.areEqual((Object)"match_parent", (Object)attributes.getAttribute("http://schemas.android.com/apk/res/android", "layout_width"))) {
                horizontalMatchParent = true;
            }
            if (Intrinsics.areEqual((Object)"match_parent", (Object)attributes.getAttribute("http://schemas.android.com/apk/res/android", "layout_height"))) {
                verticalMatchParent = true;
            }
            if (horizontalMatchParent || verticalMatchParent) {
                AttributesTransaction attributesTransaction = nlComponent2.startAttributeTransaction();
                Intrinsics.checkNotNullExpressionValue((Object)attributesTransaction, (String)"nlComponent.startAttributeTransaction()");
                AttributesTransaction transaction = attributesTransaction;
                Scene scene = this.getHost().getScene();
                Intrinsics.checkNotNullExpressionValue((Object)scene, (String)"host.scene");
                NlComponentHelperKt.setX(nlComponent2, Coordinates.dpToPx(scene.getSceneManager(), (float)x));
                Scene scene2 = this.getHost().getScene();
                Intrinsics.checkNotNullExpressionValue((Object)scene2, (String)"host.scene");
                NlComponentHelperKt.setY(nlComponent2, Coordinates.dpToPx(scene2.getSceneManager(), (float)y));
                ScoutWidget parentScoutWidget = new ScoutWidget(this.getHost().getNlComponent(), null);
                ScoutWidget[] scoutWidgets = ScoutWidget.create(CollectionsKt.listOf((Object)nlComponent2), parentScoutWidget);
                int margin = Scout.getMargin();
                if (horizontalMatchParent) {
                    ScoutArrange.expandHorizontally(scoutWidgets, parentScoutWidget, margin, false);
                }
                if (verticalMatchParent) {
                    ScoutArrange.expandVertically(scoutWidgets, parentScoutWidget, margin, false);
                }
                transaction.apply();
            }
        }
    }

    public MotionLayoutPlaceholder(@NotNull SceneComponent host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        super(host);
        this.delegator = new ViewGroupPlaceholder(host);
        this.isLiveUpdatable = true;
        this.region = this.delegator.getRegion();
    }
}

