/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.linear.targets;

import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.target.DragBaseTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.handlers.linear.LinearLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.linear.targets.LinearSeparatorTarget;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.scene.target.TargetSnapper;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinearDragTarget
extends DragBaseTarget {
    private final LinearLayoutHandler myHandler;
    private final boolean myIsDragFromPalette;
    private LinearSeparatorTarget myClosest;

    public LinearDragTarget(@NotNull LinearLayoutHandler handler2) {
        if (handler2 == null) {
            LinearDragTarget.$$$reportNull$$$0(0);
        }
        this(handler2, false);
    }

    public LinearDragTarget(@NotNull LinearLayoutHandler handler2, boolean fromPalette) {
        if (handler2 == null) {
            LinearDragTarget.$$$reportNull$$$0(1);
        }
        this.myHandler = handler2;
        this.myIsDragFromPalette = fromPalette;
    }

    @Override
    protected void updateAttributes(@NotNull NlAttributesHolder attributes, int x, int y) {
        if (attributes == null) {
            LinearDragTarget.$$$reportNull$$$0(2);
        }
    }

    @Override
    public void mouseDown(int x, int y) {
        SceneComponent parent = this.myComponent.getParent();
        assert (parent != null);
        this.myHandler.setDragging(this.myComponent, true);
        ((LayoutlibSceneManager)parent.getScene().getSceneManager()).updateTargets();
        super.mouseDown(x, y);
    }

    @Override
    public void mouseDrag(int x, int y, @NotNull List<Target> closestTargets, @NotNull SceneContext ignored) {
        Target closestTarget;
        if (closestTargets == null) {
            LinearDragTarget.$$$reportNull$$$0(3);
        }
        if (ignored == null) {
            LinearDragTarget.$$$reportNull$$$0(4);
        }
        SceneComponent sceneParent = this.myComponent.getParent();
        assert (sceneParent != null);
        this.myComponent.setDragging(true);
        TargetSnapper snapper = this.getTargetNotchSnapper();
        x -= this.myOffsetX;
        y -= this.myOffsetY;
        if (this.myHandler.isVertical(sceneParent.getNlComponent())) {
            int middle = this.myComponent.getDrawHeight() / 2;
            int parentHeight = sceneParent.getDrawHeight();
            int nx = this.myIsDragFromPalette ? x : this.myComponent.getDrawX();
            int ny = Math.min(Math.max(y, -middle), parentHeight + middle);
            ny = snapper.trySnapVertical(ny).orElse(ny);
            this.myComponent.setPosition(nx, ny);
            closestTarget = snapper.getSnappedVerticalTarget();
        } else {
            int middle = this.myComponent.getDrawWidth() / 2;
            int parentWidth = sceneParent.getDrawWidth();
            int nx = Math.min(Math.max(x, -middle), parentWidth + middle);
            nx = snapper.trySnapHorizontal(nx).orElse(nx);
            int ny = this.myIsDragFromPalette ? y : this.myComponent.getDrawY();
            this.myComponent.setPosition(nx, ny);
            closestTarget = snapper.getSnappedHorizontalTarget();
        }
        if (this.myClosest != closestTarget) {
            if (this.myClosest != null) {
                this.myClosest.setHighlight(false);
            }
            if (closestTarget instanceof LinearSeparatorTarget) {
                this.myClosest = (LinearSeparatorTarget)closestTarget;
                this.myClosest.setHighlight(true, this.myComponent.getDrawWidth(), this.myComponent.getDrawHeight());
            } else {
                this.myClosest = null;
            }
        }
        this.myComponent.getScene().repaint();
    }

    @Override
    public void mouseRelease(int x, int y, @NotNull List<Target> closestTarget) {
        if (closestTarget == null) {
            LinearDragTarget.$$$reportNull$$$0(5);
        }
        super.mouseRelease(x, y, closestTarget);
        this.myHandler.setDragging(this.myComponent, false);
        SceneComponent parent = this.myComponent.getParent();
        assert (parent != null);
        parent.updateTargets();
        if (this.myClosest != null) {
            this.myClosest.setHighlight(false);
            if (!LinearLayoutHandler.insertComponentAtTarget(this.myComponent, this.myClosest)) {
                this.myComponent.getScene().markNeedsLayout(2);
            }
        } else {
            this.myComponent.getScene().markNeedsLayout(2);
        }
    }

    @Override
    public void mouseCancel() {
        this.myHandler.setDragging(this.myComponent, false);
        SceneComponent parent = this.myComponent.getParent();
        if (parent != null) {
            parent.updateTargets();
        }
        if (this.myClosest != null) {
            this.myClosest.setHighlight(false);
        }
        super.mouseCancel();
    }

    @Nullable
    public LinearSeparatorTarget getClosest() {
        return this.myClosest;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closestTargets";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closestTarget";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/linear/targets/LinearDragTarget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updateAttributes";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseDrag";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseRelease";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

