/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.targets;

import com.android.SdkConstants;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.BaseTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.api.actions.ToggleAutoConnectAction;
import com.android.tools.idea.uibuilder.handlers.constraint.ComponentModification;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawHorizontalGuideline;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawVerticalGuideline;
import com.android.tools.idea.uibuilder.scene.target.TargetSnapper;
import com.google.common.collect.ImmutableList;
import java.awt.Cursor;
import java.util.List;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuidelineTarget
extends BaseTarget {
    protected int myOffsetX;
    protected int myOffsetY;
    protected int myFirstMouseX;
    protected int myFirstMouseY;
    protected boolean myChangedComponent;
    @NotNull
    private final TargetSnapper myTargetSnapper = new TargetSnapper();
    protected final boolean myIsHorizontal;
    private int myBegin = 20;
    private int myEnd = -1;
    private float myPercent = -1.0f;
    private GuidelineDropHandler myDropHandler;

    public GuidelineTarget(boolean isHorizontal) {
        this.myIsHorizontal = isHorizontal;
    }

    @Override
    public void setComponent(@NotNull SceneComponent component) {
        if (component == null) {
            GuidelineTarget.$$$reportNull$$$0(0);
        }
        super.setComponent(component);
        this.myDropHandler = new GuidelineDropHandler(component, this.myIsHorizontal);
    }

    @Override
    public void mouseDown(int x, int y) {
        if (this.myComponent.getParent() == null) {
            return;
        }
        this.myFirstMouseX = x;
        this.myFirstMouseY = y;
        this.myOffsetX = x - this.myComponent.getDrawX(System.currentTimeMillis());
        this.myOffsetY = y - this.myComponent.getDrawY(System.currentTimeMillis());
        this.myChangedComponent = false;
        this.myTargetSnapper.reset();
        this.myTargetSnapper.gatherNotches(this.myComponent);
    }

    @Override
    public void mouseDrag(int x, int y, @NotNull List<Target> closestTargets, @NotNull SceneContext ignored) {
        if (closestTargets == null) {
            GuidelineTarget.$$$reportNull$$$0(1);
        }
        if (ignored == null) {
            GuidelineTarget.$$$reportNull$$$0(2);
        }
        if (this.myComponent.getParent() == null) {
            return;
        }
        this.myComponent.setDragging(true);
        NlComponent component = this.myComponent.getAuthoritativeNlComponent();
        int snappedX = this.myTargetSnapper.trySnapHorizontal(x -= this.myOffsetX).orElse(x);
        int snappedY = this.myTargetSnapper.trySnapVertical(y -= this.myOffsetY).orElse(y);
        ComponentModification modification = new ComponentModification(component, "Drag");
        this.updateAttributes(modification, snappedX, snappedY);
        modification.apply();
        component.fireLiveChangeEvent();
        this.myComponent.getScene().markNeedsLayout(1);
        this.myChangedComponent = true;
    }

    @Override
    public void mouseRelease(int x, int y, @NotNull List<Target> closestTargets) {
        if (closestTargets == null) {
            GuidelineTarget.$$$reportNull$$$0(3);
        }
        if (!this.myComponent.isDragging()) {
            return;
        }
        this.myComponent.setDragging(false);
        if (this.myComponent.getParent() != null) {
            boolean commitChanges = true;
            if (Math.abs(x - this.myFirstMouseX) <= 1 && Math.abs(y - this.myFirstMouseY) <= 1) {
                commitChanges = false;
            }
            NlComponent component = this.myComponent.getAuthoritativeNlComponent();
            ComponentModification modification = new ComponentModification(component, "Drag");
            int snappedX = this.myTargetSnapper.trySnapHorizontal(x -= this.myOffsetX).orElse(x);
            int snappedY = this.myTargetSnapper.trySnapVertical(y -= this.myOffsetY).orElse(y);
            if (this.isAutoConnectionEnabled()) {
                this.myTargetSnapper.applyNotches(modification);
            }
            this.updateAttributes(modification, snappedX, snappedY);
            modification.apply();
            if (commitChanges) {
                modification.commit();
            }
        }
        if (this.myChangedComponent) {
            this.myComponent.getScene().markNeedsLayout(1);
        }
    }

    @Override
    public void mouseCancel() {
        int originalX = this.myFirstMouseX - this.myOffsetX;
        int originalY = this.myFirstMouseY - this.myOffsetY;
        this.myComponent.setPosition(originalX, originalY);
        NlComponent component = this.myComponent.getAuthoritativeNlComponent();
        AttributesTransaction transaction = component.startAttributeTransaction();
        transaction.rollback();
        component.fireLiveChangeEvent();
        this.myComponent.setDragging(false);
        this.myTargetSnapper.reset();
        this.myChangedComponent = false;
        this.myComponent.getScene().markNeedsLayout(1);
    }

    private boolean isAutoConnectionEnabled() {
        return !SdkConstants.CONSTRAINT_LAYOUT_GUIDELINE.isEqualsIgnoreCase(this.myComponent.getNlComponent().getTagName()) && ToggleAutoConnectAction.isAutoconnectOn();
    }

    @Override
    public int getPreferenceLevel() {
        return 40;
    }

    @Override
    protected boolean isHittable() {
        if (this.myComponent.isSelected()) {
            return this.myComponent.canShowBaseline() || !this.myComponent.isDragging();
        }
        return true;
    }

    @Override
    public Cursor getMouseCursor(@JdkConstants.InputEventMask int modifiersEx) {
        if (this.myIsHorizontal) {
            return Cursor.getPredefinedCursor(8);
        }
        return Cursor.getPredefinedCursor(11);
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        if (list == null) {
            GuidelineTarget.$$$reportNull$$$0(4);
        }
        if (sceneContext == null) {
            GuidelineTarget.$$$reportNull$$$0(5);
        }
        if (this.myIsHorizontal) {
            int y = (int)(this.myTop + (this.myBottom - this.myTop) / 2.0f);
            SceneComponent parent = this.myComponent.getParent();
            DrawHorizontalGuideline.add(list, sceneContext, this.myLeft, y, this.myRight, parent.getDrawX(), parent.getDrawY(), parent.getDrawHeight(), this.myBegin, this.myEnd, this.myPercent, this.myComponent.isSelected());
        } else {
            int x = (int)(this.myLeft + (this.myRight - this.myLeft) / 2.0f);
            SceneComponent parent = this.myComponent.getParent();
            DrawVerticalGuideline.add(list, sceneContext, x, this.myTop, this.myBottom, parent.getDrawX(), parent.getDrawY(), parent.getDrawWidth(), this.myBegin, this.myEnd, this.myPercent, this.myComponent.isSelected());
        }
    }

    @Override
    public boolean layout(@NotNull SceneContext sceneTransform, int l, int t, int r, int b) {
        if (sceneTransform == null) {
            GuidelineTarget.$$$reportNull$$$0(6);
        }
        int dist = 6;
        SceneComponent parent = this.myComponent.getParent();
        if (parent != null) {
            if (this.myIsHorizontal) {
                this.myLeft = parent.getDrawX();
                this.myRight = parent.getDrawX() + parent.getDrawWidth();
                this.myTop = t - dist;
                this.myBottom = t + dist;
            } else {
                this.myLeft = l - dist;
                this.myRight = l + dist;
                this.myTop = parent.getDrawY();
                this.myBottom = parent.getDrawY() + parent.getDrawHeight();
            }
        }
        NlComponent component = this.myComponent.getAuthoritativeNlComponent();
        String begin = component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin");
        String end = component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end");
        String percent = component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_percent");
        if (begin != null) {
            this.myBegin = ConstraintComponentUtilities.getDpValue(component, begin);
            this.myEnd = -1;
            this.myPercent = -1.0f;
        } else if (end != null) {
            this.myBegin = -1;
            this.myEnd = ConstraintComponentUtilities.getDpValue(component, end);
            this.myPercent = -1.0f;
        } else if (percent != null) {
            this.myBegin = -1;
            this.myEnd = -1;
            try {
                this.myPercent = Float.valueOf(percent).floatValue();
            }
            catch (NumberFormatException e) {
                this.myPercent = 0.0f;
            }
        }
        return false;
    }

    protected void updateAttributes(@NotNull NlAttributesHolder attributes, int x, int y) {
        if (attributes == null) {
            GuidelineTarget.$$$reportNull$$$0(7);
        }
        this.myDropHandler.updateAttributes(attributes, x, y);
    }

    @Override
    public String getToolTipText() {
        Object str = "Guideline (";
        if (this.myBegin != -1) {
            str = (String)str + "< " + this.myBegin + ")";
        } else if (this.myEnd != -1) {
            str = (String)str + this.myEnd + " >)";
        } else {
            float percentValue = this.myPercent;
            if (percentValue > 1.0f) {
                percentValue = 1.0f;
            }
            if (percentValue < 0.0f) {
                percentValue = 0.0f;
            }
            str = !Float.isNaN(percentValue = (float)(100 * Math.round(percentValue * 100.0f)) / 100.0f) ? (String)str + String.valueOf(percentValue) + "%)" : (String)str + "50";
        }
        return str;
    }

    @Override
    @Nullable
    public List<SceneComponent> newSelection() {
        return ImmutableList.of((Object)this.getComponent());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closestTargets";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneTransform";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/targets/GuidelineTarget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setComponent";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseDrag";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseRelease";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "render";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "layout";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "updateAttributes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class GuidelineDropHandler {
        @NotNull
        private SceneComponent myComponent;
        private boolean myHorizontal;

        public GuidelineDropHandler(@NotNull SceneComponent component, boolean horizontal) {
            if (component == null) {
                GuidelineDropHandler.$$$reportNull$$$0(0);
            }
            this.myComponent = component;
            this.myHorizontal = horizontal;
        }

        public void updateAttributes(@NotNull NlAttributesHolder attributes, int x, int y) {
            if (attributes == null) {
                GuidelineDropHandler.$$$reportNull$$$0(1);
            }
            String begin = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin");
            String end = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end");
            String percent = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_percent");
            SceneComponent parent = this.myComponent.getParent();
            int value2 = y - parent.getDrawY();
            float dimension2 = parent.getDrawHeight();
            if (!this.myHorizontal) {
                value2 = x - parent.getDrawX();
                dimension2 = parent.getDrawWidth();
            }
            if (begin != null || end == null && percent == null) {
                String position = String.format("%ddp", value2);
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin", position);
            } else if (end != null) {
                String position = String.format("%ddp", (int)dimension2 - value2);
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end", position);
            } else {
                String percentStringValue;
                float percentValue = (float)value2 / dimension2;
                if (percentValue > 1.0f) {
                    percentValue = 1.0f;
                }
                if (percentValue < 0.0f) {
                    percentValue = 0.0f;
                }
                if ((percentStringValue = String.valueOf(percentValue = (float)Math.round(percentValue * 100.0f) / 100.0f)).equalsIgnoreCase("NaN")) {
                    percentStringValue = "0.5";
                }
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_percent", percentStringValue);
            }
            ConstraintComponentUtilities.cleanup(attributes, this.myComponent.getNlComponent());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/targets/GuidelineTarget$GuidelineDropHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateAttributes";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

