/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.model;

import com.android.tools.idea.uibuilder.handlers.constraint.model.ConstraintAnchor;
import com.android.tools.idea.uibuilder.handlers.constraint.model.ConstraintAnchorConstants;
import com.android.tools.idea.uibuilder.handlers.constraint.model.ConstraintWidget;
import com.android.tools.idea.uibuilder.handlers.constraint.model.Rectangle;
import java.util.ArrayList;

public class Guideline
extends ConstraintWidget {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private ConstraintAnchor mAnchor;
    private int mOrientation;
    private final Rectangle mHead;

    public Guideline() {
        this.mAnchor = this.mTop;
        this.mOrientation = 0;
        this.mHead = new Rectangle();
        this.mAnchors.clear();
        this.mAnchors.add(this.mAnchor);
        int count = this.mListAnchors.length;
        for (int i2 = 0; i2 < count; ++i2) {
            this.mListAnchors[i2] = this.mAnchor;
        }
    }

    public Rectangle getHead() {
        int headSize = 8;
        this.mHead.setBounds(this.getDrawX() - headSize, this.getDrawY() - 2 * headSize, 2 * headSize, 2 * headSize);
        if (this.getOrientation() == 0) {
            this.mHead.setBounds(this.getDrawX() - 2 * headSize, this.getDrawY() - headSize, 2 * headSize, 2 * headSize);
        }
        return this.mHead;
    }

    public void setOrientation(int orientation) {
        if (this.mOrientation == orientation) {
            return;
        }
        this.mOrientation = orientation;
        this.mAnchors.clear();
        this.mAnchor = this.mOrientation == 1 ? this.mLeft : this.mTop;
        this.mAnchors.add(this.mAnchor);
        int count = this.mListAnchors.length;
        for (int i2 = 0; i2 < count; ++i2) {
            this.mListAnchors[i2] = this.mAnchor;
        }
    }

    public ConstraintAnchor getAnchor() {
        return this.mAnchor;
    }

    @Override
    public String getType() {
        return "Guideline";
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    @Override
    public ConstraintAnchor getAnchor(ConstraintAnchorConstants.Type anchorType) {
        switch (anchorType) {
            case LEFT: 
            case RIGHT: {
                if (this.mOrientation != 1) break;
                return this.mAnchor;
            }
            case TOP: 
            case BOTTOM: {
                if (this.mOrientation != 0) break;
                return this.mAnchor;
            }
            case BASELINE: 
            case CENTER: 
            case CENTER_X: 
            case CENTER_Y: 
            case NONE: {
                return null;
            }
        }
        throw new AssertionError((Object)anchorType.name());
    }

    @Override
    public ArrayList<ConstraintAnchor> getAnchors() {
        return this.mAnchors;
    }
}

