/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.AttrResourceValueImpl;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.ComponentProvider;
import com.android.tools.idea.common.scene.Placeholder;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.target.AnchorTarget;
import com.android.tools.idea.common.scene.target.LassoTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.ui.resourcechooser.util.ResourceChooserHelperKt;
import com.android.tools.idea.ui.resourcemanager.ResourcePickerDialog;
import com.android.tools.idea.uibuilder.actions.ChainStyleViewActions;
import com.android.tools.idea.uibuilder.actions.ToggleAllLiveRenderingAction;
import com.android.tools.idea.uibuilder.analytics.NlAnalyticsManager;
import com.android.tools.idea.uibuilder.api.CustomPanel;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.actions.DirectViewAction;
import com.android.tools.idea.uibuilder.api.actions.NestedViewActionMenu;
import com.android.tools.idea.uibuilder.api.actions.ToggleAutoConnectAction;
import com.android.tools.idea.uibuilder.api.actions.ToggleViewAction;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.api.actions.ViewActionMenu;
import com.android.tools.idea.uibuilder.api.actions.ViewActionPresentation;
import com.android.tools.idea.uibuilder.api.actions.ViewActionSeparator;
import com.android.tools.idea.uibuilder.api.actions.ViewActionUtils;
import com.android.tools.idea.uibuilder.handlers.constraint.ComponentModification;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintDragHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintHelperHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintPlaceholder;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintReferenceManagement;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintSceneInteraction;
import com.android.tools.idea.uibuilder.handlers.constraint.MarginPopup;
import com.android.tools.idea.uibuilder.handlers.constraint.WidgetConstraintPanel;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.ConstraintLayoutComponentNotchProvider;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.ConstraintLayoutNotchProvider;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.WidgetDraw;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.decorator.WidgetDecoratorConstants;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.BarrierAnchorTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.BarrierTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.BaseLineToggleViewAction;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ConstraintAnchorTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ConstraintDragTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ConstraintResizeTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.GuidelineAnchorTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.GuidelineCycleTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.GuidelineTarget;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.target.ResizeBaseTarget;
import com.android.tools.idea.uibuilder.scout.Scout;
import com.android.tools.idea.uibuilder.scout.ScoutMotionConvert;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.LafIconLookup;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstraintLayoutHandler
extends ViewGroupHandler
implements ComponentProvider {
    private static final String PREFERENCE_KEY_PREFIX = "ConstraintLayoutPreference";
    public static final String SHOW_CONSTRAINTS_PREF_KEY = "ConstraintLayoutPreferenceShowAllConstraints";
    public static final String SHOW_MARGINS_PREF_KEY = "ConstraintLayoutPreferenceShowMargins";
    public static final String FADE_UNSELECTED_VIEWS = "ConstraintLayoutPreferenceFadeUnselected";
    private static final String ADD_VERTICAL_BARRIER = "Vertical Barrier";
    private static final String ADD_HORIZONTAL_BARRIER = "Horizontal Barrier";
    private static final String ADD_TO_BARRIER = "Barrier";
    private static final String ADD_LAYER = "Layer";
    private static final String ADD_GROUP = "Group";
    private static final String ADD_CONSTRAINTS_SET = "Set of Constraints";
    private static final String ADD_FLOW = "Flow";
    private static HashMap<String, Boolean> ourVisibilityFlags = new HashMap();
    private static HashSet<String> ourHorizontalBarriers = new HashSet<String>(Arrays.asList("top", "bottom"));

    public ConstraintLayoutHandler() {
        ConstraintLayoutHandler.loadWidgetDecoratorImages();
    }

    private static void loadWidgetDecoratorImages() {
        if (WidgetDecoratorConstants.sLockImageIcon == null) {
            WidgetDecoratorConstants.sLockImageIcon = ImageUtils.iconToImage((Icon)StudioIcons.LayoutEditor.Toolbar.LOCK);
        }
        if (WidgetDecoratorConstants.sUnlockImageIcon == null) {
            WidgetDecoratorConstants.sUnlockImageIcon = ImageUtils.iconToImage((Icon)StudioIcons.LayoutEditor.Toolbar.UNLOCK);
        }
        if (WidgetDecoratorConstants.sDeleteConnectionsImageIcon == null) {
            WidgetDecoratorConstants.sDeleteConnectionsImageIcon = ImageUtils.iconToImage((Icon)StudioIcons.LayoutEditor.Toolbar.CLEAR_CONSTRAINTS);
        }
        if (WidgetDecoratorConstants.sPackChainImageIcon == null) {
            WidgetDecoratorConstants.sPackChainImageIcon = ImageUtils.iconToImage((Icon)StudioIcons.LayoutEditor.Toolbar.CYCLE_CHAIN_PACKED);
        }
        if (WidgetDraw.sGuidelineArrowLeft == null) {
            WidgetDraw.sGuidelineArrowLeft = ImageUtils.iconToImage((Icon)StudioIcons.LayoutEditor.Toolbar.ARROW_LEFT);
        }
        if (WidgetDraw.sGuidelineArrowRight == null) {
            WidgetDraw.sGuidelineArrowRight = ImageUtils.iconToImage((Icon)StudioIcons.LayoutEditor.Toolbar.ARROW_RIGHT);
        }
        if (WidgetDraw.sGuidelineArrowUp == null) {
            WidgetDraw.sGuidelineArrowUp = ImageUtils.iconToImage((Icon)StudioIcons.LayoutEditor.Toolbar.ARROW_UP);
        }
        if (WidgetDraw.sGuidelineArrowDown == null) {
            WidgetDraw.sGuidelineArrowDown = ImageUtils.iconToImage((Icon)StudioIcons.LayoutEditor.Toolbar.ARROW_DOWN);
        }
        if (WidgetDraw.sGuidelinePercent == null) {
            WidgetDraw.sGuidelinePercent = ImageUtils.iconToImage((Icon)StudioIcons.LayoutEditor.Toolbar.PERCENT);
        }
    }

    @NotNull
    private static NlAnalyticsManager getAnalyticsManager(@NotNull ViewEditor editor2) {
        if (editor2 == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(0);
        }
        NlAnalyticsManager nlAnalyticsManager = ((NlDesignSurface)editor2.getScene().getDesignSurface()).getAnalyticsManager();
        if (nlAnalyticsManager == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(1);
        }
        return nlAnalyticsManager;
    }

    @Override
    @NotNull
    public Map<String, Map<String, String>> getEnumPropertyValues(@NotNull NlComponent component) {
        if (component == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(2);
        }
        ImmutableMap values2 = ImmutableMap.of((Object)"0dp", (Object)"0dp (match constraint)", (Object)"wrap_content", (Object)"wrap_content");
        ImmutableMap immutableMap = ImmutableMap.of((Object)"layout_width", (Object)values2, (Object)"layout_height", (Object)values2);
        if (immutableMap == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(3);
        }
        return immutableMap;
    }

    @Override
    @NotNull
    public CustomPanel getLayoutCustomPanel() {
        return new WidgetConstraintPanel((List<NlComponent>)ImmutableList.of());
    }

    @Override
    public void addToolbarActions(@NotNull List<ViewAction> actions2) {
        if (actions2 == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(4);
        }
        actions2.add(ViewActionUtils.getViewOptionsAction((List<? extends ViewAction>)ImmutableList.of((Object)new ToggleVisibilityAction(SHOW_CONSTRAINTS_PREF_KEY, "Show All Constraints", false), (Object)new ToggleVisibilityAction(SHOW_MARGINS_PREF_KEY, "Show Margins", true), (Object)new ToggleVisibilityAction(FADE_UNSELECTED_VIEWS, "Fade Unselected Views ", false), (Object)new ToggleAllLiveRenderingAction())));
        actions2.add(new ToggleAutoConnectAction());
        actions2.add(new MarginSelector());
        actions2.add(new ViewActionSeparator());
        actions2.add(new ClearConstraintsAction());
        actions2.add(new InferAction());
        actions2.add(new ViewActionSeparator());
        actions2.add(new NestedViewActionMenu("Pack", StudioIcons.LayoutEditor.Toolbar.PACK_VERTICAL, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new ViewAction[]{new AlignAction(Scout.Arrange.HorizontalPack, StudioIcons.LayoutEditor.Toolbar.PACK_HORIZONTAL, "Pack Horizontally"), new AlignAction(Scout.Arrange.VerticalPack, StudioIcons.LayoutEditor.Toolbar.PACK_VERTICAL, "Pack Vertically"), new AlignAction(Scout.Arrange.ExpandHorizontally, StudioIcons.LayoutEditor.Toolbar.EXPAND_HORIZONTAL, "Expand Horizontally"), new AlignAction(Scout.Arrange.ExpandVertically, StudioIcons.LayoutEditor.Toolbar.EXPAND_VERTICAL, "Expand Vertically"), new ViewActionSeparator(), new AlignAction(Scout.Arrange.DistributeHorizontally, StudioIcons.LayoutEditor.Toolbar.DISTRIBUTE_HORIZONTAL, StudioIcons.LayoutEditor.Toolbar.DISTRIBUTE_HORIZONTAL_CONSTRAINT, "Distribute Horizontally"), new AlignAction(Scout.Arrange.DistributeVertically, StudioIcons.LayoutEditor.Toolbar.DISTRIBUTE_VERTICAL, StudioIcons.LayoutEditor.Toolbar.DISTRIBUTE_VERTICAL_CONSTRAINT, "Distribute Vertically")})})){

            @Override
            public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiersEx) {
                if (presentation == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (editor2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (handler2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (component == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (selectedChildren == null) {
                    1.$$$reportNull$$$0(4);
                }
                super.updatePresentation(presentation, editor2, handler2, component, selectedChildren, modifiersEx);
                presentation.setVisible(ConstraintLayoutHandler.isConstraintLayoutChild(selectedChildren));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "presentation";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "editor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "handler";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "component";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[0] = "selectedChildren";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$1";
                objectArray[2] = "updatePresentation";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        actions2.add(new NestedViewActionMenu("Align", StudioIcons.LayoutEditor.Toolbar.LEFT_ALIGNED_CONSTRAINT, Lists.newArrayList((Object[])new List[]{Stream.of(ConstraintViewActions.ALIGN_HORIZONTALLY_ACTIONS, ConstraintViewActions.ALIGN_VERTICALLY_ACTIONS, ImmutableList.of((Object)new ViewActionSeparator()), ConstraintViewActions.CENTER_ACTIONS).flatMap(list -> list.stream()).collect(Collectors.toList())})){

            @Override
            public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiersEx) {
                if (presentation == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (editor2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (handler2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (component == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (selectedChildren == null) {
                    2.$$$reportNull$$$0(4);
                }
                super.updatePresentation(presentation, editor2, handler2, component, selectedChildren, modifiersEx);
                presentation.setVisible(ConstraintLayoutHandler.isConstraintLayoutChild(selectedChildren));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "presentation";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "editor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "handler";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "component";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[0] = "selectedChildren";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$2";
                objectArray[2] = "updatePresentation";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        actions2.add(new NestedViewActionMenu("Guidelines", StudioIcons.LayoutEditor.Toolbar.GUIDELINE_VERTICAL, Lists.newArrayList((Object[])new List[]{ConstraintViewActions.HELPER_ACTIONS})));
        ViewActionSeparator.setupFollowingActions(actions2);
    }

    private static boolean isConstraintLayoutChild(List<NlComponent> children) {
        for (NlComponent child : children) {
            NlComponent parent = child.getParent();
            if (parent == null || !NlComponentHelperKt.isOrHasSuperclass(parent, SdkConstants.CONSTRAINT_LAYOUT)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addPopupMenuActions(@NotNull SceneComponent component, @NotNull List<ViewAction> actions2) {
        if (component == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(5);
        }
        if (actions2 == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(6);
        }
        actions2.add(new BaseLineToggleViewAction());
        actions2.add(new ClearConstraintsSelectedComponentsAction());
        actions2.add(new DisappearingActionMenu("Constrain", StudioIcons.LayoutEditor.Toolbar.CREATE_CONSTRAINTS, (List<ViewAction>)ConstraintViewActions.CONNECT_ACTIONS));
        actions2.add(new DisappearingActionMenu("Organize", StudioIcons.LayoutEditor.Toolbar.PACK_HORIZONTAL, (List<ViewAction>)ConstraintViewActions.ORGANIZE_ACTIONS));
        actions2.add(new DisappearingActionMenu("Align", StudioIcons.LayoutEditor.Toolbar.LEFT_ALIGNED, (List<ViewAction>)ConstraintViewActions.ALIGN_ACTIONS));
        actions2.add(new DisappearingActionMenu("Chains", StudioIcons.LayoutEditor.Toolbar.CREATE_HORIZ_CHAIN, (List<ViewAction>)ConstraintViewActions.CHAIN_ACTIONS));
        actions2.add(new DisappearingActionMenu("Center", StudioIcons.LayoutEditor.Toolbar.CENTER_HORIZONTAL, (List<ViewAction>)ConstraintViewActions.CENTER_ACTIONS));
        actions2.add(new DisappearingActionMenu("Add helpers", StudioIcons.LayoutEditor.Toolbar.GUIDELINE_VERTICAL, (List<ViewAction>)ConstraintViewActions.HELPER_ACTIONS));
        if (((Boolean)StudioFlags.NELE_MOTION_LAYOUT_EDITOR.get()).booleanValue()) {
            actions2.add(new ConvertToMotionLayoutComponentsAction());
        }
        return true;
    }

    @Override
    @Nullable
    public Interaction createInteraction(@NotNull ScreenView screenView, int x, int y, @NotNull NlComponent component) {
        if (screenView == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(7);
        }
        if (component == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(8);
        }
        return new ConstraintSceneInteraction(screenView, component);
    }

    @Override
    @NotNull
    public List<Target> createTargets(@NotNull SceneComponent sceneComponent) {
        if (sceneComponent == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(9);
        }
        sceneComponent.setNotchProvider(new ConstraintLayoutNotchProvider());
        ImmutableList immutableList = ImmutableList.of((Object)new LassoTarget(), (Object)new ConstraintAnchorTarget(AnchorTarget.Type.LEFT, true), (Object)new ConstraintAnchorTarget(AnchorTarget.Type.TOP, true), (Object)new ConstraintAnchorTarget(AnchorTarget.Type.RIGHT, true), (Object)new ConstraintAnchorTarget(AnchorTarget.Type.BOTTOM, true));
        if (immutableList == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(10);
        }
        return immutableList;
    }

    @Override
    @NotNull
    public List<Target> createChildTargets(@NotNull SceneComponent parentComponent, @NotNull SceneComponent childComponent) {
        if (parentComponent == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(11);
        }
        if (childComponent == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(12);
        }
        ImmutableList.Builder listBuilder = new ImmutableList.Builder();
        NlComponent nlComponent = childComponent.getAuthoritativeNlComponent();
        ViewInfo vi = NlComponentHelperKt.getViewInfo(nlComponent);
        if (vi != null) {
            if (NlComponentHelperKt.isOrHasSuperclass(nlComponent, SdkConstants.CONSTRAINT_LAYOUT_GUIDELINE)) {
                String orientation = nlComponent.getAttribute("http://schemas.android.com/apk/res/android", "orientation");
                boolean isHorizontal = true;
                if (orientation != null && orientation.equalsIgnoreCase("vertical")) {
                    isHorizontal = false;
                }
                listBuilder.add((Object)new GuidelineTarget(isHorizontal)).add((Object)(isHorizontal ? new GuidelineAnchorTarget(AnchorTarget.Type.TOP, true) : new GuidelineAnchorTarget(AnchorTarget.Type.LEFT, false))).add((Object)new GuidelineCycleTarget(isHorizontal));
                ImmutableList immutableList = listBuilder.build();
                if (immutableList == null) {
                    ConstraintLayoutHandler.$$$reportNull$$$0(13);
                }
                return immutableList;
            }
            if (NlComponentHelperKt.isOrHasSuperclass(nlComponent, SdkConstants.CONSTRAINT_LAYOUT_BARRIER)) {
                @NonNls String side = nlComponent.getAttribute("http://schemas.android.com/apk/res-auto", "barrierDirection");
                boolean isHorizontal = side == null || ourHorizontalBarriers.contains(StringUtil.toLowerCase((String)side));
                listBuilder.add((Object)new BarrierAnchorTarget(isHorizontal ? AnchorTarget.Type.TOP : AnchorTarget.Type.RIGHT, BarrierTarget.parseDirection(side))).add((Object)new BarrierTarget(BarrierTarget.parseDirection(side)));
                ImmutableList immutableList = listBuilder.build();
                if (immutableList == null) {
                    ConstraintLayoutHandler.$$$reportNull$$$0(14);
                }
                return immutableList;
            }
        }
        childComponent.setComponentProvider(this);
        childComponent.setNotchProvider(new ConstraintLayoutComponentNotchProvider());
        listBuilder.add((Object[])new Target[]{new ConstraintDragTarget(), new ConstraintResizeTarget(ResizeBaseTarget.Type.LEFT_TOP), new ConstraintResizeTarget(ResizeBaseTarget.Type.LEFT_BOTTOM), new ConstraintResizeTarget(ResizeBaseTarget.Type.RIGHT_TOP), new ConstraintResizeTarget(ResizeBaseTarget.Type.RIGHT_BOTTOM), new ConstraintAnchorTarget(AnchorTarget.Type.LEFT, false), new ConstraintAnchorTarget(AnchorTarget.Type.TOP, false), new ConstraintAnchorTarget(AnchorTarget.Type.RIGHT, false), new ConstraintAnchorTarget(AnchorTarget.Type.BOTTOM, false)});
        int baseline = NlComponentHelperKt.getBaseline(childComponent.getNlComponent());
        ViewInfo info2 = NlComponentHelperKt.getViewInfo(childComponent.getNlComponent());
        if (baseline <= 0 && info2 != null) {
            baseline = info2.getBaseLine();
        }
        if (baseline > 0) {
            listBuilder.add((Object)new ConstraintAnchorTarget(AnchorTarget.Type.BASELINE, false));
        }
        ImmutableList immutableList = listBuilder.build();
        if (immutableList == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(15);
        }
        return immutableList;
    }

    @Override
    public void cleanUpAttributes(@NotNull NlComponent component, @NotNull NlAttributesHolder attributes) {
        if (component == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(16);
        }
        if (attributes == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(17);
        }
        ConstraintComponentUtilities.cleanup(attributes, component);
    }

    @Override
    public void clearAttributes(@NotNull List<NlComponent> components) {
        if (components == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(18);
        }
        if (components.isEmpty()) {
            return;
        }
        NlWriteCommandActionUtil.run(components, "Cleared all constraints", () -> components.forEach(it -> ConstraintComponentUtilities.clearAttributes(it)));
    }

    @Override
    public DragHandler createDragHandler(@NotNull ViewEditor editor2, @NotNull SceneComponent layout2, @NotNull List<NlComponent> components, @NotNull DragType type) {
        if (editor2 == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(19);
        }
        if (layout2 == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(20);
        }
        if (components == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(21);
        }
        if (type == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(22);
        }
        return new ConstraintDragHandler(editor2, this, layout2, components, type);
    }

    @Override
    public void onChildRemoved(@NotNull ViewEditor editor2, @NotNull NlComponent layout2, @NotNull NlComponent newChild, @NotNull InsertType insertType) {
        if (editor2 == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(23);
        }
        if (layout2 == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(24);
        }
        if (newChild == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(25);
        }
        if (insertType == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(26);
        }
        for (String attribute : ConstraintComponentUtilities.ourConstraintLayoutAttributesToClear) {
            newChild.removeAttribute("http://schemas.android.com/apk/res-auto", attribute);
        }
        newChild.removeAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX");
        newChild.removeAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY");
    }

    @Override
    public boolean handlesPainting() {
        return true;
    }

    private static void ensureLayersAreShown(@NotNull ViewEditor editor2, int duration2) {
        if (editor2 == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(27);
        }
        NlDesignSurface designSurface = (NlDesignSurface)editor2.getScene().getDesignSurface();
        designSurface.forceLayersPaint(true);
        designSurface.repaint();
        Timer timer2 = new Timer(duration2, actionEvent -> designSurface.forceLayersPaint(false));
        timer2.setRepeats(false);
        timer2.start();
    }

    public static boolean getVisualProperty(String prop) {
        if (ourVisibilityFlags.containsKey(prop)) {
            return ourVisibilityFlags.get(prop);
        }
        boolean selected = PropertiesComponent.getInstance().getBoolean(prop);
        ourVisibilityFlags.put(prop, selected);
        return selected;
    }

    public static void forceDefaultVisualProperties() {
        ourVisibilityFlags.put(SHOW_CONSTRAINTS_PREF_KEY, true);
        ourVisibilityFlags.put(SHOW_MARGINS_PREF_KEY, true);
        ourVisibilityFlags.put(FADE_UNSELECTED_VIEWS, false);
    }

    @Nullable
    static String getSelectedIds(List<NlComponent> selected) {
        if (selected.isEmpty()) {
            return null;
        }
        StringBuilder builder2 = new StringBuilder();
        for (NlComponent component : selected) {
            String id;
            if (!NlComponentHelperKt.isOrHasSuperclass(component, "android.view.View") && !NlComponentHelperKt.isOrHasSuperclass(component, "android.view.ViewGroup") || (id = component.getId()) == null) continue;
            builder2.append(component.getId()).append(",");
        }
        if (builder2.length() == 0) {
            return null;
        }
        return builder2.toString().substring(0, builder2.length() - 1);
    }

    @Override
    public boolean deleteChildren(@NotNull NlComponent parent, @NotNull Collection<NlComponent> deleted) {
        if (parent == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(28);
        }
        if (deleted == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(29);
        }
        int count = parent.getChildCount();
        for (int i2 = 0; i2 < count; ++i2) {
            NlComponent component = parent.getChild(i2);
            if (deleted.contains(component)) continue;
            ConstraintLayoutHandler.willDelete(component, deleted);
        }
        return false;
    }

    public static void willDelete(NlComponent component, @NotNull Collection<NlComponent> deleted) {
        if (deleted == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(30);
        }
        for (NlComponent deletedComponent : deleted) {
            String id = deletedComponent.getId();
            ConstraintComponentUtilities.updateOnDelete(component, id);
            NlComponent parent = deletedComponent.getParent();
            if (parent == null || id == null) continue;
            ConstraintHelperHandler.willDelete(parent, id);
        }
    }

    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        ImmutableList immutableList = ImmutableList.of((Object)"minWidth", (Object)"maxWidth", (Object)"minHeight", (Object)"maxHeight");
        if (immutableList == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(31);
        }
        return immutableList;
    }

    @Override
    public ComponentProvider getComponentProvider(@NotNull SceneComponent component) {
        String attribute;
        SceneComponent parent;
        if (component == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(32);
        }
        if ((parent = component.getParent()) == null) {
            return null;
        }
        NlComponent nlComponent = parent.getNlComponent();
        if (NlComponentHelperKt.isOrHasSuperclass(nlComponent, SdkConstants.CLASS_CONSTRAINT_LAYOUT) && (attribute = nlComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", "constraints")) != null) {
            return this;
        }
        return null;
    }

    @Override
    public NlComponent getComponent(@NotNull SceneComponent component) {
        SceneComponent parent;
        if (component == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(33);
        }
        if ((parent = component.getParent()) == null) {
            return component.getNlComponent();
        }
        NlComponent nlComponent = parent.getNlComponent();
        String attribute = nlComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", "constraintSet");
        if ((attribute = NlComponent.extractId(attribute)) == null) {
            return component.getNlComponent();
        }
        NlComponent constraints = null;
        for (SceneComponent sceneComponent : parent.getChildren()) {
            String childId = sceneComponent.getNlComponent().getId();
            if (!Objects.equals(attribute, childId)) continue;
            constraints = sceneComponent.getNlComponent();
            break;
        }
        if (constraints == null) {
            return component.getNlComponent();
        }
        for (NlComponent nlComponent2 : constraints.getChildren()) {
            String reference2 = nlComponent2.getLiveAttribute("http://schemas.android.com/apk/res/android", "id");
            if ((reference2 = NlComponent.extractId(reference2)) == null || !reference2.equals(component.getNlComponent().getId())) continue;
            return nlComponent2;
        }
        return component.getNlComponent();
    }

    @Override
    public List<Placeholder> getPlaceholders(@NotNull SceneComponent component) {
        if (component == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(34);
        }
        return ImmutableList.of((Object)new ConstraintPlaceholder(component));
    }

    @Override
    public List<ViewAction> getPropertyActions(@NotNull List<NlComponent> components) {
        if (components == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(35);
        }
        ImmutableList.Builder builder2 = ImmutableList.builder();
        builder2.add((Object)new ClearConstraintsAction());
        DisappearingActionMenu connectAction = new DisappearingActionMenu("Constrain", StudioIcons.LayoutEditor.Toolbar.CREATE_CONSTRAINTS, (List<ViewAction>)ConstraintViewActions.CONNECT_ACTIONS);
        builder2.add((Object)connectAction);
        if (components.size() > 1) {
            DisappearingActionMenu alignAction = new DisappearingActionMenu("Align", StudioIcons.LayoutEditor.Toolbar.LEFT_ALIGNED, (List<ViewAction>)ConstraintViewActions.ALIGN_ACTIONS);
            builder2.add((Object)alignAction);
            DisappearingActionMenu chainAction = new DisappearingActionMenu("Chains", StudioIcons.LayoutEditor.Toolbar.CREATE_HORIZ_CHAIN, (List<ViewAction>)ConstraintViewActions.CHAIN_ACTIONS);
            builder2.add((Object)chainAction);
        }
        return builder2.build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 16: 
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenView";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneComponent";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childComponent";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 18: 
            case 21: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChild";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertType";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deleted";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnalyticsManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnumPropertyValues";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createTargets";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildTargets";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectorProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAnalyticsManager";
                break;
            }
            case 1: 
            case 3: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 31: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getEnumPropertyValues";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addToolbarActions";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addPopupMenuActions";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createInteraction";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTargets";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createChildTargets";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "cleanUpAttributes";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "clearAttributes";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createDragHandler";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "onChildRemoved";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "ensureLayersAreShown";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildren";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "willDelete";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getComponentProvider";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getComponent";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholders";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyActions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConstraintViewActions {
        private static final ImmutableList<ViewAction> ALIGN_HORIZONTALLY_ACTIONS = ImmutableList.of((Object)new AlignAction(Scout.Arrange.AlignHorizontallyLeft, StudioIcons.LayoutEditor.Toolbar.LEFT_ALIGNED, StudioIcons.LayoutEditor.Toolbar.LEFT_ALIGNED_CONSTRAINT, "Left Edges"), (Object)new AlignAction(Scout.Arrange.AlignHorizontallyCenter, StudioIcons.LayoutEditor.Toolbar.HORIZONTAL_CENTER_ALIGNED, StudioIcons.LayoutEditor.Toolbar.HORIZONTAL_CENTER_ALIGNED_CONSTRAINT, "Horizontal Centers"), (Object)new AlignAction(Scout.Arrange.AlignHorizontallyRight, StudioIcons.LayoutEditor.Toolbar.RIGHT_ALIGNED, StudioIcons.LayoutEditor.Toolbar.RIGHT_ALIGNED_CONSTRAINT, "Right Edges"));
        private static final ImmutableList<ViewAction> ALIGN_VERTICALLY_ACTIONS = ImmutableList.of((Object)new AlignAction(Scout.Arrange.AlignVerticallyTop, StudioIcons.LayoutEditor.Toolbar.TOP_ALIGNED, StudioIcons.LayoutEditor.Toolbar.TOP_ALIGNED_CONSTRAINT, "Top Edges"), (Object)new AlignAction(Scout.Arrange.AlignVerticallyMiddle, StudioIcons.LayoutEditor.Toolbar.VERTICAL_CENTER_ALIGNED, StudioIcons.LayoutEditor.Toolbar.VERTICAL_CENTER_ALIGNED_CONSTRAINT, "Vertical Centers"), (Object)new AlignAction(Scout.Arrange.AlignVerticallyBottom, StudioIcons.LayoutEditor.Toolbar.BOTTOM_ALIGNED, StudioIcons.LayoutEditor.Toolbar.BOTTOM_ALIGNED_CONSTRAINT, "Bottom Edges"), (Object)new AlignAction(Scout.Arrange.AlignBaseline, StudioIcons.LayoutEditor.Toolbar.BASELINE_ALIGNED, StudioIcons.LayoutEditor.Toolbar.BASELINE_ALIGNED_CONSTRAINT, "Baselines"));
        public static final ImmutableList<ViewAction> ALIGN_ACTIONS = ImmutableList.builder().addAll(ALIGN_HORIZONTALLY_ACTIONS).addAll(ALIGN_VERTICALLY_ACTIONS).build();
        public static final ImmutableList<ViewAction> CHAIN_ACTIONS = ImmutableList.of((Object)new DisappearingActionMenu("Horizontal Chain Style", StudioIcons.LayoutEditor.Toolbar.CYCLE_CHAIN_SPREAD_INLINE, ChainStyleViewActions.HORIZONTAL_CHAIN_STYLES), (Object)new DisappearingActionMenu("Vertical Chain Style", StudioIcons.LayoutEditor.Toolbar.CYCLE_CHAIN_SPREAD_INLINE, ChainStyleViewActions.VERTICAL_CHAIN_STYLES), (Object)new AlignAction(Scout.Arrange.CreateHorizontalChain, StudioIcons.LayoutEditor.Toolbar.CREATE_HORIZ_CHAIN, StudioIcons.LayoutEditor.Toolbar.CREATE_HORIZ_CHAIN, "Create Horizontal Chain"), (Object)new AlignAction(Scout.Arrange.CreateVerticalChain, StudioIcons.LayoutEditor.Toolbar.CREATE_VERT_CHAIN, StudioIcons.LayoutEditor.Toolbar.CREATE_VERT_CHAIN, "Create Vertical Chain"), (Object)new AlignAction(Scout.Arrange.ChainInsertHorizontal, StudioIcons.LayoutEditor.Toolbar.INSERT_HORIZ_CHAIN, StudioIcons.LayoutEditor.Toolbar.INSERT_HORIZ_CHAIN, "Insert in Horizontal Chain"), (Object)new AlignAction(Scout.Arrange.ChainInsertVertical, StudioIcons.LayoutEditor.Toolbar.INSERT_VERT_CHAIN, StudioIcons.LayoutEditor.Toolbar.INSERT_VERT_CHAIN, "Insert in Vertical Chain"), (Object)new AlignAction(Scout.Arrange.ChainVerticalRemove, StudioIcons.LayoutEditor.Toolbar.REMOVE_FROM_VERT_CHAIN, StudioIcons.LayoutEditor.Toolbar.REMOVE_FROM_VERT_CHAIN, "Remove from Vertical Chain"), (Object)new AlignAction(Scout.Arrange.ChainHorizontalRemove, StudioIcons.LayoutEditor.Toolbar.REMOVE_FROM_HORIZ_CHAIN, StudioIcons.LayoutEditor.Toolbar.REMOVE_FROM_HORIZ_CHAIN, "Remove from Horizontal Chain"), (Object)new AlignAction(Scout.Arrange.ChainVerticalMoveUp, StudioIcons.LayoutEditor.Toolbar.MOVE_UP_VERT_CHAIN, StudioIcons.LayoutEditor.Toolbar.MOVE_UP_VERT_CHAIN, "Move Up Vertical Chain"), (Object)new AlignAction(Scout.Arrange.ChainVerticalMoveDown, StudioIcons.LayoutEditor.Toolbar.MOVE_DOWN_VERT_CHAIN, StudioIcons.LayoutEditor.Toolbar.MOVE_DOWN_VERT_CHAIN, "Move Down Vertical Chain"), (Object)new AlignAction(Scout.Arrange.ChainHorizontalMoveLeft, StudioIcons.LayoutEditor.Toolbar.MOVE_LEFT_HORIZ_CHAIN, StudioIcons.LayoutEditor.Toolbar.MOVE_LEFT_HORIZ_CHAIN, "Move Left Horizontal Chain"), (Object)new AlignAction(Scout.Arrange.ChainHorizontalMoveRight, StudioIcons.LayoutEditor.Toolbar.MOVE_RIGHT_HORIZ_CHAIN, StudioIcons.LayoutEditor.Toolbar.MOVE_RIGHT_HORIZ_CHAIN, "Move Right Horizontal Chain"), (Object[])new ViewAction[0]);
        private static final ImmutableList<ViewAction> CENTER_ACTIONS = ImmutableList.of((Object)new AlignAction(Scout.Arrange.CenterHorizontally, StudioIcons.LayoutEditor.Toolbar.CENTER_HORIZONTAL, StudioIcons.LayoutEditor.Toolbar.CENTER_HORIZONTAL_CONSTRAINT, "Horizontally"), (Object)new AlignAction(Scout.Arrange.CenterVertically, StudioIcons.LayoutEditor.Toolbar.CENTER_VERTICAL, StudioIcons.LayoutEditor.Toolbar.CENTER_VERTICAL_CONSTRAINT, "Vertically"), (Object)new AlignAction(Scout.Arrange.CenterHorizontallyInParent, StudioIcons.LayoutEditor.Toolbar.CENTER_HORIZONTAL_PARENT, StudioIcons.LayoutEditor.Toolbar.CENTER_HORIZONTAL_PARENT_CONSTRAINT, "Horizontally in Parent"), (Object)new AlignAction(Scout.Arrange.CenterVerticallyInParent, StudioIcons.LayoutEditor.Toolbar.CENTER_VERTICAL_PARENT, StudioIcons.LayoutEditor.Toolbar.CENTER_VERTICAL_PARENT_CONSTRAINT, "Vertically in Parent"));
        public static final ImmutableList<ViewAction> CONNECT_ACTIONS = ImmutableList.of((Object)new ConnectAction(Scout.Connect.ConnectToParentTop, StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_TO_TOP, "parent top"), (Object)new ConnectAction(Scout.Connect.ConnectToParentBottom, StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_TO_BOTTOM, "parent bottom"), (Object)new ConnectAction(Scout.Connect.ConnectToParentStart, StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_TO_START, "parent start"), (Object)new ConnectAction(Scout.Connect.ConnectToParentEnd, StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_TO_END, "parent end"), (Object)new ConnectSource(0, null, (List<ViewAction>)ConstraintViewActions.connectFrom(false)), (Object)new ConnectSource(1, null, (List<ViewAction>)ConstraintViewActions.connectFrom(true)));
        private static final ImmutableList<ViewAction> ORGANIZE_ACTIONS = ImmutableList.of((Object)new AlignAction(Scout.Arrange.HorizontalPack, StudioIcons.LayoutEditor.Toolbar.PACK_HORIZONTAL, "Pack Horizontally"), (Object)new AlignAction(Scout.Arrange.VerticalPack, StudioIcons.LayoutEditor.Toolbar.PACK_VERTICAL, "Pack Vertically"), (Object)new AlignAction(Scout.Arrange.ExpandHorizontally, StudioIcons.LayoutEditor.Toolbar.EXPAND_HORIZONTAL, "Expand Horizontally"), (Object)new AlignAction(Scout.Arrange.ExpandVertically, StudioIcons.LayoutEditor.Toolbar.EXPAND_VERTICAL, "Expand Vertically"));
        private static final ImmutableList<ViewAction> HELPER_ACTIONS = ImmutableList.of((Object)new AddElementAction(1, StudioIcons.LayoutEditor.Toolbar.GUIDELINE_VERTICAL, "Vertical Guideline"), (Object)new AddElementAction(0, StudioIcons.LayoutEditor.Toolbar.GUIDELINE_HORIZONTAL, "Horizontal Guideline"), (Object)new AddElementAction(3, StudioIcons.LayoutEditor.Toolbar.BARRIER_VERTICAL, "Vertical Barrier"), (Object)new AddElementAction(2, StudioIcons.LayoutEditor.Toolbar.BARRIER_HORIZONTAL, "Horizontal Barrier"), (Object)new AddElementAction(4, StudioIcons.LayoutEditor.Palette.GROUP, "Group"), (Object)new AddElementAction(5, StudioIcons.LayoutEditor.Palette.CONSTRAINT_SET, "Set of Constraints"), (Object)new AddElementAction(6, StudioIcons.LayoutEditor.Palette.LAYER, "Layer"), (Object)new AddElementAction(7, StudioIcons.LayoutEditor.Palette.FLOW, "Flow"));

        private ConstraintViewActions() {
        }

        private static ImmutableList<ViewAction> connectTopVertical(boolean reverse) {
            return ImmutableList.of((Object)new ConnectAction(Scout.Connect.ConnectTopToTop, StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_TOP_TO_TOP, "top", reverse), (Object)new ConnectAction(Scout.Connect.ConnectTopToBottom, StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_TOP_TO_BOTTOM, "bottom", reverse));
        }

        private static ImmutableList<ViewAction> connectStartHorizontal(boolean reverse) {
            return ImmutableList.of((Object)new ConnectAction(Scout.Connect.ConnectStartToStart, StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_START_TO_START, "start", reverse), (Object)new ConnectAction(Scout.Connect.ConnectStartToEnd, StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_START_TO_END, "end", reverse));
        }

        private static ImmutableList<ViewAction> connectBottomVertical(boolean reverse) {
            return ImmutableList.of((Object)new ConnectAction(Scout.Connect.ConnectBottomToTop, StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_BOTTOM_TO_TOP, "top", reverse), (Object)new ConnectAction(Scout.Connect.ConnectBottomToBottom, StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_BOTTOM_TO_BOTTOM, "bottom", reverse));
        }

        private static ImmutableList<ViewAction> connectEndHorizontal(boolean reverse) {
            return ImmutableList.of((Object)new ConnectAction(Scout.Connect.ConnectEndToStart, StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_END_TO_START, "start", reverse), (Object)new ConnectAction(Scout.Connect.ConnectEndToEnd, StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_END_TO_END, "end", reverse));
        }

        private static ImmutableList<ViewAction> connectFrom(boolean reverse) {
            return ImmutableList.of((Object)new DisappearingActionMenu("top to", StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_TO_TOP, (List<ViewAction>)ConstraintViewActions.connectTopVertical(reverse)), (Object)new DisappearingActionMenu("bottom to", StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_TO_BOTTOM, (List<ViewAction>)ConstraintViewActions.connectBottomVertical(reverse)), (Object)new DisappearingActionMenu("start to", StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_TO_START, (List<ViewAction>)ConstraintViewActions.connectStartHorizontal(reverse)), (Object)new DisappearingActionMenu("end to", StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_TO_END, (List<ViewAction>)ConstraintViewActions.connectEndHorizontal(reverse)), (Object)new ConnectAction(Scout.Connect.ConnectBaseLineToBaseLine, StudioIcons.LayoutEditor.Toolbar.BASELINE_ALIGNED_CONSTRAINT, "to baseline", reverse));
        }

        private static class ConnectSource
        extends DisappearingActionMenu {
            int mIndex;

            private ConnectSource(int index2, @Nullable Icon icon2, @NotNull List<ViewAction> actions2) {
                if (actions2 == null) {
                    ConnectSource.$$$reportNull$$$0(0);
                }
                super("", icon2, actions2);
                this.mIndex = index2;
            }

            @Override
            public boolean isEnabled(List<NlComponent> selected) {
                if (selected.size() != 2) {
                    return false;
                }
                return super.isEnabled(selected);
            }

            @Override
            public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, int modifiersEx) {
                String label;
                if (presentation == null) {
                    ConnectSource.$$$reportNull$$$0(1);
                }
                if (editor2 == null) {
                    ConnectSource.$$$reportNull$$$0(2);
                }
                if (handler2 == null) {
                    ConnectSource.$$$reportNull$$$0(3);
                }
                if (component == null) {
                    ConnectSource.$$$reportNull$$$0(4);
                }
                if (selectedChildren == null) {
                    ConnectSource.$$$reportNull$$$0(5);
                }
                if (selectedChildren.size() > this.mIndex) {
                    label = selectedChildren.get(this.mIndex).getId();
                    if (label == null) {
                        label = selectedChildren.get(this.mIndex).getTagName();
                    }
                } else {
                    label = this.getLabel();
                }
                presentation.setLabel(label);
                presentation.setVisible(this.isEnabled(selectedChildren));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "actions";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "presentation";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "handler";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "component";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "selectedChildren";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$ConstraintViewActions$ConnectSource";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updatePresentation";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class ConnectAction
        extends DirectViewAction
        implements EnabledAction {
            private final Scout.Connect myConnectType;
            private final Icon myConnectConstraintIcon;
            private final Icon myConstrainIcon;
            private final String myToolTip;
            private boolean mReverse;
            private boolean mToParent = false;

            ConnectAction(Scout.Connect actionType, Icon connectConstraintIcon, String toolTip, boolean reverse) {
                super(connectConstraintIcon, toolTip);
                this.myConnectType = actionType;
                this.myConnectConstraintIcon = connectConstraintIcon;
                this.myConstrainIcon = null;
                this.myToolTip = toolTip;
                this.mReverse = reverse;
            }

            ConnectAction(Scout.Connect actionType, Icon connectConstraintIcon, String toolTip) {
                super(connectConstraintIcon, toolTip);
                this.myConnectType = actionType;
                this.myConnectConstraintIcon = connectConstraintIcon;
                this.myConstrainIcon = null;
                this.myToolTip = toolTip;
                this.mToParent = true;
            }

            @Override
            public boolean isEnabled(List<NlComponent> selected) {
                int count = selected.size();
                if (count > 2 || count == 0) {
                    return false;
                }
                if (!ConstraintLayoutHandler.isConstraintLayoutChild(selected)) {
                    return false;
                }
                return Scout.connectCheck(selected, this.myConnectType, this.mReverse);
            }

            @Override
            public void perform(@NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
                if (editor2 == null) {
                    ConnectAction.$$$reportNull$$$0(0);
                }
                if (handler2 == null) {
                    ConnectAction.$$$reportNull$$$0(1);
                }
                if (component == null) {
                    ConnectAction.$$$reportNull$$$0(2);
                }
                if (selectedChildren == null) {
                    ConnectAction.$$$reportNull$$$0(3);
                }
                Scout.connect(selectedChildren, this.myConnectType, this.mReverse, true);
                ConstraintLayoutHandler.ensureLayersAreShown(editor2, 1000);
                ComponentModification modification = new ComponentModification(component, "Connect Constraint");
                component.startAttributeTransaction().applyToModification(modification);
                modification.commit();
                ConstraintLayoutHandler.getAnalyticsManager(editor2).trackAddConstraint();
            }

            @Override
            public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiersEx) {
                if (presentation == null) {
                    ConnectAction.$$$reportNull$$$0(4);
                }
                if (editor2 == null) {
                    ConnectAction.$$$reportNull$$$0(5);
                }
                if (handler2 == null) {
                    ConnectAction.$$$reportNull$$$0(6);
                }
                if (component == null) {
                    ConnectAction.$$$reportNull$$$0(7);
                }
                if (selectedChildren == null) {
                    ConnectAction.$$$reportNull$$$0(8);
                }
                Icon icon2 = this.myConnectConstraintIcon;
                if (this.myConstrainIcon != null && (ToggleAutoConnectAction.isAutoconnectOn() || (2 & modifiersEx) == 0)) {
                    icon2 = this.myConstrainIcon;
                }
                presentation.setVisible(this.isEnabled(selectedChildren));
                presentation.setEnabled(this.isEnabled(selectedChildren));
                presentation.setIcon(icon2);
                if (this.mToParent) {
                    presentation.setLabel(this.myToolTip);
                } else {
                    Object name = selectedChildren.get(this.mReverse ? 0 : 1).getId();
                    if (name == null) {
                        name = "(" + selectedChildren.get(this.mReverse ? 0 : 1).getTagName() + ")";
                    }
                    presentation.setLabel(this.myToolTip + " of " + (String)name);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 1: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "handler";
                        break;
                    }
                    case 2: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "component";
                        break;
                    }
                    case 3: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "selectedChildren";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "presentation";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$ConstraintViewActions$ConnectAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "perform";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updatePresentation";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class MarginSelector
    extends DirectViewAction {
        private static final String PICK_A_DIMENSION = "Pick a Dimension";
        private static final float DEFAULT_ICON_FONT_SIZE = 12.0f;
        private static final int DEFAULT_ICON_WIDTH = 36;
        private static final int DEFAULT_ICON_HEIGHT = 16;
        private final ActionListener myResourcePickerIconClickListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (myComponent == null) {
                    return;
                }
                EnumSet<ResourceType> types2 = EnumSet.of(ResourceType.DIMEN);
                XmlTag tag = myComponent.getBackend().getTag();
                ResourcePickerDialog dialog2 = ResourceChooserHelperKt.createResourcePickerDialog(MarginSelector.PICK_A_DIMENSION, String.valueOf(Scout.getMargin()), myComponent.getModel().getFacet(), types2, ResourceType.DIMEN, true, false, true, tag != null ? tag.getContainingFile().getVirtualFile() : null);
                if (myMarginPopup != null) {
                    myMarginPopup.cancel();
                }
                if (dialog2.showAndGet()) {
                    this.resolveResValue(dialog2.getResourceName());
                }
            }

            private void resolveResValue(String resourceRef) {
                ConfigurationManager configurationManager = ConfigurationManager.getOrCreateInstance(myComponent.getModel().getFacet());
                XmlTag tag = myComponent.getBackend().getTag();
                assert (tag != null);
                ResourceResolver resolver = configurationManager.getConfiguration(tag.getContainingFile().getVirtualFile()).getResourceResolver();
                AttrResourceValueImpl unresolved = new AttrResourceValueImpl(ResourceNamespace.RES_AUTO, "dimens", null);
                unresolved.setValue(resourceRef);
                ResourceValue resolvedValue = resolver.resolveResValue((ResourceValue)unresolved);
                String marginDp = MarginSelector.getMarginInDp(resolvedValue);
                if (marginDp == null) {
                    Messages.showWarningDialog((String)("\"" + resourceRef + "' cannot be used for default margin. Please choose a resource with \"dp\" type instead."), (String)"Warning");
                    this.setMargin(null, 0);
                    return;
                }
                try {
                    int marginInInt = Integer.parseInt(marginDp);
                    this.setMargin(resourceRef, marginInInt);
                }
                catch (NumberFormatException nfe) {
                    Messages.showWarningDialog((String)("\"" + resourceRef + "' is not a valid dimension. Please choose a resource with correct dimension value instead."), (String)"Warning");
                    this.setMargin(null, 0);
                    Logger.getInstance(MarginPopup.class).warn("Was unable to resolve the resValue from ResourceDialog.");
                }
            }

            private void setMargin(@Nullable String resName, int value2) {
                myMarginPopup = this.createIfNeeded();
                myMarginPopup.getMargin().setValue(value2, resName);
                myMarginPopup.updateText();
                this.updateIcon();
            }
        };
        private MarginPopup myMarginPopup;
        private LookAndFeel myLookAndFeel;
        private String myPreviousDisplay;
        private Icon myMarginIcon;
        @Nullable
        private NlComponent myComponent;
        @Nullable
        private ActionButton myActionButton;

        @Nullable
        private static String getMarginInDp(ResourceValue resourceValue2) {
            if (resourceValue2 == null) {
                return null;
            }
            String value2 = resourceValue2.getValue();
            if (value2 == null) {
                return null;
            }
            String toReturn = null;
            if (value2.endsWith("dp") || value2.endsWith("px") || value2.endsWith("pt") || value2.endsWith("in") || value2.endsWith("mm") || value2.endsWith("sp")) {
                toReturn = value2.substring(0, value2.length() - 2);
            } else if (value2.endsWith("dip")) {
                toReturn = value2.substring(0, value2.length() - 3);
            }
            return toReturn;
        }

        private MarginSelector() {
            super(null, "Default Margins");
        }

        private void updateIcon() {
            this.myMarginPopup = this.createIfNeeded();
            String previousDisplay = this.myMarginPopup.getMargin().getDisplayValue();
            if (!previousDisplay.equals(this.myPreviousDisplay)) {
                this.myPreviousDisplay = previousDisplay;
                this.myMarginIcon = new Icon(){

                    @Override
                    public void paintIcon(Component c, Graphics g, int x, int y) {
                        g.setColor(JBColor.foreground());
                        g.setFont(g.getFont().deriveFont(0, JBUI.scaleFontSize((float)12.0f)));
                        String m = myPreviousDisplay;
                        FontMetrics metrics = g.getFontMetrics();
                        int strWidth = metrics.stringWidth(m);
                        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                        int stringY = (this.getIconHeight() - metrics.getHeight()) / 2 + metrics.getAscent();
                        g.drawString(m, x + (this.getIconWidth() - strWidth) / 2, y + stringY - 1);
                        g.setColor(JBColor.foreground().darker());
                        int marginRight = 6;
                        g.drawLine(x + 1, y + this.getIconHeight() - 1, x + this.getIconWidth() - 1, y + this.getIconHeight() - 1);
                        g.drawLine(x + 1, y + this.getIconHeight(), x + 1, y + this.getIconHeight() - marginRight);
                        g.drawLine(x + this.getIconWidth() - 1, y + this.getIconHeight(), x + this.getIconWidth() - 1, y + this.getIconHeight() - marginRight);
                    }

                    @Override
                    public int getIconWidth() {
                        return JBUI.scale((int)36);
                    }

                    @Override
                    public int getIconHeight() {
                        return JBUI.scale((int)16);
                    }
                };
            }
        }

        @Override
        public void perform(@NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            if (editor2 == null) {
                MarginSelector.$$$reportNull$$$0(0);
            }
            if (handler2 == null) {
                MarginSelector.$$$reportNull$$$0(1);
            }
            if (component == null) {
                MarginSelector.$$$reportNull$$$0(2);
            }
            if (selectedChildren == null) {
                MarginSelector.$$$reportNull$$$0(3);
            }
            this.myComponent = component;
            this.myMarginPopup = this.createIfNeeded();
            DesignSurface surface2 = editor2.getScene().getDesignSurface();
            ConstraintLayoutHandler.getAnalyticsManager(editor2).trackDefaultMargins();
            RelativePoint relativePoint = new RelativePoint((Component)((Object)surface2), new Point(0, 0));
            JBPopup popup2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.myMarginPopup, this.myMarginPopup.getTextField()).setRequestFocus(true).setCancelOnMouseOutCallback(event -> !this.withinComponent(event)).setCancelOnClickOutside(true).setCancelOnOtherWindowOpen(true).setCancelCallback(() -> {
                this.myMarginPopup.cancel();
                return Boolean.TRUE;
            }).createPopup();
            this.myMarginPopup.setPopup(popup2);
            Disposer.register((Disposable)popup2, this::popupClosed);
            popup2.show(relativePoint);
        }

        @NotNull
        private MarginPopup createIfNeeded() {
            if (this.myMarginPopup != null && UIManager.getLookAndFeel() == this.myLookAndFeel) {
                MarginPopup marginPopup = this.myMarginPopup;
                if (marginPopup == null) {
                    MarginSelector.$$$reportNull$$$0(4);
                }
                return marginPopup;
            }
            if (this.myMarginPopup != null) {
                this.myMarginPopup.removeResourcePickerActionListener(this.myResourcePickerIconClickListener);
                this.myMarginPopup.setActionListener(null);
            }
            this.myMarginPopup = new MarginPopup();
            this.myLookAndFeel = UIManager.getLookAndFeel();
            this.myMarginPopup.setActionListener(e -> Scout.setMargin(this.myMarginPopup.getMargin().getValue()));
            this.myMarginPopup.addResourcePickerActionListener(this.myResourcePickerIconClickListener);
            MarginPopup marginPopup = this.myMarginPopup;
            if (marginPopup == null) {
                MarginSelector.$$$reportNull$$$0(5);
            }
            return marginPopup;
        }

        private void popupClosed() {
            if (this.myMarginPopup != null) {
                this.myMarginPopup.setPopup(null);
            }
            this.myActionButton = null;
        }

        public boolean withinComponent(@NotNull MouseEvent event) {
            if (event == null) {
                MarginSelector.$$$reportNull$$$0(6);
            }
            if (this.myMarginPopup == null || !this.myMarginPopup.isShowing()) {
                return false;
            }
            Point eventLocation = event.getLocationOnScreen();
            Rectangle popupScreenBounds = new Rectangle(this.myMarginPopup.getLocationOnScreen(), this.myMarginPopup.getSize());
            if (popupScreenBounds.contains(eventLocation)) {
                return true;
            }
            if (this.myActionButton == null) {
                this.myActionButton = this.checkIfMouseEventCameFromOurActionButton(event.getSource());
                if (this.myActionButton == null) {
                    return false;
                }
            }
            Rectangle buttonScreenBounds = new Rectangle(this.myActionButton.getLocationOnScreen(), this.myActionButton.getSize());
            int extendedHeight = popupScreenBounds.y + popupScreenBounds.height - buttonScreenBounds.y;
            buttonScreenBounds.height = Math.max(buttonScreenBounds.height, extendedHeight);
            return buttonScreenBounds.contains(eventLocation);
        }

        @Nullable
        private ActionButton checkIfMouseEventCameFromOurActionButton(@Nullable Object source) {
            if (!(source instanceof ActionButton)) {
                return null;
            }
            ActionButton button2 = (ActionButton)source;
            Presentation presentation = button2.getAction().getTemplatePresentation();
            return this.getLabel().equals(presentation.getText()) && Objects.equals(this.getIcon(), presentation.getIcon()) ? button2 : null;
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiersEx) {
            if (presentation == null) {
                MarginSelector.$$$reportNull$$$0(7);
            }
            if (editor2 == null) {
                MarginSelector.$$$reportNull$$$0(8);
            }
            if (handler2 == null) {
                MarginSelector.$$$reportNull$$$0(9);
            }
            if (component == null) {
                MarginSelector.$$$reportNull$$$0(10);
            }
            if (selectedChildren == null) {
                MarginSelector.$$$reportNull$$$0(11);
            }
            this.updateIcon();
            if (this.myMarginIcon instanceof ControlIcon) {
                ((ControlIcon)this.myMarginIcon).setHighlight(ToggleAutoConnectAction.isAutoconnectOn() || (2 & modifiersEx) == 0);
            }
            presentation.setIcon(this.myMarginIcon);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$MarginSelector";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$MarginSelector";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createIfNeeded";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "withinComponent";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "updatePresentation";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AlignAction
    extends DirectViewAction
    implements EnabledAction {
        private final Scout.Arrange myActionType;
        private final Icon myAlignIcon;
        private final Icon myConstrainIcon;
        private final String myToolTip;

        AlignAction(Scout.Arrange actionType, Icon alignIcon, String toolTip) {
            super(alignIcon, toolTip);
            this.myActionType = actionType;
            this.myAlignIcon = alignIcon;
            this.myConstrainIcon = null;
            this.myToolTip = toolTip;
        }

        AlignAction(Scout.Arrange actionType, Icon alignIcon, Icon constrainIcon, String toolTip) {
            super(alignIcon, toolTip);
            this.myActionType = actionType;
            this.myAlignIcon = alignIcon;
            this.myConstrainIcon = constrainIcon;
            this.myToolTip = toolTip;
        }

        @Override
        public boolean isEnabled(List<NlComponent> selected) {
            int count = selected.size();
            switch (this.myActionType) {
                case AlignVerticallyTop: 
                case AlignVerticallyMiddle: 
                case AlignVerticallyBottom: 
                case AlignHorizontallyLeft: 
                case AlignHorizontallyCenter: 
                case AlignHorizontallyRight: 
                case DistributeVertically: 
                case DistributeHorizontally: 
                case VerticalPack: 
                case HorizontalPack: 
                case AlignBaseline: {
                    return count > 1;
                }
                case CreateHorizontalChain: {
                    return count > 1 && !Scout.chainCheck(selected, Scout.ChainTest.InHorizontalChain);
                }
                case CreateVerticalChain: {
                    return count > 1 && !Scout.chainCheck(selected, Scout.ChainTest.InVerticalChain);
                }
                case ExpandVertically: 
                case ExpandHorizontally: 
                case CenterHorizontallyInParent: 
                case CenterVerticallyInParent: 
                case CenterVertically: 
                case CenterHorizontally: {
                    return count >= 1;
                }
                case ChainHorizontalMoveLeft: {
                    return count == 1 && Scout.chainCheck(selected, Scout.ChainTest.InHorizontalChain) && !Scout.chainCheck(selected, Scout.ChainTest.IsTopOfChain);
                }
                case ChainVerticalMoveDown: {
                    return count == 1 && Scout.chainCheck(selected, Scout.ChainTest.InVerticalChain) && !Scout.chainCheck(selected, Scout.ChainTest.IsBottomOfChain);
                }
                case ChainVerticalMoveUp: {
                    return count == 1 && Scout.chainCheck(selected, Scout.ChainTest.InVerticalChain) && !Scout.chainCheck(selected, Scout.ChainTest.IsTopOfChain);
                }
                case ChainHorizontalMoveRight: {
                    return count == 1 && Scout.chainCheck(selected, Scout.ChainTest.InHorizontalChain) && !Scout.chainCheck(selected, Scout.ChainTest.IsBottomOfChain);
                }
                case ChainHorizontalRemove: {
                    return count == 1 && Scout.chainCheck(selected, Scout.ChainTest.InHorizontalChain);
                }
                case ChainVerticalRemove: {
                    return count == 1 && Scout.chainCheck(selected, Scout.ChainTest.InVerticalChain);
                }
                case ChainInsertHorizontal: {
                    return count == 1 && Scout.chainCheck(selected, Scout.ChainTest.IsNearHorizontalChain);
                }
                case ChainInsertVertical: {
                    return count == 1 && Scout.chainCheck(selected, Scout.ChainTest.IsNearVerticalChain);
                }
            }
            return false;
        }

        @Override
        public void perform(@NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            if (editor2 == null) {
                AlignAction.$$$reportNull$$$0(0);
            }
            if (handler2 == null) {
                AlignAction.$$$reportNull$$$0(1);
            }
            if (component == null) {
                AlignAction.$$$reportNull$$$0(2);
            }
            if (selectedChildren == null) {
                AlignAction.$$$reportNull$$$0(3);
            }
            ConstraintLayoutHandler.getAnalyticsManager(editor2).trackAlign();
            Scout.arrangeWidgetsAndCommit(this.myActionType, selectedChildren, (modifiers &= 2) == 0 || ToggleAutoConnectAction.isAutoconnectOn());
            ConstraintLayoutHandler.ensureLayersAreShown(editor2, 1000);
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiersEx) {
            if (presentation == null) {
                AlignAction.$$$reportNull$$$0(4);
            }
            if (editor2 == null) {
                AlignAction.$$$reportNull$$$0(5);
            }
            if (handler2 == null) {
                AlignAction.$$$reportNull$$$0(6);
            }
            if (component == null) {
                AlignAction.$$$reportNull$$$0(7);
            }
            if (selectedChildren == null) {
                AlignAction.$$$reportNull$$$0(8);
            }
            Icon icon2 = this.myAlignIcon;
            if (this.myConstrainIcon != null && (ToggleAutoConnectAction.isAutoconnectOn() || (2 & modifiersEx) == 0)) {
                icon2 = this.myConstrainIcon;
            }
            presentation.setVisible(this.isEnabled(selectedChildren));
            presentation.setEnabled(this.isEnabled(selectedChildren));
            presentation.setIcon(icon2);
            presentation.setLabel(this.myToolTip);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$AlignAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePresentation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static interface EnabledAction {
        public boolean isEnabled(List<NlComponent> var1);
    }

    private static class AddElementAction
    extends DirectViewAction {
        public static final int HORIZONTAL_GUIDELINE = 0;
        public static final int VERTICAL_GUIDELINE = 1;
        public static final int HORIZONTAL_BARRIER = 2;
        public static final int VERTICAL_BARRIER = 3;
        public static final int GROUP = 4;
        public static final int CONSTRAINT_SET = 5;
        public static final int LAYER = 6;
        public static final int FLOW = 7;
        final int myType;

        private AddElementAction(int type, Icon icon2, String text2) {
            super(icon2, text2);
            this.myType = type;
        }

        @Override
        public void perform(@NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            NlComponent parent;
            if (editor2 == null) {
                AddElementAction.$$$reportNull$$$0(0);
            }
            if (handler2 == null) {
                AddElementAction.$$$reportNull$$$0(1);
            }
            if (component == null) {
                AddElementAction.$$$reportNull$$$0(2);
            }
            if (selectedChildren == null) {
                AddElementAction.$$$reportNull$$$0(3);
            }
            for (parent = component; parent != null && !NlComponentHelperKt.isOrHasSuperclass(parent, SdkConstants.CONSTRAINT_LAYOUT); parent = parent.getParent()) {
            }
            if (parent != null) {
                boolean useAndroidx = NlComponentHelperKt.isOrHasAndroidxSuperclass(parent);
                ConstraintLayoutHandler.ensureLayersAreShown(editor2, 1000);
                switch (this.myType) {
                    case 0: {
                        NlComponent guideline = NlComponentHelperKt.createChild(parent, editor2, useAndroidx ? SdkConstants.CONSTRAINT_LAYOUT_GUIDELINE.newName() : SdkConstants.CONSTRAINT_LAYOUT_GUIDELINE.oldName(), null, InsertType.CREATE);
                        assert (guideline != null);
                        guideline.ensureId();
                        guideline.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin", "20dp");
                        ConstraintLayoutHandler.getAnalyticsManager(editor2).trackAddHorizontalGuideline();
                        guideline.setAttribute("http://schemas.android.com/apk/res/android", "orientation", "horizontal");
                        break;
                    }
                    case 1: {
                        NlComponent guideline = NlComponentHelperKt.createChild(parent, editor2, useAndroidx ? SdkConstants.CONSTRAINT_LAYOUT_GUIDELINE.newName() : SdkConstants.CONSTRAINT_LAYOUT_GUIDELINE.oldName(), null, InsertType.CREATE);
                        assert (guideline != null);
                        guideline.ensureId();
                        guideline.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin", "20dp");
                        ConstraintLayoutHandler.getAnalyticsManager(editor2).trackAddVerticalGuideline();
                        guideline.setAttribute("http://schemas.android.com/apk/res/android", "orientation", "vertical");
                        break;
                    }
                    case 4: {
                        NlComponent group2 = NlComponentHelperKt.createChild(parent, editor2, useAndroidx ? SdkConstants.CLASS_CONSTRAINT_LAYOUT_GROUP.newName() : SdkConstants.CLASS_CONSTRAINT_LAYOUT_GROUP.oldName(), null, InsertType.CREATE);
                        assert (group2 != null);
                        String referencedIds = ConstraintLayoutHandler.getSelectedIds(selectedChildren);
                        if (referencedIds != null) {
                            group2.setAttribute("http://schemas.android.com/apk/res-auto", "constraint_referenced_ids", referencedIds);
                        }
                        group2.ensureId();
                        break;
                    }
                    case 5: {
                        NlComponent constraints = NlComponentHelperKt.createChild(parent, editor2, useAndroidx ? SdkConstants.CLASS_CONSTRAINT_LAYOUT_CONSTRAINTS.newName() : SdkConstants.CLASS_CONSTRAINT_LAYOUT_CONSTRAINTS.oldName(), null, InsertType.CREATE);
                        assert (constraints != null);
                        constraints.ensureId();
                        ConstraintReferenceManagement.populateConstraints(constraints);
                        break;
                    }
                    case 6: {
                        NlComponent layer = NlComponentHelperKt.createChild(parent, editor2, useAndroidx ? SdkConstants.CLASS_CONSTRAINT_LAYOUT_LAYER.newName() : SdkConstants.CLASS_CONSTRAINT_LAYOUT_LAYER.oldName(), null, InsertType.CREATE);
                        assert (layer != null);
                        this.removeAbsolutePositioning(selectedChildren);
                        String referencedIds = ConstraintLayoutHandler.getSelectedIds(selectedChildren);
                        if (referencedIds != null) {
                            layer.setAttribute("http://schemas.android.com/apk/res-auto", "constraint_referenced_ids", referencedIds);
                        }
                        layer.ensureId();
                        break;
                    }
                    case 7: {
                        NlComponent layer = NlComponentHelperKt.createChild(parent, editor2, useAndroidx ? SdkConstants.CLASS_CONSTRAINT_LAYOUT_FLOW.newName() : SdkConstants.CLASS_CONSTRAINT_LAYOUT_FLOW.oldName(), null, InsertType.CREATE);
                        assert (layer != null);
                        this.removeAbsolutePositioning(selectedChildren);
                        String referencedIds = ConstraintLayoutHandler.getSelectedIds(selectedChildren);
                        if (referencedIds != null) {
                            layer.setAttribute("http://schemas.android.com/apk/res-auto", "constraint_referenced_ids", referencedIds);
                        }
                        layer.ensureId();
                        break;
                    }
                    case 2: {
                        NlComponent barrier;
                        int barriers = 0;
                        int other = 0;
                        for (NlComponent nlComponent : selectedChildren) {
                            if (NlComponentHelperKt.isOrHasSuperclass(nlComponent, SdkConstants.CONSTRAINT_LAYOUT_BARRIER)) {
                                ++barriers;
                            }
                            if (ConstraintComponentUtilities.isLine(nlComponent)) continue;
                            ++other;
                        }
                        if (barriers == 1 && other > 0) {
                            barrier = null;
                            for (NlComponent child : selectedChildren) {
                                if (!NlComponentHelperKt.isOrHasSuperclass(child, SdkConstants.CONSTRAINT_LAYOUT_BARRIER)) continue;
                                barrier = child;
                                break;
                            }
                            return;
                        }
                        barrier = NlComponentHelperKt.createChild(parent, editor2, useAndroidx ? SdkConstants.CONSTRAINT_LAYOUT_BARRIER.newName() : SdkConstants.CONSTRAINT_LAYOUT_BARRIER.oldName(), null, InsertType.CREATE);
                        assert (barrier != null);
                        String string = ConstraintLayoutHandler.getSelectedIds(selectedChildren);
                        if (string != null) {
                            barrier.setAttribute("http://schemas.android.com/apk/res-auto", "constraint_referenced_ids", string);
                        }
                        barrier.ensureId();
                        barrier.setAttribute("http://schemas.android.com/apk/res-auto", "barrierDirection", "top");
                        break;
                    }
                    case 3: {
                        Object barrier;
                        int barriers = 0;
                        int other = 0;
                        for (NlComponent nlComponent : selectedChildren) {
                            if (NlComponentHelperKt.isOrHasSuperclass(nlComponent, SdkConstants.CONSTRAINT_LAYOUT_BARRIER)) {
                                ++barriers;
                            }
                            if (ConstraintComponentUtilities.isLine(nlComponent)) continue;
                            ++other;
                        }
                        if (barriers == 1 && other > 0) {
                            barrier = null;
                            for (NlComponent child : selectedChildren) {
                                if (!NlComponentHelperKt.isOrHasSuperclass(child, SdkConstants.CONSTRAINT_LAYOUT_BARRIER)) continue;
                                barrier = child;
                                break;
                            }
                            return;
                        }
                        barrier = NlComponentHelperKt.createChild(parent, editor2, useAndroidx ? SdkConstants.CONSTRAINT_LAYOUT_BARRIER.newName() : SdkConstants.CONSTRAINT_LAYOUT_BARRIER.oldName(), null, InsertType.CREATE);
                        assert (barrier != null);
                        String string = ConstraintLayoutHandler.getSelectedIds(selectedChildren);
                        if (string != null) {
                            ((NlComponent)barrier).setAttribute("http://schemas.android.com/apk/res-auto", "constraint_referenced_ids", string);
                        }
                        ((NlComponent)barrier).ensureId();
                        ((NlComponent)barrier).setAttribute("http://schemas.android.com/apk/res-auto", "barrierDirection", "left");
                    }
                }
            }
        }

        private void removeAbsolutePositioning(List<NlComponent> selectedChildren) {
            for (NlComponent component : selectedChildren) {
                component.removeAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX");
                component.removeAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY");
            }
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiersEx) {
            if (presentation == null) {
                AddElementAction.$$$reportNull$$$0(4);
            }
            if (editor2 == null) {
                AddElementAction.$$$reportNull$$$0(5);
            }
            if (handler2 == null) {
                AddElementAction.$$$reportNull$$$0(6);
            }
            if (component == null) {
                AddElementAction.$$$reportNull$$$0(7);
            }
            if (selectedChildren == null) {
                AddElementAction.$$$reportNull$$$0(8);
            }
            boolean show = true;
            if ((this.myType == 3 || this.myType == 2) && (show = ConstraintComponentUtilities.isConstraintModelGreaterThan(editor2, 1, 0))) {
                int barriers = 0;
                int other = 0;
                for (NlComponent child : selectedChildren) {
                    if (NlComponentHelperKt.isOrHasSuperclass(child, SdkConstants.CONSTRAINT_LAYOUT_BARRIER)) {
                        ++barriers;
                    }
                    if (ConstraintComponentUtilities.isLine(child)) continue;
                    ++other;
                }
                if (barriers == 1 && other > 0) {
                    presentation.setLabel(ConstraintLayoutHandler.ADD_TO_BARRIER);
                } else {
                    presentation.setLabel(this.myType == 3 ? ConstraintLayoutHandler.ADD_VERTICAL_BARRIER : ConstraintLayoutHandler.ADD_HORIZONTAL_BARRIER);
                }
            }
            if (this.myType == 4) {
                show = ConstraintComponentUtilities.isConstraintModelGreaterThan(editor2, 1, 0);
            }
            if (this.myType == 5) {
                show = ConstraintComponentUtilities.isConstraintModelGreaterThan(editor2, 1, 9);
            }
            if (this.myType == 6) {
                show = ConstraintComponentUtilities.isConstraintModelGreaterThan(editor2, 1, 9);
            }
            if (this.myType == 7) {
                show = ConstraintComponentUtilities.isConstraintModelGreaterThan(editor2, 1, 9);
            }
            presentation.setVisible(show);
            presentation.setEnabled(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$AddElementAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePresentation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ControlIcon
    implements Icon {
        public static final Color HIGHLIGHT_COLOR = new Color(240116);
        Icon myIcon;
        boolean myHighlight;

        ControlIcon(Icon icon2) {
            this.myIcon = icon2;
        }

        public void setHighlight(boolean mHighlight) {
            this.myHighlight = mHighlight;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.myIcon.paintIcon(c, g, x, y);
            if (this.myHighlight) {
                g.setColor(HIGHLIGHT_COLOR);
                g.fillRect(x, y + this.getIconHeight() - 2, this.getIconWidth(), 2);
            }
        }

        @Override
        public int getIconWidth() {
            return this.myIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.myIcon.getIconHeight();
        }
    }

    private static class ToggleVisibilityAction
    extends ToggleViewAction {
        String mType;

        private ToggleVisibilityAction(String type, String text2, boolean defaultValue2) {
            super(null, LafIconLookup.getIcon((String)"checkmark"), text2, text2);
            this.mType = type;
            ourVisibilityFlags.put(this.mType, PropertiesComponent.getInstance().getBoolean(type, defaultValue2));
        }

        @Override
        public boolean isSelected(@NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent parent, @NotNull List<NlComponent> selectedChildren) {
            if (editor2 == null) {
                ToggleVisibilityAction.$$$reportNull$$$0(0);
            }
            if (handler2 == null) {
                ToggleVisibilityAction.$$$reportNull$$$0(1);
            }
            if (parent == null) {
                ToggleVisibilityAction.$$$reportNull$$$0(2);
            }
            if (selectedChildren == null) {
                ToggleVisibilityAction.$$$reportNull$$$0(3);
            }
            return ourVisibilityFlags.get(this.mType);
        }

        @Override
        public void setSelected(@NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent parent, @NotNull List<NlComponent> selectedChildren, boolean selected) {
            if (editor2 == null) {
                ToggleVisibilityAction.$$$reportNull$$$0(4);
            }
            if (handler2 == null) {
                ToggleVisibilityAction.$$$reportNull$$$0(5);
            }
            if (parent == null) {
                ToggleVisibilityAction.$$$reportNull$$$0(6);
            }
            if (selectedChildren == null) {
                ToggleVisibilityAction.$$$reportNull$$$0(7);
            }
            ourVisibilityFlags.put(this.mType, selected);
            PropertiesComponent.getInstance().setValue(this.mType, selected);
            ConstraintLayoutHandler.ensureLayersAreShown(editor2, 1000);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$ToggleVisibilityAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class InferAction
    extends DirectViewAction {
        private InferAction() {
        }

        @Override
        public void perform(@NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            if (editor2 == null) {
                InferAction.$$$reportNull$$$0(0);
            }
            if (handler2 == null) {
                InferAction.$$$reportNull$$$0(1);
            }
            if (component == null) {
                InferAction.$$$reportNull$$$0(2);
            }
            if (selectedChildren == null) {
                InferAction.$$$reportNull$$$0(3);
            }
            ConstraintLayoutHandler.getAnalyticsManager(editor2).trackInferConstraints();
            try {
                Scout.inferConstraintsAndCommit(component);
                ConstraintLayoutHandler.ensureLayersAreShown(editor2, 1000);
            }
            catch (Exception e) {
                Logger.getInstance(ConstraintLayoutHandler.class).warn("Error in inferring constraints", (Throwable)e);
            }
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiersEx) {
            if (presentation == null) {
                InferAction.$$$reportNull$$$0(4);
            }
            if (editor2 == null) {
                InferAction.$$$reportNull$$$0(5);
            }
            if (handler2 == null) {
                InferAction.$$$reportNull$$$0(6);
            }
            if (component == null) {
                InferAction.$$$reportNull$$$0(7);
            }
            if (selectedChildren == null) {
                InferAction.$$$reportNull$$$0(8);
            }
            presentation.setIcon(StudioIcons.LayoutEditor.Toolbar.INFER_CONSTRAINTS);
            presentation.setLabel("Infer Constraints");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$InferAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePresentation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ConvertToMotionLayoutComponentsAction
    extends DirectViewAction {
        private ConvertToMotionLayoutComponentsAction() {
        }

        @Override
        public boolean affectsUndo() {
            return false;
        }

        @Override
        public void perform(@NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            NlComponent parent;
            if (editor2 == null) {
                ConvertToMotionLayoutComponentsAction.$$$reportNull$$$0(0);
            }
            if (handler2 == null) {
                ConvertToMotionLayoutComponentsAction.$$$reportNull$$$0(1);
            }
            if (component == null) {
                ConvertToMotionLayoutComponentsAction.$$$reportNull$$$0(2);
            }
            if (selectedChildren == null) {
                ConvertToMotionLayoutComponentsAction.$$$reportNull$$$0(3);
            }
            String cl_name = DependencyManagementUtil.mapAndroidxName(component.getModel().getModule(), SdkConstants.CLASS_CONSTRAINT_LAYOUT);
            if (!component.getTagName().equals(cl_name) && (parent = component.getParent()) != null) {
                component = parent;
            }
            NlComponent componentToConvert = component;
            if (!component.getTagName().equals(cl_name)) {
                Messages.showErrorDialog((Component)((Object)editor2.getScene().getDesignSurface()), (String)("You can only convert ConstraintLayout not " + component.getTagName()), (String)this.getLabel());
                return;
            }
            if (Messages.showYesNoDialog((Project)editor2.getScene().getDesignSurface().getProject(), (String)"<html>This action will convert your layout into a MotionLayout<br> and create a separate MotionScene file.</html>", (String)"Motion Editor", (String)"Convert", (String)"Cancel", null) == 0) {
                NlWriteCommandActionUtil.run(componentToConvert, "Convert to MotionLayout", () -> ScoutMotionConvert.convert(componentToConvert));
                final DesignSurface designSurface = editor2.getScene().getDesignSurface();
                Timer t = new Timer(300, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Collection<SceneComponent> components = designSurface.getScene().getSceneComponents();
                        for (SceneComponent sceneComponent : components) {
                            NlComponent nlComponent = sceneComponent.getNlComponent();
                            if (!NlComponentHelperKt.isOrHasSuperclass(nlComponent, SdkConstants.CLASS_MOTION_LAYOUT)) continue;
                            designSurface.getSelectionModel().setSelection(Arrays.asList(nlComponent));
                            ((Timer)e.getSource()).stop();
                            break;
                        }
                    }
                });
                t.start();
            }
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiersEx) {
            if (presentation == null) {
                ConvertToMotionLayoutComponentsAction.$$$reportNull$$$0(4);
            }
            if (editor2 == null) {
                ConvertToMotionLayoutComponentsAction.$$$reportNull$$$0(5);
            }
            if (handler2 == null) {
                ConvertToMotionLayoutComponentsAction.$$$reportNull$$$0(6);
            }
            if (component == null) {
                ConvertToMotionLayoutComponentsAction.$$$reportNull$$$0(7);
            }
            if (selectedChildren == null) {
                ConvertToMotionLayoutComponentsAction.$$$reportNull$$$0(8);
            }
            presentation.setIcon(StudioIcons.LayoutEditor.Toolbar.CYCLE_CHAIN_SPREAD);
            boolean show = ConstraintComponentUtilities.isConstraintModelGreaterThan(editor2, 2, 0, 0, 2);
            presentation.setLabel("Convert to MotionLayout");
            presentation.setVisible(show);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$ConvertToMotionLayoutComponentsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePresentation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ClearConstraintsSelectedComponentsAction
    extends DirectViewAction {
        private ClearConstraintsSelectedComponentsAction() {
        }

        @Override
        public void perform(@NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            if (editor2 == null) {
                ClearConstraintsSelectedComponentsAction.$$$reportNull$$$0(0);
            }
            if (handler2 == null) {
                ClearConstraintsSelectedComponentsAction.$$$reportNull$$$0(1);
            }
            if (component == null) {
                ClearConstraintsSelectedComponentsAction.$$$reportNull$$$0(2);
            }
            if (selectedChildren == null) {
                ClearConstraintsSelectedComponentsAction.$$$reportNull$$$0(3);
            }
            ViewGroupHandler constraintHandler = (ViewGroupHandler)handler2;
            constraintHandler.clearAttributes(selectedChildren);
            ConstraintLayoutHandler.getAnalyticsManager(editor2).trackRemoveConstraint();
            ConstraintLayoutHandler.ensureLayersAreShown(editor2, 1000);
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiersEx) {
            if (presentation == null) {
                ClearConstraintsSelectedComponentsAction.$$$reportNull$$$0(4);
            }
            if (editor2 == null) {
                ClearConstraintsSelectedComponentsAction.$$$reportNull$$$0(5);
            }
            if (handler2 == null) {
                ClearConstraintsSelectedComponentsAction.$$$reportNull$$$0(6);
            }
            if (component == null) {
                ClearConstraintsSelectedComponentsAction.$$$reportNull$$$0(7);
            }
            if (selectedChildren == null) {
                ClearConstraintsSelectedComponentsAction.$$$reportNull$$$0(8);
            }
            presentation.setIcon(StudioIcons.LayoutEditor.Toolbar.CLEAR_CONSTRAINTS);
            presentation.setLabel("Clear Constraints of Selection");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$ClearConstraintsSelectedComponentsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePresentation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ClearConstraintsAction
    extends DirectViewAction {
        private static final String MESSAGE_DELETE_CONSTRAINT = "Delete all the constraints in the current layout?";

        private ClearConstraintsAction() {
            super(StudioIcons.LayoutEditor.Toolbar.CLEAR_CONSTRAINTS, "Clear All Constraints");
        }

        @Override
        @Nullable
        public String getConfirmationMessage() {
            return MESSAGE_DELETE_CONSTRAINT;
        }

        @Override
        public void perform(@NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            if (editor2 == null) {
                ClearConstraintsAction.$$$reportNull$$$0(0);
            }
            if (handler2 == null) {
                ClearConstraintsAction.$$$reportNull$$$0(1);
            }
            if (component == null) {
                ClearConstraintsAction.$$$reportNull$$$0(2);
            }
            if (selectedChildren == null) {
                ClearConstraintsAction.$$$reportNull$$$0(3);
            }
            ConstraintLayoutHandler.getAnalyticsManager(editor2).trackClearAllConstraints();
            ViewGroupHandler constraintHandler = (ViewGroupHandler)handler2;
            constraintHandler.clearAttributes(component.getChildren());
            editor2.getScene().select(Collections.emptyList());
            ConstraintLayoutHandler.ensureLayersAreShown(editor2, 1000);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "handler";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "component";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "selectedChildren";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$ClearConstraintsAction";
            objectArray[2] = "perform";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DisappearingActionMenu
    extends ViewActionMenu
    implements EnabledAction {
        private DisappearingActionMenu(@NotNull String menuName, @Nullable Icon icon2, @NotNull List<ViewAction> actions2) {
            if (menuName == null) {
                DisappearingActionMenu.$$$reportNull$$$0(0);
            }
            if (actions2 == null) {
                DisappearingActionMenu.$$$reportNull$$$0(1);
            }
            super(menuName, icon2, actions2);
        }

        @Override
        public boolean isEnabled(List<NlComponent> selected) {
            for (ViewAction action2 : this.myActions) {
                if (action2 instanceof EnabledAction) {
                    if (!((EnabledAction)((Object)action2)).isEnabled(selected)) continue;
                    return true;
                }
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "menuName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "actions";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$DisappearingActionMenu";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

