/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.common;

import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.handlers.common.MatchPos;
import com.android.tools.idea.uibuilder.model.Insets;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericLinearDragHandler
extends DragHandler {
    private final boolean myVertical;
    private final List<MatchPos> myIndices;
    private final int myNumPositions;
    private Integer myCurrX;
    private Integer myCurrY;
    private int mySelfPos;
    private int myInsertPos;
    private Integer myWidth;
    private Integer myHeight;
    private SceneComponent myComponent;

    public GenericLinearDragHandler(@NotNull ViewEditor editor2, @NotNull SceneComponent layout2, @NotNull List<NlComponent> components, @NotNull DragType type, @NotNull ViewGroupHandler viewGroupHandler, boolean isVertical) {
        if (editor2 == null) {
            GenericLinearDragHandler.$$$reportNull$$$0(0);
        }
        if (layout2 == null) {
            GenericLinearDragHandler.$$$reportNull$$$0(1);
        }
        if (components == null) {
            GenericLinearDragHandler.$$$reportNull$$$0(2);
        }
        if (type == null) {
            GenericLinearDragHandler.$$$reportNull$$$0(3);
        }
        if (viewGroupHandler == null) {
            GenericLinearDragHandler.$$$reportNull$$$0(4);
        }
        super(editor2, viewGroupHandler, layout2, components, type);
        this.myInsertPos = -1;
        assert (!components.isEmpty());
        this.myVertical = isVertical;
        this.myIndices = new ArrayList<MatchPos>();
        int last = this.myVertical ? layout2.getDrawY() + editor2.pxToDp(NlComponentHelperKt.getPadding((NlComponent)layout2.getNlComponent()).top) : layout2.getDrawX() + editor2.pxToDp(NlComponentHelperKt.getPadding((NlComponent)layout2.getNlComponent()).left);
        int pos = 0;
        boolean lastDragged = false;
        this.mySelfPos = -1;
        if (this.myVertical) {
            layout2.getChildren().sort(Comparator.comparingInt(SceneComponent::getDrawY));
        } else {
            layout2.getChildren().sort(Comparator.comparingInt(SceneComponent::getDrawX));
        }
        for (SceneComponent it : layout2.getChildren()) {
            if (it.getDrawWidth() > 0 && it.getDrawHeight() > 0) {
                int v;
                boolean isDragged = components.contains(it.getNlComponent());
                if (isDragged) {
                    v = this.myVertical ? it.getDrawY() + it.getDrawHeight() / 2 : it.getDrawX() + it.getDrawWidth() / 2;
                    this.mySelfPos = pos;
                    this.myIndices.add(new MatchPos(v, pos++));
                } else if (lastDragged) {
                    ++pos;
                } else {
                    v = this.myVertical ? it.getDrawY() : it.getDrawX();
                    v = (last + v) / 2;
                    this.myIndices.add(new MatchPos(v, pos++));
                }
                last = this.myVertical ? it.getDrawY() + it.getDrawHeight() : it.getDrawX() + it.getDrawWidth();
                lastDragged = isDragged;
                continue;
            }
            ++pos;
        }
        if (!lastDragged) {
            int v = last + 1;
            this.myIndices.add(new MatchPos(v, pos));
        }
        this.myNumPositions = layout2.getChildCount() + 1;
        NlComponent component = components.get(0);
        this.myComponent = new TemporarySceneComponent(layout2.getScene(), component);
        this.myComponent.setSize(editor2.pxToDp(NlComponentHelperKt.getW(component)), editor2.pxToDp(NlComponentHelperKt.getH(component)));
    }

    @Override
    @Nullable
    public String update(int x, int y, @JdkConstants.InputEventMask int modifiers, @NotNull SceneContext sceneContext) {
        if (sceneContext == null) {
            GenericLinearDragHandler.$$$reportNull$$$0(5);
        }
        super.update(x, y, modifiers, sceneContext);
        boolean isVertical = this.myVertical;
        int bestDist = Integer.MAX_VALUE;
        int bestIndex = Integer.MIN_VALUE;
        Integer bestPos = null;
        for (MatchPos index2 : this.myIndices) {
            int i2 = index2.getDistance();
            int pos = index2.getPosition();
            int dist = (isVertical ? y : x) - i2;
            if (dist < 0) {
                dist = -dist;
            }
            if (dist >= bestDist) continue;
            bestDist = dist;
            bestIndex = i2;
            bestPos = pos;
            if (bestDist > 0) continue;
            break;
        }
        if (bestIndex != Integer.MIN_VALUE) {
            if (isVertical) {
                this.myCurrX = this.layout.getDrawX() + this.layout.getDrawWidth() / 2;
                this.myCurrY = bestIndex;
                this.myWidth = this.layout.getDrawWidth();
                this.myHeight = null;
            } else {
                this.myCurrX = bestIndex;
                this.myCurrY = this.layout.getDrawY() + this.layout.getDrawHeight() / 2;
                this.myWidth = null;
                this.myHeight = this.layout.getDrawHeight();
            }
            this.myInsertPos = bestPos;
        }
        return null;
    }

    @Override
    public void paint(@NotNull NlGraphics gc) {
        if (gc == null) {
            GenericLinearDragHandler.$$$reportNull$$$0(6);
        }
        Insets padding = NlComponentHelperKt.getPadding(this.layout.getNlComponent());
        int layoutX = this.layout.getDrawX() + this.editor.pxToDp(padding.left);
        int layoutW = this.layout.getDrawWidth() - this.editor.pxToDp(padding.width());
        int layoutY = this.layout.getDrawY() + this.editor.pxToDp(padding.top);
        int layoutH = this.layout.getDrawHeight() - this.editor.pxToDp(padding.height());
        gc.useStyle(NlDrawingStyle.DROP_RECIPIENT);
        gc.drawRectDp(layoutX, layoutY, layoutW, layoutH);
        gc.useStyle(NlDrawingStyle.DROP_ZONE);
        boolean isVertical = this.myVertical;
        int selfPos = this.mySelfPos;
        for (MatchPos it : this.myIndices) {
            int i2 = it.getDistance();
            int pos = it.getPosition();
            if (pos == selfPos) continue;
            if (isVertical) {
                gc.drawLineDp(layoutX, i2, layoutX + layoutW, i2);
                continue;
            }
            gc.drawLineDp(i2, layoutY, i2, layoutY + layoutH);
        }
        Integer currX = this.myCurrX;
        Integer currY = this.myCurrY;
        if (currX != null && currY != null) {
            SceneComponent be;
            gc.useStyle(NlDrawingStyle.DROP_ZONE_ACTIVE);
            int x = currX;
            int y = currY;
            if (this.myInsertPos != selfPos || selfPos == -1) {
                gc.useStyle(NlDrawingStyle.DROP_PREVIEW);
                if (this.myWidth != null) {
                    int width = this.myWidth;
                    int fromX = x - width / 2;
                    int toX = x + width / 2;
                    gc.drawLineDp(fromX, y, toX, y);
                } else if (this.myHeight != null) {
                    int height = this.myHeight;
                    int fromY = y - height / 2;
                    int toY = y + height / 2;
                    gc.drawLineDp(x, fromY, x, toY);
                }
            }
            if ((be = this.myComponent).getDrawWidth() > 0 && be.getDrawHeight() > 0) {
                int offsetY;
                int offsetX;
                boolean isLast;
                boolean bl = isLast = this.myInsertPos == this.myNumPositions - 1;
                if (isVertical) {
                    offsetX = layoutX - be.getDrawX();
                    offsetY = currY - be.getDrawY() - (isLast ? 0 : be.getDrawHeight() / 2);
                } else {
                    offsetX = currX - be.getDrawX() - (isLast ? 0 : be.getDrawWidth() / 2);
                    offsetY = layoutY - be.getDrawY();
                }
                gc.useStyle(NlDrawingStyle.DROP_ZONE_ACTIVE);
                for (NlComponent nlComponent : this.components) {
                    SceneComponent element2 = this.layout.getSceneComponent(nlComponent);
                    if (nlComponent == this.myComponent.getNlComponent()) {
                        element2 = this.myComponent;
                    }
                    if (element2 == null) continue;
                    if (element2.getDrawWidth() > 0 && element2.getDrawHeight() > 0 && (element2.getDrawWidth() > layoutW || element2.getDrawHeight() > layoutH) && this.layout.getChildCount() == 0) {
                        int ph;
                        int py;
                        int pw;
                        int px;
                        if (element2.getDrawWidth() > layoutW) {
                            px = layoutX;
                            pw = layoutW;
                        } else {
                            px = element2.getDrawX() + offsetX;
                            pw = element2.getDrawWidth();
                        }
                        if (element2.getDrawHeight() > layoutH) {
                            py = layoutY;
                            ph = layoutH;
                        } else {
                            py = element2.getDrawY() + offsetY;
                            ph = element2.getDrawHeight();
                        }
                        gc.drawRectDp(px, py, pw, ph);
                        continue;
                    }
                    this.drawElement(gc, element2, this.editor.dpToPx(offsetX), this.editor.dpToPx(offsetY));
                }
            }
        }
    }

    private void drawElement(@NotNull NlGraphics gc, @NotNull SceneComponent component, int offsetX, int offsetY) {
        if (gc == null) {
            GenericLinearDragHandler.$$$reportNull$$$0(7);
        }
        if (component == null) {
            GenericLinearDragHandler.$$$reportNull$$$0(8);
        }
        int w = this.editor.dpToPx(component.getDrawWidth());
        int h = this.editor.dpToPx(component.getDrawHeight());
        if (w > 0 && h > 0) {
            gc.fillRect(offsetX, offsetY, w, h);
            gc.drawRect(offsetX, offsetY, w, h);
        }
        for (SceneComponent inner : component.getChildren()) {
            this.drawElement(gc, inner, offsetX, offsetY);
        }
    }

    @Override
    public void cancel() {
        Scene scene = this.editor.getScene();
        scene.removeComponent(this.myComponent);
    }

    @Override
    public void commit(int x, int y, int modifiers, @NotNull InsertType insertType) {
        if (insertType == null) {
            GenericLinearDragHandler.$$$reportNull$$$0(9);
        }
        this.editor.insertChildren(this.layout.getNlComponent(), this.components, this.myInsertPos, insertType);
        Scene scene = this.editor.getScene();
        scene.removeComponent(this.myComponent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewGroupHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneContext";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gc";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertType";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/common/GenericLinearDragHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "paint";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "drawElement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "commit";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

