/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.handlers.BuiltinViewHandlerProvider;
import com.android.tools.idea.uibuilder.handlers.MergeDelegateHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerProvider;
import com.android.tools.idea.uibuilder.menu.MenuViewHandlerManager;
import com.android.tools.idea.uibuilder.model.ClassResolutionUtilsKt;
import com.android.tools.idea.uibuilder.model.NlComponentHelper;
import com.android.tools.idea.uibuilder.statelist.ItemHandler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ViewHandlerManager
implements Disposable {
    @VisibleForTesting
    static final ExtensionPointName<ViewHandlerProvider> EP_NAME = ExtensionPointName.create((String)"com.android.tools.idea.uibuilder.handlers.viewHandlerProvider");
    private static final String HANDLER_CLASS_SUFFIX = "Handler";
    private final Project myProject;
    private final Map<String, ViewHandler> myHandlers;
    public static final ViewHandler NONE = new ViewHandler();
    private final Map<ViewHandler, List<ViewAction>> myToolbarActions;
    private final Map<ViewHandler, List<ViewAction>> myMenuActions;

    @NotNull
    public static ViewHandlerManager get(@NotNull Project project) {
        if (project == null) {
            ViewHandlerManager.$$$reportNull$$$0(0);
        }
        ViewHandlerManager manager = (ViewHandlerManager)project.getService(ViewHandlerManager.class);
        assert (manager != null);
        ViewHandlerManager viewHandlerManager = manager;
        if (viewHandlerManager == null) {
            ViewHandlerManager.$$$reportNull$$$0(1);
        }
        return viewHandlerManager;
    }

    @NotNull
    public static ViewHandlerManager get(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            ViewHandlerManager.$$$reportNull$$$0(2);
        }
        return ViewHandlerManager.get(facet2.getModule().getProject());
    }

    public ViewHandlerManager(@NotNull Project project) {
        if (project == null) {
            ViewHandlerManager.$$$reportNull$$$0(3);
        }
        this.myHandlers = Maps.newHashMap();
        this.myToolbarActions = Maps.newHashMap();
        this.myMenuActions = Maps.newHashMap();
        this.myProject = project;
    }

    @Nullable
    public ViewHandler getHandler(@NotNull NlComponent component) {
        String tag;
        if (component == null) {
            ViewHandlerManager.$$$reportNull$$$0(4);
        }
        switch (tag = component.getTagName()) {
            case "item": {
                ViewHandler handler2 = MenuViewHandlerManager.getHandler(component);
                if (handler2 != null) {
                    return handler2;
                }
                return new ItemHandler();
            }
            case "merge": {
                ViewHandler groupHandler;
                String parentTag = component.getAttribute("http://schemas.android.com/tools", "parentTag");
                if (parentTag != null && (groupHandler = this.getHandler(parentTag)) instanceof ViewGroupHandler) {
                    return new MergeDelegateHandler((ViewGroupHandler)groupHandler);
                }
                return this.getHandler("merge");
            }
        }
        return this.getHandler(tag);
    }

    @NotNull
    public ViewHandler getHandlerOrDefault(@NotNull NlComponent component) {
        ViewHandler handler2;
        if (component == null) {
            ViewHandlerManager.$$$reportNull$$$0(5);
        }
        ViewHandler viewHandler = (handler2 = this.getHandler(component)) != null ? handler2 : NONE;
        if (viewHandler == null) {
            ViewHandlerManager.$$$reportNull$$$0(6);
        }
        return viewHandler;
    }

    @NotNull
    public ViewHandler getHandlerOrDefault(@NotNull String viewTag) {
        ViewHandler handler2;
        if (viewTag == null) {
            ViewHandlerManager.$$$reportNull$$$0(7);
        }
        ViewHandler viewHandler = (handler2 = this.getHandler(viewTag)) != null ? handler2 : NONE;
        if (viewHandler == null) {
            ViewHandlerManager.$$$reportNull$$$0(8);
        }
        return viewHandler;
    }

    @Nullable
    public ViewHandler getHandler(@NotNull String viewTag) {
        if (viewTag == null) {
            ViewHandlerManager.$$$reportNull$$$0(9);
        }
        if (Disposer.isDisposed((Disposable)this)) {
            Logger.getInstance(ViewHandlerManager.class).warn("ViewHandlerManager::getHandler after dispose()");
            return null;
        }
        ViewHandler handler2 = this.myHandlers.get(viewTag);
        if (handler2 == null) {
            String tag;
            if (viewTag.indexOf(46) != -1 && !(tag = NlComponentHelper.INSTANCE.viewClassToTag(viewTag)).equals(viewTag) && (handler2 = this.getHandler(tag)) != null) {
                this.myHandlers.put(viewTag, handler2);
                return handler2;
            }
            handler2 = this.createHandler(viewTag);
            this.myHandlers.put(viewTag, handler2);
        }
        return handler2 != NONE ? handler2 : null;
    }

    public void registerHandler(@NotNull String viewTag, @NotNull ViewHandler handler2) {
        if (viewTag == null) {
            ViewHandlerManager.$$$reportNull$$$0(10);
        }
        if (handler2 == null) {
            ViewHandlerManager.$$$reportNull$$$0(11);
        }
        if (Disposer.isDisposed((Disposable)this)) {
            Logger.getInstance(ViewHandlerManager.class).warn("ViewHandlerManager::registerHandler(" + viewTag + ", ...) after dispose()");
            return;
        }
        this.myHandlers.put(viewTag, handler2);
    }

    @Nullable
    public ViewGroupHandler findLayoutHandler(@NotNull NlComponent component, boolean strict) {
        if (component == null) {
            ViewHandlerManager.$$$reportNull$$$0(12);
        }
        NlComponent curr = component;
        if (strict) {
            curr = curr.getParent();
        }
        while (curr != null) {
            ViewHandler handler2 = this.getHandler(curr);
            if (handler2 instanceof ViewGroupHandler) {
                return (ViewGroupHandler)handler2;
            }
            curr = curr.getParent();
        }
        return null;
    }

    private ViewHandler createHandler(@NotNull String viewTag) {
        ViewHandler builtInHandler;
        if (viewTag == null) {
            ViewHandlerManager.$$$reportNull$$$0(13);
        }
        if ((builtInHandler = BuiltinViewHandlerProvider.INSTANCE.findHandler(viewTag)) != null) {
            return builtInHandler;
        }
        ViewHandler extensionHandler = EP_NAME.extensions((AreaInstance)this.myProject).map(extension -> extension.findHandler(viewTag)).filter(Objects::nonNull).limit(2L).reduce(null, (a, b) -> {
            if (a != null && b != null) {
                Logger.getInstance(ViewHandler.class).warn("Multiple ViewHandlers returned by extensions for tag " + viewTag);
                return a;
            }
            return a != null ? a : b;
        });
        if (extensionHandler != null) {
            return extensionHandler;
        }
        Logger.getInstance(ViewHandler.class).debug("No built-in or extension defined ViewHandlers found for " + viewTag);
        try {
            String defaultHandlerPkgPrefix = "com.android.tools.idea.uibuilder.handlers.";
            String handlerClass = defaultHandlerPkgPrefix + viewTag + HANDLER_CLASS_SUFFIX;
            Class<?> cls = Class.forName(handlerClass);
            return (ViewHandler)cls.newInstance();
        }
        catch (Exception exception) {
            Logger.getInstance(ViewHandler.class).debug("Looking for user code defined handlers for " + viewTag);
            return (ViewHandler)ApplicationManager.getApplication().runReadAction(() -> {
                if (this.myProject.isDisposed()) {
                    return NONE;
                }
                try {
                    PsiClass[] viewClasses = ClassResolutionUtilsKt.findClassesForViewTag(this.myProject, viewTag);
                    if (viewClasses.length > 0) {
                        String handlerName = viewTag + HANDLER_CLASS_SUFFIX;
                        PsiClass[] handlerClasses = JavaPsiFacade.getInstance((Project)this.myProject).findClasses(handlerName, GlobalSearchScope.allScope((Project)this.myProject));
                        if (handlerClasses.length == 0) {
                            for (PsiClass cls : viewClasses) {
                                String fqn;
                                PsiClass superClass = cls.getSuperClass();
                                if (superClass == null || (fqn = superClass.getQualifiedName()) == null) continue;
                                return this.getHandler(NlComponentHelper.INSTANCE.viewClassToTag(fqn));
                            }
                        } else {
                            for (PsiClass cls : handlerClasses) {
                                Logger.getInstance(ViewHandler.class).debug(String.format("Found view handler %s  of type %s", cls.getQualifiedName(), cls.getClass().getName()));
                            }
                        }
                    }
                }
                catch (IndexNotReadyException ignore) {
                    return NONE;
                }
                return NONE;
            });
        }
    }

    public List<ViewAction> getToolbarActions(@NotNull ViewHandler handler2) {
        List<ViewAction> actions2;
        if (handler2 == null) {
            ViewHandlerManager.$$$reportNull$$$0(14);
        }
        if ((actions2 = this.myToolbarActions.get(handler2)) == null) {
            actions2 = new ArrayList<ViewAction>();
            handler2.addToolbarActions(actions2);
            this.myToolbarActions.put(handler2, actions2);
        }
        return actions2;
    }

    @NotNull
    public List<ViewAction> getPopupMenuActions(@NotNull SceneComponent component, @NotNull ViewHandler handler2) {
        List<ViewAction> actions2;
        if (component == null) {
            ViewHandlerManager.$$$reportNull$$$0(15);
        }
        if (handler2 == null) {
            ViewHandlerManager.$$$reportNull$$$0(16);
        }
        if ((actions2 = this.myMenuActions.get(handler2)) == null && handler2.addPopupMenuActions(component, actions2 = new ArrayList<ViewAction>())) {
            this.myMenuActions.put(handler2, actions2);
        }
        List<ViewAction> list = actions2;
        if (list == null) {
            ViewHandlerManager.$$$reportNull$$$0(17);
        }
        return list;
    }

    public void dispose() {
        this.myHandlers.clear();
    }

    @TestOnly
    void clearCache() {
        this.myHandlers.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/ViewHandlerManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewTag";
                break;
            }
            case 11: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/ViewHandlerManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandlerOrDefault";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPopupMenuActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 17: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getHandlerOrDefault";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerHandler";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findLayoutHandler";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createHandler";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getToolbarActions";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPopupMenuActions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

