/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.ui.resourcechooser.util.ResourceChooserHelperKt;
import com.android.tools.idea.ui.resourcemanager.ResourcePickerDialog;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.editor.LayoutNavigationManager;
import com.android.tools.idea.uibuilder.model.NlModelHelperKt;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.lint.checks.AnnotationDetector;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import org.jetbrains.android.uipreview.ChooseClassDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewEditorImpl
extends ViewEditor {
    private final Configuration myConfiguration;
    private final NlModel myModel;
    private final SceneManager mySceneManager;
    private final Scene myScene;
    @VisibleForTesting
    private Collection<ViewInfo> myRootViews;

    public ViewEditorImpl(@NotNull SceneView sceneView) {
        if (sceneView == null) {
            ViewEditorImpl.$$$reportNull$$$0(0);
        }
        this(sceneView.getModel(), sceneView.getScene());
    }

    public ViewEditorImpl(@NotNull NlModel model2) {
        if (model2 == null) {
            ViewEditorImpl.$$$reportNull$$$0(1);
        }
        this(model2, null);
    }

    public ViewEditorImpl(@NotNull NlModel model2, @Nullable Scene scene) {
        if (model2 == null) {
            ViewEditorImpl.$$$reportNull$$$0(2);
        }
        this.myConfiguration = model2.getConfiguration();
        this.myModel = model2;
        this.myScene = scene;
        this.mySceneManager = scene != null ? scene.getSceneManager() : null;
    }

    @Override
    @Nullable
    public AndroidVersion getCompileSdkVersion() {
        return AndroidModuleInfo.getInstance(this.myModel.getFacet()).getBuildSdkVersion();
    }

    @Override
    @NotNull
    public AndroidVersion getMinSdkVersion() {
        AndroidVersion androidVersion = AndroidModuleInfo.getInstance(this.myModel.getFacet()).getMinSdkVersion();
        if (androidVersion == null) {
            ViewEditorImpl.$$$reportNull$$$0(3);
        }
        return androidVersion;
    }

    @Override
    @NotNull
    public AndroidVersion getTargetSdkVersion() {
        AndroidVersion androidVersion = AndroidModuleInfo.getInstance(this.myModel.getFacet()).getTargetSdkVersion();
        if (androidVersion == null) {
            ViewEditorImpl.$$$reportNull$$$0(4);
        }
        return androidVersion;
    }

    @Override
    @NotNull
    public Configuration getConfiguration() {
        Configuration configuration = this.myConfiguration;
        if (configuration == null) {
            ViewEditorImpl.$$$reportNull$$$0(5);
        }
        return configuration;
    }

    @Override
    @NotNull
    public NlModel getModel() {
        NlModel nlModel = this.myModel;
        if (nlModel == null) {
            ViewEditorImpl.$$$reportNull$$$0(6);
        }
        return nlModel;
    }

    @Override
    @NotNull
    public LayoutlibSceneManager getSceneBuilder() {
        assert (this.mySceneManager != null) : "ViewEditorImpl incorrectly configured";
        LayoutlibSceneManager layoutlibSceneManager = (LayoutlibSceneManager)this.mySceneManager;
        if (layoutlibSceneManager == null) {
            ViewEditorImpl.$$$reportNull$$$0(7);
        }
        return layoutlibSceneManager;
    }

    @Override
    @NotNull
    public Collection<ViewInfo> getRootViews() {
        if (this.myRootViews != null) {
            Collection<ViewInfo> collection2 = this.myRootViews;
            if (collection2 == null) {
                ViewEditorImpl.$$$reportNull$$$0(8);
            }
            return collection2;
        }
        RenderResult result2 = this.getSceneBuilder().getRenderResult();
        if (result2 == null) {
            List<ViewInfo> list = Collections.emptyList();
            if (list == null) {
                ViewEditorImpl.$$$reportNull$$$0(9);
            }
            return list;
        }
        ImmutableList<ViewInfo> immutableList = result2.getRootViews();
        if (immutableList == null) {
            ViewEditorImpl.$$$reportNull$$$0(10);
        }
        return immutableList;
    }

    @VisibleForTesting
    public void setRootViews(@NotNull Collection<ViewInfo> rootViews) {
        if (rootViews == null) {
            ViewEditorImpl.$$$reportNull$$$0(11);
        }
        this.myRootViews = rootViews;
    }

    @Override
    @NotNull
    public CompletableFuture<Map<NlComponent, Dimension>> measureChildren(@NotNull NlComponent parent, @Nullable RenderTask.AttributeFilter filter2) {
        if (parent == null) {
            ViewEditorImpl.$$$reportNull$$$0(12);
        }
        if (!parent.getBackend().isValid()) {
            CompletableFuture<Map<NlComponent, Dimension>> completableFuture = CompletableFuture.completedFuture(Collections.emptyMap());
            if (completableFuture == null) {
                ViewEditorImpl.$$$reportNull$$$0(13);
            }
            return completableFuture;
        }
        if (parent.getChildCount() == 0) {
            CompletableFuture<Map<NlComponent, Dimension>> completableFuture = CompletableFuture.completedFuture(Collections.emptyMap());
            if (completableFuture == null) {
                ViewEditorImpl.$$$reportNull$$$0(14);
            }
            return completableFuture;
        }
        HashMap tagToComponent = Maps.newHashMapWithExpectedSize((int)parent.getChildCount());
        for (NlComponent child : parent.getChildren()) {
            tagToComponent.put(child.getTagDeprecated(), child);
        }
        NlModel model2 = this.myModel;
        XmlFile xmlFile = model2.getFile();
        Module module2 = model2.getModule();
        RenderService renderService = RenderService.getInstance(module2.getProject());
        RenderTask task2 = renderService.taskBuilder(model2.getFacet(), this.getConfiguration()).withPsiFile((PsiFile)xmlFile).buildSynchronously();
        if (task2 == null) {
            CompletableFuture<Map<NlComponent, Dimension>> completableFuture = CompletableFuture.completedFuture(Collections.emptyMap());
            if (completableFuture == null) {
                ViewEditorImpl.$$$reportNull$$$0(15);
            }
            return completableFuture;
        }
        XmlTag parentTag = parent.getTagDeprecated();
        CompletionStage completionStage = ((CompletableFuture)task2.measureChildren(parentTag, filter2).whenCompleteAsync((map2, ex) -> task2.dispose(), (Executor)AppExecutorUtil.getAppExecutorService())).thenApply(map2 -> {
            if (map2 == null) {
                return Collections.emptyMap();
            }
            HashMap unweightedSizes = Maps.newHashMap();
            for (Map.Entry entry : map2.entrySet()) {
                ViewInfo viewInfo = (ViewInfo)entry.getValue();
                viewInfo = RenderService.getSafeBounds(viewInfo);
                Dimension size = new Dimension(viewInfo.getRight() - viewInfo.getLeft(), viewInfo.getBottom() - viewInfo.getTop());
                NlComponent child = (NlComponent)tagToComponent.get(entry.getKey());
                if (child == null) continue;
                unweightedSizes.put(child, size);
            }
            return unweightedSizes;
        });
        if (completionStage == null) {
            ViewEditorImpl.$$$reportNull$$$0(16);
        }
        return completionStage;
    }

    @Override
    @Nullable
    public String displayResourceInput(@NotNull String title, @NotNull EnumSet<ResourceType> types2, boolean includeSampleData) {
        String resource;
        if (title == null) {
            ViewEditorImpl.$$$reportNull$$$0(17);
        }
        if (types2 == null) {
            ViewEditorImpl.$$$reportNull$$$0(18);
        }
        NlModel model2 = this.myModel;
        ResourcePickerDialog dialog2 = ResourceChooserHelperKt.createResourcePickerDialog(title.isEmpty() ? "Pick a Resource" : title, null, model2.getFacet(), types2, null, false, includeSampleData, true, model2.getVirtualFile());
        dialog2.show();
        if (dialog2.isOK() && (resource = dialog2.getResourceName()) != null && !resource.isEmpty()) {
            return resource;
        }
        return null;
    }

    @Override
    @Nullable
    public String displayClassInput(@NotNull String title, @NotNull Set<String> superTypes, @Nullable Predicate<String> filter2, @Nullable String currentValue) {
        if (title == null) {
            ViewEditorImpl.$$$reportNull$$$0(19);
        }
        if (superTypes == null) {
            ViewEditorImpl.$$$reportNull$$$0(20);
        }
        Module module2 = this.myModel.getModule();
        String[] superTypesArray = ArrayUtil.toStringArray(superTypes);
        Predicate<PsiClass> psiFilter = ChooseClassDialog.getIsPublicAndUnrestrictedFilter();
        if (filter2 == null) {
            filter2 = ChooseClassDialog.getIsUserDefinedFilter();
        }
        psiFilter = psiFilter.and(ChooseClassDialog.qualifiedNameFilter(filter2));
        return ChooseClassDialog.openDialog(module2, title, currentValue, psiFilter, superTypesArray);
    }

    @VisibleForTesting
    static boolean isPublicAndUnRestricted(@NotNull PsiClass psiClass) {
        PsiModifierList modifiers;
        if (psiClass == null) {
            ViewEditorImpl.$$$reportNull$$$0(21);
        }
        if ((modifiers = psiClass.getModifierList()) == null) {
            return false;
        }
        if (!modifiers.hasModifierProperty("public")) {
            return false;
        }
        for (PsiAnnotation annotation : modifiers.getAnnotations()) {
            if (!AnnotationDetector.RESTRICT_TO_ANNOTATION.isEquals(annotation.getQualifiedName())) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Scene getScene() {
        assert (this.myScene != null) : "ViewEditorImpl incorrectly configured";
        Scene scene = this.myScene;
        if (scene == null) {
            ViewEditorImpl.$$$reportNull$$$0(22);
        }
        return scene;
    }

    @Override
    public boolean canInsertChildren(@NotNull NlComponent parent, @NotNull List<NlComponent> children, int index2) {
        if (parent == null) {
            ViewEditorImpl.$$$reportNull$$$0(23);
        }
        if (children == null) {
            ViewEditorImpl.$$$reportNull$$$0(24);
        }
        return this.getModel().canAddComponents(children, parent, ViewEditorImpl.getChild(parent, index2));
    }

    @Override
    public void insertChildren(@NotNull NlComponent parent, @NotNull List<NlComponent> children, int index2, @NotNull InsertType insertType) {
        if (parent == null) {
            ViewEditorImpl.$$$reportNull$$$0(25);
        }
        if (children == null) {
            ViewEditorImpl.$$$reportNull$$$0(26);
        }
        if (insertType == null) {
            ViewEditorImpl.$$$reportNull$$$0(27);
        }
        this.getModel().addComponents(children, parent, ViewEditorImpl.getChild(parent, index2), insertType, this.myScene.getDesignSurface());
    }

    @Nullable
    private static NlComponent getChild(@NotNull NlComponent parent, int index2) {
        if (parent == null) {
            ViewEditorImpl.$$$reportNull$$$0(28);
        }
        return 0 <= index2 && index2 < parent.getChildCount() ? parent.getChild(index2) : null;
    }

    @Override
    public void openResourceFile(@NotNull String resourceId) {
        ResourceValue resValue;
        ResourceResolver resourceResolver2;
        VirtualFile file2;
        if (resourceId == null) {
            ViewEditorImpl.$$$reportNull$$$0(29);
        }
        if ((file2 = IdeResourcesUtil.resolveLayout((RenderResources)(resourceResolver2 = this.myConfiguration.getResourceResolver()), resValue = resourceResolver2.findResValue(resourceId, false))) == null) {
            return;
        }
        LayoutNavigationManager.getInstance(this.myConfiguration.getModule().getProject()).pushFile(this.myModel.getVirtualFile(), file2);
    }

    @NotNull
    public static ViewEditor getOrCreate(@NotNull Scene scene) {
        if (scene == null) {
            ViewEditorImpl.$$$reportNull$$$0(30);
        }
        ViewEditor viewEditor = ((LayoutlibSceneManager)scene.getSceneManager()).getViewEditor();
        if (viewEditor == null) {
            ViewEditorImpl.$$$reportNull$$$0(31);
        }
        return viewEditor;
    }

    @Override
    public boolean moduleDependsOnAppCompat() {
        return NlModelHelperKt.moduleDependsOnAppCompat(this.myModel);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 22: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 22: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneView";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 22: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/ViewEditorImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootViews";
                break;
            }
            case 12: 
            case 23: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superTypes";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertType";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceId";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scene";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/ViewEditorImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinSdkVersion";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetSdkVersion";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneBuilder";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootViews";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "measureChildren";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getScene";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 22: 
            case 31: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setRootViews";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "measureChildren";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "displayResourceInput";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "displayClassInput";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isPublicAndUnRestricted";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "canInsertChildren";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "insertChildren";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getChild";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "openResourceFile";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 22: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

