/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.api;

import android.view.View;
import android.view.ViewGroup;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.uibuilder.api.ScrollHandler;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import org.jetbrains.annotations.NotNull;

public final class ScrollViewScrollHandler
implements ScrollHandler {
    private final int myMaxScrollableSize;
    private final int myScrollUnitSize;
    private final int myStartScrollPosition;
    @NotNull
    private final IntConsumer myScrollSetter;
    @NotNull
    private final IntSupplier myScrollGetter;
    @NotNull
    private final Runnable myScrollHandler;

    ScrollViewScrollHandler(int maxScrollableSize, int scrollUnitSize, @NotNull IntConsumer scrollSetter, @NotNull IntSupplier scrollGetter, @NotNull Runnable scrollHandler) {
        if (scrollSetter == null) {
            ScrollViewScrollHandler.$$$reportNull$$$0(0);
        }
        if (scrollGetter == null) {
            ScrollViewScrollHandler.$$$reportNull$$$0(1);
        }
        if (scrollHandler == null) {
            ScrollViewScrollHandler.$$$reportNull$$$0(2);
        }
        this.myMaxScrollableSize = maxScrollableSize;
        this.myScrollUnitSize = scrollUnitSize;
        this.myScrollSetter = scrollSetter;
        this.myScrollGetter = scrollGetter;
        this.myStartScrollPosition = scrollGetter.getAsInt();
        this.myScrollHandler = scrollHandler;
    }

    @NotNull
    public static ScrollViewScrollHandler createHandler(@NotNull ViewGroup viewGroup, int maxScrollableSize, int scrollUnitSize, @NotNull Orientation orientation) {
        if (viewGroup == null) {
            ScrollViewScrollHandler.$$$reportNull$$$0(3);
        }
        if (orientation == null) {
            ScrollViewScrollHandler.$$$reportNull$$$0(4);
        }
        return new ScrollViewScrollHandler(maxScrollableSize, scrollUnitSize, orientation == Orientation.VERTICAL ? arg_0 -> ((ViewGroup)viewGroup).setScrollY(arg_0) : arg_0 -> ((ViewGroup)viewGroup).setScrollX(arg_0), orientation == Orientation.VERTICAL ? () -> ((ViewGroup)viewGroup).getScrollY() : () -> ((ViewGroup)viewGroup).getScrollX(), () -> ScrollViewScrollHandler.handleScrolling((View)viewGroup));
    }

    private static void handleScrolling(@NotNull View view) {
        if (view == null) {
            ScrollViewScrollHandler.$$$reportNull$$$0(5);
        }
        RenderService.getRenderAsyncActionExecutor().runAsyncAction(() -> {
            int scrollPosX = view.getScrollX();
            int scrollPosY = view.getScrollY();
            if (scrollPosX != 0 || scrollPosY != 0) {
                if (view.isNestedScrollingEnabled()) {
                    int[] consumed = new int[2];
                    int axis = scrollPosX != 0 ? 1 : 0;
                    if (view.startNestedScroll(axis |= scrollPosY != 0 ? 2 : 0)) {
                        view.dispatchNestedPreScroll(scrollPosX, scrollPosY, consumed, null);
                        view.dispatchNestedScroll(consumed[0], consumed[1], scrollPosX, scrollPosY, null);
                        view.stopNestedScroll();
                        scrollPosX -= consumed[0];
                        scrollPosY -= consumed[1];
                    }
                }
                if (scrollPosX != 0 || scrollPosY != 0) {
                    view.scrollTo(scrollPosX, scrollPosY);
                }
                view.requestLayout();
            }
            if (!(view instanceof ViewGroup)) {
                return;
            }
            ViewGroup group2 = (ViewGroup)view;
            for (int i2 = 0; i2 < group2.getChildCount(); ++i2) {
                View child = group2.getChildAt(i2);
                ScrollViewScrollHandler.handleScrolling(child);
            }
        });
    }

    @Override
    public int update(int scrollAmount) {
        int currentScrollPosition = this.myScrollGetter.getAsInt();
        int newScrollPos = Math.min(this.myMaxScrollableSize, Math.max(0, this.myStartScrollPosition + scrollAmount * this.myScrollUnitSize));
        if (newScrollPos == currentScrollPosition) {
            return 0;
        }
        this.myScrollSetter.accept(newScrollPos);
        this.myScrollHandler.run();
        return newScrollPos - currentScrollPosition;
    }

    @Override
    public void commit(int scrollAmount) {
        this.update(scrollAmount);
    }

    @Override
    public boolean canScroll(int scrollAmount) {
        if (this.myScrollGetter.getAsInt() == 0 && scrollAmount < 0) {
            return false;
        }
        return this.myScrollGetter.getAsInt() != this.myMaxScrollableSize || scrollAmount <= 0;
    }

    public static int getMaxScrollable(@NotNull ViewGroup viewGroup, @NotNull Function<ViewGroup, Integer> measureGroup, @NotNull Function<View, Integer> measureChildren) {
        if (viewGroup == null) {
            ScrollViewScrollHandler.$$$reportNull$$$0(6);
        }
        if (measureGroup == null) {
            ScrollViewScrollHandler.$$$reportNull$$$0(7);
        }
        if (measureChildren == null) {
            ScrollViewScrollHandler.$$$reportNull$$$0(8);
        }
        int maxScrollable = 0;
        for (int i2 = 0; i2 < viewGroup.getChildCount(); ++i2) {
            maxScrollable += measureChildren.apply(viewGroup.getChildAt(i2)).intValue();
        }
        if ((maxScrollable -= measureGroup.apply(viewGroup).intValue()) < 0) {
            maxScrollable = 0;
        }
        return maxScrollable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollSetter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollGetter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollHandler";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewGroup";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orientation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "measureGroup";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "measureChildren";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/api/ScrollViewScrollHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "handleScrolling";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getMaxScrollable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Orientation {
        VERTICAL,
        HORIZONTAL;

    }
}

