/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.wizard;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.wizard.template.Category;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WizardUtils {
    public static final String COMPOSE_MIN_AGP_VERSION = "4.0.0-alpha02";
    private static final int PACKAGE_LENGTH_LIMIT = 100;

    @NotNull
    public static File getProjectLocationParent() {
        String parent = RecentProjectsManager.getInstance().getLastProjectCreationLocation();
        if (parent != null) {
            return new File(PathUtil.toSystemDependentName((String)parent));
        }
        String defaultProjectLocation = GeneralSettings.getInstance().getDefaultProjectDirectory();
        if (defaultProjectLocation != null && !defaultProjectLocation.isEmpty()) {
            return new File(defaultProjectLocation);
        }
        String child = ApplicationNamesInfo.getInstance().getFullProductName().replace(" ", "") + "Projects";
        return new File(SystemProperties.getUserHome(), child);
    }

    @Nullable
    public static String validatePackageName(@Nullable String packageName) {
        String string = packageName = packageName == null ? "" : packageName;
        if (packageName.length() >= 100) {
            return AndroidBundle.message("android.wizard.module.package.too.long", new Object[0]);
        }
        return AndroidUtils.validateAndroidPackageName(packageName);
    }

    @NotNull
    public static String toHtmlString(@NotNull String text2) {
        if (text2 == null) {
            WizardUtils.$$$reportNull$$$0(0);
        }
        if (!StringUtil.isEmpty((String)text2) && !text2.startsWith("<html>")) {
            text2 = text2.trim().replaceAll("\n", "<br>");
            String string = String.format("<html>%1$s</html>", text2);
            if (string == null) {
                WizardUtils.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = text2;
        if (string == null) {
            WizardUtils.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static URL toUrl(@NotNull String urlAsString) {
        URL url;
        if (urlAsString == null) {
            WizardUtils.$$$reportNull$$$0(3);
        }
        try {
            url = new URL(urlAsString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        URL uRL = url;
        if (uRL == null) {
            WizardUtils.$$$reportNull$$$0(4);
        }
        return uRL;
    }

    @NotNull
    public static JBScrollPane wrapWithVScroll(@NotNull JPanel innerPanel) {
        if (innerPanel == null) {
            WizardUtils.$$$reportNull$$$0(5);
        }
        return WizardUtils.wrapWithVScroll(innerPanel, WIZARD_BORDER.LARGE);
    }

    @NotNull
    public static JBScrollPane wrapWithVScroll(@NotNull JPanel innerPanel, WIZARD_BORDER wizardBorder) {
        if (innerPanel == null) {
            WizardUtils.$$$reportNull$$$0(6);
        }
        JBScrollPane sp = new JBScrollPane((Component)innerPanel, 20, 31);
        sp.setBorder(WIZARD_BORDER.EMPTY.border);
        innerPanel.setBorder(wizardBorder.border);
        JBScrollPane jBScrollPane = sp;
        if (jBScrollPane == null) {
            WizardUtils.$$$reportNull$$$0(7);
        }
        return jBScrollPane;
    }

    public static String getUniqueName(String initialValue, Validator<? super String> validator) {
        Object uniqueName = initialValue;
        for (int i2 = 2; i2 <= 100 && validator.validate(uniqueName).getSeverity() == Validator.Severity.ERROR; ++i2) {
            uniqueName = initialValue + i2;
        }
        return uniqueName;
    }

    public static boolean hasComposeMinAgpVersion(@Nullable Project project, Category category) {
        if (project == null || !Category.Compose.equals((Object)category)) {
            return true;
        }
        AndroidPluginInfo androidPluginInfo = AndroidPluginInfo.findFromModel(project);
        if (androidPluginInfo == null) {
            return true;
        }
        GradleVersion agpVersion = androidPluginInfo.getPluginVersion();
        if (agpVersion == null) {
            return true;
        }
        return agpVersion.compareTo(COMPOSE_MIN_AGP_VERSION) >= 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ui/wizard/WizardUtils";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlAsString";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ui/wizard/WizardUtils";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toHtmlString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toUrl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithVScroll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toHtmlString";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toUrl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithVScroll";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum WIZARD_BORDER {
        EMPTY((Border)JBUI.Borders.empty()),
        SMALL(JBUI.Borders.empty((int)16)),
        LARGE((Border)JBUI.Borders.empty((int)0, (int)72));

        public final Border border;

        private WIZARD_BORDER(Border border) {
            if (border == null) {
                WIZARD_BORDER.$$$reportNull$$$0(0);
            }
            this.border = border;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "border", "com/android/tools/idea/ui/wizard/WizardUtils$WIZARD_BORDER", "<init>"));
        }
    }
}

