/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.wizard;

import com.android.tools.adtui.util.GraphicsUtil;
import com.intellij.ui.Gray;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Objects;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckeredBackgroundPanel
extends JPanel {
    @NotNull
    public static final Gray DEFAULT_ODD_CELL_COLOR = Gray.xE0;
    @NotNull
    public static final Gray DEFAULT_EVEN_CELL_COLOR = Gray.xFF;
    private static final int DEFAULT_CELL_SIZE = 10;
    @NotNull
    private final Rectangle myRectangle = new Rectangle();
    @NotNull
    private Color myOddCellColor;
    @NotNull
    private Color myEvenCellColor;
    private int myCellSize;

    public CheckeredBackgroundPanel() {
        this(10, (Color)DEFAULT_ODD_CELL_COLOR, (Color)DEFAULT_EVEN_CELL_COLOR);
    }

    public CheckeredBackgroundPanel(int cellSize, @Nullable Color oddCellColor, @Nullable Color evenCellColor) {
        if (cellSize < 1) {
            throw new IllegalArgumentException("Invalid cell size");
        }
        this.myCellSize = cellSize;
        this.myOddCellColor = oddCellColor == null ? DEFAULT_ODD_CELL_COLOR : oddCellColor;
        this.myEvenCellColor = evenCellColor == null ? DEFAULT_EVEN_CELL_COLOR : evenCellColor;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.myRectangle.setBounds(0, 0, this.getWidth(), this.getHeight());
        GraphicsUtil.paintCheckeredBackground((Graphics)g, (Color)this.myOddCellColor, (Color)this.myEvenCellColor, (Shape)this.myRectangle, (int)this.myCellSize);
    }

    public int getCellSize() {
        return this.myCellSize;
    }

    public void setCellSize(int cellSize) {
        if (cellSize == this.myCellSize && cellSize >= 1) {
            return;
        }
        this.myCellSize = cellSize;
        this.repaint();
    }

    @NotNull
    public Color getOddCellColor() {
        Color color = this.myOddCellColor;
        if (color == null) {
            CheckeredBackgroundPanel.$$$reportNull$$$0(0);
        }
        return color;
    }

    public void setOddCellColor(@Nullable Color oddCellColor) {
        if (Objects.equals(this.myOddCellColor, oddCellColor)) {
            return;
        }
        this.myOddCellColor = oddCellColor == null ? DEFAULT_ODD_CELL_COLOR : oddCellColor;
        this.repaint();
    }

    @NotNull
    public Color getEvenCellColor() {
        Color color = this.myEvenCellColor;
        if (color == null) {
            CheckeredBackgroundPanel.$$$reportNull$$$0(1);
        }
        return color;
    }

    public void setEvenCellColor(@Nullable Color evenCellColor) {
        if (Objects.equals(this.myEvenCellColor, evenCellColor)) {
            return;
        }
        this.myEvenCellColor = evenCellColor == null ? DEFAULT_EVEN_CELL_COLOR : evenCellColor;
        this.repaint();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/android/tools/idea/ui/wizard/CheckeredBackgroundPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOddCellColor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvenCellColor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

