/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.deserializers;

import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchPoint2D;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.intellij.openapi.diagnostic.Logger;
import java.lang.reflect.Type;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PointDeserializer
implements JsonDeserializer<SketchPoint2D> {
    static final Pattern pattern = Pattern.compile("\\{([+-]?[0-9.]+e?[+-]?[0-9]*),\\s*([+-]?[0-9.]+e?[+-]?[0-9]*)}");

    @Nullable
    public SketchPoint2D deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) {
        String positionString;
        Matcher matcher;
        if (json == null) {
            PointDeserializer.$$$reportNull$$$0(0);
        }
        if (typeOfT == null) {
            PointDeserializer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            PointDeserializer.$$$reportNull$$$0(2);
        }
        if ((matcher = pattern.matcher(positionString = json.getAsString())).matches()) {
            double x = Double.parseDouble(matcher.group(1));
            double y = Double.parseDouble(matcher.group(2));
            return new SketchPoint2D(x, y);
        }
        Logger.getInstance(PointDeserializer.class).warn("Bad point format: " + positionString + ".");
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "json";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "typeOfT";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/ui/resourcemanager/sketchImporter/parser/deserializers/PointDeserializer";
        objectArray[2] = "deserialize";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

