/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models;

import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.builders.PathStringBuilder;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.BorderModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.FillModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.GradientModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.InheritedProperties;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.ResizingConstraint;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.StyleModel;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ShapeModel {
    private static final int DEFAULT_BORDER_WIDTH_VALUE = 0;
    private static final int DEFAULT_COLOR_VALUE = 0;
    protected boolean isFlippedHorizontal;
    protected boolean isFlippedVertical;
    protected boolean isClosed;
    protected boolean hasClippingMask;
    protected boolean shouldBreakMaskChain;
    @Nullable
    protected StyleModel myShapeStyle;
    protected boolean myIsClosed;
    protected int myShapeOperation;
    protected boolean myHasClippingMask;
    protected boolean myShouldBreakMaskChain;
    protected boolean myIsLastShape;
    @NotNull
    protected ResizingConstraint myResizingConstraint;
    @NotNull
    protected Point2D.Double myShapeFrameLocation;
    protected boolean myIsFlippedVertical;
    protected boolean myIsflippedhorizontal;
    protected int myRotationDegrees;
    @NotNull
    private Shape myShape;
    @NotNull
    private Rectangle2D myShapeBounds;

    public ShapeModel(@NotNull Shape shape, @Nullable StyleModel style, boolean flippedHorizontal, boolean flippedVertical, boolean closed, int rotation, int operation, @NotNull Point2D.Double framePosition, boolean hasClippingMask, boolean shouldBreakMaskChain, boolean isLastShapeGroup, @NotNull ResizingConstraint constraint) {
        if (shape == null) {
            ShapeModel.$$$reportNull$$$0(0);
        }
        if (framePosition == null) {
            ShapeModel.$$$reportNull$$$0(1);
        }
        if (constraint == null) {
            ShapeModel.$$$reportNull$$$0(2);
        }
        this.myShape = shape;
        this.myIsClosed = closed;
        this.myShapeOperation = operation;
        this.myHasClippingMask = hasClippingMask;
        this.myShouldBreakMaskChain = shouldBreakMaskChain;
        this.myIsLastShape = isLastShapeGroup;
        this.myShapeStyle = style;
        this.myResizingConstraint = constraint;
        this.myIsflippedhorizontal = flippedHorizontal;
        this.myIsFlippedVertical = flippedVertical;
        this.myShapeFrameLocation = framePosition;
        this.myRotationDegrees = rotation;
        this.myShapeBounds = shape.getBounds2D();
    }

    @NotNull
    public Shape getShape() {
        Shape shape = this.myShape;
        if (shape == null) {
            ShapeModel.$$$reportNull$$$0(3);
        }
        return shape;
    }

    public int getBooleanOperation() {
        return this.myShapeOperation;
    }

    @Nullable
    public BorderModel getShapeBorder() {
        return this.myShapeStyle != null ? this.myShapeStyle.getBorder() : null;
    }

    public int getBorderColor() {
        return this.getShapeBorder() != null ? this.getShapeBorder().getColor().getRGB() : 0;
    }

    public int getBorderWidth() {
        return this.getShapeBorder() != null ? this.getShapeBorder().getWidth() : 0;
    }

    @Nullable
    public FillModel getFill() {
        return this.myShapeStyle != null ? this.myShapeStyle.getFill() : null;
    }

    public int getFillColor() {
        return this.getFill() != null ? this.getFill().getColor().getRGB() : 0;
    }

    @Nullable
    public GradientModel getGradient() {
        return this.getFill() != null ? this.getFill().getGradientModel() : null;
    }

    public boolean hasClippingMask() {
        return this.myHasClippingMask;
    }

    public boolean shouldBreakMaskChain() {
        return this.myShouldBreakMaskChain;
    }

    public boolean isLastShape() {
        return this.myIsLastShape;
    }

    @NotNull
    public ResizingConstraint getResizingConstraint() {
        ResizingConstraint resizingConstraint = this.myResizingConstraint;
        if (resizingConstraint == null) {
            ShapeModel.$$$reportNull$$$0(4);
        }
        return resizingConstraint;
    }

    @NotNull
    public Point2D.Double getShapeFrameLocation() {
        Point2D.Double double_ = this.myShapeFrameLocation;
        if (double_ == null) {
            ShapeModel.$$$reportNull$$$0(5);
        }
        return double_;
    }

    @NotNull
    protected AffineTransform computeAffineTransform(@Nullable InheritedProperties inheritedProperties) {
        if (inheritedProperties != null) {
            this.myShapeFrameLocation.setLocation(inheritedProperties.getInheritedTranslation());
            this.myIsflippedhorizontal = inheritedProperties.isInheritedFlipX();
            this.myIsFlippedVertical = inheritedProperties.isInheritedFlipY();
            this.myRotationDegrees = inheritedProperties.getInheritedRotation();
        }
        AffineTransform shapeTransform = new AffineTransform();
        shapeTransform.setToIdentity();
        shapeTransform.translate(this.myShapeFrameLocation.getX(), this.myShapeFrameLocation.getY());
        if (this.myIsflippedhorizontal) {
            shapeTransform.scale(-1.0, 1.0);
            shapeTransform.translate(-(this.myShapeBounds.getWidth() + 2.0 * this.myShapeBounds.getX()), 0.0);
        }
        if (this.myIsFlippedVertical) {
            shapeTransform.scale(1.0, -1.0);
            shapeTransform.translate(0.0, -(this.myShapeBounds.getHeight() + 2.0 * this.myShapeBounds.getY()));
        }
        shapeTransform.rotate(Math.toRadians(-this.myRotationDegrees), this.myShapeBounds.getCenterX(), this.myShapeBounds.getCenterY());
        AffineTransform affineTransform = shapeTransform;
        if (affineTransform == null) {
            ShapeModel.$$$reportNull$$$0(6);
        }
        return affineTransform;
    }

    @NotNull
    public String getPathString() {
        PathStringBuilder pathStringBuilder = new PathStringBuilder();
        PathIterator pathIterator = this.myShape.getPathIterator(null);
        while (!pathIterator.isDone()) {
            double[] coordinates = new double[6];
            int type = pathIterator.currentSegment(coordinates);
            switch (type) {
                case 0: {
                    pathStringBuilder.startPath(coordinates[0], coordinates[1]);
                    break;
                }
                case 1: {
                    pathStringBuilder.createLine(coordinates[0], coordinates[1]);
                    break;
                }
                case 3: {
                    pathStringBuilder.createBezierCurve(coordinates);
                    break;
                }
                case 2: {
                    pathStringBuilder.createQuadCurve(coordinates[0], coordinates[1], coordinates[2], coordinates[3]);
                    break;
                }
                case 4: {
                    pathStringBuilder.endPath();
                }
            }
            pathIterator.next();
        }
        String string = pathStringBuilder.build();
        if (string == null) {
            ShapeModel.$$$reportNull$$$0(7);
        }
        return string;
    }

    protected void transformGradient(@NotNull AffineTransform transform) {
        GradientModel shapeGradient;
        if (transform == null) {
            ShapeModel.$$$reportNull$$$0(8);
        }
        FillModel shapeFill = this.myShapeStyle != null ? this.myShapeStyle.getFill() : null;
        GradientModel gradientModel = shapeGradient = shapeFill != null ? shapeFill.getGradientModel() : null;
        if (shapeGradient != null) {
            shapeGradient.applyTransformation(transform);
        }
    }

    public void applyOpacity(double parentOpacity) {
        if (this.myShapeStyle != null) {
            this.myShapeStyle.applyOpacity(parentOpacity);
        }
    }

    public void setFramePosition(@NotNull Point2D.Double position) {
        if (position == null) {
            ShapeModel.$$$reportNull$$$0(9);
        }
        this.myShapeFrameLocation = position;
    }

    public abstract void applyTransformations(@Nullable InheritedProperties var1);

    public abstract void scale(double var1, double var3);

    public abstract void translateTo(double var1, double var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shape";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "framePosition";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ui/resourcemanager/sketchImporter/converter/models/ShapeModel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ui/resourcemanager/sketchImporter/converter/models/ShapeModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShape";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getResizingConstraint";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShapeFrameLocation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "computeAffineTransform";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "transformGradient";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setFramePosition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

