/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.builders;

import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.SketchLibrary;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.builders.Path2DBuilder;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.AreaModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.AssetModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.BorderModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.ColorAssetModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.DrawableAssetModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.FillModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.GradientModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.GradientStopModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.InheritedProperties;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.PathModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.ResizingConstraint;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.ShapeModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.StudioResourcesModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.StyleModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.SymbolModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.document.SketchDocument;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.document.SketchForeignSymbol;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.document.SketchSharedStyle;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.interfaces.SketchLayer;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.interfaces.SketchLayerable;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchArtboard;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchBorder;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchCurvePoint;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchExportFormat;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchFill;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchGradient;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchGradientStop;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchGraphicsContextSettings;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchPage;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchPoint2D;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchShapeGroup;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchShapePath;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchStyle;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchSymbolInstance;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchSymbolMaster;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.ui.SketchFile;
import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SketchToStudioConverter {
    private static final String DEFAULT_DOCUMENT_COLOR_NAME = "document_color";

    @NotNull
    public static StudioResourcesModel getResources(@NotNull SketchPage sketchPage, @NotNull SketchLibrary library) {
        if (sketchPage == null) {
            SketchToStudioConverter.$$$reportNull$$$0(0);
        }
        if (library == null) {
            SketchToStudioConverter.$$$reportNull$$$0(1);
        }
        ImmutableList.Builder listBuilder = new ImmutableList.Builder();
        for (SketchArtboard artboard : SketchFile.getArtboards(sketchPage)) {
            listBuilder.add((Object)SketchToStudioConverter.createDrawableAsset(artboard, library));
        }
        for (SketchSymbolMaster symbolMaster : SketchFile.getAllSymbolMasters(sketchPage)) {
            listBuilder.add((Object)SketchToStudioConverter.createDrawableAsset(symbolMaster, library, AssetModel.Origin.SYMBOL));
        }
        return new StudioResourcesModel((ImmutableList<DrawableAssetModel>)listBuilder.build(), (ImmutableList<ColorAssetModel>)ImmutableList.of());
    }

    @NotNull
    public static StudioResourcesModel getResources(@NotNull SketchDocument sketchDocument, @NotNull SketchLibrary library) {
        if (sketchDocument == null) {
            SketchToStudioConverter.$$$reportNull$$$0(2);
        }
        if (library == null) {
            SketchToStudioConverter.$$$reportNull$$$0(3);
        }
        ImmutableList.Builder drawableListBuilder = new ImmutableList.Builder();
        ImmutableList.Builder colorListBuilder = new ImmutableList.Builder();
        colorListBuilder.addAll(SketchToStudioConverter.getDocumentColors(sketchDocument));
        colorListBuilder.addAll(SketchToStudioConverter.getExternalColors(sketchDocument));
        colorListBuilder.addAll(SketchToStudioConverter.getSharedColors(sketchDocument));
        drawableListBuilder.addAll(SketchToStudioConverter.getExternalDrawables(sketchDocument, library));
        drawableListBuilder.addAll(SketchToStudioConverter.getSharedDrawables(sketchDocument, library));
        return new StudioResourcesModel((ImmutableList<DrawableAssetModel>)drawableListBuilder.build(), (ImmutableList<ColorAssetModel>)colorListBuilder.build());
    }

    @NotNull
    public static DrawableAssetModel createDrawableAsset(@NotNull SketchArtboard artboard, @NotNull SketchLibrary library) {
        SketchLayer[] layers;
        if (artboard == null) {
            SketchToStudioConverter.$$$reportNull$$$0(4);
        }
        if (library == null) {
            SketchToStudioConverter.$$$reportNull$$$0(5);
        }
        ImmutableList.Builder shapes = new ImmutableList.Builder();
        for (SketchLayer layer : layers = artboard.getLayers()) {
            if (layer instanceof SketchSymbolInstance && library.hasSymbols()) {
                shapes.addAll(SketchToStudioConverter.createShapeModelsFromSymbol((SketchSymbolInstance)layer, new InheritedProperties(), library));
                continue;
            }
            if (layer instanceof SketchShapeGroup) {
                shapes.addAll(SketchToStudioConverter.createShapeModelFromShapeGroup((SketchShapeGroup)layer, new InheritedProperties(), false));
                continue;
            }
            if (!(layer instanceof SketchLayerable)) continue;
            shapes.addAll(SketchToStudioConverter.createShapeModelsFromLayerable((SketchLayerable)((Object)layer), new InheritedProperties(), library));
        }
        ImmutableList shapeModels = shapes.build();
        String name = SketchToStudioConverter.getDefaultName(artboard);
        boolean exportable = artboard.getExportOptions().getExportFormats().length != 0;
        Rectangle2D.Double dimension2 = artboard.getFrame();
        return new DrawableAssetModel((ImmutableList<ShapeModel>)shapeModels, exportable, name, dimension2, dimension2, AssetModel.Origin.ARTBOARD);
    }

    @NotNull
    private static DrawableAssetModel createDrawableAsset(@NotNull SketchSymbolMaster symbolMaster, @NotNull SketchLibrary library, @NotNull AssetModel.Origin origin) {
        if (symbolMaster == null) {
            SketchToStudioConverter.$$$reportNull$$$0(6);
        }
        if (library == null) {
            SketchToStudioConverter.$$$reportNull$$$0(7);
        }
        if (origin == null) {
            SketchToStudioConverter.$$$reportNull$$$0(8);
        }
        boolean exportable = symbolMaster.getExportOptions().getExportFormats().length != 0;
        String name = SketchToStudioConverter.getDefaultName(symbolMaster);
        Rectangle2D.Double dimension2 = symbolMaster.getFrame();
        return new DrawableAssetModel(SketchToStudioConverter.createShapeModelsFromLayerable(symbolMaster, new InheritedProperties(), library), exportable, name, dimension2, dimension2, origin);
    }

    @NotNull
    private static String getDefaultName(@NotNull SketchLayer layer) {
        if (layer == null) {
            SketchToStudioConverter.$$$reportNull$$$0(9);
        }
        String name = layer.getName();
        if (layer.getExportOptions().getExportFormats().length != 0) {
            SketchExportFormat format2 = layer.getExportOptions().getExportFormats()[0];
            if (format2.getNamingScheme() == 1) {
                String string = format2.getName() + name;
                if (string == null) {
                    SketchToStudioConverter.$$$reportNull$$$0(10);
                }
                return string;
            }
            if (format2.getNamingScheme() == 0) {
                String string = name + format2.getName();
                if (string == null) {
                    SketchToStudioConverter.$$$reportNull$$$0(11);
                }
                return string;
            }
        }
        String string = name;
        if (string == null) {
            SketchToStudioConverter.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private static ImmutableList<ShapeModel> createShapeModelsFromSymbol(@NotNull SketchSymbolInstance symbolInstance, @NotNull InheritedProperties inheritedProperties, @NotNull SketchLibrary library) {
        SymbolModel symbolModel;
        if (symbolInstance == null) {
            SketchToStudioConverter.$$$reportNull$$$0(13);
        }
        if (inheritedProperties == null) {
            SketchToStudioConverter.$$$reportNull$$$0(14);
        }
        if (library == null) {
            SketchToStudioConverter.$$$reportNull$$$0(15);
        }
        if ((symbolModel = SketchToStudioConverter.getSymbolModel(symbolInstance.getSymbolId(), library)) == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                SketchToStudioConverter.$$$reportNull$$$0(16);
            }
            return immutableList;
        }
        symbolModel.setSymbolInstance(symbolInstance);
        inheritedProperties = SketchToStudioConverter.inheritFromSymbol(symbolInstance, inheritedProperties);
        symbolModel.scaleShapes();
        symbolModel.applyProperties(inheritedProperties);
        ImmutableList<ShapeModel> immutableList = symbolModel.getShapeModels();
        if (immutableList == null) {
            SketchToStudioConverter.$$$reportNull$$$0(17);
        }
        return immutableList;
    }

    @Nullable
    private static SymbolModel getSymbolModel(@NotNull String symbolId, @NotNull SketchLibrary library) {
        SketchSymbolMaster symbolMaster;
        if (symbolId == null) {
            SketchToStudioConverter.$$$reportNull$$$0(18);
        }
        if (library == null) {
            SketchToStudioConverter.$$$reportNull$$$0(19);
        }
        if ((symbolMaster = library.getSymbol(symbolId)) == null) {
            return null;
        }
        ImmutableList<ShapeModel> shapeModels = SketchToStudioConverter.createShapeModelsFromLayerable(symbolMaster, new InheritedProperties(), library);
        return new SymbolModel(shapeModels, symbolMaster);
    }

    @NotNull
    private static ImmutableList<ShapeModel> createShapeModelFromShapeGroup(@NotNull SketchShapeGroup shapeGroup, @NotNull InheritedProperties inheritedProperties, boolean isLastShapeGroup) {
        SketchBorder shapeGroupBorder;
        if (shapeGroup == null) {
            SketchToStudioConverter.$$$reportNull$$$0(20);
        }
        if (inheritedProperties == null) {
            SketchToStudioConverter.$$$reportNull$$$0(21);
        }
        SketchFill[] fills = shapeGroup.getStyle().getFills();
        SketchBorder[] borders = shapeGroup.getStyle().getBorders();
        SketchFill shapeGroupFill = fills != null ? fills[0] : null;
        SketchBorder sketchBorder = shapeGroupBorder = borders != null ? borders[0] : null;
        if (shapeGroupBorder == null && shapeGroupFill == null && !shapeGroup.hasClippingMask()) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                SketchToStudioConverter.$$$reportNull$$$0(22);
            }
            return immutableList;
        }
        SketchLayer[] layers = shapeGroup.getLayers();
        SketchShapePath baseSketchShapePath = (SketchShapePath)layers[0];
        Path2D.Double baseShapePath = SketchToStudioConverter.getPath2D(baseSketchShapePath);
        StyleModel styleModel = SketchToStudioConverter.createStyleModel(shapeGroup.getStyle());
        if (styleModel != null) {
            styleModel.makeGradientRelative(baseShapePath);
        }
        InheritedProperties newInheritedProperties = SketchToStudioConverter.inheritFromShapeGroup(shapeGroup, inheritedProperties);
        PathModel finalShape = new PathModel(baseShapePath, styleModel, baseSketchShapePath.isFlippedHorizontal(), baseSketchShapePath.isFlippedVertical(), baseSketchShapePath.isClosed(), baseSketchShapePath.getRotation(), shapeGroup.getBooleanOperation(), baseSketchShapePath.getFramePosition(), shapeGroup.hasClippingMask(), shapeGroup.shouldBreakMaskChain(), isLastShapeGroup, inheritedProperties.getInheritedResizingConstraint());
        if (layers.length == 1) {
            finalShape.applyTransformations(newInheritedProperties);
            ImmutableList immutableList = ImmutableList.of((Object)finalShape);
            if (immutableList == null) {
                SketchToStudioConverter.$$$reportNull$$$0(23);
            }
            return immutableList;
        }
        AreaModel finalArea = finalShape.convertToArea();
        finalArea.applyTransformations(null);
        for (int i2 = 1; i2 < layers.length; ++i2) {
            SketchShapePath path2 = (SketchShapePath)layers[i2];
            if (!path2.isVisible()) continue;
            PathModel pathModel = SketchToStudioConverter.createPathModel(path2);
            AreaModel areaModel = pathModel.convertToArea();
            areaModel.applyTransformations(null);
            finalArea.applyOperation(areaModel);
        }
        finalArea.applyTransformations(newInheritedProperties);
        ImmutableList immutableList = ImmutableList.of((Object)finalArea);
        if (immutableList == null) {
            SketchToStudioConverter.$$$reportNull$$$0(24);
        }
        return immutableList;
    }

    @NotNull
    private static PathModel createPathModel(@NotNull SketchShapePath shapePath) {
        if (shapePath == null) {
            SketchToStudioConverter.$$$reportNull$$$0(25);
        }
        return new PathModel(SketchToStudioConverter.getPath2D(shapePath), null, shapePath.isFlippedHorizontal(), shapePath.isFlippedVertical(), shapePath.isClosed(), shapePath.getRotation(), shapePath.getBooleanOperation(), shapePath.getFramePosition(), false, false, false, new ResizingConstraint());
    }

    @NotNull
    public static ImmutableList<ShapeModel> createShapeModelsFromLayerable(@NotNull SketchLayerable layerable, @NotNull InheritedProperties inheritedProperties, @NotNull SketchLibrary library) {
        if (layerable == null) {
            SketchToStudioConverter.$$$reportNull$$$0(26);
        }
        if (inheritedProperties == null) {
            SketchToStudioConverter.$$$reportNull$$$0(27);
        }
        if (library == null) {
            SketchToStudioConverter.$$$reportNull$$$0(28);
        }
        ImmutableList.Builder builder2 = new ImmutableList.Builder();
        inheritedProperties = SketchToStudioConverter.inheritFromLayerable(layerable, inheritedProperties);
        boolean isLastGroupElement = false;
        SketchLayer[] groupLayers = layerable.getLayers();
        for (int i2 = 0; i2 < groupLayers.length; ++i2) {
            if (i2 == groupLayers.length - 1) {
                isLastGroupElement = true;
            }
            SketchLayer layer = groupLayers[i2];
            if (library.hasSymbols() && layer instanceof SketchSymbolInstance) {
                builder2.addAll(SketchToStudioConverter.createShapeModelsFromSymbol((SketchSymbolInstance)layer, inheritedProperties, library));
                continue;
            }
            if (layer instanceof SketchShapeGroup) {
                SketchShapeGroup shapeGroup = (SketchShapeGroup)layer;
                builder2.addAll(SketchToStudioConverter.createShapeModelFromShapeGroup(shapeGroup, inheritedProperties, isLastGroupElement));
                continue;
            }
            if (!(layer instanceof SketchLayerable)) continue;
            builder2.addAll(SketchToStudioConverter.createShapeModelsFromLayerable((SketchLayerable)((Object)layer), inheritedProperties, library));
        }
        ImmutableList immutableList = builder2.build();
        if (immutableList == null) {
            SketchToStudioConverter.$$$reportNull$$$0(29);
        }
        return immutableList;
    }

    @NotNull
    private static InheritedProperties inheritFromSymbol(@NotNull SketchSymbolInstance symbolInstance, @NotNull InheritedProperties inheritedProperties) {
        if (symbolInstance == null) {
            SketchToStudioConverter.$$$reportNull$$$0(30);
        }
        if (inheritedProperties == null) {
            SketchToStudioConverter.$$$reportNull$$$0(31);
        }
        Rectangle2D.Double frame = symbolInstance.getFrame();
        Point2D.Double translation = new Point2D.Double(frame.getX(), frame.getY());
        SketchGraphicsContextSettings contextSettings = symbolInstance.getStyle().getContextSettings();
        double opacity = contextSettings != null ? contextSettings.getOpacity() : 1.0;
        ResizingConstraint constraint = symbolInstance.getResizingConstraint();
        return new InheritedProperties(inheritedProperties, translation, symbolInstance.isFlippedHorizontal(), symbolInstance.isFlippedVertical(), symbolInstance.getRotation(), opacity, constraint);
    }

    @NotNull
    private static InheritedProperties inheritFromShapeGroup(@NotNull SketchShapeGroup shapeGroup, @NotNull InheritedProperties inheritedProperties) {
        if (shapeGroup == null) {
            SketchToStudioConverter.$$$reportNull$$$0(32);
        }
        if (inheritedProperties == null) {
            SketchToStudioConverter.$$$reportNull$$$0(33);
        }
        Rectangle2D.Double frame = shapeGroup.getFrame();
        Point2D.Double translation = new Point2D.Double(frame.getX(), frame.getY());
        ResizingConstraint constraint = shapeGroup.getResizingConstraint();
        return new InheritedProperties(inheritedProperties, translation, shapeGroup.isFlippedHorizontal(), shapeGroup.isFlippedVertical(), shapeGroup.getRotation(), 1.0, constraint);
    }

    @NotNull
    private static InheritedProperties inheritFromLayerable(@NotNull SketchLayerable layerable, @NotNull InheritedProperties inheritedProperties) {
        if (layerable == null) {
            SketchToStudioConverter.$$$reportNull$$$0(34);
        }
        if (inheritedProperties == null) {
            SketchToStudioConverter.$$$reportNull$$$0(35);
        }
        Rectangle2D.Double frame = layerable.getFrame();
        Point2D.Double translation = !(layerable instanceof SketchSymbolMaster) ? new Point2D.Double(frame.getX(), frame.getY()) : new Point2D.Double();
        SketchGraphicsContextSettings graphicContextSettings = layerable.getStyle().getContextSettings();
        double opacity = graphicContextSettings != null ? graphicContextSettings.getOpacity() : 1.0;
        return new InheritedProperties(inheritedProperties, translation, layerable.isFlippedHorizontal(), layerable.isFlippedVertical(), layerable.getRotation(), opacity, layerable.getResizingConstraint());
    }

    @Nullable
    private static StyleModel createStyleModel(@Nullable SketchStyle sketchStyle) {
        if (sketchStyle == null) {
            return null;
        }
        SketchGraphicsContextSettings styleGraphicsContextSettings = sketchStyle.getContextSettings();
        double styleOpacity = styleGraphicsContextSettings != null ? styleGraphicsContextSettings.getOpacity() : 1.0;
        SketchBorder[] sketchBorders = sketchStyle.getBorders();
        SketchBorder sketchBorder = sketchBorders != null && sketchBorders.length != 0 ? sketchBorders[0] : null;
        BorderModel borderModel = sketchBorder != null && sketchBorder.isEnabled() ? new BorderModel(sketchBorder.getThickness(), sketchBorder.getColor()) : null;
        SketchFill[] sketchFills = sketchStyle.getFills();
        SketchFill sketchFill = sketchFills != null && sketchFills.length != 0 ? sketchFills[0] : null;
        FillModel fillModel = null;
        if (sketchFill != null && sketchFill.isEnabled()) {
            SketchGradient sketchGradient = sketchFill.getGradient();
            GradientModel gradientModel = SketchToStudioConverter.createGradientModel(sketchGradient);
            SketchGraphicsContextSettings fillGraphicsContextSettings = sketchFill.getContextSettings();
            double fillOpacity = fillGraphicsContextSettings != null ? fillGraphicsContextSettings.getOpacity() : 1.0;
            fillModel = new FillModel(sketchFill.getColor(), gradientModel, fillOpacity);
        }
        return new StyleModel(fillModel, borderModel, styleOpacity);
    }

    @Nullable
    private static GradientModel createGradientModel(@Nullable SketchGradient sketchGradient) {
        if (sketchGradient == null) {
            return null;
        }
        SketchGradientStop[] gradientStops = sketchGradient.getStops();
        GradientStopModel[] gradientStopModels = new GradientStopModel[gradientStops.length];
        for (int i2 = 0; i2 < gradientStops.length; ++i2) {
            SketchGradientStop gradientStop = gradientStops[i2];
            gradientStopModels[i2] = new GradientStopModel(gradientStop.getPosition(), gradientStop.getColor());
        }
        return new GradientModel(sketchGradient.getGradientType(), sketchGradient.getFrom(), sketchGradient.getTo(), gradientStopModels);
    }

    @NotNull
    private static Path2D.Double getPath2D(@NotNull SketchShapePath shapePath) {
        if (shapePath == null) {
            SketchToStudioConverter.$$$reportNull$$$0(36);
        }
        if ("rectangle".equals(shapePath.getClassType())) {
            if (SketchToStudioConverter.hasRoundCorners(shapePath)) {
                return SketchToStudioConverter.getRoundRectanglePath(shapePath);
            }
            return SketchToStudioConverter.getGenericPath(shapePath);
        }
        return SketchToStudioConverter.getGenericPath(shapePath);
    }

    @NotNull
    private static Path2D.Double getGenericPath(@NotNull SketchShapePath shapePath) {
        if (shapePath == null) {
            SketchToStudioConverter.$$$reportNull$$$0(37);
        }
        Path2DBuilder path2DBuilder = new Path2DBuilder();
        SketchCurvePoint[] points = shapePath.getPoints();
        if (points.length == 0) {
            return new Path2D.Double();
        }
        SketchPoint2D startCoords = points[0].getPoint().makeAbsolutePosition(shapePath.getFrame());
        path2DBuilder.startPath(startCoords);
        SketchCurvePoint currentCurvePoint = points[0];
        for (int i2 = 1; i2 < points.length; ++i2) {
            SketchCurvePoint previousCurvePoint = points[i2 - 1];
            currentCurvePoint = points[i2];
            SketchPoint2D previousPoint = previousCurvePoint.getPoint().makeAbsolutePosition(shapePath.getFrame());
            SketchPoint2D currentPoint = currentCurvePoint.getPoint().makeAbsolutePosition(shapePath.getFrame());
            SketchPoint2D previousPointCurveFrom = previousPoint;
            SketchPoint2D currentPointCurveTo = currentPoint;
            if (previousCurvePoint.hasCurveFrom()) {
                previousPointCurveFrom = previousCurvePoint.getCurveFrom().makeAbsolutePosition(shapePath.getFrame());
            }
            if (currentCurvePoint.hasCurveTo()) {
                currentPointCurveTo = currentCurvePoint.getCurveTo().makeAbsolutePosition(shapePath.getFrame());
            }
            if (!previousCurvePoint.hasCurveFrom() && !currentCurvePoint.hasCurveTo()) {
                path2DBuilder.createLine(currentPoint);
                continue;
            }
            path2DBuilder.createBezierCurve(previousPointCurveFrom, currentPointCurveTo, currentPoint);
        }
        if (shapePath.isClosed()) {
            path2DBuilder.createClosedShape(shapePath, currentCurvePoint);
        }
        Path2D.Double double_ = path2DBuilder.build();
        if (double_ == null) {
            SketchToStudioConverter.$$$reportNull$$$0(38);
        }
        return double_;
    }

    @NotNull
    private static Path2D.Double getRoundRectanglePath(@NotNull SketchShapePath shapePath) {
        if (shapePath == null) {
            SketchToStudioConverter.$$$reportNull$$$0(39);
        }
        Path2DBuilder path2DBuilder = new Path2DBuilder();
        SketchCurvePoint[] points = shapePath.getPoints();
        SketchPoint2D startPoint = new SketchPoint2D(0.0, 0.0);
        SketchPoint2D endPoint = new SketchPoint2D(0.0, 0.0);
        SketchPoint2D previousPoint = new SketchPoint2D(0.0, 0.0);
        for (int i2 = 0; i2 < points.length; ++i2) {
            switch (i2) {
                case 0: {
                    startPoint.setLocation(0.0, points[i2].getCornerRadius());
                    endPoint.setLocation(points[i2].getCornerRadius(), 0.0);
                    path2DBuilder.startPath(startPoint);
                    break;
                }
                case 1: {
                    startPoint.setLocation(shapePath.getFrame().getWidth() - (double)points[i2].getCornerRadius(), 0.0);
                    endPoint.setLocation(shapePath.getFrame().getWidth(), points[i2].getCornerRadius());
                    break;
                }
                case 2: {
                    startPoint.setLocation(shapePath.getFrame().getWidth(), shapePath.getFrame().getHeight() - (double)points[i2].getCornerRadius());
                    endPoint.setLocation(shapePath.getFrame().getWidth() - (double)points[i2].getCornerRadius(), shapePath.getFrame().getHeight());
                    break;
                }
                case 3: {
                    startPoint.setLocation(points[i2].getCornerRadius(), shapePath.getFrame().getHeight());
                    endPoint.setLocation(0.0, shapePath.getFrame().getHeight() - (double)points[i2].getCornerRadius());
                }
            }
            if (points[i2].getCornerRadius() != 0) {
                if (!previousPoint.equals(startPoint) && i2 != 0) {
                    path2DBuilder.createLine(startPoint);
                }
                path2DBuilder.createQuadCurve(points[i2].getPoint().makeAbsolutePosition(shapePath.getFrame()), endPoint);
            } else {
                path2DBuilder.createLine(startPoint.makeAbsolutePosition(shapePath.getFrame()));
            }
            previousPoint.setLocation(endPoint);
        }
        path2DBuilder.closePath();
        Path2D.Double double_ = path2DBuilder.build();
        if (double_ == null) {
            SketchToStudioConverter.$$$reportNull$$$0(40);
        }
        return double_;
    }

    private static boolean hasRoundCorners(@NotNull SketchShapePath shapePath) {
        SketchCurvePoint[] points;
        if (shapePath == null) {
            SketchToStudioConverter.$$$reportNull$$$0(41);
        }
        for (SketchCurvePoint point : points = shapePath.getPoints()) {
            if (point.getCornerRadius() == 0) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static ImmutableList<ColorAssetModel> getDocumentColors(@NotNull SketchDocument sketchDocument) {
        Color[] documentColors;
        int len;
        if (sketchDocument == null) {
            SketchToStudioConverter.$$$reportNull$$$0(42);
        }
        if ((len = (documentColors = sketchDocument.getAssets().getColors()).length) == 1) {
            ImmutableList immutableList = ImmutableList.of((Object)new ColorAssetModel(true, DEFAULT_DOCUMENT_COLOR_NAME, documentColors[0], AssetModel.Origin.DOCUMENT));
            if (immutableList == null) {
                SketchToStudioConverter.$$$reportNull$$$0(43);
            }
            return immutableList;
        }
        ImmutableList.Builder colorListBuilder = new ImmutableList.Builder();
        for (int i2 = 0; i2 < len; ++i2) {
            colorListBuilder.add((Object)new ColorAssetModel(true, "document_color_" + (i2 + 1), documentColors[i2], AssetModel.Origin.DOCUMENT));
        }
        ImmutableList immutableList = colorListBuilder.build();
        if (immutableList == null) {
            SketchToStudioConverter.$$$reportNull$$$0(44);
        }
        return immutableList;
    }

    @NotNull
    private static ImmutableList<ColorAssetModel> getExternalColors(@NotNull SketchDocument sketchDocument) {
        if (sketchDocument == null) {
            SketchToStudioConverter.$$$reportNull$$$0(45);
        }
        ImmutableList.Builder colorListBuilder = new ImmutableList.Builder();
        ImmutableList immutableList = colorListBuilder.build();
        if (immutableList == null) {
            SketchToStudioConverter.$$$reportNull$$$0(46);
        }
        return immutableList;
    }

    @NotNull
    private static ImmutableList<ColorAssetModel> getSharedColors(@NotNull SketchDocument sketchDocument) {
        SketchSharedStyle[] sharedStyles;
        if (sketchDocument == null) {
            SketchToStudioConverter.$$$reportNull$$$0(47);
        }
        ImmutableList.Builder colorListBuilder = new ImmutableList.Builder();
        for (SketchSharedStyle style : sharedStyles = sketchDocument.getLayerStyles()) {
            Color color;
            SketchFill[] fills = style.getValue().getFills();
            Color color2 = color = fills != null && fills.length != 0 ? fills[0].getColor() : null;
            if (color == null) continue;
            colorListBuilder.add((Object)new ColorAssetModel(true, style.getName(), color, AssetModel.Origin.SHARED));
        }
        ImmutableList immutableList = colorListBuilder.build();
        if (immutableList == null) {
            SketchToStudioConverter.$$$reportNull$$$0(48);
        }
        return immutableList;
    }

    @NotNull
    private static ImmutableList<DrawableAssetModel> getExternalDrawables(@NotNull SketchDocument sketchDocument, @NotNull SketchLibrary library) {
        if (sketchDocument == null) {
            SketchToStudioConverter.$$$reportNull$$$0(49);
        }
        if (library == null) {
            SketchToStudioConverter.$$$reportNull$$$0(50);
        }
        if (sketchDocument.getForeignSymbols() == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                SketchToStudioConverter.$$$reportNull$$$0(51);
            }
            return immutableList;
        }
        ImmutableList.Builder drawableListBuilder = new ImmutableList.Builder();
        for (SketchForeignSymbol foreignSymbol : sketchDocument.getForeignSymbols()) {
            DrawableAssetModel drawableAsset = SketchToStudioConverter.createDrawableAsset(foreignSymbol.getSymbolMaster(), library, AssetModel.Origin.EXTERNAL);
            drawableListBuilder.add((Object)drawableAsset);
        }
        ImmutableList immutableList = drawableListBuilder.build();
        if (immutableList == null) {
            SketchToStudioConverter.$$$reportNull$$$0(52);
        }
        return immutableList;
    }

    @NotNull
    private static ImmutableList<DrawableAssetModel> getSharedDrawables(@NotNull SketchDocument sketchDocument, @NotNull SketchLibrary library) {
        if (sketchDocument == null) {
            SketchToStudioConverter.$$$reportNull$$$0(53);
        }
        if (library == null) {
            SketchToStudioConverter.$$$reportNull$$$0(54);
        }
        ImmutableList.Builder drawableListBuilder = new ImmutableList.Builder();
        ImmutableList immutableList = drawableListBuilder.build();
        if (immutableList == null) {
            SketchToStudioConverter.$$$reportNull$$$0(55);
        }
        return immutableList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 38: 
            case 40: 
            case 43: 
            case 44: 
            case 46: 
            case 48: 
            case 51: 
            case 52: 
            case 55: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 38: 
            case 40: 
            case 43: 
            case 44: 
            case 46: 
            case 48: 
            case 51: 
            case 52: 
            case 55: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sketchPage";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 15: 
            case 19: 
            case 28: 
            case 50: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 2: 
            case 42: 
            case 45: 
            case 47: 
            case 49: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sketchDocument";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artboard";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolMaster";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layer";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 38: 
            case 40: 
            case 43: 
            case 44: 
            case 46: 
            case 48: 
            case 51: 
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ui/resourcemanager/sketchImporter/converter/builders/SketchToStudioConverter";
                break;
            }
            case 13: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolInstance";
                break;
            }
            case 14: 
            case 21: 
            case 27: 
            case 31: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inheritedProperties";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolId";
                break;
            }
            case 20: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shapeGroup";
                break;
            }
            case 25: 
            case 36: 
            case 37: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shapePath";
                break;
            }
            case 26: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layerable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ui/resourcemanager/sketchImporter/converter/builders/SketchToStudioConverter";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultName";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createShapeModelsFromSymbol";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createShapeModelFromShapeGroup";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createShapeModelsFromLayerable";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericPath";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoundRectanglePath";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentColors";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalColors";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getSharedColors";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalDrawables";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getSharedDrawables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResources";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDrawableAsset";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultName";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 38: 
            case 40: 
            case 43: 
            case 44: 
            case 46: 
            case 48: 
            case 51: 
            case 52: 
            case 55: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createShapeModelsFromSymbol";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolModel";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createShapeModelFromShapeGroup";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createPathModel";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createShapeModelsFromLayerable";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "inheritFromSymbol";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "inheritFromShapeGroup";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "inheritFromLayerable";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getPath2D";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getGenericPath";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getRoundRectanglePath";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "hasRoundCorners";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentColors";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getExternalColors";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getSharedColors";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getExternalDrawables";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getSharedDrawables";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 38: 
            case 40: 
            case 43: 
            case 44: 
            case 46: 
            case 48: 
            case 51: 
            case 52: 
            case 55: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

